/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.mobile;

import java.util.Arrays;
import nc.bs.dao.BaseDAO;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pub.pf.PfMailAndSMSUtil;
import nc.bs.pub.pf.PfUtilTools;
import nc.itf.uap.rbac.IUserManageQuery;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.mailapprove.pub.MailApproveResult;
import nc.ui.pf.multilang.PfMultiLangUtil;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.msg.AbstractMsgL10NCallback;
import nc.vo.sm.UserVO;
import nc.vo.uap.pf.PFBusinessException;

public class MailHandler {
    private static MailHandler instance = new MailHandler();

    private MailHandler() {
    }

    public static MailHandler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emailMsgReceived(MailApproveResult approveResult) {
        String checkman = approveResult.getUserID();
        String pwd = approveResult.getUserPWD();
        String result = approveResult.getApproveResult();
        String note = approveResult.getApproveContent();
        String billid = approveResult.getBillID();
        String billtype = approveResult.getBillType();
        String ds = approveResult.getDsName();
        String emailAddr = approveResult.getToMail();
        String[] dispatched_ids = approveResult.getDispatchResult();
        String worknote = approveResult.getWorknote();
        final String billno = this.getBillNo(approveResult);
        final String billTypeName = this.getBilltypeName(billtype);
        String title = this.getTitle(approveResult);
        StringBuffer msg = new StringBuffer();
        msg.append("checkman=").append(checkman);
        msg.append(", pwd=").append(pwd);
        msg.append(", result=").append(result);
        msg.append(", note=").append(note);
        msg.append(", billid=").append(billid);
        msg.append(", billtype=").append(billtype);
        msg.append(", ds=").append(ds);
        msg.append(", emailAddr=").append(emailAddr);
        try {
            msg.append(", dispatch_ids=").append(Arrays.asList(dispatched_ids));
        }
        catch (Throwable e) {
            Logger.error((Object)e.getMessage());
        }
        Logger.error((Object)"____begin MailHandler.emailMsgReceived()", (Throwable)new Throwable());
        Logger.error((Object)msg.toString());
        String originUser = InvocationInfoProxy.getInstance().getUserId();
        String originDs = InvocationInfoProxy.getInstance().getUserDataSource();
        try {
            String strMsg = new AbstractMsgL10NCallback(){

                @Override
                public String getMessage() throws BusinessException {
                    if (StringUtil.isEmptyWithTrim((String)billno) || StringUtil.isEmptyWithTrim((String)billTypeName)) {
                        return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MailHandler-000000");
                    }
                    String para = billTypeName + " " + billno;
                    return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "MailHandler-0000", null, new String[]{para});
                }
            }.getLocalizedMsg(checkman);
            PfUtilTools.regDataSourceForServlet(ds);
            this.checkPassword(checkman, pwd);
            InvocationInfoProxy.getInstance().setUserId(checkman);
            PfUtilTools.approveSilentlyWithWorkNotePk(billtype, billid, result, note, checkman, dispatched_ids, worknote);
            PfMailAndSMSUtil.sendEmail(title, strMsg, new String[]{emailAddr}, null, null);
        }
        catch (Throwable e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            try {
                final Throwable refExp = e;
                String message = new AbstractMsgL10NCallback(){

                    @Override
                    public String getMessage() throws BusinessException {
                        if (StringUtil.isEmptyWithTrim((String)billTypeName) || StringUtil.isEmptyWithTrim((String)billno)) {
                            return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "MailHandler-0001", null, new String[]{refExp.getMessage()});
                        }
                        String para = billTypeName + " " + billno;
                        return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "MailHandler-0002", null, new String[]{para, refExp.getMessage()});
                    }
                }.getLocalizedMsg(checkman);
                PfMailAndSMSUtil.sendEmail(title, message, new String[]{emailAddr}, null, null);
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            InvocationInfoProxy.getInstance().setUserId(originUser);
            InvocationInfoProxy.getInstance().setUserDataSource(originDs);
        }
    }

    private String getBillNo(MailApproveResult result) {
        try {
            String billtype = result.getBillType();
            String billid = result.getBillID();
            String sql = "select billno from pub_wf_instance where billtype=? and billversionpk=?";
            SQLParameter param = new SQLParameter();
            param.addParam(billtype);
            param.addParam(billid);
            Object billno = new BaseDAO().executeQuery(sql, param, (ResultSetProcessor)new ColumnProcessor());
            if (billno == null) {
                return null;
            }
            return billno.toString();
        }
        catch (Throwable e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getBilltypeName(String billtype) {
        BilltypeVO btvo = PfDataCache.getBillType(billtype);
        if (btvo == null) {
            return null;
        }
        return PfMultiLangUtil.getSuperVONameOfCurrentLang(btvo, "billtypename");
    }

    private void logParams(String uid, String pwd, String result, String note, String billid, String billtype, String ds) {
    }

    private String getTitle(MailApproveResult result) {
        try {
            return new AbstractMsgL10NCallback(){

                @Override
                public String getMessage() throws BusinessException {
                    return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000000");
                }
            }.getLocalizedMsg(result.getUserID());
        }
        catch (Throwable e) {
            return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000000");
        }
    }

    private void checkPassword(String uid, String pwd) throws BusinessException {
        IUserManageQuery umq = (IUserManageQuery)NCLocator.getInstance().lookup(IUserManageQuery.class);
        UserVO userVO = umq.getUser(uid);
        String strPwd = userVO.getUser_password();
        if (!strPwd.equalsIgnoreCase(pwd)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MailHandler-000001"));
        }
    }
}

