/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.pub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nc.bs.dao.BaseDAO;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.PfDataCacheConstant;
import nc.bs.pf.pub.cache.CondStringKey;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IWorkflowDefine;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.BeanListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.cache.ext.CacheToMapAdapter;
import nc.vo.cache.ext.ElementVersionSensitiveMap;
import nc.vo.cache.ext.ICacheVersionMonitor;
import nc.vo.cache.ext.ObjectCacheVersionMonitor;
import nc.vo.cache.ext.VersionMonitorFactory;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.wfengine.core.parser.UfXPDLParser;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.WorkflowDefinitionVO;
import nc.vo.wfengine.ext.ApproveFlowAdjustVO;

public class WorkflowProcessCache
implements PfDataCacheConstant {
    private static Map<String, WorkflowProcessCache> dsInstMap = new HashMap<String, WorkflowProcessCache>();
    ElementVersionSensitiveMap map = null;

    private WorkflowProcessCache() {
        String region = InvocationInfoProxy.getInstance().getUserDataSource() + "platform" + "workflowprocess";
        CacheToMapAdapter adapter = (CacheToMapAdapter)CacheToMapAdapter.getInstance((String)region);
        this.map = new ElementVersionSensitiveMap((Map)adapter, new VersionMonitorFactory(){

            public ICacheVersionMonitor createVersionMonitor(Object key) {
                return new ObjectCacheVersionMonitor(String.valueOf(key));
            }
        });
    }

    private ElementVersionSensitiveMap getVersionSensitiveCache() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowProcessCache getInstance() {
        String ds = InvocationInfoProxy.getInstance().getUserDataSource();
        if (!dsInstMap.containsKey(ds)) {
            Map<String, WorkflowProcessCache> map = dsInstMap;
            synchronized (map) {
                if (!dsInstMap.containsKey(ds)) {
                    dsInstMap.put(ds, new WorkflowProcessCache());
                }
            }
        }
        return dsInstMap.get(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicWorkflowProcess getWorkflowProcess(String defPK) throws BusinessException {
        HashMap<String, BasicWorkflowProcess> pkProcessMap = (HashMap<String, BasicWorkflowProcess>)this.getVersionSensitiveCache().get((Object)"WORKFLOWPROCESS");
        if (pkProcessMap == null) {
            Object object = MUTEX_WORKFLOWPROCESS;
            synchronized (object) {
                pkProcessMap = (HashMap)this.getVersionSensitiveCache().get((Object)"WORKFLOWPROCESS");
                if (pkProcessMap == null) {
                    pkProcessMap = this.queryAndCacheProcess(defPK, null);
                    this.getVersionSensitiveCache().put((Object)"WORKFLOWPROCESS", pkProcessMap);
                }
            }
        } else if (!pkProcessMap.containsKey(defPK)) {
            Object object = MUTEX_WORKFLOWPROCESS;
            synchronized (object) {
                if (!pkProcessMap.containsKey(defPK)) {
                    HashMap<String, BasicWorkflowProcess> map = this.queryAndCacheProcess(defPK, null);
                    if (map == null) {
                        return null;
                    }
                    pkProcessMap.putAll(map);
                }
            }
        } else {
            BasicWorkflowProcess process = (BasicWorkflowProcess)pkProcessMap.get(defPK);
            Map extendsMap = process.getExtendedAttributes();
            Object versionts = extendsMap.get("versionts");
            if (versionts == null) {
                pkProcessMap = this.queryAndCacheProcess(defPK, null);
                this.getVersionSensitiveCache().put((Object)"WORKFLOWPROCESS", pkProcessMap);
            } else {
                IWorkflowDefine defQry = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
                String versionts_str = (String)versionts;
                WorkflowDefinitionVO wvo = defQry.queryFixedFields(defPK, new String[]{"pk_wf_def", "ts"});
                if (!versionts_str.equals(wvo.getTs().toStdString())) {
                    pkProcessMap = this.queryAndCacheProcess(defPK, null);
                    this.getVersionSensitiveCache().put((Object)"WORKFLOWPROCESS", pkProcessMap);
                }
            }
        }
        if (pkProcessMap == null) {
            return null;
        }
        return pkProcessMap.get(defPK);
    }

    public void forceUpdate(String defPK) throws BusinessException {
        HashMap<String, BasicWorkflowProcess> pkProcessMap = (HashMap<String, BasicWorkflowProcess>)this.getVersionSensitiveCache().get((Object)"WORKFLOWPROCESS");
        pkProcessMap = this.queryAndCacheProcess(defPK, null);
        this.getVersionSensitiveCache().put((Object)"WORKFLOWPROCESS", pkProcessMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeWorkflowProcess(String processInstancePK, WorkflowProcess wp) {
        if (processInstancePK == null) {
            return;
        }
        if (wp == null) {
            HashMap hashCacheObj = (HashMap)this.getVersionSensitiveCache().get((Object)"WORKFLOWPROCESS");
            if (hashCacheObj != null) {
                hashCacheObj.remove(processInstancePK);
            }
        } else {
            HashMap<String, WorkflowProcess> hashCacheObj = (HashMap<String, WorkflowProcess>)this.getVersionSensitiveCache().get((Object)"WORKFLOWPROCESS");
            if (hashCacheObj == null) {
                Object object = MUTEX_WORKFLOWPROCESS;
                synchronized (object) {
                    hashCacheObj = (HashMap)this.getVersionSensitiveCache().get((Object)"WORKFLOWPROCESS");
                    if (hashCacheObj == null) {
                        hashCacheObj = new HashMap<String, WorkflowProcess>();
                        this.getVersionSensitiveCache().put((Object)"WORKFLOWPROCESS", hashCacheObj);
                    }
                }
            }
            hashCacheObj.put(processInstancePK, wp);
        }
    }

    private HashMap<String, BasicWorkflowProcess> queryAndCacheProcess(String defPK, String procInstPk) throws BusinessException {
        try {
            IWorkflowDefine defQry = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
            HashMap<String, BasicWorkflowProcess> hashCacheObj = defQry.findDefinitionByDefPkAndInstPk(defPK, procInstPk);
            return hashCacheObj;
        }
        catch (XPDLParserException e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicWorkflowProcess getWorkflowProcess(String defPK, String processInstPK) throws BusinessException {
        HashMap<String, BasicWorkflowProcess> pkProcessMap = (HashMap<String, BasicWorkflowProcess>)this.getVersionSensitiveCache().get((Object)"WORKFLOWPROCESS");
        if (pkProcessMap == null) {
            Object object = MUTEX_WORKFLOWPROCESS;
            synchronized (object) {
                pkProcessMap = (HashMap)this.getVersionSensitiveCache().get((Object)"WORKFLOWPROCESS");
                if (pkProcessMap == null) {
                    pkProcessMap = this.queryAndCacheProcess(defPK, processInstPK);
                    this.getVersionSensitiveCache().put((Object)"WORKFLOWPROCESS", pkProcessMap);
                }
            }
        } else if (!pkProcessMap.containsKey(defPK)) {
            Object object = MUTEX_WORKFLOWPROCESS;
            synchronized (object) {
                if (!pkProcessMap.containsKey(defPK)) {
                    HashMap<String, BasicWorkflowProcess> map = this.queryAndCacheProcess(defPK, processInstPK);
                    pkProcessMap.putAll(map);
                }
            }
        } else if (processInstPK != null && !pkProcessMap.containsKey(processInstPK)) {
            Object object = MUTEX_WORKFLOWPROCESS;
            synchronized (object) {
                if (!pkProcessMap.containsKey(processInstPK)) {
                    this.queryAndCacheProcessInAdjust(pkProcessMap, defPK, processInstPK);
                }
            }
        } else {
            BasicWorkflowProcess process = null;
            process = pkProcessMap.containsKey(processInstPK) ? (BasicWorkflowProcess)pkProcessMap.get(processInstPK) : (BasicWorkflowProcess)pkProcessMap.get(defPK);
            Map extendsMap = process.getExtendedAttributes();
            Object versionts = extendsMap.get("versionts");
            if (versionts == null) {
                if (pkProcessMap.containsKey(processInstPK)) {
                    this.queryAndCacheProcessInAdjust(pkProcessMap, defPK, processInstPK);
                } else {
                    pkProcessMap = this.queryAndCacheProcess(defPK, processInstPK);
                    this.getVersionSensitiveCache().put((Object)"WORKFLOWPROCESS", pkProcessMap);
                }
            } else {
                String dbtsStr = "";
                if (pkProcessMap.containsKey(processInstPK)) {
                    ApproveFlowAdjustVO wvo = this.queryApproveFlowAdjustVO_Db(defPK, processInstPK);
                    dbtsStr = wvo.getTs().toStdString();
                } else {
                    IWorkflowDefine defQry = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
                    WorkflowDefinitionVO wvo = defQry.queryFixedFields(defPK, new String[]{"pk_wf_def", "ts"});
                    dbtsStr = wvo.getTs().toStdString();
                }
                String versionts_str = (String)versionts;
                if (!versionts_str.equals(dbtsStr)) {
                    if (pkProcessMap.containsKey(processInstPK)) {
                        this.queryAndCacheProcessInAdjust(pkProcessMap, defPK, processInstPK);
                    } else {
                        pkProcessMap = this.queryAndCacheProcess(defPK, processInstPK);
                        this.getVersionSensitiveCache().put((Object)"WORKFLOWPROCESS", pkProcessMap);
                    }
                }
            }
        }
        if (pkProcessMap.containsKey(processInstPK)) {
            return pkProcessMap.get(processInstPK);
        }
        return pkProcessMap.get(defPK);
    }

    private void queryAndCacheProcessInAdjust(HashMap<String, BasicWorkflowProcess> hashCacheObj, String defPK, String processInstPK) throws BusinessException {
        BasicWorkflowProcess bwp = null;
        if (RuntimeEnv.getInstance().isRunningInServer()) {
            CondStringKey key = new CondStringKey("pub_wf_def_adjust", defPK, processInstPK);
            Object cachedObj = PFRequestDataCacheProxy.get((IRequestDataCacheKey)key);
            if (cachedObj == PFRequestDataCacheProxy.NULL || cachedObj == null) {
                return;
            }
            if (cachedObj != null && cachedObj instanceof BasicWorkflowProcess) {
                bwp = (BasicWorkflowProcess)cachedObj;
            } else {
                bwp = this.queryAndCacheProcessInAdjust_Db(defPK, processInstPK);
                if (bwp == null) {
                    PFRequestDataCacheProxy.put((IRequestDataCacheKey)key, (Object)PFRequestDataCacheProxy.NULL);
                } else {
                    PFRequestDataCacheProxy.put((IRequestDataCacheKey)key, (Object)bwp);
                }
            }
        } else {
            bwp = this.queryAndCacheProcessInAdjust_Db(defPK, processInstPK);
        }
        if (bwp != null) {
            hashCacheObj.put(processInstPK, bwp);
        }
    }

    private ApproveFlowAdjustVO queryApproveFlowAdjustVO_Db(String defPK, String processInstPK) throws BusinessException {
        Object tsStr = null;
        if (processInstPK != null) {
            BaseDAO dao = new BaseDAO();
            String condition = " pk_wf_instance=? ";
            SQLParameter para1 = new SQLParameter();
            para1.addParam(processInstPK);
            Collection obj = dao.retrieveByClause(ApproveFlowAdjustVO.class, condition, new String[]{"pk_wf_instance", "ts"}, para1);
            if (obj != null && obj.size() > 0) {
                return obj.toArray(new ApproveFlowAdjustVO[0])[0];
            }
        }
        return null;
    }

    private BasicWorkflowProcess queryAndCacheProcessInAdjust_Db(String defPK, String processInstPK) throws BusinessException {
        try {
            BasicWorkflowProcess bwp = null;
            if (processInstPK != null) {
                String sql1 = "select content,ts from pub_wf_def_adjust where pk_wf_instance=?";
                SQLParameter para1 = new SQLParameter();
                para1.addParam(processInstPK);
                ArrayList adjustVOs = (ArrayList)((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).executeQuery(sql1, para1, (ResultSetProcessor)new BeanListProcessor(ApproveFlowAdjustVO.class));
                if (adjustVOs != null && adjustVOs.size() > 0) {
                    UFDateTime ts;
                    ApproveFlowAdjustVO adjustVO = (ApproveFlowAdjustVO)adjustVOs.get(0);
                    bwp = UfXPDLParser.getInstance().parseProcess(adjustVO.getContent());
                    bwp.setPrimaryKey(defPK);
                    HashMap<String, String> extendsMap = bwp.getExtendedAttributes();
                    if (extendsMap == null) {
                        extendsMap = new HashMap<String, String>();
                    }
                    if ((ts = adjustVO.getTs()) != null) {
                        extendsMap.put("versionts", ts.toStdString());
                    }
                }
            }
            return bwp;
        }
        catch (XPDLParserException e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }
}

