/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.pub;

import com.ufida.dataset.IContext;
import com.ufida.iufo.table.exarea.ExtendAreaCell;
import com.ufida.iufo.table.exarea.ExtendAreaModel;
import com.ufida.report.anareport.anaratio.CalRatioField;
import com.ufida.report.anareport.base.BaseSearchTemplateCondition;
import com.ufida.report.anareport.base.BaseSearchTemplateConditionItem;
import com.ufida.report.anareport.base.DefaultConditionProcessor;
import com.ufida.report.anareport.model.AbsAnaReportModel;
import com.ufida.report.anareport.model.AnaRepField;
import com.ufida.report.anareport.model.CombineField;
import com.ufida.report.anareport.model.FieldCountDef;
import com.ufida.report.frquery.base.Operator;
import com.ufida.report.frquery.utils.FrFilterDescriptorGenerator;
import com.ufsoft.table.AreaPosition;
import com.ufsoft.table.CellPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.bs.rbac.report.ReportQueryCondition;
import nc.itf.iufo.freereport.extend.IQueryCondition;
import nc.pub.smart.metadata.Field;
import nc.pub.smart.model.descriptor.Descriptor;
import nc.pub.smart.model.preferences.Parameter;
import nc.ui.querytemplate.filter.IFilter;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.pub.query.ConditionVO;
import nc.vo.querytemplate.QueryTemplateConvertor;

public class AllWorkflowReportConditionProcessor
extends DefaultConditionProcessor {
    public IQueryCondition doQueryByWebScheme(IContext context, AbsAnaReportModel reportModel, IQueryScheme queryScheme) {
        BaseSearchTemplateCondition templateCondition = (BaseSearchTemplateCondition)context.getAttribute("FreeReport_All_Condition");
        List conditionItems = templateCondition.getRealSearchConditionItems();
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        for (BaseSearchTemplateConditionItem conditionItem : conditionItems) {
            if ("time_type".equals(conditionItem.getField())) continue;
            Parameter parameter = new Parameter();
            parameter.setCode(conditionItem.getField());
            parameter.setOperator(conditionItem.getOpertype());
            String value = conditionItem.getValue();
            if (value == null || value.trim().equals("")) continue;
            parameter.setValue((Object)(value != null ? value.toString().split(",") : new String[]{}));
            paramList.add(parameter);
        }
        FrFilterDescriptorGenerator descriptorGenerator = new FrFilterDescriptorGenerator();
        ExtendAreaModel extendAreaModel = reportModel.getExtendAreaModel();
        Map<String, Field> fieldMap = AllWorkflowReportConditionProcessor.getReportAnaField(extendAreaModel);
        ArrayList<Descriptor> descList = new ArrayList<Descriptor>();
        Operator operator = Operator.EQUAL;
        for (Parameter param : paramList) {
            int dataType = -1;
            if (fieldMap.containsKey(param.getCode())) {
                dataType = fieldMap.get(param.getCode()).getDataType();
            }
            String[] paramValueStrs = (String[])param.getValue();
            ArrayList<String> paramValueList = new ArrayList<String>();
            for (String paramStr : paramValueStrs) {
                paramValueList.add(paramStr);
            }
            Descriptor desc = descriptorGenerator.createFilterDescriptor(param.getCode(), dataType, operator.getOperatorByStrOperator(param.getOperator()), paramValueList, context);
            descList.add(desc);
        }
        ReportQueryCondition queryCondition = new ReportQueryCondition(true);
        queryCondition.setDescriptors(descList.toArray(new Descriptor[0]));
        Object obj = queryScheme.get("filters");
        if (obj instanceof IFilter[]) {
            IFilter[] iFilters = (IFilter[])obj;
            int len = iFilters.length;
            ConditionVO[] conditionVOs = new ConditionVO[len];
            for (int i = 0; i < len; ++i) {
                conditionVOs[i] = QueryTemplateConvertor.convert2ConditionVO((IFilter)iFilters[i]);
            }
            queryCondition.setConditionVOs(conditionVOs);
            context.setAttribute("freereport_querycondition_vos", (Object)conditionVOs);
        }
        context.setAttribute("isWeb", (Object)true);
        String where = queryScheme.getWhereSQLOnly();
        queryCondition.setUserObject((Object)where);
        queryCondition.setDescriptors(null);
        return queryCondition;
    }

    private static Map<String, Field> getReportAnaField(ExtendAreaModel extendAreaModel) {
        ExtendAreaCell[] cells;
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (ExtendAreaCell cell : cells = extendAreaModel.getExtendAreaCells()) {
            AreaPosition area = cell.getArea();
            for (CellPosition c : area.split()) {
                AnaRepField repField = (AnaRepField)cell.getCellsModel().getBsFormat(c, "AnaRepFieldInfo");
                if (repField == null) continue;
                if (repField.getFieldType() == 2 || repField.getFieldType() == 12 || repField.getFieldType() == 14) {
                    FieldCountDef fieldCountDef = repField.getFieldCountDef();
                    Field mainField = fieldCountDef.getMainField();
                    map.put(mainField.getFldname(), mainField);
                    Field rangeField = fieldCountDef.getRangeField();
                    if (rangeField == null) continue;
                    map.put(mainField.getFldname(), rangeField);
                    continue;
                }
                Field fld = repField.getField();
                if (fld instanceof CombineField) {
                    Field[] fields;
                    Field mainfld = ((CombineField)fld).getMainFld();
                    map.put(mainfld.getFldname(), mainfld);
                    for (Field f : fields = ((CombineField)fld).getFields()) {
                        map.put(f.getFldname(), f);
                    }
                    continue;
                }
                if (fld instanceof CalRatioField) {
                    CalRatioField calRatioField = (CalRatioField)fld;
                    AnaRepField measFld = calRatioField.getMeasFld();
                    map.put(measFld.getField().getFldname(), measFld.getField());
                    continue;
                }
                map.put(fld.getFldname(), fld);
            }
        }
        return map;
    }
}

