/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.change;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.bs.pf.change.BillSplitter;
import nc.md.data.access.DASFacade;
import nc.md.data.access.NCObject;
import nc.md.model.IAttribute;
import nc.md.model.IBean;
import nc.md.model.type.IType;
import nc.md.util.MDUtil;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.ChangeVOAdjustContext;
import nc.vo.pf.change.IChangeVOAdjust;
import nc.vo.pf.change.PfBillMappingUtil;
import nc.vo.pf.change.SplitItemVO;
import nc.vo.pf.change.UserDefineFunction;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.BusinessRuntimeException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.formulaset.FormulaParseFather;
import nc.vo.pub.formulaset.VarryVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.lang.UFDouble;
import nc.vo.uap.pf.PFBusinessException;

public class BillMappingConvertor {
    protected String m_strDate = null;
    protected String m_strOperator = null;
    protected String m_strGroup;
    protected String m_strNowTime;
    protected UFDateTime m_strBuziTime;
    protected UFDate m_strBuziDate;
    protected String m_sourceBilltype = null;
    protected String m_destBilltype;
    protected String m_destTranstype;
    private String[][] sMoves = null;
    private String[][] sAssigns = null;
    private String[] sFormulas = null;
    private UserDefineFunction[] uFunctions = null;
    private String frontClass = null;
    private String backClass = null;
    private String reserveFrontClass = null;
    private String reserveBackClass = null;
    protected FormulaParseFather formulaParse;
    protected ArrayList<SplitItemVO> alSplitVO = null;

    public BillMappingConvertor(FormulaParseFather fp) {
        this.formulaParse = fp;
    }

    public FormulaParseFather getFormulaParse() {
        return this.formulaParse;
    }

    public ArrayList<SplitItemVO> getSplitVOList() {
        if (this.alSplitVO == null) {
            this.alSplitVO = new ArrayList();
        }
        return this.alSplitVO;
    }

    public String getFrontClass() {
        return this.frontClass;
    }

    public void setFrontClass(String frontClass) {
        this.frontClass = frontClass;
    }

    public String getBackClass() {
        return this.backClass;
    }

    public void setBackClass(String backClass) {
        this.backClass = backClass;
    }

    public void setMoveRules(String[][] mRules) {
        this.sMoves = mRules;
    }

    public void setAssignRules(String[][] aRules) {
        this.sAssigns = aRules;
    }

    public void setFormulaRules(String[] fRules) {
        this.sFormulas = fRules;
    }

    public void setUserDefineFunctions(UserDefineFunction[] uFuncs) {
        this.uFunctions = uFuncs;
    }

    public String[][] getMoveRules() {
        return this.sMoves;
    }

    public String[][] getAssignRules() {
        return this.sAssigns;
    }

    public String[] getFormulaRules() {
        return this.sFormulas;
    }

    public String getSourceBilltype() {
        return this.m_sourceBilltype;
    }

    public void setSourceBilltype(String sourceBilltype) {
        this.m_sourceBilltype = sourceBilltype;
    }

    public String getDestBilltype() {
        return this.m_destBilltype;
    }

    public void setDestBilltype(String billtype) {
        this.m_destBilltype = billtype;
    }

    public void setSysGroup(String corpCode) {
        this.m_strGroup = corpCode;
    }

    public void setSysTime(String time) {
        this.m_strNowTime = time;
    }

    public void setBuziTime(UFDateTime time) {
        this.m_strBuziTime = time;
    }

    public void setBuziDate(UFDate date) {
        this.m_strBuziDate = date;
    }

    public void setSysDate(String sysDate) {
        this.m_strDate = sysDate;
    }

    public void setSysOperator(String sysOperator) {
        this.m_strOperator = sysOperator;
    }

    public boolean isCheck(CircularlyAccessibleValueObject souce, CircularlyAccessibleValueObject target) {
        target.setStatus(souce.getStatus());
        return true;
    }

    private IChangeVOAdjust getAfterClassImpl() throws BusinessException {
        if (this.getBackClass() == null || this.getBackClass().trim().length() == 0) {
            return null;
        }
        try {
            Class<?> c = Class.forName(this.getBackClass());
            Object afterClassInstance = c.newInstance();
            return (IChangeVOAdjust)afterClassInstance;
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000017", null, new String[]{ex.getMessage()}));
        }
    }

    private IChangeVOAdjust getBeforeClassImpl() throws BusinessException {
        if (this.getFrontClass() == null || this.getFrontClass().trim().length() == 0) {
            return null;
        }
        try {
            Class<?> c = Class.forName(this.getFrontClass());
            Object afterClassInstance = c.newInstance();
            return (IChangeVOAdjust)afterClassInstance;
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000018", null, new String[]{ex.getMessage()}));
        }
    }

    private IChangeVOAdjust getReserveClassImpl(String className) throws BusinessException {
        if (StringUtil.isEmptyWithTrim((String)className)) {
            return null;
        }
        try {
            Class<?> c = Class.forName(className);
            Object instance = c.newInstance();
            return (IChangeVOAdjust)instance;
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000019", null, new String[]{ex.getMessage()}));
        }
    }

    private void execFormulasMetaToMeta(AggregatedValueObject sourceVO, AggregatedValueObject targetVO) throws BusinessException {
        String[] formulas = this.sFormulas;
        if (formulas == null || formulas.length == 0) {
            return;
        }
        for (int i = 0; i < formulas.length; ++i) {
            Logger.debug((Object)("**\u6267\u884c\u516c\u5f0f\u4ea4\u6362:" + formulas[i]));
            this.getFormulaParse().setExpress(formulas[i]);
            VarryVO varry = this.getFormulaParse().getVarry();
            if (varry == null) continue;
            this.execFormulaMetaToMeta2(sourceVO, targetVO, varry);
        }
    }

    private void execFormulasMetaToMetaBatch(AggregatedValueObject[] sourceVOs, AggregatedValueObject[] targetVOs) throws BusinessException {
        String[] formulas = this.sFormulas;
        if (formulas == null || formulas.length == 0) {
            return;
        }
        for (int i = 0; i < formulas.length; ++i) {
            Logger.debug((Object)("**\u6267\u884c\u516c\u5f0f\u4ea4\u6362:" + formulas[i]));
            this.getFormulaParse().setExpress(formulas[i]);
            VarryVO varry = this.getFormulaParse().getVarry();
            if (varry == null || sourceVOs == null || sourceVOs.length == 0) continue;
            this.execFormulaMetaToMeta2Batch(sourceVOs, targetVOs, varry);
        }
    }

    private void execFormulasMetaToMetaBatch(NCObject[] sourceNcObjs, NCObject[] targetNcObjs) throws BusinessException {
        String[] formulas = this.sFormulas;
        if (formulas == null || formulas.length == 0) {
            return;
        }
        for (int i = 0; i < formulas.length; ++i) {
            Logger.debug((Object)("**\u6267\u884c\u516c\u5f0f\u4ea4\u6362:" + formulas[i]));
            this.getFormulaParse().setExpress(formulas[i]);
            VarryVO varry = this.getFormulaParse().getVarry();
            if (varry == null) continue;
            this.execFormulaMetaToMeta2Batch(sourceNcObjs, targetNcObjs, varry);
        }
    }

    private boolean canChangeBatch(NCObject[] sourceNcObjs, NCObject[] targetNcObjs, VarryVO varry) {
        for (int j = 0; j < (varry.getVarry() == null ? 0 : varry.getVarry().length); ++j) {
            String var = varry.getVarry()[j];
            int end = sourceNcObjs.length;
            for (int start = 0; start < end; ++start) {
                Object value = this.getVarValueFromMetadata(sourceNcObjs[start], var);
                if (value == null) {
                    value = this.getVarValueFromMetadata(targetNcObjs[start], var);
                }
                if (!(value instanceof Object[]) || (Object[])value == null || ((Object[])value).length <= 1) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canChangeBatch(AggregatedValueObject[] sourceVOs, AggregatedValueObject[] targetVOs, VarryVO varry) {
        for (int j = 0; j < (varry.getVarry() == null ? 0 : varry.getVarry().length); ++j) {
            String var = varry.getVarry()[j];
            int end = sourceVOs.length;
            for (int start = 0; start < end; ++start) {
                Object value = this.getVarValueFromMetadata(sourceVOs[start], var);
                if (value == null) {
                    value = this.getVarValueFromMetadata(targetVOs[start], var);
                }
                if (!(value instanceof Object[]) || (Object[])value == null || ((Object[])value).length <= 1) continue;
                return false;
            }
        }
        return true;
    }

    private void execFormulaMetaToMeta2Batch(AggregatedValueObject[] sourceVOs, AggregatedValueObject[] targetVOs, VarryVO varry) throws BusinessException {
        String destPath = varry.getFormulaName();
        NCObject ncObj = NCObject.newInstance((Object)targetVOs[0]);
        boolean canBatch = this.canChangeBatch(sourceVOs, targetVOs, varry);
        if (!canBatch || this.isCollectionOfPath(destPath, ncObj.getRelatedBean()) && this.isCollectionOfSrc(varry)) {
            for (int i = 0; i < sourceVOs.length; ++i) {
                this.execFormulaMetaToMeta2(sourceVOs[i], targetVOs[i], varry);
            }
        } else {
            this.parseMetaFormulaVarBatch(sourceVOs, targetVOs, varry);
            IType iType = ncObj.getRelatedBean().getAttributeByPath(destPath).getDataType();
            Object[] realValues = null;
            Object[] valueObjs = this.getFormulaParse().getValueO();
            realValues = new Object[targetVOs.length];
            for (int i = 0; i < targetVOs.length; ++i) {
                realValues[i] = valueObjs.length == 1 && (varry.getVarry() == null || varry.getVarry().length == 0) ? this.getValueByIType(valueObjs[0], iType) : this.getValueByIType(valueObjs[i], iType);
            }
            String errStr = this.getFormulaParse().getError();
            if (!StringUtil.isEmptyWithTrim((String)errStr)) {
                throw new PFBusinessException(errStr);
            }
            int end = targetVOs.length;
            for (int i = 0; i < end; ++i) {
                NCObject _ncObj = NCObject.newInstance((Object)targetVOs[i]);
                _ncObj.setAttributeValue(destPath, realValues[i]);
            }
        }
    }

    private void execFormulaMetaToMeta2Batch(NCObject[] sourceNcObjs, NCObject[] targetNcObjs, VarryVO varry) throws BusinessException {
        String destPath = varry.getFormulaName();
        NCObject ncObj = targetNcObjs[0];
        boolean canBatch = this.canChangeBatch(sourceNcObjs, targetNcObjs, varry);
        if (!canBatch || this.isCollectionOfPath(destPath, ncObj.getRelatedBean()) && this.isCollectionOfSrc(varry)) {
            for (int i = 0; i < sourceNcObjs.length; ++i) {
                this.execFormulaMetaToMeta2(sourceNcObjs[i], targetNcObjs[i], varry);
            }
        } else {
            this.parseMetaFormulaVarBatch(sourceNcObjs, targetNcObjs, varry);
            IType iType = ncObj.getRelatedBean().getAttributeByPath(destPath).getDataType();
            Object[] realValues = null;
            Object[] valueObjs = this.getFormulaParse().getValueO();
            realValues = new Object[targetNcObjs.length];
            for (int i = 0; i < targetNcObjs.length; ++i) {
                realValues[i] = valueObjs.length == 1 && (varry.getVarry() == null || varry.getVarry().length == 0) ? this.getValueByIType(valueObjs[0], iType) : this.getValueByIType(valueObjs[i], iType);
            }
            String errStr = this.getFormulaParse().getError();
            if (!StringUtil.isEmptyWithTrim((String)errStr)) {
                throw new PFBusinessException(errStr);
            }
            int end = targetNcObjs.length;
            for (int i = 0; i < end; ++i) {
                NCObject _ncObj = targetNcObjs[i];
                _ncObj.setAttributeValue(destPath, realValues[i]);
            }
        }
    }

    private void execFormulaMetaToMeta2(NCObject sourceNcObjs, NCObject targetNcObjs, VarryVO varry) throws BusinessException {
        this.parseMetaFormulaVar(sourceNcObjs, targetNcObjs, varry);
        String destPath = varry.getFormulaName();
        IType iType = targetNcObjs.getRelatedBean().getAttributeByPath(destPath).getDataType();
        Object[] realValue = null;
        if (this.isCollectionOfPath(destPath, targetNcObjs.getRelatedBean()) && this.isCollectionOfSrc(varry)) {
            Object[] valueObjs = this.getFormulaParse().getValueO();
            for (int i = 0; i < (valueObjs == null ? 0 : valueObjs.length); ++i) {
                valueObjs[i] = this.getValueByIType(valueObjs[i], iType);
            }
            realValue = valueObjs;
        } else {
            Object valueObj = this.getFormulaParse().getValueAsObject();
            realValue = this.getValueByIType(valueObj, iType);
        }
        String errStr = this.getFormulaParse().getError();
        if (!StringUtil.isEmptyWithTrim((String)errStr)) {
            throw new PFBusinessException(errStr);
        }
        targetNcObjs.setAttributeValue(destPath, (Object)realValue);
    }

    private void execFormulaMetaToMeta2(AggregatedValueObject sourceVO, AggregatedValueObject targetVO, VarryVO varry) throws BusinessException {
        this.parseMetaFormulaVar(sourceVO, targetVO, varry);
        String destPath = varry.getFormulaName();
        NCObject ncObj = NCObject.newInstance((Object)targetVO);
        IType iType = ncObj.getRelatedBean().getAttributeByPath(destPath).getDataType();
        Object[] realValue = null;
        if (this.isCollectionOfPath(destPath, ncObj.getRelatedBean()) && this.isCollectionOfSrc(varry)) {
            Object[] valueObjs = this.getFormulaParse().getValueO();
            for (int i = 0; i < (valueObjs == null ? 0 : valueObjs.length); ++i) {
                valueObjs[i] = this.getValueByIType(valueObjs[i], iType);
            }
            realValue = valueObjs;
        } else {
            Object valueObj = this.getFormulaParse().getValueAsObject();
            realValue = this.getValueByIType(valueObj, iType);
        }
        String errStr = this.getFormulaParse().getError();
        if (!StringUtil.isEmptyWithTrim((String)errStr)) {
            throw new PFBusinessException(errStr);
        }
        ncObj.setAttributeValue(destPath, (Object)realValue);
    }

    private boolean isCollectionOfSrc(VarryVO varry) {
        if (varry.getVarry() != null && varry.getVarry().length > 0) {
            for (String var : varry.getVarry()) {
                Object tmpObj = this.getFormulaParse().getJepParser().getVariables().get(var);
                if (!(tmpObj instanceof List)) continue;
                return true;
            }
        }
        return false;
    }

    private void parseMetaFormulaVarBatch(NCObject[] sourceObjs, NCObject[] targetObjs, VarryVO varry) {
        Logger.debug((Object)"**\u5f00\u59cb\u6267\u884c\u5143\u6570\u636e\u516c\u5f0f");
        for (int j = 0; j < (varry.getVarry() == null ? 0 : varry.getVarry().length); ++j) {
            String var = varry.getVarry()[j];
            ArrayList<Object> values = new ArrayList<Object>();
            List sourceValues = null;
            if (PfBillMappingUtil.isSystemEnvField(var)) {
                Object systemValue = this.getEnvParamValue(var);
                int end = sourceObjs.length;
                for (int index = 0; index < end; ++index) {
                    values.add(systemValue);
                }
            } else {
                sourceValues = DASFacade.getAttributeValue((String[])new String[]{var}, (NCObject[])sourceObjs);
                if (sourceValues == null || sourceValues.size() == 0) {
                    sourceValues = DASFacade.getAttributeValue((String[])new String[]{var}, (NCObject[])targetObjs);
                }
                int end = sourceObjs.length;
                for (int index = 0; index < end && sourceValues != null; ++index) {
                    Object[] temp_sourceValue = (Object[])sourceValues.get(index);
                    Object sourceValue = null;
                    if (temp_sourceValue != null && temp_sourceValue.length != 0) {
                        sourceValue = temp_sourceValue[0];
                    }
                    if (sourceValue instanceof Object[]) {
                        Object temp = null;
                        if (sourceValue != null && ((Object[])sourceValue).length == 1) {
                            temp = ((Object[])sourceValue)[0];
                        }
                        values.add(temp);
                        continue;
                    }
                    values.add(sourceValue);
                }
            }
            this.getFormulaParse().addVariable(var, values);
        }
    }

    private void parseMetaFormulaVarBatch(AggregatedValueObject[] sourceVOs, AggregatedValueObject[] targetVOs, VarryVO varry) {
        Logger.debug((Object)"**\u5f00\u59cb\u6267\u884c\u5143\u6570\u636e\u516c\u5f0f");
        NCObject[] sourceObjs = new NCObject[sourceVOs.length];
        NCObject[] targetObjs = new NCObject[targetVOs.length];
        int end = sourceObjs.length;
        for (int index = 0; index < end; ++index) {
            sourceObjs[index] = NCObject.newInstance((Object)sourceVOs[index]);
        }
        for (int j = 0; j < (varry.getVarry() == null ? 0 : varry.getVarry().length); ++j) {
            String var = varry.getVarry()[j];
            ArrayList<Object> values = new ArrayList<Object>();
            List sourceValues = null;
            if (PfBillMappingUtil.isSystemEnvField(var)) {
                Object systemValue = this.getEnvParamValue(var);
                int end2 = sourceObjs.length;
                for (int index = 0; index < end2; ++index) {
                    values.add(systemValue);
                }
            } else {
                int end3;
                sourceValues = DASFacade.getAttributeValue((String[])new String[]{var}, (NCObject[])sourceObjs);
                if (sourceValues == null || sourceValues.size() == 0) {
                    end3 = targetObjs.length;
                    for (int index = 0; index < end3; ++index) {
                        targetObjs[index] = NCObject.newInstance((Object)targetVOs[index]);
                    }
                    sourceValues = DASFacade.getAttributeValue((String[])new String[]{var}, (NCObject[])targetObjs);
                }
                end3 = sourceObjs.length;
                for (int index = 0; index < end3 && sourceValues != null; ++index) {
                    Object[] temp_sourceValue = (Object[])sourceValues.get(index);
                    Object sourceValue = null;
                    if (temp_sourceValue != null && temp_sourceValue.length != 0) {
                        sourceValue = temp_sourceValue[0];
                    }
                    if (sourceValue instanceof Object[]) {
                        Object temp = null;
                        if (sourceValue != null && ((Object[])sourceValue).length == 1) {
                            temp = ((Object[])sourceValue)[0];
                        }
                        values.add(temp);
                        continue;
                    }
                    values.add(sourceValue);
                }
            }
            this.getFormulaParse().addVariable(var, values);
        }
    }

    private void parseMetaFormulaVar(NCObject sourceNcObjs, NCObject targetNcObjs, VarryVO varry) {
        Logger.debug((Object)"**\u5f00\u59cb\u6267\u884c\u5143\u6570\u636e\u516c\u5f0f");
        for (int j = 0; j < (varry.getVarry() == null ? 0 : varry.getVarry().length); ++j) {
            String var = varry.getVarry()[j];
            Object value = this.getVarValueFromMetadata(sourceNcObjs, var);
            if (value == null) {
                value = this.getVarValueFromMetadata(targetNcObjs, var);
            }
            this.getFormulaParse().addVariable(var, value);
            Logger.debug((Object)("**\u53d8\u91cfvar=" + var + ";\u8d4b\u503cvalue=" + value));
        }
    }

    private void parseMetaFormulaVar(AggregatedValueObject sourceVO, AggregatedValueObject targetVO, VarryVO varry) {
        Logger.debug((Object)"**\u5f00\u59cb\u6267\u884c\u5143\u6570\u636e\u516c\u5f0f");
        for (int j = 0; j < (varry.getVarry() == null ? 0 : varry.getVarry().length); ++j) {
            String var = varry.getVarry()[j];
            Object value = this.getVarValueFromMetadata(sourceVO, var);
            if (value == null) {
                value = this.getVarValueFromMetadata(targetVO, var);
            }
            this.getFormulaParse().addVariable(var, value);
            Logger.debug((Object)("**\u53d8\u91cfvar=" + var + ";\u8d4b\u503cvalue=" + value));
        }
    }

    private void execFieldsMetaToMetaBatch(AggregatedValueObject[] sourceVOs, AggregatedValueObject[] targetVOs) {
        int end;
        int i;
        if (this.sMoves == null || this.sMoves.length == 0) {
            return;
        }
        NCObject[] targetNcObjs = new NCObject[targetVOs.length];
        NCObject[] sourceNcObjs = new NCObject[sourceVOs.length];
        int end2 = targetVOs.length;
        for (i = 0; i < end2; ++i) {
            targetNcObjs[i] = NCObject.newInstance((Object)targetVOs[i]);
        }
        end2 = sourceVOs.length;
        for (i = 0; i < end2; ++i) {
            sourceNcObjs[i] = NCObject.newInstance((Object)sourceVOs[i]);
        }
        Object value = null;
        HashMap<String, String> noSysEnvPathsMap = new HashMap<String, String>();
        HashMap<String, String> sysEnvPathsMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < this.sMoves.length; ++i2) {
            if (PfBillMappingUtil.isSystemEnvField(this.sMoves[i2][1])) {
                sysEnvPathsMap.put(this.sMoves[i2][0], this.sMoves[i2][1]);
                continue;
            }
            noSysEnvPathsMap.put(this.sMoves[i2][0], this.sMoves[i2][1]);
        }
        Set syskeys = sysEnvPathsMap.keySet();
        for (String name : syskeys) {
            String srcPath = (String)sysEnvPathsMap.get(name);
            Object valueObj = this.getEnvParamValue(srcPath);
            for (NCObject targetNcObj : targetNcObjs) {
                if (valueObj == null) continue;
                IType iType = targetNcObj.getRelatedBean().getAttributeByPath(name).getDataType();
                this.doMeta2Meta(targetNcObj, valueObj, iType, name);
            }
        }
        String[] destAttributes = noSysEnvPathsMap.keySet().toArray(new String[0]);
        ArrayList srcAttributes = new ArrayList();
        int end3 = destAttributes.length;
        for (int start = 0; start < end3; ++start) {
            srcAttributes.add(noSysEnvPathsMap.get(destAttributes[start]));
        }
        List varValueArr = DASFacade.getAttributeValue((String[])srcAttributes.toArray(new String[0]), (NCObject[])sourceNcObjs);
        int n = end = targetNcObjs == null ? 0 : targetNcObjs.length;
        for (int start = 0; start < end; ++start) {
            Object[] varValues = (Object[])varValueArr.get(start);
            int k = destAttributes.length;
            for (int j = 0; j < k; ++j) {
                IAttribute ittribute = targetNcObjs[start].getRelatedBean().getAttributeByPath(destAttributes[j]);
                if (ittribute == null) {
                    String error = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow65", "BillMappingConvertor-31200001", null, new String[]{destAttributes[j]});
                    throw new BusinessRuntimeException(error);
                }
                IType iType = ittribute.getDataType();
                Object valueObj = varValues[j];
                if (valueObj == null) continue;
                this.doMeta2Meta(targetNcObjs[start], valueObj, iType, destAttributes[j]);
            }
        }
    }

    private void execFieldsMetaToMetaBatch(NCObject[] sourceNcObjs, NCObject[] targetNcObjs) {
        int end;
        IType iType;
        if (this.sMoves == null || this.sMoves.length == 0) {
            return;
        }
        Object value = null;
        HashMap<String, String> noSysEnvPathsMap = new HashMap<String, String>();
        HashMap<String, String> sysEnvPathsMap = new HashMap<String, String>();
        for (int i = 0; i < this.sMoves.length; ++i) {
            if (PfBillMappingUtil.isSystemEnvField(this.sMoves[i][1])) {
                sysEnvPathsMap.put(this.sMoves[i][0], this.sMoves[i][1]);
                continue;
            }
            noSysEnvPathsMap.put(this.sMoves[i][0], this.sMoves[i][1]);
        }
        Set syskeys = sysEnvPathsMap.keySet();
        for (String name : syskeys) {
            String srcPath = (String)sysEnvPathsMap.get(name);
            Object valueObj = this.getEnvParamValue(srcPath);
            for (NCObject targetNcObj : targetNcObjs) {
                if (valueObj == null) continue;
                iType = targetNcObj.getRelatedBean().getAttributeByPath(name).getDataType();
                this.doMeta2Meta(targetNcObj, valueObj, iType, name);
            }
        }
        String[] destAttributes = noSysEnvPathsMap.keySet().toArray(new String[0]);
        ArrayList srcAttributes = new ArrayList();
        int end2 = destAttributes.length;
        for (int start = 0; start < end2; ++start) {
            srcAttributes.add(noSysEnvPathsMap.get(destAttributes[start]));
        }
        List varValueArr = DASFacade.getAttributeValue((String[])srcAttributes.toArray(new String[0]), (NCObject[])sourceNcObjs);
        int n = end = targetNcObjs == null ? 0 : targetNcObjs.length;
        for (int start = 0; start < end; ++start) {
            Object[] varValues = (Object[])varValueArr.get(start);
            int k = destAttributes.length;
            for (int j = 0; j < k; ++j) {
                iType = targetNcObjs[start].getRelatedBean().getAttributeByPath(destAttributes[j]).getDataType();
                Object valueObj = varValues[j];
                if (valueObj == null) continue;
                this.doMeta2Meta(targetNcObjs[start], valueObj, iType, destAttributes[j]);
            }
        }
    }

    private void execFieldsMetaToMeta(AggregatedValueObject sourceVO, AggregatedValueObject targetVO) {
        if (this.sMoves == null || this.sMoves.length == 0) {
            return;
        }
        NCObject ncObj = NCObject.newInstance((Object)targetVO);
        NCObject sourceObj = NCObject.newInstance((Object)sourceVO);
        Object value = null;
        HashMap<String, String> noSysEnvPathsMap = new HashMap<String, String>();
        HashMap<String, String> sysEnvPathsMap = new HashMap<String, String>();
        for (int i = 0; i < this.sMoves.length; ++i) {
            if (PfBillMappingUtil.isSystemEnvField(this.sMoves[i][1])) {
                sysEnvPathsMap.put(this.sMoves[i][0], this.sMoves[i][1]);
                continue;
            }
            noSysEnvPathsMap.put(this.sMoves[i][0], this.sMoves[i][1]);
        }
        Set syskeys = sysEnvPathsMap.keySet();
        for (String name : syskeys) {
            String srcPath = (String)sysEnvPathsMap.get(name);
            Object valueObj = this.getEnvParamValue(srcPath);
            if (valueObj == null) continue;
            IType iType = ncObj.getRelatedBean().getAttributeByPath(name).getDataType();
            this.doMeta2Meta(ncObj, valueObj, iType, name);
        }
        String[] destAttributes = noSysEnvPathsMap.keySet().toArray(new String[0]);
        ArrayList srcAttributes = new ArrayList();
        int end = destAttributes.length;
        for (int start = 0; start < end; ++start) {
            srcAttributes.add(noSysEnvPathsMap.get(destAttributes[start]));
        }
        Object[] varValues = this.getVarValueFromMetadataBatch(sourceObj, srcAttributes.toArray(new String[0]));
        int end2 = destAttributes.length;
        for (int i = 0; i < end2; ++i) {
            Object valueObj = varValues[i];
            if (valueObj == null) continue;
            IType iType = ncObj.getRelatedBean().getAttributeByPath(destAttributes[i]).getDataType();
            this.doMeta2Meta(ncObj, valueObj, iType, destAttributes[i]);
        }
    }

    private void doMeta2Meta(NCObject ncObj, Object valueObj, IType iType, String name) {
        if (PfMetadataTools.isObjectArray(valueObj)) {
            int len = Array.getLength(valueObj);
            Object[] objArray = new Object[len];
            for (int j = 0; j < len; ++j) {
                objArray[j] = this.getValueByIType(Array.get(valueObj, j), iType);
            }
            if (this.isCollectionOfPath(name, ncObj.getRelatedBean())) {
                ncObj.setAttributeValue(name, (Object)objArray);
            } else {
                ncObj.setAttributeValue(name, Array.get(objArray, 0));
            }
        } else {
            ncObj.setAttributeValue(name, this.getValueByIType(valueObj, iType));
        }
    }

    private void doMeta2Meta(NCObject[] ncObj, Object valueObj, IType iType, String name) {
        if (PfMetadataTools.isObjectArray(valueObj)) {
            int len = Array.getLength(valueObj);
            Object[] objArray = new Object[len];
            for (int j = 0; j < len; ++j) {
                objArray[j] = this.getValueByIType(Array.get(valueObj, j), iType);
            }
            if (this.isCollectionOfPath(name, ncObj[0].getRelatedBean())) {
                for (int k = 0; k < ncObj.length; ++k) {
                    ncObj[k].setAttributeValue(name, (Object)objArray);
                }
            } else {
                Object headvalue = Array.get(objArray, 0);
                for (int k = 0; k < ncObj.length; ++k) {
                    ncObj[k].setAttributeValue(name, headvalue);
                }
            }
        } else {
            Object headvalue = this.getValueByIType(valueObj, iType);
            for (int k = 0; k < ncObj.length; ++k) {
                ncObj[k].setAttributeValue(name, headvalue);
            }
        }
    }

    private void execAssignsForMetadata(AggregatedValueObject targetVO) {
        if (this.sAssigns == null || this.sAssigns.length == 0) {
            return;
        }
        NCObject ncObj = NCObject.newInstance((Object)targetVO);
        for (int i = 0; i < this.sAssigns.length; ++i) {
            IAttribute attr;
            Logger.debug((Object)(" \u6267\u884c\u8d4b\u503c\uff1a" + this.sAssigns[i][0] + "->" + this.sAssigns[i][1]));
            Object valueObj = this.sAssigns[i][1];
            if (PfBillMappingUtil.isSystemEnvField(this.sAssigns[i][1])) {
                valueObj = this.getEnvParamValue(this.sAssigns[i][1]);
            }
            if ((attr = ncObj.getRelatedBean().getAttributeByPath(this.sAssigns[i][0])) == null) {
                Logger.error((Object)("\u53d6\u8def\u5f84\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5VO\u4ea4\u6362\u8def\u5f84\u7684\u914d\u7f6e\uff0c\u5b9e\u4f53\uff1a" + ncObj.getRelatedBean().getDisplayName() + "###\u9519\u8bef\u7684\u5c5e\u6027\u8def\u5f84\uff1a\uff1a" + this.sAssigns[i][0]));
                continue;
            }
            ncObj.setAttributeValue(this.sAssigns[i][0], this.getValueByIType(valueObj, attr.getDataType()));
        }
    }

    private void execAssignsForMetadata(NCObject ncObj) {
        if (this.sAssigns == null || this.sAssigns.length == 0) {
            return;
        }
        for (int i = 0; i < this.sAssigns.length; ++i) {
            IAttribute attr;
            Logger.debug((Object)(" \u6267\u884c\u8d4b\u503c\uff1a" + this.sAssigns[i][0] + "->" + this.sAssigns[i][1]));
            Object valueObj = this.sAssigns[i][1];
            if (PfBillMappingUtil.isSystemEnvField(this.sAssigns[i][1])) {
                valueObj = this.getEnvParamValue(this.sAssigns[i][1]);
            }
            if ((attr = ncObj.getRelatedBean().getAttributeByPath(this.sAssigns[i][0])) == null) {
                Logger.error((Object)("\u53d6\u8def\u5f84\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5VO\u4ea4\u6362\u8def\u5f84\u7684\u914d\u7f6e\uff0c\u5b9e\u4f53\uff1a" + ncObj.getRelatedBean().getDisplayName() + "###\u9519\u8bef\u7684\u5c5e\u6027\u8def\u5f84\uff1a\uff1a" + this.sAssigns[i][0]));
                continue;
            }
            ncObj.setAttributeValue(this.sAssigns[i][0], this.getValueByIType(valueObj, attr.getDataType()));
        }
    }

    private Object getValueByIType(Object valueObj, IType iType) {
        if (valueObj == null) {
            return null;
        }
        Object objTarget = valueObj;
        objTarget = iType.valueOf(valueObj);
        return objTarget;
    }

    public AggregatedValueObject[] retChangeBusiVOs(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject[] sorceVOs) throws BusinessException {
        IChangeVOAdjust reserveAfterClass;
        if (sorceVOs == null || sorceVOs.length == 0) {
            return null;
        }
        AggregatedValueObject[] originalVOs = sorceVOs;
        ChangeVOAdjustContext adjustContext = new ChangeVOAdjustContext();
        adjustContext.setSrcBilltype(srcBillOrTranstype);
        adjustContext.setDestBilltype(destBillOrTranstype);
        adjustContext.clearSplitList().addAll(this.getSplitVOList());
        IChangeVOAdjust reserveBeforeClass = this.getReserveClassImpl(this.getReserveFrontClass());
        if (reserveBeforeClass != null && ((sorceVOs = reserveBeforeClass.batchAdjustBeforeChange(sorceVOs, adjustContext)) == null || sorceVOs.length == 0)) {
            return null;
        }
        IChangeVOAdjust beforeClassImpl = this.getBeforeClassImpl();
        if (beforeClassImpl != null && ((sorceVOs = beforeClassImpl.batchAdjustBeforeChange(sorceVOs, adjustContext)) == null || sorceVOs.length == 0)) {
            return null;
        }
        BillSplitter pfSplit = new BillSplitter();
        sorceVOs = pfSplit.splitBeforProc(sorceVOs, adjustContext);
        AggregatedValueObject[] tagVOs = new AggregatedValueObject[]{};
        tagVOs = this.metadataToMetadataBatch(srcBillOrTranstype, destBillOrTranstype, sorceVOs, tagVOs);
        tagVOs = pfSplit.splitAfterProc(sorceVOs, tagVOs, adjustContext);
        IChangeVOAdjust afterClassImpl = this.getAfterClassImpl();
        if (afterClassImpl != null) {
            tagVOs = afterClassImpl.batchAdjustAfterChange(sorceVOs, tagVOs, adjustContext);
        }
        if ((reserveAfterClass = this.getReserveClassImpl(this.getReserveBackClass())) != null) {
            tagVOs = reserveAfterClass.batchAdjustAfterChange(sorceVOs, tagVOs, adjustContext);
        }
        pfSplit.clearSplitChange(originalVOs, adjustContext);
        return tagVOs;
    }

    public AggregatedValueObject[] retChangeBusiVOs(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject[] sorceVOs, int classifyMode) throws BusinessException {
        IChangeVOAdjust reserveAfterClass;
        if (sorceVOs == null || sorceVOs.length == 0) {
            return null;
        }
        AggregatedValueObject[] originalVOs = sorceVOs;
        ChangeVOAdjustContext adjustContext = new ChangeVOAdjustContext();
        adjustContext.setSrcBilltype(srcBillOrTranstype);
        adjustContext.setDestBilltype(destBillOrTranstype);
        adjustContext.clearSplitList().addAll(this.getSplitVOList());
        IChangeVOAdjust reserveBeforeClass = this.getReserveClassImpl(this.getReserveFrontClass());
        if (reserveBeforeClass != null && ((sorceVOs = reserveBeforeClass.batchAdjustBeforeChange(sorceVOs, adjustContext)) == null || sorceVOs.length == 0)) {
            return null;
        }
        IChangeVOAdjust beforeClassImpl = this.getBeforeClassImpl();
        if (beforeClassImpl != null && ((sorceVOs = beforeClassImpl.batchAdjustBeforeChange(sorceVOs, adjustContext)) == null || sorceVOs.length == 0)) {
            return null;
        }
        long start = System.currentTimeMillis();
        BillSplitter pfSplit = new BillSplitter();
        sorceVOs = pfSplit.splitBeforProc(sorceVOs, adjustContext);
        AggregatedValueObject[] tagVOs = new AggregatedValueObject[]{};
        tagVOs = this.metadataToMetadataBatch(srcBillOrTranstype, destBillOrTranstype, sorceVOs, tagVOs, classifyMode);
        tagVOs = pfSplit.splitAfterProc(sorceVOs, tagVOs, adjustContext);
        start = System.currentTimeMillis();
        IChangeVOAdjust afterClassImpl = this.getAfterClassImpl();
        if (afterClassImpl != null) {
            tagVOs = afterClassImpl.batchAdjustAfterChange(sorceVOs, tagVOs, adjustContext);
        }
        if ((reserveAfterClass = this.getReserveClassImpl(this.getReserveBackClass())) != null) {
            tagVOs = reserveAfterClass.batchAdjustAfterChange(sorceVOs, tagVOs, adjustContext);
        }
        pfSplit.clearSplitChange(originalVOs, adjustContext);
        return tagVOs;
    }

    private AggregatedValueObject[] metadataToMetadataBatch(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject[] sorceVOs, AggregatedValueObject[] tagVOs) throws BusinessException {
        tagVOs = PfBillMappingUtil.initDestBillVOs(srcBillOrTranstype, destBillOrTranstype, sorceVOs, this);
        for (int i = 0; i < sorceVOs.length; ++i) {
            AggregatedValueObject sourceVO = sorceVOs[i];
            AggregatedValueObject targetVO = tagVOs[i];
            this.execAssignsForMetadata(targetVO);
        }
        this.execFieldsMetaToMetaBatch(sorceVOs, tagVOs);
        this.execFormulasMetaToMetaBatch(sorceVOs, tagVOs);
        return tagVOs;
    }

    private AggregatedValueObject[] metadataToMetadataBatch(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject[] sorceVOs, AggregatedValueObject[] tagVOs, int classifyMode) throws BusinessException {
        tagVOs = PfBillMappingUtil.initDestBillVOs(srcBillOrTranstype, destBillOrTranstype, sorceVOs, this, classifyMode);
        for (int i = 0; i < sorceVOs.length; ++i) {
            AggregatedValueObject sourceVO = sorceVOs[i];
            AggregatedValueObject targetVO = tagVOs[i];
            this.execAssignsForMetadata(targetVO);
        }
        this.execFieldsMetaToMetaBatch(sorceVOs, tagVOs);
        this.execFormulasMetaToMetaBatch(sorceVOs, tagVOs);
        return tagVOs;
    }

    public static boolean isParentField(String key) {
        if (key == null) {
            return false;
        }
        return key.startsWith("H_");
    }

    public static boolean isChildField(String key) {
        if (key == null) {
            return false;
        }
        return key.startsWith("B_");
    }

    private boolean isCollectionOfPath(String strPath, IBean bean) {
        IAttribute attr = null;
        int npos = strPath.indexOf(46);
        if (npos < 0) {
            attr = bean.getAttributeByName(strPath);
            return MDUtil.isCollectionType((IType)attr.getDataType());
        }
        String[] paths = strPath.split("\\.");
        StringBuffer newPath = new StringBuffer();
        for (int j = 0; j < paths.length; ++j) {
            newPath.append(paths[j]);
            attr = bean.getAttributeByPath(newPath.toString());
            if (MDUtil.isCollectionType((IType)attr.getDataType())) {
                return true;
            }
            newPath.append(".");
        }
        return false;
    }

    private Object getEnvParamValue(String srcField) {
        String valueObj = null;
        if (srcField.equals("SYSDATE")) {
            valueObj = this.m_strDate;
        } else if (srcField.equals("BUZIDATE")) {
            valueObj = this.m_strBuziDate;
        } else if (srcField.equals("SYSOPERATOR")) {
            valueObj = this.m_strOperator;
        } else if (srcField.equals("SYSGROUP")) {
            valueObj = this.m_strGroup;
        } else if (srcField.equals("SYSTIME")) {
            valueObj = this.m_strNowTime;
        } else if (srcField.equals("BUZITIME")) {
            valueObj = this.m_strBuziTime;
        } else if (srcField.equals("NCSYSUSER")) {
            valueObj = "NC_USER0000000000000";
        } else if (srcField.equals("DESTBILLTYPE")) {
            valueObj = this.m_destBilltype;
        } else if (srcField.equals("DESTTRANSTYPE")) {
            valueObj = this.m_destTranstype;
        }
        return valueObj;
    }

    private Object getVarValueFromMetadata(NCObject ncObj, String srcPath) {
        Object valueObj = null;
        if (PfBillMappingUtil.isSystemEnvField(srcPath)) {
            valueObj = this.getEnvParamValue(srcPath);
        } else {
            valueObj = ncObj.getAttributeValue(srcPath);
            if (valueObj != null && !valueObj.equals("") && valueObj instanceof String) {
                valueObj = valueObj.toString();
            }
        }
        return valueObj;
    }

    private Object getVarValueFromMetadata(AggregatedValueObject sourceVO, String srcPath) {
        Object valueObj = null;
        if (PfBillMappingUtil.isSystemEnvField(srcPath)) {
            valueObj = this.getEnvParamValue(srcPath);
        } else {
            NCObject ncObj = NCObject.newInstance((Object)sourceVO);
            valueObj = ncObj.getAttributeValue(srcPath);
            if (valueObj != null && !valueObj.equals("") && valueObj instanceof String) {
                valueObj = valueObj.toString();
            }
        }
        return valueObj;
    }

    private Object[] getVarValueFromMetadataBatch(AggregatedValueObject[] sourceVOs, String srcPath) {
        Object[] results = new Object[sourceVOs.length];
        if (PfBillMappingUtil.isSystemEnvField(srcPath)) {
            Object fillValue = this.getEnvParamValue(srcPath);
            Arrays.fill(results, fillValue);
        } else {
            NCObject[] ncObjs = new NCObject[sourceVOs.length];
            int end = sourceVOs.length;
            for (int start = 0; start < end; ++start) {
                ncObjs[start] = NCObject.newInstance((Object)sourceVOs[start]);
            }
            List valueObjArr = DASFacade.getAttributeValue((String[])new String[]{srcPath}, (NCObject[])ncObjs);
            int end2 = results.length;
            for (int start = 0; start < end2; ++start) {
                Object[] objs = (Object[])valueObjArr.get(start);
                Object result = objs[0];
                if (result != null && !result.equals("") && result instanceof String) {
                    result = result.toString();
                }
                results[start] = result;
            }
        }
        return results;
    }

    private Object[] getVarValueFromMetadataBatch(NCObject sourceObj, String[] srcPaths) {
        Object[] valueObjs = sourceObj.getAttributeValue(srcPaths);
        return valueObjs;
    }

    private Object getVarValueFromMetadata2(NCObject sourceObj, String srcPath) {
        Object valueObj = null;
        if (PfBillMappingUtil.isSystemEnvField(srcPath)) {
            valueObj = this.getEnvParamValue(srcPath);
        } else {
            valueObj = sourceObj.getAttributeValue(srcPath);
            if (valueObj != null && !valueObj.equals("") && valueObj instanceof String) {
                valueObj = valueObj.toString();
            }
        }
        return valueObj;
    }

    public void initFormulaParse() {
        Logger.debug((Object)">>>AbstractConversion.initFormulaParse() called");
        if (this.uFunctions == null) {
            return;
        }
        for (int i = 0; i < this.uFunctions.length; ++i) {
            String className = this.uFunctions[i].getClassName();
            String methodName = this.uFunctions[i].getMethodName();
            Class returnType = this.uFunctions[i].getReturnType();
            Logger.debug((Object)(">>>className=" + className));
            Logger.debug((Object)(">>>methodName=" + methodName));
            Logger.debug((Object)(">>>returnType=" + returnType));
            this.getFormulaParse().setSelfMethod(className, methodName, returnType, this.uFunctions[i].getArgTypes(), false);
        }
    }

    public static String getFieldName(String key) {
        String fieldname = null;
        fieldname = key.startsWith("H_") || key.startsWith("B_") ? key.substring(2) : key;
        return fieldname;
    }

    protected void setValueToVo(Object valueObj, CircularlyAccessibleValueObject billvo, String fieldName, Class fieldType) {
        Object dblTarget;
        if (valueObj == null) {
            return;
        }
        if (fieldType == null) {
            return;
        }
        Object oTarget = valueObj;
        if (fieldType.equals(String.class)) {
            String strTarget = valueObj.toString();
            oTarget = strTarget;
        }
        if (fieldType.equals(UFDouble.class)) {
            if (valueObj instanceof UFDouble) {
                oTarget = valueObj;
            } else {
                dblTarget = new UFDouble(valueObj.toString());
                oTarget = dblTarget;
            }
        }
        if (fieldType.equals(Integer.class)) {
            if (valueObj instanceof Integer) {
                oTarget = valueObj;
            } else {
                dblTarget = Integer.valueOf(valueObj.toString());
                oTarget = dblTarget;
            }
        }
        if (fieldType.equals(UFBoolean.class)) {
            dblTarget = UFBoolean.valueOf((String)valueObj.toString());
            oTarget = dblTarget;
        }
        if (fieldType.equals(UFDate.class)) {
            if (valueObj instanceof UFDate) {
                oTarget = valueObj;
            } else {
                dblTarget = new UFDate(valueObj.toString());
                oTarget = dblTarget;
            }
        }
        billvo.setAttributeValue(fieldName, oTarget);
    }

    protected Class getFieldType(CircularlyAccessibleValueObject billvo, String fieldName) {
        Class cl = null;
        try {
            cl = billvo.getClass().getDeclaredField("m_" + fieldName).getType();
        }
        catch (NoSuchFieldException e) {
            try {
                cl = billvo.getClass().getDeclaredField(fieldName).getType();
            }
            catch (NoSuchFieldException ex) {
                cl = String.class;
            }
            catch (Exception ex) {
                Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return cl;
    }

    public void setDestTranstype(String transtype) {
        this.m_destTranstype = transtype;
    }

    public String getReserveFrontClass() {
        return this.reserveFrontClass;
    }

    public void setReserveFrontClass(String reserveFrontClass) {
        this.reserveFrontClass = reserveFrontClass;
    }

    public String getReserveBackClass() {
        return this.reserveBackClass;
    }

    public void setReserveBackClass(String reserveBackClass) {
        this.reserveBackClass = reserveBackClass;
    }
}

