/*
 * Decompiled with CFR 0.152.
 */
package nccloud.riawf.flowchar.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import nc.bs.logging.Logger;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class NccMultiLinedView
extends VertexView {
    protected static transient MultiLinedRenderer renderer = new MultiLinedRenderer();
    protected static transient MultiLinedEditor editor = new MultiLinedEditor();

    public NccMultiLinedView() {
    }

    public NccMultiLinedView(Object cell) {
        super(cell);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public GraphCellEditor getEditor() {
        return editor;
    }

    public static class MultiLinedRenderer
    extends JTextArea
    implements CellViewRenderer {
        protected transient JGraph graph = null;
        protected transient Color gradientColor = null;
        protected transient boolean hasFocus;
        protected transient boolean selected;
        protected transient boolean preview;

        public MultiLinedRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
            this.setText(view.getCell().toString());
            this.graph = graph;
            this.selected = sel;
            this.preview = preview;
            this.hasFocus = focus;
            AttributeMap attributes = view.getAllAttributes();
            this.installAttributes(graph, (Map)attributes);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            try {
                if (this.gradientColor != null && !this.preview) {
                    this.setOpaque(false);
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                    g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(g);
                this.paintSelectionBorder(g);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void paintSelectionBorder(Graphics g) {
            ((Graphics2D)g).setStroke(GraphConstants.SELECTION_STROKE);
            if (this.hasFocus && this.selected) {
                g.setColor(this.graph.getLockedHandleColor());
            } else if (this.selected) {
                g.setColor(this.graph.getHighlightColor());
            }
            if (this.selected) {
                Dimension d = this.getSize();
                g.drawRect(0, 0, d.width - 1, d.height - 1);
            }
        }

        protected void installAttributes(JGraph graph, Map attributes) {
            this.setOpaque(GraphConstants.isOpaque((Map)attributes));
            Color foreground = GraphConstants.getForeground((Map)attributes);
            this.setForeground(foreground != null ? foreground : graph.getForeground());
            Color background = GraphConstants.getBackground((Map)attributes);
            this.setBackground(background != null ? background : graph.getBackground());
            Font font = GraphConstants.getFont((Map)attributes);
            this.setFont(font != null ? font : graph.getFont());
            Border border = GraphConstants.getBorder((Map)attributes);
            Color bordercolor = GraphConstants.getBorderColor((Map)attributes);
            if (border != null) {
                this.setBorder(border);
            } else if (bordercolor != null) {
                int borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth((Map)attributes)));
                this.setBorder(BorderFactory.createLineBorder(bordercolor, borderWidth));
            }
            this.gradientColor = GraphConstants.getGradientColor((Map)attributes);
        }
    }

    public static class MultiLinedEditor
    extends DefaultGraphCellEditor {
        public Component getGraphCellEditorComponent(JGraph graph, Object cell, boolean isSelected) {
            Component component = super.getGraphCellEditorComponent(graph, cell, isSelected);
            CellView view = graph.getGraphLayoutCache().getMapping(cell, false);
            Rectangle2D tmp = view.getBounds();
            this.editingComponent.setBounds((int)tmp.getX(), (int)tmp.getY(), (int)tmp.getWidth(), (int)tmp.getHeight());
            Font font = GraphConstants.getFont((Map)view.getAllAttributes());
            this.editingComponent.setFont(font != null ? font : graph.getFont());
            return component;
        }

        protected GraphCellEditor createGraphCellEditor() {
            return new RealCellEditor();
        }

        protected Container createContainer() {
            return new ModifiedEditorContainer();
        }

        class ModifiedEditorContainer
        extends DefaultGraphCellEditor.EditorContainer {
            ModifiedEditorContainer() {
                super((DefaultGraphCellEditor)MultiLinedEditor.this);
            }

            public void doLayout() {
                super.doLayout();
                Dimension cSize = this.getSize();
                Dimension dim = MultiLinedEditor.this.editingComponent.getSize();
                MultiLinedEditor.this.editingComponent.setSize(dim.width - 2, dim.height);
                this.setSize(cSize.width, this.getPreferredSize().height);
            }
        }

        public class RealCellEditor
        extends AbstractCellEditor
        implements GraphCellEditor {
            JTextArea editorComponent = new JTextArea();

            public RealCellEditor() {
                this.editorComponent.setBorder(UIManager.getBorder("Tree.editorBorder"));
                this.editorComponent.setLineWrap(true);
                this.editorComponent.setWrapStyleWord(true);
                this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
                this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 64), "shiftEnter");
                this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 128), "metaEnter");
                this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
                this.editorComponent.getActionMap().put("enter", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RealCellEditor.this.stopCellEditing();
                    }
                });
                AbstractAction newLineAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Document doc = RealCellEditor.this.editorComponent.getDocument();
                        try {
                            doc.insertString(RealCellEditor.this.editorComponent.getCaretPosition(), "\n", null);
                        }
                        catch (BadLocationException e1) {
                            Logger.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                };
                this.editorComponent.getActionMap().put("shiftEnter", newLineAction);
                this.editorComponent.getActionMap().put("metaEnter", newLineAction);
            }

            public Component getGraphCellEditorComponent(JGraph graph, Object value, boolean isSelected) {
                this.editorComponent.setText(value.toString());
                this.editorComponent.selectAll();
                return this.editorComponent;
            }

            @Override
            public Object getCellEditorValue() {
                return this.editorComponent.getText();
            }

            @Override
            public boolean stopCellEditing() {
                CellView view = MultiLinedEditor.this.graph.getGraphLayoutCache().getMapping(MultiLinedEditor.this.graph.getEditingCell(), false);
                AttributeMap map = view.getAllAttributes();
                Rectangle2D cellBounds = GraphConstants.getBounds((Map)map);
                Rectangle editingBounds = this.editorComponent.getBounds();
                GraphConstants.setBounds((Map)map, (Rectangle2D)new Rectangle((int)cellBounds.getX(), (int)cellBounds.getY(), editingBounds.width, editingBounds.height));
                return super.stopCellEditing();
            }

            @Override
            public boolean shouldSelectCell(EventObject event) {
                this.editorComponent.requestFocus();
                return super.shouldSelectCell(event);
            }
        }
    }
}

