/*
 * Decompiled with CFR 0.152.
 */
package nccloud.riawf.flowchar.graph;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class NccEllipseView
extends VertexView {
    public static transient EllipseRenderer renderer = new EllipseRenderer();

    public NccEllipseView() {
    }

    public NccEllipseView(Object cell) {
        super(cell);
    }

    public Point2D getPerimeterPoint(Point2D source, Point2D p) {
        double yout;
        double xout;
        double dist2Squared;
        Rectangle2D r = this.getBounds();
        double x = r.getX();
        double y = r.getY();
        double a = (r.getWidth() + 1.0) / 2.0;
        double b = (r.getHeight() + 1.0) / 2.0;
        double x0 = x + a;
        double y0 = y + b;
        double x1 = p.getX();
        double y1 = p.getY();
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (dx == 0.0) {
            return new Point((int)x0, (int)(y0 + b * dy / Math.abs(dy)));
        }
        double d = dy / dx;
        double h = y0 - d * x0;
        double e = a * a * d * d + b * b;
        double f = -2.0 * x0 * e;
        double g = a * a * d * d * x0 * x0 + b * b * x0 * x0 - a * a * b * b;
        double det = Math.sqrt(f * f - 4.0 * e * g);
        double xout1 = (-f + det) / (2.0 * e);
        double xout2 = (-f - det) / (2.0 * e);
        double yout1 = d * xout1 + h;
        double yout2 = d * xout2 + h;
        double dist1Squared = Math.pow(xout1 - x1, 2.0) + Math.pow(yout1 - y1, 2.0);
        if (dist1Squared < (dist2Squared = Math.pow(xout2 - x1, 2.0) + Math.pow(yout2 - y1, 2.0))) {
            xout = xout1;
            yout = yout1;
        } else {
            xout = xout2;
            yout = yout2;
        }
        return this.getAttributes().createPoint(xout, yout);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public static class EllipseRenderer
    extends VertexRenderer {
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width += d.width / 8;
            d.height += d.height / 2;
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            int b = this.borderWidth;
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            boolean tmp = this.selected;
            if (super.isOpaque()) {
                g.setColor(super.getBackground());
                if (this.gradientColor != null && !this.preview) {
                    this.setOpaque(false);
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                }
                g.fillOval(b - 1, b - 1, d.width - b, d.height - b);
            }
            try {
                this.setBorder(null);
                this.setOpaque(false);
                this.selected = false;
                super.paint(g);
            }
            finally {
                this.selected = tmp;
            }
            if (this.bordercolor != null) {
                g.setColor(this.bordercolor);
                g2.setStroke(new BasicStroke(b));
                g.drawOval(b - 1, b - 1, d.width - b, d.height - b);
            }
            if (this.selected) {
                g2.setStroke(GraphConstants.SELECTION_STROKE);
                g.setColor(this.highlightColor);
                g.drawOval(b - 1, b - 1, d.width - b, d.height - b);
            }
        }
    }
}

