/*
 * Decompiled with CFR 0.152.
 */
package nccloud.riawf.flowchar;

import java.awt.event.MouseEvent;
import nccloud.riawf.flowchar.graph.NccAbstractFlowCell;
import nccloud.riawf.flowchar.graph.NccActivityView;
import nccloud.riawf.flowchar.graph.NccEllipseView;
import nccloud.riawf.flowchar.graph.NccMultiLinedView;
import nccloud.riawf.flowchar.graph.NccTextCell;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.VertexView;

public class NccUfWCellViewFactory
extends DefaultCellViewFactory {
    protected VertexView createVertexView(Object cell) {
        if (cell instanceof NccAbstractFlowCell) {
            NccAbstractFlowCell afc = (NccAbstractFlowCell)cell;
            int shape = afc.getShapeStyle().getValue();
            if (shape != 0) {
                return new NccEllipseView(cell);
            }
            return new NccActivityView(cell);
        }
        if (cell instanceof NccTextCell && ((NccTextCell)cell).isMultiLined()) {
            return new NccMultiLinedView(cell);
        }
        return super.createVertexView(cell);
    }

    protected EdgeView createEdgeView(Object cell) {
        return new EdgeView(cell){

            public CellHandle getHandle(GraphContext context) {
                return new NccUfWEdgeHandle(this, context);
            }
        };
    }

    static class NccUfWEdgeHandle
    extends EdgeView.EdgeHandle {
        public NccUfWEdgeHandle(EdgeView edge, GraphContext ctx) {
            super(edge, ctx);
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return event.isShiftDown();
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return event.isShiftDown();
        }
    }
}

