/*
 * Decompiled with CFR 0.152.
 */
package nccloud.riawf.flowchar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import nc.bs.logging.Logger;
import nc.rule.datastruct.IRule;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.pf.plugin.MsgReceiverVO;
import nc.vo.wfengine.core.WFElement;
import nc.vo.wfengine.core.condition.Condition;
import nc.vo.wfengine.core.transition.BasicTransition;
import nc.vo.wfengine.core.transition.SplitJoinType;
import nc.vo.wfengine.core.transition.Transition;
import nc.vo.wfengine.core.util.CoreUtilities;
import nccloud.riawf.flowchar.graph.NccNoRouting;

public class NccGraphUtils {
    private static final String HTML_OPEN = "<html>";
    private static final String HTML_CLOSE = "</html>";
    private static final String STRONG_OPEN = "<strong>";
    private static final String STRONG_CLOSE = "</strong>";
    private static final String LINE_BREAK = "<br>";
    private static final String COLON_SPACE = ": ";

    public static Point getAutoCoordinateByIndex(int index) {
        Point start = new Point();
        int row = index / 3;
        int col = index % 3;
        start.x = 90 + 130 * col;
        start.y = 30 + 120 * row;
        return start;
    }

    public static void center(Window w, int minXDiffFromMax, int minYDiffFromMax) {
        w.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = w.getPreferredSize();
        if (windowSize.width > screenSize.width - minXDiffFromMax) {
            windowSize.width = screenSize.width - minXDiffFromMax;
        }
        if (windowSize.height > screenSize.height - minYDiffFromMax) {
            windowSize.height = screenSize.height - minYDiffFromMax;
        }
        w.setSize(windowSize);
        w.setLocation(screenSize.width / 2 - windowSize.width / 2, screenSize.height / 2 - windowSize.height / 2);
    }

    public static boolean isMadeByUFW(WFElement wfelement) {
        Object value = CoreUtilities.getValueOfExtendedAttr(wfelement, "MadeBy");
        if (wfelement == null) {
            return false;
        }
        return value != null && value.equals("UFW");
    }

    public static String parsePoints(List points) {
        String ret = "";
        int size = points.size();
        Point p = null;
        for (int i = 0; i < size; ++i) {
            p = (Point)points.get(i);
            ret = ret + p.x + ";" + p.y + ";";
        }
        return ret;
    }

    public static Map getBreakPoints(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "BreakPoint");
        HashMap retMap = null;
        if (value == null) {
            return retMap;
        }
        retMap = new HashMap();
        if (value instanceof ArrayList) {
            ArrayList alValue = (ArrayList)value;
            for (int i = 0; i < alValue.size(); ++i) {
                Object strObj = alValue.get(i);
                NccGraphUtils.fillMapByXmlString((String)strObj, retMap);
            }
        } else {
            NccGraphUtils.fillMapByXmlString((String)value, retMap);
        }
        return retMap;
    }

    private static void fillMapByXmlString(String xmlStr, HashMap outMap) {
        String[] pPos = CoreUtilities.tokenize(xmlStr, ";");
        if (pPos == null || pPos.length != 3) {
            return;
        }
        Point p = new Point(Integer.parseInt(pPos[0]), Integer.parseInt(pPos[1]));
        int index = Integer.parseInt(pPos[2]);
        outMap.put(index, p);
    }

    public static boolean isRoutingTransition(Map attributes) {
        Object routing = attributes.get("routing");
        return routing != null && !(routing instanceof NccNoRouting);
    }

    public static boolean isPopupTrigger(MouseEvent evt) {
        return NccGraphUtils.isRightButton(evt.getModifiers());
    }

    public static boolean isRightButton(int modifiers) {
        return (modifiers & 4) != 0;
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y) {
        NccGraphUtils.showPopupMenu(popup, comp, x, y, true);
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y, boolean point) {
        Component win;
        int offsetX = 0;
        int offsetY = 0;
        int extraOffset = point ? 1 : 0;
        for (win = comp; !(win instanceof Window) && win != null; win = win.getParent()) {
            offsetX += win.getX();
            offsetY += win.getY();
        }
        if (win != null) {
            Dimension size = popup.getPreferredSize();
            Rectangle screenSize = win.getGraphicsConfiguration().getBounds();
            x = x + offsetX + size.width + win.getX() > screenSize.width && x + offsetX + win.getX() >= size.width ? (point ? (x -= size.width + extraOffset) : win.getWidth() - size.width - offsetX + extraOffset) : (x += extraOffset);
            y = y + offsetY + size.height + win.getY() > screenSize.height && y + offsetY + win.getY() >= size.height ? (point ? win.getHeight() - size.height - offsetY + extraOffset : comp.getY() - size.height - 1) : (y += extraOffset);
            popup.show(comp, x, y);
        } else {
            popup.show(comp, x + extraOffset, y + extraOffset);
        }
    }

    public static String makeTooltip(Object userObject, String[] elements) {
        if (elements == null) {
            return "";
        }
        String s = HTML_OPEN;
        for (int i = 0; i < elements.length; ++i) {
            s = s + NccGraphUtils.makeAnotherHtmlLine(userObject, elements[i]);
        }
        s = s.substring(0, s.length() - LINE_BREAK.length());
        s = s + HTML_CLOSE;
        return s;
    }

    private static String makeAnotherHtmlLine(Object userObject, String el) {
        int MAX_LENGTH = 60;
        String textToAppend = "";
        textToAppend = textToAppend + STRONG_OPEN;
        if (el.equals("Condition")) {
            textToAppend = textToAppend + NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000027") + COLON_SPACE;
            textToAppend = textToAppend + STRONG_CLOSE;
            BasicTransition bt = (BasicTransition)userObject;
            Condition cond = bt.getCondition();
            if (cond != null) {
                List lExpress = cond.getXpressions();
                if (lExpress.size() > 0) {
                    IRule rule = (IRule)lExpress.get(0);
                    textToAppend = textToAppend + rule.toString();
                }
                textToAppend = textToAppend + LINE_BREAK;
            }
        } else {
            textToAppend = textToAppend + NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", el) + COLON_SPACE;
            textToAppend = textToAppend + STRONG_CLOSE;
            Object o = NccGraphUtils.getValueByReflect(userObject, el);
            String val = "";
            if (o != null) {
                if (o instanceof String) {
                    val = o.toString();
                } else if (o instanceof MsgReceiverVO[]) {
                    MsgReceiverVO[] msgs;
                    for (MsgReceiverVO msg : msgs = (MsgReceiverVO[])o) {
                        val = val + msg.getName() + ",";
                    }
                    if (val.length() > 0) {
                        val = val.substring(0, val.length() - 1);
                    }
                } else {
                    val = o instanceof SplitJoinType ? ((SplitJoinType)o).toString() : (o instanceof Boolean ? UFBoolean.valueOf((boolean)((Boolean)o)).toString() : o.toString());
                }
            }
            textToAppend = textToAppend + val;
            textToAppend = textToAppend + LINE_BREAK;
        }
        return textToAppend;
    }

    private static Object getValueByReflect(Object obj, String name) {
        Method m = NccGraphUtils.getReadMethod(obj.getClass(), name);
        Object ret = null;
        try {
            if (m != null) {
                ret = m.invoke(obj, null);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret == null ? "" : ret;
    }

    private static Method getReadMethod(Class clazz, String propertyName) {
        Method readMethod = null;
        String base = NccGraphUtils.capitalize(propertyName);
        try {
            readMethod = clazz.getMethod("is" + base, null);
        }
        catch (Exception getterExc) {
            try {
                readMethod = clazz.getMethod("get" + base, null);
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return readMethod;
    }

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

