/*
 * Decompiled with CFR 0.152.
 */
package nccloud.ctms.change.show.handle;

import java.util.ArrayList;
import java.util.List;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.org.OrgVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.BusinessRuntimeException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.wfengine.definition.WorkflowDefinitionVO;
import nccloud.ctms.change.dto.WorkFlowDTO;
import nccloud.ctms.change.show.handle.AbstractChangeHandler;
import nccloud.ctms.change.vo.ChangeItemVO;
import nccloud.ctms.change.vo.ChangeShowData;
import nccloud.putitf.riart.billtype.IBilltypeService;

public class WorkFlowChangeHandler
extends AbstractChangeHandler {
    public ChangeShowData handle(List<ChangeItemVO> items) {
        ChangeShowData data = new ChangeShowData();
        ArrayList<WorkFlowDTO> list = new ArrayList<WorkFlowDTO>();
        BaseDAO baseDao = new BaseDAO();
        for (ChangeItemVO item : items) {
            try {
                WorkflowDefinitionVO vo = (WorkflowDefinitionVO)((Object)baseDao.retrieveByPK(WorkflowDefinitionVO.class, item.getOpItemPk()));
                WorkFlowDTO dto = new WorkFlowDTO();
                dto.setOpNote(item.getNote());
                dto.setOpType(item.getOpType());
                dto.setOpUser(item.getOpUser());
                if (vo == null) {
                    vo = (WorkflowDefinitionVO)((Object)item.getData());
                }
                IBilltypeService ser = (IBilltypeService)NCLocator.getInstance().lookup(IBilltypeService.class);
                dto.setNodeName(vo.getNode_name());
                if (vo != null && vo.getBilltype() != null) {
                    try {
                        String billtypename = ser.getBilltypeName(vo.getBilltype());
                        if (!StringUtil.isEmpty((String)billtypename)) {
                            dto.setBillType(billtypename);
                        }
                    }
                    catch (BusinessException billtypename) {
                        // empty catch block
                    }
                }
                if (vo != null && vo.getPk_billtypeid() != null) {
                    try {
                        BilltypeVO btvo = ser.getBilltypeByid(vo.getPk_billtypeid());
                        if (btvo != null && !StringUtil.isEmpty((String)btvo.toString())) {
                            dto.setTranstype(btvo.toString());
                        }
                    }
                    catch (BusinessException btvo) {
                        // empty catch block
                    }
                }
                if (vo != null && vo.getPk_org() != null) {
                    try {
                        ArrayList<String> org = new ArrayList<String>();
                        org.add(vo.getPk_org());
                        OrgVO[] vos = ser.queryOrgVOByPK(org);
                        if (vos != null && vos.length > 0) {
                            dto.setPkOrg(MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)vos[0], (String)"name", null));
                        }
                    }
                    catch (BusinessException businessException) {
                        // empty catch block
                    }
                }
                dto.setPkWfDef(vo.getPk_wf_def());
                dto.setVersion(vo.getVersion());
                dto.setWorkflowType(vo.getWorkflow_type());
                list.add(dto);
            }
            catch (DAOException e) {
                Logger.error((Object)e.getMessage());
                throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        data.setData(list);
        return data;
    }
}

