/*
 * Decompiled with CFR 0.152.
 */
package nccloud.ctms.change.show.handle;

import java.util.ArrayList;
import java.util.List;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.OrgVO;
import nc.vo.pf.pub.BusitypeVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nccloud.ctms.change.dto.BusiflowDTO;
import nccloud.ctms.change.show.handle.AbstractChangeHandler;
import nccloud.ctms.change.vo.ChangeItemVO;
import nccloud.ctms.change.vo.ChangeShowData;
import nccloud.putitf.riart.billtype.IBilltypeService;

public class BusiflowChangeHandler
extends AbstractChangeHandler {
    public ChangeShowData handle(List<ChangeItemVO> items) {
        ChangeShowData data = new ChangeShowData();
        ArrayList<BusiflowDTO> list = new ArrayList<BusiflowDTO>();
        BaseDAO baseDao = new BaseDAO();
        for (ChangeItemVO item : items) {
            try {
                BusitypeVO vo = (BusitypeVO)((Object)baseDao.retrieveByPK(BusitypeVO.class, item.getOpItemPk()));
                BusiflowDTO dto = new BusiflowDTO();
                dto.setOpNote(item.getNote());
                dto.setOpType(item.getOpType());
                dto.setOpUser(item.getOpUser());
                if (vo == null) {
                    vo = (BusitypeVO)((Object)item.getData());
                }
                IBilltypeService ser = (IBilltypeService)NCLocator.getInstance().lookup(IBilltypeService.class);
                dto.setBusiname(MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)vo, (String)"businame", null));
                dto.setBusicode(vo.getBusicode());
                dto.setVersion(vo.getVersion());
                dto.setBusiprop(this.whatIs(vo.getBusiprop()));
                if (vo != null && vo.getPrimarybilltype() != null) {
                    try {
                        String billtypename = ser.getBilltypeName(vo.getPrimarybilltype());
                        if (!StringUtil.isEmpty((String)billtypename)) {
                            dto.setPrimarybilltype(billtypename);
                        }
                    }
                    catch (BusinessException e) {
                        Logger.error((Object)((Object)e));
                    }
                }
                if (vo != null && vo.getPk_orgs() != null && vo.getPk_orgs().length > 0) {
                    String pk_org = vo.getPk_orgs()[0];
                    try {
                        ArrayList<String> org = new ArrayList<String>();
                        org.add(pk_org);
                        OrgVO[] vos = ser.queryOrgVOByPK(org);
                        if (vos != null && vos.length > 0) {
                            dto.setPk_org(MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)vos[0], (String)"name", null));
                        }
                    }
                    catch (BusinessException e) {
                        Logger.error((Object)((Object)e));
                    }
                }
                dto.setPk_busitype(vo.getPk_busitype());
                list.add(dto);
            }
            catch (DAOException e) {
                Logger.error((Object)((Object)e));
            }
        }
        data.setData(list);
        return data;
    }

    private String whatIs(Integer busiprop) {
        int number = busiprop;
        switch (number) {
            case 0: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "purchase");
            }
            case 1: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "sale");
            }
            case 2: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "pur_sale");
            }
            case 3: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "Recei_payable");
            }
            case 4: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "cost");
            }
            case 5: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "other");
            }
            case 6: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "hr");
            }
            case 7: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "allocation");
            }
            case 8: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "capital");
            }
            case 9: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busiflowDesign", "assets");
            }
        }
        return null;
    }
}

