/*
 * Decompiled with CFR 0.152.
 */
package nccloud.bs.pub.pf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import itf.approvecenter.util.CloudPFBizRetObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pf.pub.cache.CondStringKey;
import nc.bs.pf.pub.cache.ICacheDataQueryCallback;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.bs.pf.pub.cache.WFTaskCacheKey;
import nc.bs.pf.pub.wapper.MessageHandleWapper;
import nc.bs.pf.workflow.def.WFFuncodeUtil;
import nc.bs.pub.pf.IMessageCenterInfoCallBack;
import nc.bs.pub.pf.MsgCenterContext;
import nc.bs.pub.pf.PfUtilTools;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFMessageMetaService;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.itf.uap.rbac.IUserManageQuery;
import nc.message.itf.IMessageQueryService;
import nc.message.itf.IMessageService;
import nc.message.util.MessageCenter;
import nc.message.vo.NCMessage;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.msg.MessageMetaVO;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.BusinessRuntimeException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.billtype2.ExtendedClassEnum;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.msg.CommonMessageVO;
import nc.vo.pub.msg.MessageVO;
import nc.vo.pub.msg.MessageinfoVO;
import nc.vo.pub.pf.Pfi18nTools;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.pub.workflowqry.FlowHistoryUtil;
import nc.vo.sm.UserVO;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.definition.ActivityTypeEnum;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.WFTask;
import nccloud.bs.pub.pf.CloudPfUtil;
import nccloud.commons.lang.StringUtils;
import nccloud.impl.platform.common.util.CollectionUtils;
import nccloud.itf.uap.pf.NCCWorkFlowService;
import nccloud.message.itf.IApproveMessageManageService;
import nccloud.message.vo.NCCApproveMessageVO;
import nccloud.message.vo.NCCMessage;
import nccloud.message.vo.NCCMessageVO;
import nccloud.message.vo.NCCNoticeMessageVO;
import nccloud.message.vo.NCCPrealertMessageVO;
import nccloud.message.vo.NCCTodoMessageVO;
import nccloud.pubitf.riart.pf.INccPFCrossServiceQuery;
import nccloud.putitf.riart.billtype.IBillRelatedAppService;
import nccloud.putitf.riawf.mobileapp.INccMobileBillDataListener;

public class PfMessageUtil {
    public static final String DEFAULT_SENDER = "NC_USER0000000000000";

    private static IMessageQueryService lookupMessageQueryService() {
        return (IMessageQueryService)NCLocator.getInstance().lookup(IMessageQueryService.class);
    }

    private static IMessageService lookupMessageService() {
        return (IMessageService)NCLocator.getInstance().lookup(IMessageService.class);
    }

    public static void fill(NCMessage ncmsg, WorkflownoteVO workflownote, String funcode, String langcode) throws BusinessException {
        String subject;
        nc.message.vo.MessageVO messageVO = ncmsg.getMessage();
        String actionType = workflownote.getActiontype();
        String msgSourceType = null;
        msgSourceType = actionType != null && actionType.startsWith("BIZ") ? "pfbizmsg" : "worklist";
        if (workflownote != null && workflownote.getMessagenote() != null && workflownote.getMessagenote().endsWith("{wfMachineImpl-0014}")) {
            msgSourceType = "addApproveFinished";
        }
        subject = !StringUtil.isEmptyWithTrim((String)(subject = messageVO.getSubject())) ? PfMessageUtil.getI18NMessageNoteForUser(subject, workflownote.getCheckman(), langcode) : PfMessageUtil.getI18NMessageNoteForUser(workflownote.getMessagenote(), workflownote.getCheckman(), langcode);
        String content = messageVO.getContent();
        if (!StringUtil.isEmptyWithTrim((String)content)) {
            content = PfMessageUtil.getI18NMessageNoteForUser(content, workflownote.getCheckman(), langcode);
        }
        String sender = workflownote.getSenderman() != null ? workflownote.getSenderman() : DEFAULT_SENDER;
        messageVO.setContenttype(actionType);
        messageVO.setMsgsourcetype(msgSourceType);
        messageVO.setSubject(subject);
        messageVO.setContent(content);
        messageVO.setReceiver(workflownote.getCheckman());
        messageVO.setSender(sender);
        messageVO.setIsdelete(workflownote.getReceivedeleteflag());
        messageVO.setIshandled(UFBoolean.FALSE);
        messageVO.setPk_group(workflownote.getPk_group());
        messageVO.setSendtime(workflownote.getSenddate());
        messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
        messageVO.setPriority(workflownote.getPriority());
        messageVO.setTs(workflownote.getTs());
        messageVO.setDr(workflownote.getDr());
        messageVO.setPk_org(workflownote.getPk_org());
        messageVO.setDetail(workflownote.getBillid() + "@" + workflownote.getPk_billtype() + "@" + workflownote.getBillno() + "@" + funcode);
        messageVO.setPk_detail(workflownote.getPk_checkflow());
        messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(workflownote.getPk_billtype()));
        messageVO.setSubcolor(PfMessageUtil.getMessageColor(workflownote.getPk_billtype(), workflownote.getBillid()));
        messageVO.setFuncid(workflownote.getPk_message());
    }

    public static void fill(NCMessage ncmsg, WorkflownoteVO workflownote) throws BusinessException {
        nc.message.vo.MessageVO messageVO = ncmsg.getMessage();
        String actionType = workflownote.getActiontype();
        String msgSourceType = null;
        msgSourceType = actionType != null && actionType.startsWith("BIZ") ? "pfbizmsg" : "worklist";
        String subject = messageVO.getSubject();
        subject = !StringUtil.isEmptyWithTrim((String)subject) ? PfMessageUtil.getI18NMessageNoteForUser(subject, workflownote.getCheckman()) : PfMessageUtil.getI18NMessageNoteForUser(workflownote.getMessagenote(), workflownote.getCheckman());
        String content = messageVO.getContent();
        if (!StringUtil.isEmptyWithTrim((String)content)) {
            content = PfMessageUtil.getI18NMessageNoteForUser(content, workflownote.getCheckman());
        }
        String sender = workflownote.getSenderman() != null ? workflownote.getSenderman() : DEFAULT_SENDER;
        messageVO.setContenttype(actionType);
        messageVO.setMsgsourcetype(msgSourceType);
        messageVO.setSubject(subject);
        messageVO.setContent(content);
        messageVO.setReceiver(workflownote.getCheckman());
        messageVO.setSender(sender);
        messageVO.setIsdelete(workflownote.getReceivedeleteflag());
        messageVO.setIshandled(UFBoolean.FALSE);
        messageVO.setPk_group(workflownote.getPk_group());
        messageVO.setSendtime(workflownote.getSenddate());
        messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
        messageVO.setPriority(workflownote.getPriority());
        messageVO.setTs(workflownote.getTs());
        messageVO.setDr(workflownote.getDr());
        messageVO.setPk_org(workflownote.getPk_org());
        messageVO.setDetail(workflownote.getBillid() + "@" + workflownote.getPk_billtype() + "@" + workflownote.getBillno() + "@" + WFFuncodeUtil.getActivityFuncode(workflownote));
        messageVO.setPk_detail(workflownote.getPk_checkflow());
        messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(workflownote.getPk_billtype()));
        messageVO.setSubcolor(PfMessageUtil.getMessageColor(workflownote.getPk_billtype(), workflownote.getBillid()));
    }

    public static NCMessage transferToNCMessage(WorkflownoteVO workflownote) throws BusinessException {
        NCMessage ncmsg = workflownote.getNcMsg();
        PfMessageUtil.fill(ncmsg, workflownote);
        return ncmsg;
    }

    public static NCMessage transferToNCMessage(WorkflownoteVO workflownote, String funcode, String langcode) throws BusinessException {
        NCMessage ncmsg = workflownote.getNcMsg();
        PfMessageUtil.fill(ncmsg, workflownote, funcode, langcode);
        return ncmsg;
    }

    public static String getModuleOfBilltype(String pk_billtypecode) {
        try {
            BilltypeVO btvo = PfDataCache.getBillTypeInfo(pk_billtypecode);
            if (btvo != null) {
                return btvo.getSystemcode();
            }
            return null;
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getI18NMessageNoteForUser(String note, String cuserid, String langcode) throws BusinessException {
        String originLang = InvocationInfoProxy.getInstance().getLangCode();
        try {
            String i18nNote;
            InvocationInfoProxy.getInstance().setLangCode(langcode);
            String string = i18nNote = MessageVO.getMessageNoteAfterI18N(note);
            return string;
        }
        finally {
            InvocationInfoProxy.getInstance().setLangCode(originLang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getI18NMessageNoteForUser(String note, String cuserid) throws BusinessException {
        String langcode = Pfi18nTools.getLangcodeOfUser(cuserid);
        String originLang = InvocationInfoProxy.getInstance().getLangCode();
        try {
            String i18nNote;
            InvocationInfoProxy.getInstance().setLangCode(langcode);
            String string = i18nNote = MessageVO.getMessageNoteAfterI18N(note);
            return string;
        }
        finally {
            InvocationInfoProxy.getInstance().setLangCode(originLang);
        }
    }

    public static NCMessage transferToNCMessage(MessageinfoVO msginfovo) throws BusinessException {
        NCMessage ncMessage = new NCMessage();
        nc.message.vo.MessageVO messageVO = new nc.message.vo.MessageVO();
        if (msginfovo.getType() == 6) {
            messageVO.setMsgsourcetype("notice");
        } else {
            messageVO.setMsgsourcetype("worklist");
        }
        messageVO.setReceiver(msginfovo.getCheckman());
        String subject = PfMessageUtil.getI18NMessageNoteForUser(msginfovo.getTitle(), msginfovo.getCheckman());
        messageVO.setSubject(subject);
        messageVO.setSender(msginfovo.getSenderman());
        messageVO.setIsdelete(msginfovo.getReceivedeleteflag());
        messageVO.setIshandled(UFBoolean.FALSE);
        messageVO.setSendtime(msginfovo.getSenddate());
        messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
        messageVO.setPriority(msginfovo.getPriority());
        messageVO.setTs(msginfovo.getTs());
        messageVO.setDr(msginfovo.getDr());
        messageVO.setContent(msginfovo.getContent());
        messageVO.setPk_group(msginfovo.getPk_corp());
        messageVO.setPk_detail(msginfovo.getPk_wf_msg() + "@" + msginfovo.getPk_wf_task() + "@" + msginfovo.getType() + "@" + msginfovo.getType() + "@");
        messageVO.setDetail(msginfovo.getBillid() + "@" + msginfovo.getPk_billtype() + "@" + msginfovo.getBillno());
        messageVO.setContenttype("BIZ");
        messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(msginfovo.getPk_billtype()));
        messageVO.setDef(msginfovo.getDef());
        ncMessage.setMessage(messageVO);
        ncMessage.setDef(msginfovo.getDef());
        return ncMessage;
    }

    public static void insertBizMessages(MessageinfoVO[] array) throws BusinessException {
        if (array == null || array.length == 0) {
            return;
        }
        NCMessage[] ncMsgs = new NCMessage[array.length];
        MessageMetaVO[] metas = new MessageMetaVO[array.length];
        ArrayList<NCCMessage> nccMessages = new ArrayList<NCCMessage>();
        String cpySendMsg = InvocationInfoProxy.getInstance().getProperty("cpySendMsg");
        for (int i = 0; i < array.length; ++i) {
            ncMsgs[i] = PfMessageUtil.transferToNCMessage(array[i]);
            nccMessages.add(PfMessageUtil.convertToNCCMsgVo(ncMsgs[i].getMessage().getMsgsourcetype(), ncMsgs[i]));
            metas[i] = PfMessageUtil.createMessageMeta(array[i]);
        }
        if (cpySendMsg != null) {
            for (NCCMessage nccMessage : nccMessages) {
                nccMessage.getMessage().setFunccode("cpy_noticMessage");
                nccMessage.getMessage().setDetail(nccMessage.getMessage().getBillid() + "@" + nccMessage.getMessage().getBilltype() + "@" + nccMessage.getMessage().getBillno() + "@");
            }
        }
        try {
            if (nccMessages != null && nccMessages.size() > 0) {
                nccloud.message.util.MessageCenter.sendMessage((NCCMessage[])nccMessages.toArray(new NCCMessage[0]), (boolean)true);
            }
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metas);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static MessageVO transferNCMessageToMessageVO(NCMessage ncmsg) {
        if (ncmsg == null) {
            return null;
        }
        MessageVO msgVO = new MessageVO();
        msgVO.setActionTypeCode(ncmsg.getMessage().getContenttype());
        msgVO.setCheckerCode(ncmsg.getMessage().getReceiver());
        msgVO.setPrimaryKey(ncmsg.getMessage().getPrimaryKey());
        msgVO.setCorpPK(ncmsg.getMessage().getPk_org());
        try {
            String detail = ncmsg.getMessage().getDetail();
            String[] values = detail.split("@");
            msgVO.setBillPK(values[0]);
            msgVO.setPk_billtype(values[1]);
            msgVO.setBillNO(values[2]);
            if (values.length >= 4) {
                msgVO.setFuncode(values[3]);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
        try {
            WorkflownoteVO notevo = null;
            if (ncmsg.getMessage() != null) {
                notevo = (WorkflownoteVO)((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveByPK(WorkflownoteVO.class, ncmsg.getMessage().getPk_detail());
            }
            if (notevo != null) {
                msgVO.setUserobject(notevo.getUserobject());
                if (notevo.getWorkflow_type() != null) {
                    msgVO.setWorkflowtype(notevo.getWorkflow_type());
                }
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
        msgVO.setMessageNote(ncmsg.getMessage().getContent());
        return msgVO;
    }

    private static NCMessage[] transferToNCMessage(CommonMessageVO msg) {
        HashSet<String> setHasAdded = new HashSet<String>();
        ArrayList<NCMessage> list = new ArrayList<NCMessage>();
        for (int i = 0; i < msg.getReceiver().length; ++i) {
            if (setHasAdded.contains(msg.getReceiver()[i].getUserPK())) continue;
            NCMessage ncMessage = new NCMessage();
            nc.message.vo.MessageVO messageVO = new nc.message.vo.MessageVO();
            messageVO.setMsgsourcetype(msg.getActionType());
            messageVO.setReceiver(msg.getReceiver()[i].getUserPK());
            messageVO.setSubject(msg.getTitle());
            messageVO.setSender(msg.getSender() == null ? NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000706") : msg.getSender());
            messageVO.setIsdelete(UFBoolean.FALSE);
            messageVO.setIsread(UFBoolean.FALSE);
            messageVO.setSendtime(msg.getSendDataTime());
            messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
            messageVO.setPriority(Integer.valueOf(msg.getPriority()));
            messageVO.setTs(msg.getSendDataTime());
            messageVO.setDr(Integer.valueOf(0));
            messageVO.setContent(msg.getMessageContent());
            messageVO.setIshandled(UFBoolean.FALSE);
            messageVO.setDetail(msg.getBillid() + "@" + msg.getBilltype() + "@" + msg.getBillno());
            ncMessage.setMessage(messageVO);
            messageVO.setPk_group(InvocationInfoProxy.getInstance().getGroupId());
            messageVO.setPk_detail(msg.getPk_wf_msg() + "@" + msg.getPk_wf_task() + "@" + msg.getBilltype());
            messageVO.setContenttype(msg.isNeedFlowCheck() ? "MSG_NEEDCHECK" : "MSG_NOCHECK");
            messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(msg.getBilltype()));
            list.add(ncMessage);
            setHasAdded.add(msg.getReceiver()[i].getUserPK());
        }
        return list.toArray(new NCMessage[0]);
    }

    @Deprecated
    private static NCMessage[] transferToNCMessage2(CommonMessageVO msg) {
        HashSet<String> setHasAdded = new HashSet<String>();
        ArrayList<NCMessage> list = new ArrayList<NCMessage>();
        for (int i = 0; i < msg.getReceiver().length; ++i) {
            if (setHasAdded.contains(msg.getReceiver()[i].getUserPK())) continue;
            NCMessage ncMessage = new NCMessage();
            nc.message.vo.MessageVO messageVO = new nc.message.vo.MessageVO();
            messageVO.setMsgsourcetype(msg.getActionType());
            messageVO.setReceiver(msg.getReceiver()[i].getUserPK());
            messageVO.setSubject(msg.getTitle());
            messageVO.setSender(msg.getSender() == null ? NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000706") : msg.getSender());
            messageVO.setIsdelete(UFBoolean.FALSE);
            messageVO.setSendtime(msg.getSendDataTime());
            messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
            messageVO.setPriority(Integer.valueOf(msg.getPriority()));
            messageVO.setContent(msg.getMessageContent());
            messageVO.setTs(msg.getSendDataTime());
            messageVO.setDr(Integer.valueOf(0));
            messageVO.setIshandled(UFBoolean.FALSE);
            messageVO.setPk_group(InvocationInfoProxy.getInstance().getGroupId());
            messageVO.setPk_detail(msg.getPk_wf_msg() + "@" + msg.getPk_wf_task() + "@" + msg.getBilltype());
            messageVO.setContenttype(msg.isNeedFlowCheck() ? "MSG_NEEDCHECK" : "MSG_NOCHECK");
            messageVO.setDetail(msg.getBillid() + "@" + msg.getBilltype() + "@" + msg.getBillno());
            messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(msg.getBilltype()));
            ncMessage.setMessage(messageVO);
            list.add(ncMessage);
            setHasAdded.add(msg.getReceiver()[i].getUserPK());
        }
        return list.toArray(new NCMessage[0]);
    }

    private static NCMessage[] transferToNoticeMessage(CommonMessageVO msg) {
        HashSet<String> setHasAdded = new HashSet<String>();
        ArrayList<NCMessage> list = new ArrayList<NCMessage>();
        for (int i = 0; i < msg.getReceiver().length; ++i) {
            if (setHasAdded.contains(msg.getReceiver()[i].getUserPK())) continue;
            NCMessage ncMessage = new NCMessage();
            nc.message.vo.MessageVO messageVO = new nc.message.vo.MessageVO();
            messageVO.setMsgsourcetype("notice");
            messageVO.setReceiver(msg.getReceiver()[i].getUserPK());
            messageVO.setSubject(msg.getTitle());
            messageVO.setSender(msg.getSender());
            messageVO.setIsdelete(UFBoolean.FALSE);
            messageVO.setSendtime(msg.getSendDataTime());
            messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
            messageVO.setPriority(Integer.valueOf(msg.getPriority()));
            messageVO.setContent(msg.getMessageContent());
            messageVO.setTs(msg.getSendDataTime());
            messageVO.setDr(Integer.valueOf(0));
            messageVO.setIshandled(UFBoolean.FALSE);
            messageVO.setPk_group(InvocationInfoProxy.getInstance().getGroupId());
            messageVO.setPk_detail(msg.getPk_wf_msg() + "@" + msg.getPk_wf_task() + "@" + msg.getBilltype());
            messageVO.setContenttype("BIZ");
            messageVO.setDetail(msg.getBillid() + "@" + msg.getBilltype() + "@" + msg.getBillno());
            messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(msg.getBilltype()));
            ncMessage.setMessage(messageVO);
            list.add(ncMessage);
            setHasAdded.add(msg.getReceiver()[i].getUserPK());
        }
        return list.toArray(new NCMessage[0]);
    }

    public static void sendNoticeMessage(CommonMessageVO messagevo) throws BusinessException {
        ArrayList<NCCMessage> nccmsgs = new ArrayList<NCCMessage>();
        if (messagevo.getReceiver() == null || messagevo.getReceiver().length == 0) {
            return;
        }
        try {
            NCMessage[] msgvos = PfMessageUtil.transferToNoticeMessage(messagevo);
            if (msgvos != null && msgvos.length > 0) {
                String obj = InvocationInfoProxy.getInstance().getProperty("noticeShowDetailFlag");
                boolean isNoticeFlag = false;
                String noticeShowDetailFlag = String.valueOf(obj);
                if (obj != null) {
                    isNoticeFlag = true;
                }
                for (NCMessage msg : msgvos) {
                    NCCMessage nccmsg = PfMessageUtil.convertToNCCMsgVo("notice", msg);
                    if (isNoticeFlag) {
                        nccmsg.getMessage().setFunccode(noticeShowDetailFlag);
                        nccmsg.getMessage().setBillid(messagevo.getBillid());
                        nccmsg.getMessage().setBilltype(messagevo.getBilltype());
                        nccmsg.getMessage().setDetail(messagevo.getBillid() + "@" + messagevo.getBilltype() + "@" + messagevo.getBillno() + "@");
                    }
                    nccmsgs.add(nccmsg);
                }
            }
            if (nccmsgs != null && nccmsgs.size() > 0) {
                nccloud.message.util.MessageCenter.sendMessage((NCCMessage[])nccmsgs.toArray(new NCCMessage[0]), (boolean)true);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static void sendMessageOfWorknote(WorkflownoteVO workflownoteVO) throws BusinessException {
        if (workflownoteVO == null) {
            return;
        }
        if (PfMessageUtil.checkmanIsVirtual(workflownoteVO)) {
            return;
        }
        NCMessage ncMsg = PfMessageUtil.transferToNCMessage(workflownoteVO);
        try {
            String[] msgpk = MessageCenter.sendMessage((NCMessage[])new NCMessage[]{ncMsg}, (boolean)true);
            String pk_message = msgpk[0];
            WFTask task = PfMessageUtil.getWFTask(workflownoteVO.getPk_wf_task());
            MessageMetaVO metavo = PfMessageUtil.createMessageMeta(workflownoteVO, task, pk_message);
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metavo);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getMessageColor(final String billtype, final String billid) {
        CondStringKey key = new CondStringKey("pfmessageutil_get_message_color", billtype, billid);
        ICacheDataQueryCallback<String> callback = new ICacheDataQueryCallback<String>(){

            public String queryData() throws BusinessException {
                ArrayList<Billtype2VO> b2voList = PfDataCache.getBillType2Info(billtype, ExtendedClassEnum.MESSAGECENTER_INFO_CALLBACK.getIntValue());
                if (ArrayUtil.isNotNull(b2voList)) {
                    Billtype2VO b2vo = (Billtype2VO)((Object)b2voList.get(0));
                    String className = b2vo.getClassname();
                    String realBillType = b2vo.getPk_billtype();
                    try {
                        IMessageCenterInfoCallBack cb = (IMessageCenterInfoCallBack)PfUtilTools.instantizeObject(realBillType, className);
                        MsgCenterContext msgCenterContext = cb.getMsgCenterContext(billid);
                        return msgCenterContext == null ? null : msgCenterContext.getColor();
                    }
                    catch (Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                return null;
            }
        };
        try {
            return (String)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void sendMessageOfWorknoteBatch(String type, WorkflownoteVO[] array, WFTask currenttask) throws BusinessException {
        if (array == null || array.length == 0) {
            return;
        }
        if (PfMessageUtil.checkmanIsVirtual(array[0])) {
            return;
        }
        try {
            List<NCCMessage> nccMsgVOs = PfMessageUtil.getNCCMessagesByWorkflownoteVos(type, array, currenttask);
            if ("approve".equals(type)) {
                for (NCCMessage msgVO : nccMsgVOs) {
                    PfMessageUtil.updateApproveMobileMsg(msgVO);
                }
            }
            String[] msgpks = nccloud.message.util.MessageCenter.sendMessage((NCCMessage[])nccMsgVOs.toArray(new NCCMessage[0]), (boolean)true);
            List<NCMessage> ncMsgVOs = PfMessageUtil.getNCMessagesByWorkflownoteVos(array);
            ArrayList<MessageMetaVO> metaList = new ArrayList<MessageMetaVO>();
            for (int i = 0; i < array.length; ++i) {
                String pk_message = ncMsgVOs.get(i).getMessage().getPk_message();
                WFTask task = PfMessageUtil.getWFTask(array[i].getPk_wf_task());
                MessageMetaVO metavo = PfMessageUtil.createMessageMeta(array[i], task, pk_message);
                metaList.add(metavo);
            }
            IPFMessageMetaService srv = (IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class);
            srv.insert(metaList.toArray(new MessageMetaVO[0]));
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static void updateApproveMobileMsg(NCCMessage msgVO) throws BusinessException {
        String billId = msgVO.getMessage().getBillid();
        String billtypeCode = msgVO.getMessage().getBilltype();
        ArrayList<Billtype2VO> list = PfDataCache.getBillType2Info(billtypeCode, ExtendedClassEnum.NCC_MOBILE_BILLDATA_LISTENER.getIntValue());
        if (CollectionUtils.isNotEmpty(list)) {
            String mobileUrl;
            INccMobileBillDataListener listener;
            Map<String, String> map;
            Billtype2VO b2vo = (Billtype2VO)((Object)list.get(0));
            String className = b2vo.getClassname();
            String realBillType = b2vo.getPk_billtype();
            if (StringUtils.isNotBlank((CharSequence)className) && (map = (listener = (INccMobileBillDataListener)PfUtilTools.instantizeObject(realBillType, className.trim())).getBusiMobileInfo(billId, billtypeCode)) != null && !map.isEmpty() && map.containsKey("mobileurl") && StringUtils.isNotBlank((CharSequence)(mobileUrl = map.get("mobileurl")))) {
                String msgDetail;
                String string = msgDetail = msgVO.getMessage() != null ? msgVO.getMessage().getDetail() : "";
                if (msgDetail.indexOf("{") == 0 && msgDetail.lastIndexOf("}") == msgDetail.length() - 1) {
                    JSONObject detailobj = JSONObject.parseObject((String)msgDetail);
                    detailobj.put("mobileurl", (Object)mobileUrl);
                    String newMSgDetail = detailobj.toJSONString();
                    msgVO.getMessage().setDetail(newMSgDetail);
                }
            }
        }
    }

    private static void sort(List<MessageHandleWapper> list) {
        list.sort(new Comparator<MessageHandleWapper>(){

            @Override
            public int compare(MessageHandleWapper o1, MessageHandleWapper o2) {
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static void sendMessageOfWorknoteBatchAndHistoryRejectReason(String type, WorkflownoteVO[] array, int rejectStat, String rejectreason, WFTask currentTask) throws BusinessException {
        if (array == null || array.length == 0) {
            return;
        }
        if (PfMessageUtil.checkmanIsVirtual(array[0])) {
            return;
        }
        try {
            List<NCCMessage> nccMsgVOs = rejectStat == 1 ? PfMessageUtil.getNCCMessagesByWorkflownoteVosAndHistoryRejectReason(type, array, rejectStat, rejectreason, currentTask) : PfMessageUtil.getNCCMessagesByWorkflownoteVos(type, array, currentTask);
            if (CollectionUtils.isNotEmpty(nccMsgVOs)) {
                String msgType = nccMsgVOs.get(0).getMessageType();
                if ("approve".equals(msgType)) {
                    for (NCCMessage msgVO : nccMsgVOs) {
                        PfMessageUtil.updateApproveMobileMsg(msgVO);
                    }
                    String[] stringArray = nccloud.message.util.MessageCenter.sendMessage((NCCMessage[])nccMsgVOs.toArray(new NCCMessage[0]), (boolean)true);
                } else {
                    String sendMessageBillMaker = InvocationInfoProxy.getInstance().getProperty("sendMessageBillMaker");
                    if (sendMessageBillMaker == null) {
                        String[] stringArray = nccloud.message.util.MessageCenter.sendMessage((NCCMessage[])nccMsgVOs.toArray(new NCCMessage[0]), (boolean)true);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static List<NCCMessage> getNCCMessagesByWorkflownoteVos(String type, WorkflownoteVO[] array, WFTask currentTask) throws BusinessException {
        ArrayList ncMsgVOs = new ArrayList();
        String[] funcodes = PfMessageUtil.getFuncodeByNoteVos(array);
        ArrayList<String> cuserids = new ArrayList<String>();
        ArrayList<NCCMessage> nccMsgList = new ArrayList<NCCMessage>();
        BasicWorkflowProcess wf = null;
        try {
            if (currentTask != null) {
                wf = PfDataCache.getWorkflowProcess(currentTask.getWfProcessDefPK());
            }
        }
        catch (Exception e1) {
            Logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BusinessRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        String hasDeatilValue = "";
        for (int i = 0; i < array.length; ++i) {
            String cuserid = array[i].getCheckman();
            if (cuserid == null || "".equalsIgnoreCase(cuserid)) continue;
            cuserids.add(cuserid);
        }
        HashMap<String, String> langcodes = Pfi18nTools.getLangcodesOfUserFromDb(cuserids.toArray(new String[0]));
        boolean isRejectToFirst = false;
        for (int i = 0; i < array.length; ++i) {
            String pk_checkflow = array[i].getPk_checkflow();
            Collection noteVos = new BaseDAO().retrieveByClause(WorkflownoteVO.class, "pk_checkflow = '" + pk_checkflow + "'");
            if (CollectionUtils.isEmpty((Collection)noteVos)) continue;
            String funcode = null;
            if (funcodes != null && funcodes.length > i) {
                funcode = funcodes[i];
            }
            if (funcode == null) {
                funcode = "";
            }
            String langcode = langcodes.get(array[i].getCheckman());
            NCMessage ncMsg = PfMessageUtil.transferToNCMessage(array[i], funcode, langcode);
            NCCMessage nccMsg = null;
            ncMsg.getMessage().setBilltype(array[i].getPk_billtype());
            ncMsg.getMessage().setBillid(array[i].getBillid());
            boolean isRejecttoFirst = false;
            if ("approve".equals(type)) {
                if (!isRejectToFirst) {
                    try {
                        int actType;
                        Activity activity;
                        if (wf != null && currentTask != null && (activity = wf.findActivityByID(currentTask.getActivityID())) instanceof GenericActivityEx && (actType = activity.getActivityType()) == ActivityTypeEnum.Makebill.getIntValue()) {
                            isRejecttoFirst = true;
                            nccMsg = PfMessageUtil.convertToNCCMsgVo4RejecttoFirst(type, ncMsg, "", array[i].getWorkflow_type());
                        }
                    }
                    catch (Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BusinessRuntimeException(e.getMessage());
                    }
                }
                if (!isRejecttoFirst) {
                    isRejectToFirst = true;
                    nccMsg = PfMessageUtil.convertToNCCMsgVo(type, ncMsg, "", array[i].getWorkflow_type(), array[i], currentTask);
                    if (StringUtils.isEmpty((CharSequence)hasDeatilValue)) {
                        JSONObject jsonObject;
                        JSONObject jSONObject = jsonObject = nccMsg.getMessage().getDetail() == null ? new JSONObject() : JSON.parseObject((String)nccMsg.getMessage().getDetail());
                        if ((array[i].getWorkflow_type() == 4 || array[i].getWorkflow_type() == 6 || array[i].getWorkflow_type() == 5) && jsonObject.get((Object)"enableActions") != null) {
                            List strs = (List)jsonObject.get((Object)"enableActions");
                            JSONObject json = new JSONObject();
                            WFTask task = null;
                            task = array[i].getTaskInfo().getTask() != null ? array[i].getTaskInfo().getTask() : currentTask;
                            if (task != null) {
                                jsonObject.put("enableActions", (Object)strs.toArray(new String[0]));
                                hasDeatilValue = jsonObject.toJSONString();
                                nccMsg.getMessage().setDetail(jsonObject.toJSONString());
                            }
                        } else {
                            hasDeatilValue = nccMsg.getMessage().getDetail();
                        }
                    } else {
                        nccMsg.getMessage().setDetail(hasDeatilValue);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)nccMsg.getMessage().getDetail())) {
                    JSONObject josndetail = new JSONObject();
                    josndetail.put("SubmitRejectBillMode", (Object)array[i].getBillSubmitModelType());
                } else if (isRejecttoFirst) {
                    Logger.debug((Object)"nothing");
                } else {
                    String detail = nccMsg.getMessage().getDetail();
                    JSONObject josndetail = JSON.parseObject((String)detail);
                    josndetail.put("SubmitRejectBillMode", (Object)array[i].getBillSubmitModelType());
                    nccMsg.getMessage().setDetail(JSON.toJSONString((Object)josndetail));
                }
                boolean iscanbactch = CloudPfUtil.isExistAssignableInfoWhenPass(array[i]);
                if (iscanbactch) {
                    nccMsg.getMessage().setCanBatch(UFBoolean.FALSE);
                } else if (array[i].getWorkflow_type().intValue() == WorkflowTypeEnum.Workflow.getIntValue() || array[i].getWorkflow_type().intValue() == WorkflowTypeEnum.SubWorkflow.getIntValue() || array[i].getWorkflow_type().intValue() == WorkflowTypeEnum.SubWorkApproveflow.getIntValue()) {
                    if (wf != null) {
                        boolean isworkflowTransitionSelectableInfos = CloudPfUtil.isExistTransitionSelectableInfos(array[i], wf);
                        if (isworkflowTransitionSelectableInfos) {
                            nccMsg.getMessage().setCanBatch(UFBoolean.FALSE);
                        } else {
                            nccMsg.getMessage().setCanBatch(UFBoolean.TRUE);
                        }
                    }
                } else {
                    nccMsg.getMessage().setCanBatch(UFBoolean.TRUE);
                }
                nccMsgList.add(nccMsg);
            }
            if (!"notice".equals(type)) continue;
            nccMsg = PfMessageUtil.convertToNCCMsgVo(type, ncMsg, "", array[i].getWorkflow_type(), null, null);
            String obj = InvocationInfoProxy.getInstance().getProperty("noticeShowDetailFlag");
            if (obj != null) {
                String noticeShowDetailFlag = obj;
                nccMsg.getMessage().setFunccode(noticeShowDetailFlag);
                nccMsg.getMessage().setBilltype(array[i].pk_billtype);
                nccMsg.getMessage().setBillid(array[i].getBillid());
                InvocationInfoProxy.getInstance().setProperty("noticeShowDetailFlag", null);
            } else {
                nccMsg.getMessage().setDetail(null);
            }
            nccMsgList.add(nccMsg);
        }
        return nccMsgList;
    }

    private static List<NCCMessage> getNCCMessagesByWorkflownoteVosAndHistoryRejectReason(String type, WorkflownoteVO[] array, int rejectstat, String rejectreason, WFTask currentTask) throws BusinessException {
        List<NCCMessage> nccMsgList = PfMessageUtil.getNCCMessagesByWorkflownoteVos(type, array, currentTask);
        if (rejectstat == 1 && nccMsgList != null && nccMsgList.size() > 0) {
            for (NCCMessage ncmsg : nccMsgList) {
                if (ncmsg.getMessageType() == null || !ncmsg.getMessageType().equals("approve")) continue;
                String detail = ncmsg.getMessage().getDetail();
                JSONObject josndetail = JSON.parseObject((String)detail);
                JSONObject j = new JSONObject();
                j.put("isReject", (Object)true);
                j.put("rejectReason", (Object)rejectreason);
                josndetail.put("rejectHistory", (Object)j);
                ncmsg.getMessage().setDetail(JSON.toJSONString((Object)josndetail));
            }
        }
        return nccMsgList;
    }

    private static NCCMessage convertToNCCMsgVo4RejecttoFirst(String messageType, NCMessage ncmsg, String string, Integer workflow_type) {
        JSONObject hitmsgjson = new JSONObject();
        NCCMessage nccMsg = new NCCMessage();
        nccMsg.setMessageType("notice");
        nccMsg.setPk_messagetemplate(ncmsg.getPk_messagetemplate());
        nccMsg.setPropertySetting(ncmsg.getPropertySetting());
        nccMsg.setAttachmentSetting(ncmsg.getAttachmentSetting());
        nccMsg.setAddrbooks(ncmsg.getAddrbooks());
        nccMsg.setMsgContexts(ncmsg.getMsgContexts());
        nccMsg.setAttachmentPreSetting(ncmsg.getAttachmentPreSetting());
        NCCNoticeMessageVO nccVo = new NCCNoticeMessageVO();
        nc.message.vo.MessageVO vo = ncmsg.getMessage();
        nccVo.setPk_message(vo.getPk_message());
        nccVo.setSubject(vo.getSubject());
        nccVo.setContent(vo.getContent());
        nccVo.setContenttype(vo.getContenttype());
        nccVo.setMsgtype(vo.getMsgtype());
        nccVo.setMsgsourcetype(vo.getMsgsourcetype());
        nccVo.setPriority(vo.getPriority());
        nccVo.setWorkflowtype(workflow_type + "");
        String detail = vo.getDetail();
        nccVo.setDetail(detail);
        nccVo.setSendtime(vo.getSendtime());
        nccVo.setSender(vo.getSender());
        nccVo.setSendstate(vo.getSendstate());
        nccVo.setReceiver(vo.getReceiver());
        nccVo.setPk_group(vo.getPk_group());
        nccVo.setPk_org(vo.getPk_org());
        nccVo.setBilltype(vo.getBilltype());
        nccVo.setBillid(vo.getBillid());
        nccVo.setTs(vo.getTs());
        nccVo.setDr(vo.getDr());
        nccVo.setPk_detail(vo.getPk_detail());
        nccVo.setReceipt(UFBoolean.valueOf((String)vo.getReceipt()));
        nccVo.setWorkflowtype(workflow_type + "");
        IUserManageQuery userMq = (IUserManageQuery)NCLocator.getInstance().lookup(IUserManageQuery.class);
        try {
            UserVO usersender = userMq.getUser(nccVo.getSender());
            if (usersender != null) {
                String userNameLang = MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)usersender, (String)"user_name", null);
                nccVo.setSubject(userNameLang + NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "00020001-0479"));
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage());
            throw new BusinessRuntimeException(e.getMessage());
        }
        nccVo.setFunccode("reject_billmaker_message");
        nccMsg.setMessage((NCCMessageVO)nccVo);
        return nccMsg;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static NCCMessage convertToNCCMsgVo(String messageType, NCMessage ncmsg, String params, Integer workflow_type, WorkflownoteVO noteVO, WFTask currentTask) {
        hitmsgjson = new JSONObject();
        nccMsg = new NCCMessage();
        nccMsg.setMessageType(messageType);
        nccMsg.setPk_messagetemplate(ncmsg.getPk_messagetemplate());
        nccMsg.setPropertySetting(ncmsg.getPropertySetting());
        nccMsg.setAttachmentSetting(ncmsg.getAttachmentSetting());
        nccMsg.setAddrbooks(ncmsg.getAddrbooks());
        nccMsg.setMsgContexts(ncmsg.getMsgContexts());
        nccMsg.setAttachmentPreSetting(ncmsg.getAttachmentPreSetting());
        nccVo /* !! */  = messageType == "todo" ? new NCCTodoMessageVO() : (messageType == "prealert" ? new NCCPrealertMessageVO() : (messageType == "notice" ? new NCCNoticeMessageVO() : new NCCApproveMessageVO()));
        _note = null;
        _bvo = noteVO;
        actionVO = null;
        if (messageType == "approve") {
            enableActions = "";
            try {
                actionVO = ((NCCWorkFlowService)NCLocator.getInstance().lookup(NCCWorkFlowService.class)).queryActions(ncmsg, noteVO, currentTask);
            }
            catch (BusinessException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessRuntimeException(e.getMessage());
            }
            if (workflow_type == 4 || workflow_type == 5) {
                try {
                    historynsfVO = FlowHistoryUtil.convertHistorymsgVOs4NCC(_bvo.getPk_billtype(), new WorkflownoteVO[]{noteVO})[0];
                    if (actionVO == null) ** GOTO lbl56
                    for (String action : actionVO.getActions()) {
                        if ("".equals(enableActions)) {
                            enableActions = "\"" + action + "\",";
                            continue;
                        }
                        enableActions = enableActions + "\"" + action + "\",";
                    }
                    if (!"".equals(enableActions)) {
                        enableActions = enableActions.substring(0, enableActions.length() - 1);
                        nccVo /* !! */ .setDetail(" {\"enableActions\":[\"" + historynsfVO.getApprovelink() + "\"," + enableActions + "]}");
                    }
                    nccVo /* !! */ .setDetail(" {\"enableActions\":[\"" + historynsfVO.getApprovelink() + "\"]}");
                }
                catch (DAOException e1) {
                    Logger.error((Object)e1.getMessage(), (Throwable)e1);
                    throw new BusinessRuntimeException(e1.getMessage());
                }
                catch (BusinessException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BusinessRuntimeException(e.getMessage());
                }
                catch (Exception e2) {
                    Logger.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new BusinessRuntimeException(e2.getMessage());
                }
            } else {
                if (actionVO != null) {
                    for (String action : actionVO.getActions()) {
                        if ("".equals(enableActions)) {
                            enableActions = "\"" + action + "\",";
                            continue;
                        }
                        enableActions = enableActions + "\"" + action + "\",";
                    }
                    enableActions = enableActions.substring(0, enableActions.length() - 1);
                }
                nccVo /* !! */ .setDetail(" {\"enableActions\":[" + enableActions + "]}");
            }
        }
lbl56:
        // 6 sources

        vo = ncmsg.getMessage();
        nccVo /* !! */ .setPk_message(vo.getPk_message());
        nccVo /* !! */ .setSubject(vo.getSubject());
        nccVo /* !! */ .setContent(vo.getContent());
        nccVo /* !! */ .setContenttype(vo.getContenttype());
        nccVo /* !! */ .setMsgtype(vo.getMsgtype());
        nccVo /* !! */ .setMsgsourcetype(vo.getMsgsourcetype());
        nccVo /* !! */ .setPriority(vo.getPriority());
        nccVo /* !! */ .setWorkflowtype(workflow_type + "");
        detail = vo.getDetail();
        if (messageType == "approve") {
            values = detail.split("@");
            if (values.length >= 1) {
                nccVo /* !! */ .setBillid(values[0]);
            }
            if (values.length >= 2) {
                nccVo /* !! */ .setBilltype(values[1]);
            }
            if (values.length >= 3) {
                nccVo /* !! */ .setBillno(values[2]);
            }
            if (values.length >= 4 && StringUtils.isNotEmpty((CharSequence)values[1])) {
                try {
                    mapvalue = ((IBillRelatedAppService)NCLocator.getInstance().lookup(IBillRelatedAppService.class)).queryApproveAppInfo(values[3], values[1]);
                    nccVo /* !! */ .setParams("appcode=" + mapvalue.get("appcode") + "&pagecode=" + String.valueOf(mapvalue.get("pagecode")));
                    nccVo /* !! */ .setFunccode(String.valueOf(mapvalue.get("appcode")));
                }
                catch (BusinessException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BusinessRuntimeException(e.getMessage());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)nccVo /* !! */ .getDetail())) {
                josndetail = JSON.parseObject((String)nccVo /* !! */ .getDetail());
                if (actionVO.getHint() != null) {
                    reobj = new CloudPFBizRetObj();
                    reobj.setHintMessage(actionVO.getHint());
                    hitmsgjson = JSON.parseObject((String)JSON.toJSONString((Object)reobj));
                }
                josndetail.put("clientinfo", (Object)hitmsgjson);
                if (actionVO.isUserdefButton()) {
                    josndetail.put("usedefpass", (Object)"Y");
                } else {
                    josndetail.put("usedefpass", (Object)"N");
                }
                nccVo /* !! */ .setDetail(JSON.toJSONString((Object)josndetail));
            }
        } else {
            nccVo /* !! */ .setDetail(detail);
        }
        if (ncmsg.getMessage() != null && ncmsg.getMessage().getMsgsourcetype() != null && "addApproveFinished".equals(ncmsg.getMessage().getMsgsourcetype())) {
            values = detail.split("@");
            if (values.length >= 1) {
                nccVo /* !! */ .setBillid(values[0]);
            }
            if (values.length >= 2) {
                nccVo /* !! */ .setBilltype(values[1]);
                if (StringUtils.isNotEmpty((CharSequence)values[1])) {
                    try {
                        mapvalue = ((IBillRelatedAppService)NCLocator.getInstance().lookup(IBillRelatedAppService.class)).queryApproveAppInfo(null, values[1]);
                        nccVo /* !! */ .setParams("appcode=" + mapvalue.get("appcode") + "&pagecode=" + String.valueOf(mapvalue.get("pagecode")));
                        nccVo /* !! */ .setFunccode(String.valueOf(mapvalue.get("appcode")));
                    }
                    catch (BusinessException e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (values.length >= 3) {
                nccVo /* !! */ .setBillno(values[2]);
            }
        }
        nccVo /* !! */ .setSendtime(vo.getSendtime());
        nccVo /* !! */ .setSender(vo.getSender());
        nccVo /* !! */ .setSendstate(vo.getSendstate());
        nccVo /* !! */ .setReceiver(vo.getReceiver());
        nccVo /* !! */ .setPk_group(vo.getPk_group());
        nccVo /* !! */ .setPk_org(vo.getPk_org());
        nccVo /* !! */ .setFuncid(vo.getFuncid());
        nccVo /* !! */ .setTs(vo.getTs());
        nccVo /* !! */ .setDr(vo.getDr());
        nccVo /* !! */ .setPk_detail(vo.getPk_detail());
        nccVo /* !! */ .setReceipt(UFBoolean.valueOf((String)vo.getReceipt()));
        nccVo /* !! */ .setWorkflowtype(workflow_type + "");
        nccMsg.setMessage((NCCMessageVO)nccVo /* !! */ );
        return nccMsg;
    }

    private static String isCrossService(String className, String billTypeCode) throws BusinessException {
        try {
            INccPFCrossServiceQuery nccPFCrossServiceQueryImpl = (INccPFCrossServiceQuery)NCLocator.getInstance().lookup(INccPFCrossServiceQuery.class);
            return nccPFCrossServiceQueryImpl.isCrossServiceByClassName(className, billTypeCode);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static List<NCMessage> getNCMessagesByWorkflownoteVos(WorkflownoteVO[] array) throws BusinessException {
        ArrayList<NCMessage> ncMsgVOs = new ArrayList<NCMessage>();
        String[] funcodes = PfMessageUtil.getFuncodeByNoteVos(array);
        ArrayList<String> cuserids = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            String cuserid = array[i].getCheckman();
            if (cuserid == null || "".equalsIgnoreCase(cuserid)) continue;
            cuserids.add(cuserid);
        }
        HashMap<String, String> langcodes = Pfi18nTools.getLangcodesOfUserFromDb(cuserids.toArray(new String[0]));
        for (int i = 0; i < array.length; ++i) {
            String funcode = null;
            if (funcodes != null && funcodes.length > i) {
                funcode = funcodes[i];
            }
            if (funcode == null) {
                funcode = "";
            }
            String langcode = langcodes.get(array[i].getCheckman());
            NCMessage ncMsg = PfMessageUtil.transferToNCMessage(array[i], funcode, langcode);
            ncMsgVOs.add(ncMsg);
        }
        return ncMsgVOs;
    }

    public static String[] getFuncodeByNoteVos(WorkflownoteVO[] array) throws BusinessException {
        return WFFuncodeUtil.getActivityFuncode(array);
    }

    public static WFTask getWFTask(final String pk_wf_task) throws BusinessException {
        if (pk_wf_task == null) {
            return null;
        }
        WFTaskCacheKey key = new WFTaskCacheKey(pk_wf_task);
        ICacheDataQueryCallback<WFTask> callback = new ICacheDataQueryCallback<WFTask>(){

            public WFTask queryData() throws BusinessException {
                return ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).getWFTask(pk_wf_task);
            }
        };
        return (WFTask)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
    }

    public static MessageMetaVO createMessageMeta(MessageinfoVO msg) {
        MessageMetaVO meta = new MessageMetaVO();
        meta.setPk_group(msg.getPk_corp());
        meta.setMessage_type("nc-notice");
        meta.setBilltype(msg.getPk_billtype());
        meta.setBillid(msg.getBillid());
        meta.setBillno(msg.getBillno());
        meta.setTitle(msg.getTitle());
        meta.setReceiver(msg.getCheckman());
        meta.setSenddate(msg.getSenddate());
        return meta;
    }

    public static MessageMetaVO createMessageMeta(WorkflownoteVO note, WFTask task, String pk_message) {
        MessageMetaVO metavo = new MessageMetaVO();
        if (note.getActiontype().startsWith("Z") || note.getActiontype().startsWith("MAKEBILL")) {
            metavo.setMessage_type("nc-workitem");
        } else {
            metavo.setMessage_type("nc-notice");
        }
        metavo.setPk_group(note.getPk_group());
        metavo.setBilltype(note.getPk_billtype());
        metavo.setBillid(note.getBillVersionPK());
        metavo.setBillno(note.getBillno());
        metavo.setPk_checkflow(note.getPk_checkflow());
        metavo.setPk_message(pk_message);
        metavo.setTitle(note.getMessagenote());
        metavo.setReceiver(note.getCheckman());
        metavo.setSenddate(note.getSenddate());
        if (task != null) {
            metavo.setActivity_id(task.getActivityID());
            metavo.setPk_wf_instance(task.getWfProcessInstancePK());
        }
        return metavo;
    }

    public static void deleteMessagesOfWorknote(WorkflownoteVO[] notes) throws BusinessException {
        if (notes == null || notes.length == 0) {
            return;
        }
        Logger.info((Object)("deleteMessagesOfWorknote aryWorknote:" + notes));
        String ids = "";
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < notes.length; ++i) {
            jsonArray.add((Object)notes[i].getPk_checkflow());
        }
        JSONObject params = new JSONObject();
        params.put("pk_details", (Object)jsonArray);
        ((IApproveMessageManageService)NCLocator.getInstance().lookup(IApproveMessageManageService.class)).setDelete((Map)params, true, null);
    }

    public static void deletePullMessage(String billid) throws BusinessException {
        String cond = " pk_detail='" + billid + "' and contenttype='" + "BIZ_PULL" + "'";
        String[] pks = PfMessageUtil.lookupMessageQueryService().queryNCMsgPKs(cond);
        PfMessageUtil.lookupMessageService().deleteMessageByPk(pks);
        ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).deleteByPkMessage(pks);
    }

    public static void setHandled(WorkflownoteVO worknote) throws BusinessException {
        NCMessage[] ncMsgs = PfMessageUtil.lookupMessageQueryService().queryNCMessages("pk_detail='" + worknote.pk_checkflow + "'");
        if (ncMsgs == null || ncMsgs.length == 0) {
            return;
        }
        for (NCMessage message : ncMsgs) {
            message.getMessage().setIshandled(UFBoolean.TRUE);
        }
        PfMessageUtil.lookupMessageService().udpateMessage(ncMsgs);
    }

    public static NCCMessage[] convertToNCCMsgVos(String messageType, NCMessage[] ncMsgVOs) {
        return PfMessageUtil.convertToNCCMsgVos(messageType, ncMsgVOs, "");
    }

    private static boolean checkmanIsVirtual(WorkflownoteVO workflownoteVO) throws BusinessException {
        String pk_checkman = workflownoteVO.getCheckman();
        IUserManageQuery iUserService = (IUserManageQuery)NCLocator.getInstance().lookup(IUserManageQuery.class.getName());
        UserVO checkuser = iUserService.getUser(pk_checkman);
        return null != checkuser && checkuser.getUser_type() == -1;
    }

    public static NCCMessage[] convertToNCCMsgVos(String messageType, NCMessage[] ncMsgVOs, String params) {
        ArrayList<NCCMessage> nccMsgList = new ArrayList<NCCMessage>();
        if (ncMsgVOs != null && ncMsgVOs.length > 0) {
            for (NCMessage ncmsg : ncMsgVOs) {
                NCCMessage nccMsg = PfMessageUtil.convertToNCCMsgVo(messageType, ncmsg, params);
                nccMsgList.add(nccMsg);
            }
        }
        return nccMsgList.toArray(new NCCMessage[ncMsgVOs.length]);
    }

    public static NCCMessage[] convertToNCCMsgVos(String messageType, String appcode, NCMessage[] ncMsgVOs, String params) {
        ArrayList<NCCMessage> nccMsgList = new ArrayList<NCCMessage>();
        if (ncMsgVOs != null && ncMsgVOs.length > 0) {
            for (NCMessage ncmsg : ncMsgVOs) {
                NCCMessage nccMsg = PfMessageUtil.convertToNCCMsgVo(messageType, ncmsg, params);
                NCCMessageVO nccVo = nccMsg.getMessage();
                nccVo.setFunccode(appcode);
                nccMsg.setMessage(nccVo);
                nccMsgList.add(nccMsg);
            }
        }
        return nccMsgList.toArray(new NCCMessage[ncMsgVOs.length]);
    }

    public static List<NCCMessage> convertToNCCMsgVos(String messageType, List<NCMessage> ncMsgVOs) {
        ArrayList<NCCMessage> nccMsgList = new ArrayList<NCCMessage>();
        if (ncMsgVOs != null && ncMsgVOs.size() > 0) {
            for (NCMessage ncmsg : ncMsgVOs) {
                NCCMessage nccMsg = PfMessageUtil.convertToNCCMsgVo(messageType, ncmsg);
                nccMsgList.add(nccMsg);
            }
        }
        return nccMsgList;
    }

    public static NCCMessage convertToNCCMsgVo(String messageType, NCMessage ncmsg) {
        return PfMessageUtil.convertToNCCMsgVo(messageType, ncmsg, "");
    }

    public static NCCMessage convertToNCCMsgVo(String messageType, String appcode, NCMessage ncmsg, String params) {
        NCCMessage nccMsg = PfMessageUtil.convertToNCCMsgVo(messageType, ncmsg, params);
        NCCMessageVO nccVo = nccMsg.getMessage();
        nccVo.setFunccode(appcode);
        nccMsg.setMessage(nccVo);
        return nccMsg;
    }

    /*
     * Unable to fully structure code
     */
    public static NCCMessage convertToNCCMsgVo(String messageType, NCMessage ncmsg, String params) {
        if (ncmsg.getMessage().getMsgtype().equals("sms")) {
            content = "";
            str = ncmsg.getMessage().getContent();
            regex = "<span class=\"labeltext\">(.*)</span >";
            regex1 = "<span  class=\"normaltext\">(.*)</span >";
            pattern1 = Pattern.compile(regex1);
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(str);
            matcher1 = pattern1.matcher(str);
            while (matcher.find() && matcher1.find()) {
                content = content + matcher.group(1) + matcher1.group(1) + "  ";
            }
            if (!StringUtil.isEmpty((String)content)) {
                ncmsg.getMessage().setContent(content);
            }
        }
        nccMsg = new NCCMessage();
        nccMsg.setMessageType(messageType);
        nccMsg.setPk_messagetemplate(ncmsg.getPk_messagetemplate());
        nccMsg.setPropertySetting(ncmsg.getPropertySetting());
        nccMsg.setAttachmentSetting(ncmsg.getAttachmentSetting());
        nccMsg.setAddrbooks(ncmsg.getAddrbooks());
        nccMsg.setMsgContexts(ncmsg.getMsgContexts());
        nccMsg.setAttachmentPreSetting(ncmsg.getAttachmentPreSetting());
        nccMsg.setDef(ncmsg.getDef());
        if (messageType == "todo") {
            nccVo = new NCCTodoMessageVO();
        } else if (messageType == "prealert") {
            nccVo = new NCCPrealertMessageVO();
        } else if (messageType == "notice") {
            nccVo = new NCCNoticeMessageVO();
            nccVo.setMsgNoticeType("ncc" + ncmsg.getMessage().getMsgNoticeType());
        } else {
            nccVo = new NCCApproveMessageVO();
        }
        if (messageType == "approve") {
            actionVO = null;
            enableActions = "";
            try {
                con = null;
                noteVO = null;
                if (ncmsg != null && ncmsg.getMessage() != null && ncmsg.getMessage().getPk_detail() != null) {
                    con = new BaseDAO().retrieveByClause(WorkflownoteVO.class, "pk_checkflow='" + ncmsg.getMessage().getPk_detail() + "'");
                }
                noteVO = con == null || con.isEmpty() != false ? null : con.toArray(new WorkflownoteVO[0])[0];
                actionVO = ((NCCWorkFlowService)NCLocator.getInstance().lookup(NCCWorkFlowService.class)).queryActions(ncmsg, noteVO, null);
                if (actionVO != null) {
                    for (String action : actionVO.getActions()) {
                        if ("".equals(enableActions)) {
                            enableActions = "\"" + action + "\",";
                            continue;
                        }
                        enableActions = enableActions + "\"" + action + "\",";
                    }
                }
                if (enableActions.length() > 0) {
                    enableActions = enableActions.substring(0, enableActions.length() - 1);
                }
                nccVo.setDetail(" {\"enableActions\":[" + enableActions + "]}");
                if (noteVO == null) ** GOTO lbl135
                nccVo.setWorkflowtype(String.valueOf(noteVO.getWorkflow_type()));
                if (noteVO.getWorkflow_type() != 4 && noteVO.getWorkflow_type() != 5 && noteVO.getWorkflow_type() != 6) ** GOTO lbl135
                ss = nccVo.getDetail();
                if (ss.contains("pass")) {
                    historynsfVO = FlowHistoryUtil.convertHistorymsgVOs4NCC(noteVO.getPk_billtype(), new WorkflownoteVO[]{noteVO})[0];
                    if ("Z_A".equals(ncmsg.getMessage().getContenttype())) {
                        ss.replace("pass", NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "0nccloud1016Design-0000"));
                    }
                    ss.replace("pass", historynsfVO.getApprovelink());
                }
                jsonObject = JSON.parseObject((String)nccVo.getDetail());
                strs = (List)jsonObject.get((Object)"enableActions");
                _nstrs = new ArrayList<String>();
                historynsfVO = FlowHistoryUtil.convertHistorymsgVOs4NCC(noteVO.getPk_billtype(), new WorkflownoteVO[]{noteVO})[0];
                if ("Z_A".equals(ncmsg.getMessage().getContenttype())) {
                    _nstrs.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "0nccloud1016Design-0000"));
                } else {
                    _nstrs.add(historynsfVO.getApprovelink());
                }
                for (String str : strs) {
                    _nstrs.add(str);
                }
                jsonObject.put("enableActions", (Object)_nstrs.toArray(new String[0]));
                nccVo.setDetail(jsonObject.toJSONString());
            }
            catch (BusinessException e) {
                Logger.error((Object)e);
                throw new BusinessRuntimeException(e.getMessage());
            }
        } else if (messageType == "notice") {
            con = null;
            noteVO = null;
            try {
                if (ncmsg != null && ncmsg.getMessage() != null && ncmsg.getMessage().getPk_detail() != null) {
                    con = new BaseDAO().retrieveByClause(WorkflownoteVO.class, "pk_checkflow='" + ncmsg.getMessage().getPk_detail() + "'");
                }
                noteVO = con == null || con.isEmpty() != false ? null : con.toArray(new WorkflownoteVO[0])[0];
            }
            catch (DAOException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessRuntimeException(e.getMessage());
            }
            if (noteVO != null) {
                nccVo.setWorkflowtype(String.valueOf(noteVO.getWorkflow_type()));
                try {
                    if (noteVO.getWorkflow_type() == 4 || noteVO.getWorkflow_type() == 5 || noteVO.getWorkflow_type() == 6) {
                        ss = nccVo.getDetail();
                        if (ss.contains("pass")) {
                            historynsfVO = FlowHistoryUtil.convertHistorymsgVOs4NCC(ncmsg.getMessage().getBilltype(), new WorkflownoteVO[]{noteVO})[0];
                            if ("Z_A".equals(ncmsg.getMessage().getContenttype())) {
                                ss.replace("pass", NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "0nccloud1016Design-0000"));
                            } else {
                                ss.replace("pass", historynsfVO.getApprovelink());
                            }
                        } else {
                            jsonObject = JSON.parseObject((String)nccVo.getDetail());
                            strs = (List)jsonObject.get((Object)"enableActions");
                            _nstrs = new ArrayList<String>();
                            historynsfVO = FlowHistoryUtil.convertHistorymsgVOs4NCC(ncmsg.getMessage().getBilltype(), new WorkflownoteVO[]{noteVO})[0];
                            if ("Z_A".equals(ncmsg.getMessage().getContenttype())) {
                                _nstrs.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "0nccloud1016Design-0000"));
                            } else {
                                _nstrs.add(historynsfVO.getApprovelink());
                            }
                            for (String str : strs) {
                                _nstrs.add(str);
                            }
                            jsonObject.put("enableActions", (Object)_nstrs.toArray(new String[0]));
                            nccVo.setDetail(jsonObject.toJSONString());
                        }
                    }
                }
                catch (BusinessException e) {
                    Logger.error((Object)e.getMessage());
                    throw new BusinessRuntimeException(e.getMessage());
                }
            }
        }
lbl135:
        // 12 sources

        vo = ncmsg.getMessage();
        nccVo.setPk_message(vo.getPk_message());
        nccVo.setSubject(vo.getSubject());
        nccVo.setContent(vo.getContent());
        nccVo.setContenttype(vo.getContenttype());
        nccVo.setMsgtype(vo.getMsgtype());
        nccVo.setMsgsourcetype(vo.getMsgsourcetype());
        nccVo.setPriority(vo.getPriority());
        nccVo.setBilltype(vo.getBilltype());
        nccVo.setBillid(vo.getBillid());
        detail = vo.getDetail();
        if (StringUtils.isNotEmpty((CharSequence)detail)) {
            Logger.debug((Object)"nothing");
        }
        if (messageType == "approve") {
            values = detail.split("@");
            if (values.length >= 1) {
                nccVo.setBillid(values[0]);
            }
            if (values.length >= 2) {
                nccVo.setBilltype(values[1]);
            }
            if (values.length >= 3) {
                nccVo.setBillno(values[2]);
            }
            if (values.length >= 4) {
                nccVo.setFunccode(values[3]);
            }
        } else if (messageType == "notice") {
            if (detail == null) {
                detail = "";
            }
            values = detail.split("@");
            if ((nccVo.getBillid() == null || nccVo.getBillid().trim().length() == 0) && values.length >= 1) {
                nccVo.setBillid(values[0]);
            }
            if (values.length >= 2) {
                nccVo.setBilltype(values[1]);
            }
            if (values.length >= 3) {
                nccVo.setBillno(values[2]);
            }
            notes = null;
            try {
                notes = new BaseDAO().retrieveByClause(WorkflownoteVO.class, "pk_checkflow = '" + vo.getPk_detail() + "'");
            }
            catch (DAOException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessRuntimeException(e.getMessage());
            }
            v0 = bvo = notes == null || notes.isEmpty() != false ? null : notes.toArray(new WorkflownoteVO[0])[0];
            if (bvo != null && StringUtils.isNotEmpty((CharSequence)bvo.getPk_billtype())) {
                try {
                    mapvalue = ((IBillRelatedAppService)NCLocator.getInstance().lookup(IBillRelatedAppService.class)).queryApproveAppInfo(null, bvo.getPk_billtype());
                    nccVo.setParams("appcode=" + mapvalue.get("appcode") + "&pagecode=" + String.valueOf(mapvalue.get("pagecode")));
                    nccVo.setFunccode(String.valueOf(mapvalue.get("appcode")));
                }
                catch (BusinessException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BusinessRuntimeException(e.getMessage());
                }
            }
        } else if (messageType == "todo") {
            nccVo.setBillno(detail);
            nccVo.setDetail(detail);
        } else {
            nccVo.setDetail(detail);
        }
        nccVo.setSendtime(vo.getSendtime());
        nccVo.setSender(vo.getSender());
        nccVo.setSendstate(vo.getSendstate());
        nccVo.setReceiver(vo.getReceiver());
        nccVo.setPk_group(vo.getPk_group());
        nccVo.setPk_org(vo.getPk_org());
        nccVo.setParams(params);
        nccVo.setTs(vo.getTs());
        nccVo.setDr(vo.getDr());
        nccVo.setPk_detail(vo.getPk_detail());
        nccVo.setReceipt(UFBoolean.valueOf((String)vo.getReceipt()));
        nccVo.setFuncid(vo.getFuncid());
        ss = nccVo.getDetail();
        nccMsg.setMessage((NCCMessageVO)nccVo);
        return nccMsg;
    }
}

