/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import nc.bs.framework.common.NCLocator;
import nc.itf.uap.pf.IWorkflowDefine;
import nc.vo.pub.BusinessException;
import nc.vo.pub.guid.GuidUtils;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.Implementation;
import nc.vo.wfengine.core.activity.SubFlow;
import nc.vo.wfengine.core.parser.UfXPDLParser;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.WorkflowDefinitionVO;
import nc.vo.wfengine.definition.WorkflowTypeEnum;

public class SubFlowExtractor {
    public static final String extractSubflowIds(WorkflowDefinitionVO defvo) throws BusinessException, XPDLParserException {
        if (defvo == null || defvo.getContent() == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = SubFlowExtractor.extractSubflowList(defvo);
        if (list != null && list.size() > 0) {
            for (String subid : list) {
                sb.append("'" + subid + "',");
            }
            return sb.toString();
        }
        return null;
    }

    public static final ArrayList<String> extractSubflowList(WorkflowDefinitionVO defvo) throws BusinessException, XPDLParserException {
        if (defvo == null || defvo.getContent() == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        BasicWorkflowProcess bwp = UfXPDLParser.getInstance().parseProcess(defvo.getContent().toString());
        List actList = bwp.getActivities();
        for (Activity act : actList) {
            Implementation impl = act.getImplementation();
            if (impl == null || !(impl instanceof SubFlow)) continue;
            String subid = ((SubFlow)impl).getId();
            list.add(subid);
        }
        return list;
    }

    public static boolean hasReference(WorkflowProcess refer, WorkflowProcess referee) {
        List activities = refer.getActivities();
        if (activities != null) {
            for (Object o : activities) {
                SubFlow subFlow;
                Activity activity = (Activity)o;
                if (activity.getImplementation() == null || !(activity.getImplementation() instanceof SubFlow) || (subFlow = (SubFlow)activity.getImplementation()).getId() == null || !subFlow.getId().equals(referee.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public static void replaceSubflowIds(WorkflowProcess[] wps) throws BusinessException {
        HashMap<String, WorkflowProcess> map = new HashMap<String, WorkflowProcess>();
        HashMap<String, String> idmapping = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        for (WorkflowProcess wp : wps) {
            map.put(wp.getProcessDefinitionId(), wp);
            sb.append("'");
            sb.append(wp.getPrimaryKey());
            sb.append("',");
        }
        IWorkflowDefine queryitf = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class.getName());
        HashSet<String> instacncesPks = queryitf.queryWfInstanceDefid(sb.toString());
        for (WorkflowProcess wp : wps) {
            List activities = wp.getActivities();
            sb = new StringBuffer();
            if (activities != null) {
                for (Object o : activities) {
                    String str;
                    Activity activity = (Activity)o;
                    if (activity.getImplementation() == null || !(activity.getImplementation() instanceof SubFlow)) continue;
                    SubFlow subFlow = (SubFlow)activity.getImplementation();
                    sb.append("'");
                    sb.append(subFlow.getId());
                    sb.append("',");
                    if (!instacncesPks.contains(subFlow.getId())) continue;
                    if (idmapping.get(subFlow.getId()) == null) {
                        str = GuidUtils.generate();
                        idmapping.put(subFlow.getId(), str);
                        subFlow.setId(str);
                        continue;
                    }
                    str = (String)idmapping.get(subFlow.getId());
                    subFlow.setId(str);
                }
            }
            if (sb.length() <= 0) continue;
            wp.setSublfowIds(sb.toString());
        }
        for (WorkflowProcess wp : wps) {
            String newid = (String)idmapping.get(wp.getProcessDefinitionId());
            if (newid != null) {
                wp.setId(newid);
                continue;
            }
            if (wp.getWorkflowType() != WorkflowTypeEnum.SubWorkApproveflow.getIntValue() && wp.getWorkflowType() != WorkflowTypeEnum.SubApproveflow.getIntValue()) continue;
            wp.setFakeId(GuidUtils.generate());
        }
    }
}

