/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.util;

import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.itf.bd.workcalendar.IWorkCalendarInnerService;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.wfengine.core.util.DateUtilities;

public final class DurationUnit
implements Serializable {
    static final long serialVersionUID = 3955674746845399636L;
    public static final int YEAR_INT = 0;
    public static final int MONTH_INT = 1;
    public static final int DAY_INT = 2;
    public static final int HOUR_INT = 3;
    public static final int MINUTE_INT = 4;
    public static final int SECOND_INT = 5;
    public static final DurationUnit YEAR = new DurationUnit(0);
    public static final DurationUnit MONTH = new DurationUnit(1);
    public static final DurationUnit DAY = new DurationUnit(2);
    public static final DurationUnit HOUR = new DurationUnit(3);
    public static final DurationUnit MINUTE = new DurationUnit(4);
    public static final DurationUnit SECOND = new DurationUnit(5);
    private static final String[] TAGS = new String[]{"Y", "M", "D", "h", "m", "s"};
    private static final DurationUnit[] VALUES = new DurationUnit[]{YEAR, MONTH, DAY, HOUR, MINUTE, SECOND};
    private static final HashMap tagMap = new HashMap();
    private static final HashMap unitToMillisecondsMap = new HashMap();
    private final int _value;

    public static DurationUnit fromString(String tag) {
        DurationUnit durationUnit = (DurationUnit)tagMap.get(tag);
        if (durationUnit == null && tag != null) {
            throw new IllegalArgumentException(tag);
        }
        return durationUnit;
    }

    public static long unitToMilliseconds(DurationUnit unit) {
        Long value = (Long)unitToMillisecondsMap.get(unit);
        if (value == null) {
            throw new IllegalArgumentException("Unknown duration unit: " + unit);
        }
        return value;
    }

    private DurationUnit(int value) {
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    public String toString() {
        switch (this._value) {
            case 0: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "DurationUnit-000000");
            }
            case 1: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "DurationUnit-000001");
            }
            case 2: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "DurationUnit-000002");
            }
            case 3: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "DurationUnit-000003");
            }
            case 4: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "DurationUnit-000004");
            }
            case 5: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "DurationUnit-000005");
            }
        }
        return "ERROR";
    }

    public long toMilliseconds() {
        return DurationUnit.unitToMilliseconds(this);
    }

    public Object readResolve() {
        return VALUES[this._value];
    }

    public String getTag() {
        return TAGS[this._value];
    }

    public static String getElapsedTime(UFDateTime beginTime, UFDateTime endTime) {
        if (beginTime.after(endTime)) {
            UFDateTime temp = beginTime;
            beginTime = endTime;
            endTime = temp;
        }
        int[] raw = DurationUnit.getElapsedTimeRaw(beginTime, endTime);
        return DurationUnit.getStrElapsed(raw[0], raw[1], raw[2], raw[3]);
    }

    public static int[] getElapsedTimeRaw(UFDateTime beginTime, UFDateTime endTime) {
        int iDays = Math.abs(UFDateTime.getHoursBetween((UFDateTime)beginTime, (UFDateTime)endTime) / 24);
        int iHours = Math.abs(UFDateTime.getHoursBetween((UFDateTime)beginTime, (UFDateTime)endTime) - iDays * 24);
        int iMins = Math.abs(UFDateTime.getMinutesBetween((UFDateTime)beginTime, (UFDateTime)endTime) - iDays * 24 * 60 - iHours * 60);
        int iSecs = Math.abs(UFDateTime.getSecondsBetween((UFDateTime)beginTime, (UFDateTime)endTime) - iDays * 24 * 3600 - iHours * 3600 - iMins * 60);
        return new int[]{iDays, iHours, iMins, iSecs};
    }

    public static int[] getElapsedTimeInWorkCalendarRaw(String pk_org, UFDateTime beginTime, UFDateTime endTime) {
        if (beginTime == null || endTime == null) {
            throw new IllegalArgumentException();
        }
        IWorkCalendarInnerService wciService = (IWorkCalendarInnerService)NCLocator.getInstance().lookup(IWorkCalendarInnerService.class);
        int[] raw = null;
        String elapsed = null;
        try {
            String[] str;
            String beginLiteral = beginTime.toStdString();
            String endLiteral = endTime.toStdString();
            if (!StringUtil.isEmptyWithTrim((String)pk_org) && beginLiteral != null && beginLiteral.length() == 19 && endLiteral != null && endLiteral.length() == 19) {
                elapsed = wciService.calculateWorkLoad(pk_org, beginLiteral, endLiteral);
            }
            if (!StringUtil.isEmptyWithTrim(elapsed) && (str = elapsed.toString().split(":")).length == 4) {
                int day = Integer.parseInt(str[0]);
                int hour = Integer.parseInt(str[1]);
                int min = Integer.parseInt(str[2]);
                int sec = Integer.parseInt(str[3]);
                raw = new int[]{day, hour, min, sec};
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (raw == null) {
            raw = DurationUnit.getElapsedTimeRaw(beginTime, endTime);
        }
        return raw;
    }

    public static String getElapsedTimeInWorkCalendar(String pk_org, UFDateTime beginTime, UFDateTime endTime) {
        int[] raw = DurationUnit.getElapsedTimeInWorkCalendarRaw(pk_org, beginTime, endTime);
        return DurationUnit.getStrElapsed(raw[0], raw[1], raw[2], raw[3]);
    }

    public static String getStrElapsed(int iDays, int iHours, int iMins, int iSecs) {
        StringBuffer sb = new StringBuffer();
        sb.append(iDays);
        sb.append(DAY.toString());
        sb.append(iHours);
        sb.append(HOUR.toString());
        sb.append(iMins);
        sb.append(MINUTE.toString());
        sb.append(iSecs);
        sb.append(SECOND.toString());
        return sb.toString();
    }

    public static String getElapsedTime(long elapsed) {
        Long dayToMillis = (Long)unitToMillisecondsMap.get(DAY);
        int iDays = (int)(elapsed / dayToMillis);
        Long hourToMillis = (Long)unitToMillisecondsMap.get(HOUR);
        int iHours = (int)((elapsed - (long)iDays * dayToMillis) / hourToMillis);
        Long minToMillis = (Long)unitToMillisecondsMap.get(MINUTE);
        int iMins = (int)((elapsed - (long)iDays * dayToMillis - (long)iHours * hourToMillis) / minToMillis);
        Long secToMillis = (Long)unitToMillisecondsMap.get(SECOND);
        int iSecs = (int)((elapsed - (long)iDays * dayToMillis - (long)iHours * hourToMillis - (long)iMins * minToMillis) / secToMillis);
        return DurationUnit.getStrElapsed(iDays, iHours, iMins, iSecs);
    }

    public static void main(String[] args) {
        Logger.debug((Object)"main called");
        try {
            String s = DurationUnit.getElapsedTime(new UFDateTime(DateUtilities.getInstance().parse("2007-09-11 17:44:57")), new UFDateTime(DateUtilities.getInstance().parse("2007-09-12 12:51:40")));
            Logger.debug((Object)s);
            s = DurationUnit.getElapsedTime(new UFDateTime(DateUtilities.getInstance().parse("2007-09-11 20:53:00")), new UFDateTime(DateUtilities.getInstance().parse("2007-09-12 09:50:39")));
            Logger.debug((Object)s);
        }
        catch (ParseException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        for (int i = 0; i < TAGS.length; ++i) {
            tagMap.put(TAGS[i], VALUES[i]);
        }
        unitToMillisecondsMap.put(SECOND, 1000L);
        unitToMillisecondsMap.put(MINUTE, 60000L);
        unitToMillisecondsMap.put(HOUR, 3600000L);
        unitToMillisecondsMap.put(DAY, 86400000L);
        unitToMillisecondsMap.put(MONTH, 2592000000L);
        unitToMillisecondsMap.put(YEAR, 31536000000L);
    }
}

