/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.util;

import java.io.Serializable;
import nc.vo.wfengine.core.util.DurationUnit;

public class Duration
implements Serializable {
    static final long serialVersionUID = -4251576301062064086L;
    private int value;
    private DurationUnit unit;

    public Duration(int value, DurationUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public Duration(String durationString) throws NumberFormatException {
        Duration d = Duration.parse(durationString);
        this.value = d.getValue();
        this.unit = d.getUnit();
    }

    public int getValue() {
        return this.value;
    }

    public DurationUnit getUnit() {
        return this.unit;
    }

    public DurationUnit getUnit(DurationUnit defaultUnit) {
        if (this.unit == null) {
            return defaultUnit;
        }
        return this.unit;
    }

    public long getDurationInMilliseconds(DurationUnit defaultUnit) {
        int value = this.getValue();
        DurationUnit unit = this.getUnit(defaultUnit);
        if (value == 0) {
            return value;
        }
        long duration = (long)value * unit.toMilliseconds();
        return duration;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.value);
        if (this.unit != null) {
            buffer.append(this.unit);
        }
        return buffer.toString();
    }

    public static Duration parse(String durationString) throws NumberFormatException {
        if (durationString == null) {
            throw new IllegalArgumentException("Duration string cannot be null");
        }
        StringBuffer intBuffer = new StringBuffer();
        DurationUnit unit = null;
        for (int i = 0; i < durationString.length(); ++i) {
            char c = durationString.charAt(i);
            if (Character.isDigit(c)) {
                intBuffer.append(c);
                continue;
            }
            if (!Character.isLetter(c)) continue;
            char[] cArray = new char[]{c};
            unit = DurationUnit.fromString(new String(cArray));
        }
        if (intBuffer.toString().equals("")) {
            return new Duration(0, unit);
        }
        return new Duration(Integer.parseInt(intBuffer.toString()), unit);
    }
}

