/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DateUtilities {
    private static final DateUtilities dateUtilities = new DateUtilities();
    private List formats;
    private DateFormat UFSOFT_STANDARD_DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat DAY_STANDARD_DF = new SimpleDateFormat("yyyy-MM-dd");

    private DateUtilities() {
        this.resetFormats();
    }

    public void resetFormats() {
        this.formats = new ArrayList();
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz"));
        this.formats.add(new SimpleDateFormat("MM/dd/yyyy HH:mm:ss a"));
        this.formats.add(this.UFSOFT_STANDARD_DF);
        this.formats.add(this.DAY_STANDARD_DF);
    }

    public static DateUtilities getInstance() {
        return dateUtilities;
    }

    public Date parse(String dateString) throws ParseException {
        Iterator iter = this.formats.iterator();
        while (iter.hasNext()) {
            try {
                return ((DateFormat)iter.next()).parse(dateString);
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("Unsupported date format", -1);
    }

    public List getFormats() {
        return this.formats;
    }

    public String format(Date date) {
        return this.UFSOFT_STANDARD_DF.format(date);
    }

    public String formatJustDay(Date date) {
        return this.DAY_STANDARD_DF.format(date);
    }
}

