/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import nc.bs.logging.Logger;
import nc.vo.wfengine.core.ConformanceClass;
import nc.vo.wfengine.core.ExternalPackage;
import nc.vo.wfengine.core.GraphConformance;
import nc.vo.wfengine.core.PackageHeader;
import nc.vo.wfengine.core.RedefinableHeader;
import nc.vo.wfengine.core.Script;
import nc.vo.wfengine.core.XpdlPackage;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.ActivitySet;
import nc.vo.wfengine.core.activity.BlockActivity;
import nc.vo.wfengine.core.activity.ExecutionType;
import nc.vo.wfengine.core.activity.Implementation;
import nc.vo.wfengine.core.activity.NoImplementation;
import nc.vo.wfengine.core.activity.SubFlow;
import nc.vo.wfengine.core.activity.Tool;
import nc.vo.wfengine.core.activity.ToolSet;
import nc.vo.wfengine.core.application.Application;
import nc.vo.wfengine.core.condition.Condition;
import nc.vo.wfengine.core.condition.ConditionType;
import nc.vo.wfengine.core.data.ActualParameter;
import nc.vo.wfengine.core.data.ArrayType;
import nc.vo.wfengine.core.data.BasicType;
import nc.vo.wfengine.core.data.DataField;
import nc.vo.wfengine.core.data.DataType;
import nc.vo.wfengine.core.data.DeclaredType;
import nc.vo.wfengine.core.data.EnumerationType;
import nc.vo.wfengine.core.data.ExternalReference;
import nc.vo.wfengine.core.data.FormalParameter;
import nc.vo.wfengine.core.data.ListType;
import nc.vo.wfengine.core.data.RecordType;
import nc.vo.wfengine.core.data.SchemaType;
import nc.vo.wfengine.core.data.Type;
import nc.vo.wfengine.core.data.TypeDeclaration;
import nc.vo.wfengine.core.data.UnionType;
import nc.vo.wfengine.core.parser.GraphChecker;
import nc.vo.wfengine.core.parser.PackageValidatorMessages;
import nc.vo.wfengine.core.parser.ValidationError;
import nc.vo.wfengine.core.participant.Participant;
import nc.vo.wfengine.core.transition.Join;
import nc.vo.wfengine.core.transition.Split;
import nc.vo.wfengine.core.transition.SplitJoinType;
import nc.vo.wfengine.core.transition.Transition;
import nc.vo.wfengine.core.transition.TransitionRestriction;
import nc.vo.wfengine.core.util.CoreUtilities;
import nc.vo.wfengine.core.util.Deadline;
import nc.vo.wfengine.core.workflow.AbstractWorkflowProcess;
import nc.vo.wfengine.core.workflow.WorkflowProcess;

public class PackageValidator
implements PackageValidatorMessages {
    public static final String GRAPH_CONFORMANCE_MIN_PROP = "graph.conformance.minimum";
    private static final String PACKAGE = "Package";
    private static final String ACTIVITY = "Activity";
    private static final String ACTIVITY_SET = "ActivitySet";
    private static final String PKG_APPLICATION = "Application(Package)";
    private static final String APPLICATION = "Application";
    private static final String PKG_DATA_FIELD = "DataField(Package)";
    private static final String DATA_FIELD = "DataField";
    private static final String FORMAL_PARAMETER = "FormalParameter";
    private static final String PKG_PARTICIPANT = "Participant(Package)";
    private static final String PARTICIPANT = "Participant";
    private static final String TRANSITION = "Transition";
    private static final String TYPE_DECLARATION = "TypeDeclaration";
    private static final String WORKFLOW_PROCESS = "WorkflowProcess";
    private static final String WORKFLOW_FORMAL_PARAMETER = "FormalParameter(Workflow)";
    private static final String[][] DEFAULTS = new String[][]{{"graph.conformance.minimum", GraphConformance.NON_BLOCKED.toString()}};
    private static final Set _countryCodes = new TreeSet();
    private static final Properties _defaultProps = new Properties();
    private Properties _props = new Properties(_defaultProps);
    ValidationContext _ctx = null;

    public PackageValidator() {
    }

    public PackageValidator(Properties props) {
        if (props != null) {
            this._props.putAll((Map<?, ?>)props);
        }
    }

    public String getProperty(String key) {
        return this._props.getProperty(key);
    }

    public Object setProperty(String key, String value) {
        return this._props.setProperty(key, value);
    }

    public void validate(XpdlPackage pkg, boolean throwException) {
        List wps = pkg.getWorkflowProcesses();
        int n = wps.size();
        for (int i = 0; i < n; ++i) {
            ((AbstractWorkflowProcess)wps.get(i)).resolveReferences();
        }
        this._ctx = new ValidationContext(pkg);
        this.checkPackage(this._ctx);
    }

    public ValidationError[] getErrors() {
        return this._ctx.getErrors();
    }

    public ValidationError[] getWarnings() {
        return this._ctx.getWarnings();
    }

    private void checkPackage(ValidationContext ctx) {
        XpdlPackage pkg = ctx.pkg;
        ctx.pushPrefix("Package[" + pkg.getId() + ']');
        ctx.checkValidUniqueId(pkg, null, PACKAGE, pkg.getId(), pkg);
        this.checkPackageHeader(ctx);
        this.checkRedefinableHeader(pkg.getRedefinableHeader(), ctx);
        this.checkConformanceClass(ctx);
        this.checkScript(ctx);
        this.checkTypeDeclarations(ctx);
        this.checkParticipants(pkg.getParticipants(), true, ctx);
        this.checkApplications(pkg.getApplications(), true, ctx);
        this.checkDataFields(pkg.getDataFields(), true, ctx);
        this.checkWorkflows(ctx);
        ctx.popPrefix();
    }

    private void checkPackageHeader(ValidationContext ctx) {
        ctx.pushPrefix("PackageHeader");
        PackageHeader hdr = ctx.pkg.getPackageHeader();
        ctx.checkNotNull(hdr, "/XPDLVersion", hdr.getXPDLVersion());
        ctx.checkNotNull(hdr, "/Vendor", hdr.getVendor());
        ctx.checkNotNull(hdr, "/Created", hdr.getCreated());
        ctx.popPrefix();
    }

    private void checkRedefinableHeader(RedefinableHeader hdr, ValidationContext ctx) {
        String country;
        ctx.pushPrefix("RedefinableHeader");
        if (hdr != null && (country = hdr.getCountrykey()) != null && !_countryCodes.contains(country)) {
            ctx.addWarning(hdr, 30, new Object[]{country}, "Unsupported country: " + country);
        }
        ctx.popPrefix();
    }

    private void checkConformanceClass(ValidationContext ctx) {
        GraphConformance gc;
        ConformanceClass cc = ctx.pkg.getConformanceClass();
        GraphConformance graphConformance = gc = cc == null ? null : cc.getGraphConformance();
        if (gc == null) {
            gc = GraphConformance.NON_BLOCKED;
        }
        String gcl = this.getProperty(GRAPH_CONFORMANCE_MIN_PROP);
        ctx.checkGE(ctx.pkg, " Graph conformance level must be at least " + gcl, "GraphConformance", GraphConformance.fromString(gcl).getValue(), gc.getValue());
        GraphChecker graphChecker = null;
        List wps = ctx.pkg.getWorkflowProcesses();
        for (WorkflowProcess wp : wps) {
            int[] loopNodes;
            ctx.pushPrefix("Workflow[" + wp.getId() + ']');
            List activities = wp.getActivities();
            boolean[][] incidenceMatrix = this.createIncidenceMatrix(activities);
            if (incidenceMatrix != null && (loopNodes = (graphChecker = new GraphChecker(incidenceMatrix)).getCyclicNodes()) != null) {
                ctx.addWarning(wp, 35, new Object[]{ctx.peekPrefix()}, "TheGraphIsCyclic");
            }
            Set splitActs = CoreUtilities.getSplitOrJoinActivities(activities, 0);
            Set joinActs = CoreUtilities.getSplitOrJoinActivities(activities, 1);
            if (splitActs.size() != joinActs.size()) {
                ctx.addWarning(wp, 36, new Object[]{ctx.peekPrefix()}, "the number of splits and joins don't matches");
            }
            if (this.getNoOfANDSplitsOrJoins(splitActs, 0) != this.getNoOfANDSplitsOrJoins(joinActs, 1)) {
                ctx.addWarning(wp, 37, new Object[]{ctx.peekPrefix()}, "ErrorOneOrMoreSplitsDoNotHaveCorrespondingJoinBecauseOfTypeMismatch");
            }
            ctx.popPrefix();
        }
    }

    protected int getNoOfANDSplitsOrJoins(Set acts, int sOrJ) {
        int no = 0;
        for (Activity act : acts) {
            if (!CoreUtilities.isANDTypeSplitOrJoin(act, sOrJ)) continue;
            ++no;
        }
        return no;
    }

    protected boolean[][] createIncidenceMatrix(List activities) {
        int size = activities.size();
        boolean[][] incidenceMatrix = new boolean[size][size];
        for (int indAct = 0; indAct < size; ++indAct) {
            Activity a = (Activity)activities.get(indAct);
            List trans = a.getWorkflowProcess().getTransitions();
            HashSet oas = new HashSet();
            for (Transition t : CoreUtilities.getTransitions(trans, a.getId(), -1)) {
                Activity aOut;
                if (t == null || t.getToActivity() == null || !((aOut = t.getToActivity()) instanceof Activity)) continue;
                int indOut = activities.indexOf(aOut);
                if (indOut == -1) {
                    return null;
                }
                incidenceMatrix[indAct][indOut] = true;
            }
        }
        return incidenceMatrix;
    }

    private void checkScript(ValidationContext ctx) {
        Script script = ctx.pkg.getScript();
        if (script != null) {
            String type = script.getType();
            ctx.pushPrefix("Script[" + type + ']');
            if (type == null || !type.startsWith("text/x-") && !type.startsWith("text/xml/x-")) {
                ctx.addError(ctx.pkg, 31, new Object[]{script}, " is not a valid script declaration. The script type is an extended MIME Media Type and must start with \"text/x-\" or \"text/xml/x-\"");
            }
            ctx.popPrefix();
        }
    }

    @Deprecated
    private void checkExternalPackages(ValidationContext ctx) {
        List pkgs = ctx.pkg.getExternalPackages();
        for (int i = 0; i < pkgs.size(); ++i) {
            ExternalPackage pkg = (ExternalPackage)pkgs.get(i);
            ctx.checkNotNull(ctx.pkg, "/ExternalPackages/ExternalPackage[" + i + "]/@href", pkg.getHref());
        }
    }

    private void checkTypeDeclarations(ValidationContext ctx) {
        ctx.resetUniqueId(TYPE_DECLARATION);
        List typeDeclarations = ctx.pkg.getTypeDeclarations();
        if (typeDeclarations != null) {
            int n = typeDeclarations.size();
            for (int i = 0; i < n; ++i) {
                this.checkTypeDeclaration((TypeDeclaration)typeDeclarations.get(i), ctx);
            }
        }
    }

    private void checkTypeDeclaration(TypeDeclaration typeDecl, ValidationContext ctx) {
        ctx.pushPrefix("TypeDeclaration[" + typeDecl.getId() + ']');
        ctx.checkValidUniqueId(typeDecl, null, TYPE_DECLARATION, typeDecl.getId(), typeDecl);
        Type type = typeDecl.getType();
        if (type == null) {
            ctx.addError(ctx.pkg, 32, null, typeDecl + " is not a valid type declaration: a type is required.");
        }
        ctx.popPrefix();
    }

    private void checkParticipants(List participants, boolean pkgLevel, ValidationContext ctx) {
        String pri = pkgLevel ? PKG_PARTICIPANT : PARTICIPANT;
        String sec = pkgLevel ? null : PKG_PARTICIPANT;
        ctx.resetUniqueId(pri);
        if (participants != null) {
            int n = participants.size();
            for (int i = 0; i < n; ++i) {
                Participant particip = (Participant)participants.get(i);
                ctx.checkValidUniqueId(particip, "/Participant[" + particip.getId() + ']', pri, sec, particip.getId(), particip);
            }
        }
    }

    private void checkApplications(List applications, boolean pkgLevel, ValidationContext ctx) {
        String pri = pkgLevel ? PKG_APPLICATION : APPLICATION;
        String sec = pkgLevel ? null : PKG_APPLICATION;
        ctx.resetUniqueId(pri);
        if (applications != null) {
            int n = applications.size();
            for (int i = 0; i < n; ++i) {
                Application app = (Application)applications.get(i);
                ctx.pushPrefix("Application[" + app.getId() + ']');
                ctx.checkValidUniqueId(app, null, pri, sec, app.getId(), app);
                this.checkFormalParameters(app.getFormalParameters(), false, ctx);
                ctx.popPrefix();
            }
        }
    }

    private void checkFormalParameters(List parameters, boolean wfLevel, ValidationContext ctx) {
        String key = wfLevel ? WORKFLOW_FORMAL_PARAMETER : FORMAL_PARAMETER;
        ctx.resetUniqueId(key);
        if (parameters != null) {
            int n = parameters.size();
            for (int i = 0; i < n; ++i) {
                FormalParameter parm = (FormalParameter)parameters.get(i);
                ctx.checkValidUniqueId(parm, "/FormalParameter[" + parm.getId() + ']', key, parm.getId(), parm);
            }
        }
    }

    private void checkDataFields(List dataFields, boolean pkgLevel, ValidationContext ctx) {
        ctx.resetUniqueId(pkgLevel ? PKG_DATA_FIELD : DATA_FIELD);
        if (dataFields != null) {
            int n = dataFields.size();
            for (int i = 0; i < n; ++i) {
                this.checkDataField((DataField)dataFields.get(i), pkgLevel, ctx);
            }
        }
    }

    private void checkDataField(DataField dataField, boolean pkgLevel, ValidationContext ctx) {
        String pri = pkgLevel ? PKG_DATA_FIELD : DATA_FIELD;
        String sec = pkgLevel ? null : WORKFLOW_FORMAL_PARAMETER;
        String tert = pkgLevel ? null : PKG_DATA_FIELD;
        String dataFieldId = dataField.getId();
        ctx.pushPrefix("DataField[" + dataFieldId + ']');
        ctx.checkValidUniqueId(dataField, null, pri, sec, tert, dataFieldId, dataField);
        DataType dataType = dataField.getDataType();
        Type type = dataType == null ? null : dataType.getType();
        ctx.checkNotNull(dataField, "/Type", type);
        if (type instanceof BasicType) {
            Logger.debug((Object)"nothing");
        } else if (type instanceof DeclaredType) {
            ctx.checkValidIdRef(dataField, "/Id", TYPE_DECLARATION, ((DeclaredType)type).getId());
        } else if (type instanceof SchemaType) {
            Logger.debug((Object)"nothing");
        } else if (type instanceof ExternalReference) {
            Logger.debug((Object)"nothing");
        } else if (type instanceof RecordType) {
            Logger.debug((Object)"nothing");
        } else if (type instanceof UnionType) {
            Logger.debug((Object)"nothing");
        } else if (type instanceof EnumerationType) {
            Logger.debug((Object)"nothing");
        } else if (type instanceof ArrayType) {
            Logger.debug((Object)"nothing");
        } else if (type instanceof ListType) {
            Logger.debug((Object)"nothing");
        }
        ctx.popPrefix();
    }

    private void checkWorkflows(ValidationContext ctx) {
        ctx.resetUniqueId(WORKFLOW_PROCESS);
        List workflowProcesses = ctx.pkg.getWorkflowProcesses();
        if (workflowProcesses != null) {
            int n = workflowProcesses.size();
            for (int i = 0; i < n; ++i) {
                this.checkWorkflow((WorkflowProcess)workflowProcesses.get(i), ctx);
            }
        }
    }

    private void checkWorkflow(WorkflowProcess workflow, ValidationContext ctx) {
        ctx.resetUniqueId(DATA_FIELD);
        ctx.resetUniqueId(WORKFLOW_FORMAL_PARAMETER);
        ctx.resetUniqueId(ACTIVITY);
        ctx.resetUniqueId(TRANSITION);
        String workflowId = workflow.getId();
        ctx.pushPrefix("Workflow[" + workflowId + ']');
        ctx.checkValidUniqueId(workflow, null, WORKFLOW_PROCESS, workflowId, workflow);
        this.checkRedefinableHeader(workflow.getRedefinableHeader(), ctx);
        this.checkFormalParameters(workflow.getFormalParameters(), true, ctx);
        this.checkDataFields(workflow.getDataFields(), false, ctx);
        this.checkParticipants(workflow.getParticipants(), false, ctx);
        this.checkApplications(workflow.getApplications(), false, ctx);
        this.checkActivitySets(workflow.getActivitySets(), ctx);
        this.checkActivities(workflow, workflow.getActivities(), ctx);
        this.checkTransitions(workflow.getTransitions(), ctx);
        ctx.popPrefix();
    }

    private void checkActivitySets(List activitySets, ValidationContext ctx) {
        ctx.resetUniqueId(ACTIVITY_SET);
        if (activitySets != null) {
            int n = activitySets.size();
            for (int i = 0; i < n; ++i) {
                this.checkActivitySet((ActivitySet)activitySets.get(i), ctx);
            }
        }
    }

    private void checkActivitySet(ActivitySet activitySet, ValidationContext ctx) {
        String id = activitySet.getId();
        ctx.pushPrefix("ActivitySet[" + id + ']');
        ctx.checkValidUniqueId(activitySet, null, ACTIVITY_SET, id, activitySet);
        this.checkActivities(activitySet, activitySet.getActivities(), ctx);
        this.checkTransitions(activitySet.getTransitions(), ctx);
        ctx.popPrefix();
    }

    private void checkActivities(Object src, List activities, ValidationContext ctx) {
        if (activities != null) {
            boolean foundStart = false;
            boolean foundExit = false;
            int n = activities.size();
            for (int i = 0; i < n; ++i) {
                Activity activity = (Activity)activities.get(i);
                this.checkActivity(activity, ctx);
                if (activity.isStartActivity()) {
                    foundStart = true;
                }
                if (!activity.isExitActivity()) continue;
                foundExit = true;
            }
            if (!foundStart) {
                ctx.addError(src, 6, new Object[]{ctx.peekPrefix()}, " must have at least one start activity (one with no afferent (inbound) transitions)");
            }
            if (!foundExit) {
                ctx.addError(src, 7, new Object[]{ctx.peekPrefix()}, " must have at least one exit activity (one with no efferent (outbound) transitions)");
            }
        }
    }

    private void checkActivity(Activity activity, ValidationContext ctx) {
        int count;
        List deadlines;
        int i;
        int n;
        Implementation impl;
        String activityId = activity.getId();
        ctx.pushPrefix("Activity[" + activityId + ']');
        ctx.checkValidUniqueId(activity, null, ACTIVITY, activityId, activity);
        String performer = activity.getPerformer();
        if (performer != null) {
            StringTokenizer strTok = new StringTokenizer(performer, ",");
            while (strTok.hasMoreTokens()) {
                ctx.checkValidIdRef(activity, "/Performer", PARTICIPANT, PKG_PARTICIPANT, strTok.nextToken());
            }
        }
        int bodyCount = 0;
        BlockActivity blk = activity.getBlockActivity();
        if (blk != null) {
            String blockId = blk.getBlockId();
            if (ctx.checkNotNull(activity, "/BlockActivity/Id", blockId) && blk.getActivitySet() == null) {
                ctx.addError(activity, 8, new Object[]{ctx.peekPrefix(), blockId}, "/BlockActivity references an undefined ActivitySet[" + blockId + ']');
            }
            ++bodyCount;
        }
        if ((impl = activity.getImplementation()) != null) {
            ctx.pushPrefix("Implementation");
            if (!(impl instanceof NoImplementation)) {
                if (impl instanceof SubFlow) {
                    SubFlow subFlow = (SubFlow)impl;
                    String subFlowId = subFlow.getId();
                    ctx.pushPrefix("SubFlow[" + subFlowId + ']');
                    if (ctx.checkNotNull(subFlow, null, subFlowId)) {
                        boolean found = false;
                        n = ctx.pkg.getWorkflowProcesses().size();
                        for (i = 0; i < n; ++i) {
                            WorkflowProcess workflow = (WorkflowProcess)ctx.pkg.getWorkflowProcesses().get(i);
                            if (!workflow.getId().equals(subFlowId)) continue;
                            this.checkActualParameters((Object)subFlow, workflow.getFormalParameters(), subFlow.getActualParameters(), ctx);
                            found = true;
                            break;
                        }
                        if (!found) {
                            ctx.addError(activity, 9, new Object[]{activityId, subFlowId}, " references an undefined WorkflowProcess[" + subFlowId + ']');
                        }
                    }
                    ctx.popPrefix();
                } else if (impl instanceof ToolSet) {
                    ToolSet toolSet = (ToolSet)impl;
                    int n2 = toolSet.getTools().size();
                    for (int j = 0; j < n2; ++j) {
                        String toolId;
                        Tool tool = (Tool)toolSet.getTools().get(j);
                        if (!ctx.checkNotNull(tool, "/Tool/Id", toolId = tool.getId())) continue;
                        ctx.pushPrefix("Tool[" + toolId + ']');
                        Application app = (Application)ctx.checkValidIdRef(tool, null, APPLICATION, PKG_APPLICATION, toolId);
                        ctx.checkNotNull(tool, "/Type", tool.getToolType());
                        if (app != null) {
                            ExternalReference extRef = app.getExternalReference();
                            if (extRef == null) {
                                this.checkActualParameters((Object)tool, app.getFormalParameters(), tool.getActualParameters(), ctx);
                            } else {
                                this.checkActualParameters((Object)tool, extRef, tool.getActualParameters(), ctx);
                            }
                        }
                        ctx.popPrefix();
                    }
                }
            }
            ++bodyCount;
            ctx.popPrefix();
        }
        if (activity.getRoute() != null) {
            if (performer != null) {
                ctx.addError(activity, 10, new Object[]{activityId}, "/Route cannot have a Performer");
            }
            ++bodyCount;
        }
        if (bodyCount != 1) {
            ctx.addError(activity, 11, new Object[]{activityId}, " must include only one of: Route, Implementation, or BlockActivity");
        }
        if ((deadlines = activity.getDeadlines()) != null) {
            Object condition;
            HashSet<String> deadlineExceptions = new HashSet<String>();
            ctx.pushPrefix("Deadline");
            int syncCount = 0;
            n = deadlines.size();
            for (i = 0; i < n; ++i) {
                Deadline deadline = (Deadline)deadlines.get(i);
                condition = deadline.getDeadlineCondition();
                ctx.checkNotNull(deadline, "/Condition", condition);
                String exceptionName = deadline.getExceptionName();
                ctx.checkNotNull(deadline, "/Exception", exceptionName);
                deadlineExceptions.add(exceptionName);
                if (deadline.getExecutionType() != ExecutionType.SYNCHRONOUS || ++syncCount != 2) continue;
                ctx.addError(activity, 12, new Object[]{activityId}, " can only have one synchronous deadline");
            }
            Map transitions = activity.getEfferentTransitions();
            if (transitions != null) {
                for (Transition transition : transitions.values()) {
                    condition = transition.getCondition();
                    if (condition != null) {
                        ConditionType type = condition.getType();
                        if (type == ConditionType.DEFAULTEXCEPTION) {
                            deadlineExceptions.clear();
                            break;
                        }
                        if (type == ConditionType.EXCEPTION) {
                            deadlineExceptions.remove(condition.getValue());
                        }
                    }
                    if (transition.getExecution() == null || deadlines.size() <= 0) continue;
                    ctx.addError(activity, 13, new Object[]{activityId, transition.getId()}, " is incompatible with Transition[" + transition.getId() + "]/ExtendedAttribute[" + "Execution" + ']');
                }
            }
            for (String exception : deadlineExceptions) {
                ctx.addError(activity, 14, new Object[]{activityId, exception}, "/ExceptionName[" + exception + "] is not handled by any efferent (outbound) transition");
            }
            ctx.popPrefix();
        }
        List restrictions = activity.getTransitionRestrictions();
        SplitJoinType splitType = null;
        boolean joinFound = false;
        boolean splitFound = false;
        boolean otherwiseFound = false;
        boolean conditionFound = false;
        boolean nonConditionFound = false;
        if (restrictions != null) {
            ctx.pushPrefix("TransitionRestriction");
            int n3 = restrictions.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Condition condition;
                Split split;
                TransitionRestriction restriction = (TransitionRestriction)restrictions.get(i2);
                Join join = restriction.getJoin();
                if (join != null) {
                    if (joinFound) {
                        ctx.addError(activity, 15, new Object[]{activityId}, " TransitionRestrictions can only contain one join.");
                    }
                    joinFound = true;
                }
                if ((split = restriction.getSplit()) == null) continue;
                if (splitFound) {
                    ctx.addError(activity, 16, new Object[]{activityId}, " TransitionRestrictions can only contain one split in OBE (XPDL permits more, but does not define the semantics).");
                }
                splitFound = true;
                splitType = split.getType();
                ctx.checkNotNull(split, "/Split/Type", splitType);
                if (splitType == SplitJoinType.XOR) {
                    ctx.pushPrefix("Split[XOR]");
                    for (Transition transition : activity.getEfferentTransitions().values()) {
                        condition = transition.getCondition();
                        ConditionType conditionType = condition == null ? null : condition.getType();
                        if (conditionType != ConditionType.OTHERWISE) continue;
                        if (otherwiseFound) {
                            ctx.addError(transition, 21, new Object[]{activityId}, " an OTHERWISE transition has already been defined");
                        }
                        otherwiseFound = true;
                    }
                    ctx.popPrefix();
                    continue;
                }
                for (Transition transition : activity.getEfferentTransitions().values()) {
                    condition = transition.getCondition();
                    ConditionType transitionType = condition == null ? null : condition.getType();
                    if (transitionType != ConditionType.OTHERWISE) continue;
                    if (otherwiseFound) {
                        ctx.addError(transition, 21, new Object[]{activityId}, " an OTHERWISE transition has already been defined");
                    }
                    otherwiseFound = true;
                }
            }
            ctx.popPrefix();
        }
        if (!joinFound && (count = activity.getAfferentTransitions().size()) > 1) {
            ctx.addError(activity, 22, new Object[]{activityId, count}, " has " + count + " afferent (inbound) transitions, and therefore requires a Join");
        }
        if (!splitFound) {
            count = 0;
            for (Transition transition : activity.getEfferentTransitions().values()) {
                ConditionType transitionType;
                Condition condition = transition.getCondition();
                ConditionType conditionType = transitionType = condition == null ? null : condition.getType();
                if (transition.getEvent() != null || transitionType != null && transitionType != ConditionType.CONDITION && transitionType != ConditionType.OTHERWISE) continue;
                ++count;
            }
            if (count > 1) {
                ctx.addError(activity, 23, new Object[]{activityId, count}, " has " + count + " regular efferent (outbound) transitions, and therefore requires a Split");
            }
        }
        if (splitType == SplitJoinType.XOR && conditionFound && !nonConditionFound && !otherwiseFound) {
            boolean fullBlocked;
            ConformanceClass conformanceClass = activity.getWorkflowProcess().getPackage().getConformanceClass();
            boolean bl = fullBlocked = conformanceClass != null && conformanceClass.getGraphConformance() == GraphConformance.FULL_BLOCKED;
            if (fullBlocked) {
                ctx.addError(activity, 34, new Object[]{activityId}, " is in a FULL_BLOCKED WorkflowProcess and has an XOR-Split, and therefore requires an OTHERWISE or unconditional transition.");
            }
        }
        ctx.popPrefix();
    }

    private void checkActualParameters(Object src, ExternalReference extRef, List actualParms, ValidationContext ctx) {
    }

    private void checkActualParameters(Object src, List formalParms, List actualParms, ValidationContext ctx) {
        int apCount;
        int fpCount = formalParms == null ? 0 : formalParms.size();
        boolean ok = ctx.checkEQ(src, " formal and actual parameter counts differ", "FormalParameters", fpCount, apCount = actualParms == null ? 0 : actualParms.size());
        if (ok) {
            block4: for (int i = 0; i < fpCount; ++i) {
                FormalParameter fp = (FormalParameter)formalParms.get(i);
                ActualParameter ap = (ActualParameter)actualParms.get(i);
                int pmode = fp.getMode() != null ? fp.getMode().getValue() : 0;
                switch (pmode) {
                    case 0: {
                        continue block4;
                    }
                    case 1: 
                    case 2: {
                        String apName = ap.getText();
                        String prefix = "/ActualParameter[" + fp.getId() + ']';
                        Object ref = ctx.checkValidIdRef(src, prefix, DATA_FIELD, WORKFLOW_FORMAL_PARAMETER, PKG_DATA_FIELD, apName);
                        if (ref == null) continue block4;
                        DataType dt = null;
                        if (ref instanceof FormalParameter) {
                            dt = ((FormalParameter)ref).getDataType();
                        } else if (ref instanceof DataField) {
                            dt = ((DataField)ref).getDataType();
                        }
                        if (dt != null) continue block4;
                        fp.getIndex();
                        ctx.addError(src, 26, new Object[]{String.valueOf(i), apName}, "Unable to determine DataType for ActualParameter[" + i + "]: " + apName);
                        continue block4;
                    }
                }
            }
        }
    }

    private void checkTransitions(List transitions, ValidationContext ctx) {
        if (transitions != null) {
            int n = transitions.size();
            for (int i = 0; i < n; ++i) {
                this.checkTransition((Transition)transitions.get(i), ctx);
            }
        }
    }

    private void checkTransition(Transition transition, ValidationContext ctx) {
        String transitionId = transition.getId();
        ctx.pushPrefix("Transition[" + transitionId + ']');
        ctx.checkValidUniqueId(transition, null, TRANSITION, transitionId, transition);
        if (transition.getFromActivity() == null) {
            String fromId = transition.getFrom();
            ctx.addError(transition, 24, new Object[]{transitionId, fromId}, "/From references an undefined Activity[" + fromId + ']');
        }
        if (transition.getToActivity() == null) {
            String toId = transition.getTo();
            ctx.addError(transition, 25, new Object[]{transitionId, toId}, "/To references an undefined Activity[" + toId + ']');
        }
        ctx.popPrefix();
    }

    static {
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            String country = locales[i].getCountry();
            if (country.length() <= 0) continue;
            _countryCodes.add(country);
        }
        for (int i = 0; i < DEFAULTS.length; ++i) {
            String[] entry = DEFAULTS[i];
            _defaultProps.setProperty(entry[0], entry[1]);
        }
    }

    private static class ValidationContext {
        private XpdlPackage pkg;
        private Stack _prefixes = new Stack();
        private Map _uniqueIds = new HashMap();
        private String _prefix;
        private List _errors;
        private List _warnings;

        ValidationContext(XpdlPackage pkg) {
            this.pkg = pkg;
        }

        void popPrefix() {
            this._prefixes.pop();
            this.generatePrefix();
        }

        String peekPrefix() {
            return (String)this._prefixes.peek();
        }

        void pushPrefix(String prefix) {
            this._prefixes.push(prefix);
            this.generatePrefix();
        }

        private void generatePrefix() {
            StringBuffer sb = new StringBuffer();
            Iterator i = this._prefixes.iterator();
            while (i.hasNext()) {
                sb.append('/');
                sb.append(i.next());
            }
            this._prefix = sb.toString();
        }

        void checkValidUniqueId(Object src, String prefix, String priKey, String id, Object obj) {
            this.checkValidUniqueId(src, prefix, priKey, null, null, id, obj);
        }

        void checkValidUniqueId(Object src, String prefix, String priKey, String secKey, String id, Object obj) {
            this.checkValidUniqueId(src, prefix, priKey, secKey, null, id, obj);
        }

        void checkValidUniqueId(Object src, String prefix, String priKey, String secKey, String tertKey, String id, Object obj) {
            String owner;
            String string = owner = prefix != null ? prefix : this.peekPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if (id == null || id.trim().length() == 0) {
                this.addError(src, 0, new Object[]{owner}, prefix + "/Id must be specified");
            } else {
                Map uniqueIds;
                boolean exists;
                if (!this.isValidNMToken(id)) {
                    this.addError(src, 28, new Object[]{owner}, prefix + "/Id is not a valid NMTOKEN");
                }
                if (!(exists = (uniqueIds = this.getUniqueIds(priKey)).containsKey(id)) && secKey != null) {
                    exists = this.getUniqueIds(secKey).containsKey(id);
                }
                if (!exists && tertKey != null) {
                    exists = this.getUniqueIds(tertKey).containsKey(id);
                }
                if (exists) {
                    this.addError(src, 1, new Object[]{owner}, prefix + " is already defined. Remove the duplicate entity or assign it a unique ID.");
                } else {
                    uniqueIds.put(id, obj);
                }
            }
        }

        private boolean isValidNMToken(String id) {
            boolean valid = true;
            int n = id.length();
            for (int i = 0; i < n; ++i) {
                char c = id.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_') continue;
                valid = false;
                break;
            }
            return valid;
        }

        Object checkValidIdRef(Object src, String prefix, String primaryKey, String refId) {
            return this.checkValidIdRef(src, prefix, primaryKey, null, null, refId);
        }

        Object checkValidIdRef(Object src, String prefix, String primaryKey, String secondaryKey, String refId) {
            return this.checkValidIdRef(src, prefix, primaryKey, secondaryKey, null, refId);
        }

        Object checkValidIdRef(Object src, String prefix, String primaryKey, String secondaryKey, String tertiaryKey, String refId) {
            Object obj;
            String owner;
            String string = owner = prefix != null ? prefix : this.peekPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if ((obj = this.getUniqueIds(primaryKey).get(refId)) == null && secondaryKey != null) {
                obj = this.getUniqueIds(secondaryKey).get(refId);
            }
            if (obj == null && tertiaryKey != null) {
                obj = this.getUniqueIds(tertiaryKey).get(refId);
            }
            if (obj == null) {
                this.addError(src, 2, new Object[]{owner, primaryKey, refId}, prefix + " references an undefined " + primaryKey + '[' + refId + ']');
            }
            return obj;
        }

        void resetUniqueId(String key) {
            this.getUniqueIds(key).clear();
        }

        boolean checkNotNull(Object src, String prefix, Object obj) {
            boolean b;
            String s;
            if (prefix == null) {
                prefix = "";
            }
            if (obj instanceof String && (s = ((String)obj).trim()).length() == 0) {
                obj = null;
            }
            boolean bl = b = obj != null;
            if (!b) {
                this.addError(src, 3, new Object[]{this.peekPrefix(), prefix}, prefix + " must be specified");
            }
            return b;
        }

        boolean checkEQ(Object src, String prefix, String property, int expected, int actual) {
            boolean b;
            if (prefix == null) {
                prefix = "";
            }
            boolean bl = b = actual == expected;
            if (!b) {
                this.addError(src, 4, new Object[]{this.peekPrefix(), property, expected, actual}, prefix + ": expected <" + expected + ">, actual <" + actual + '>');
            }
            return b;
        }

        boolean checkGE(Object src, String prefix, String property, int expected, int actual) {
            boolean b;
            if (prefix == null) {
                prefix = "";
            }
            boolean bl = b = actual >= expected;
            if (!b) {
                this.addError(src, 5, new Object[]{this.peekPrefix(), property, expected, actual}, prefix + ": expected <" + expected + ">, actual <" + actual + '>');
            }
            return b;
        }

        void addError(Object src, int msgCode, Object[] args, String msg) {
            if (this._errors == null) {
                this._errors = new ArrayList();
            }
            this._errors.add(new ValidationError(1, msgCode, args, src, this._prefix + msg));
        }

        void addWarning(Object src, int msgCode, Object[] args, String msg) {
            if (this._warnings == null) {
                this._warnings = new ArrayList();
            }
            this._warnings.add(new ValidationError(0, msgCode, args, src, this._prefix + msg));
        }

        ValidationError[] getErrors() {
            return this._errors == null ? null : this._errors.toArray(new ValidationError[this._errors.size()]);
        }

        ValidationError[] getWarnings() {
            return this._warnings == null ? null : this._warnings.toArray(new ValidationError[this._warnings.size()]);
        }

        private Map getUniqueIds(String key) {
            HashMap ids = (HashMap)this._uniqueIds.get(key);
            if (ids == null) {
                ids = new HashMap();
                this._uniqueIds.put(key, ids);
            }
            return ids;
        }
    }
}

