/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.data;

import nc.bs.logging.Logger;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.wfengine.core.AbstractWFElement;
import nc.vo.wfengine.core.data.BasicType;
import nc.vo.wfengine.core.data.DataType;
import nc.vo.wfengine.core.data.Type;

public class DataField
extends AbstractWFElement {
    static final long serialVersionUID = 8312139864854170366L;
    private DataType dataType;
    private String initialValue;
    private int length;
    private boolean isArray;

    public DataField(String id, String name, String description, DataType dataType) {
        super(id, name);
        this.setDescription(description);
        this.setDataType(dataType);
    }

    public DataField(String name, String description, BasicType dataType) {
        super("", name);
        this.setDescription(description);
        this.setDataType(new DataType(dataType));
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException("Data type cannot be null");
        }
        this.dataType = dataType;
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean flag) {
        this.isArray = flag;
    }

    public Object getValueByCol(int col) {
        if (col == 0) {
            return this.getDescription() == null ? this.getName() : this.getDescription();
        }
        if (col == 1) {
            Type type = this.getDataType().getType();
            if (type instanceof BasicType) {
                return type;
            }
            return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000333");
        }
        if (col == 2) {
            return this.initialValue == null ? "" : this.initialValue;
        }
        return "ERROR";
    }

    public void setValueByCol(int col, Object value) {
        Logger.debug((Object)"[DEBUG] setValueByCol()");
        if (col == 0) {
            this.setDescription(value.toString());
            this.setDataType(this.getDataType());
        } else if (col == 1) {
            Type type = (Type)value;
            this.setDataType(new DataType(type));
        } else if (col == 2) {
            this.setInitialValue(value.toString());
        } else {
            Logger.debug((Object)"###! ERROR !");
        }
    }

    public static int getColumnLength() {
        return 3;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean bDefault = super.equals(obj);
        boolean nameIsEqual = this.getName().equals(((AbstractWFElement)obj).getName());
        return bDefault && nameIsEqual;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object clone() {
        DataField df = null;
        df = (DataField)super.clone();
        df.setArray(this.isArray());
        df.setInitialValue(this.getInitialValue());
        df.setLength(this.getLength());
        df.setDataType((DataType)this.getDataType().clone());
        return df;
    }
}

