/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.uap.pf.refmodel;

import java.util.Map;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.itf.uap.pf.IWorkflowDefine;
import nc.ui.bd.ref.AbstractRefModel;
import nc.ui.bd.ref.busi.UserWithClassRefModel;
import nc.vo.general.rule.GeneralRuleRefModel;
import nc.vo.pub.participant.ParticipantItem;
import nc.vo.uap.pf.OrganizeUnitTypes;
import nc.vo.uap.pf.refmodel.BusiReportStruParticipantRefModel;
import nc.vo.uap.pf.refmodel.PostParticipantRefModel;
import nc.vo.uap.pf.refmodel.ResponsibilityParticipantRefModel;
import nc.vo.uap.pf.refmodel.RoleGroupParticipantRefModel;
import nc.vo.uap.pf.refmodel.RoleParticipantRefModel;
import nc.vo.uap.pf.refmodel.UserGroupParticipantRefModel;
import nc.vo.uap.pf.refmodel.VirtualRoleParticipantRefModel;
import nc.vo.uap.pf.refmodel.WfUserGroupParticipantRefModel;

public class OrganizeUnitRefModelUtil {
    private Map<String, ParticipantItem> participantMap;

    public static AbstractRefModel getRefModel(int organizeUnitType) {
        switch (organizeUnitType) {
            case 1: {
                UserWithClassRefModel model = new UserWithClassRefModel();
                model.setAuthControl(false);
                model.setUseDataPower(false);
                return model;
            }
            case 6: {
                return new UserGroupParticipantRefModel();
            }
            case 2: {
                RoleParticipantRefModel roleModel = new RoleParticipantRefModel();
                roleModel.setUseDataPower(false);
                return roleModel;
            }
            case 7: {
                return new RoleGroupParticipantRefModel();
            }
            case 3: {
                return new PostParticipantRefModel();
            }
            case 9: {
                return new BusiReportStruParticipantRefModel();
            }
            case 11: {
                return new ResponsibilityParticipantRefModel();
            }
            case 5: {
                return new WfUserGroupParticipantRefModel();
            }
            case 10: {
                return new VirtualRoleParticipantRefModel();
            }
            case 13: {
                return new GeneralRuleRefModel(null);
            }
        }
        return null;
    }

    public static AbstractRefModel getRefModel(String type) {
        try {
            int typeInt = OrganizeUnitTypes.fetchTypeByTag((String)type).getValue();
            return OrganizeUnitRefModelUtil.getRefModel(typeInt);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<String, ParticipantItem> getParticipantMap(String pk_billType) {
        if (this.participantMap == null) {
            Map<String, ParticipantItem> participants = null;
            IWorkflowDefine defSrv = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
            try {
                participants = defSrv.getCustomParticipantMap(pk_billType);
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            if (participants != null) {
                this.participantMap = participants;
            }
        }
        return this.participantMap;
    }
}

