/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowusergroup;

import java.util.HashSet;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.bs.pub.pf.ParticipantFilterContext;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.vo.ml.MultiLangUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.OrgVO;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.workflowusergroup.WFUserGroupUtil;
import nc.vo.pub.workflowusergroup.WfUserGroupResolvingException;
import nc.vo.uap.pf.IWfUserGroupResolver;

public class WfUserGroup4Superintend
implements IWfUserGroupResolver {
    private String NAME = NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Superintend-000000");

    private String[] getParameterValue(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        return WFUserGroupUtil.getParameterValueWithException(this.NAME, context.getBillEntity(), billtype, parameter, pk_org);
    }

    @Override
    public HashSet<String> queryUsers(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        long beginMills = System.currentTimeMillis();
        try {
            HashSet<String> hsUser = new HashSet<String>();
            String[] orgPks = this.getParameterValue(billtype, context, parameter, pk_org, prevParticipant);
            OrgVO[] orgvo = WFUserGroupUtil.getOrgUnitQryService().getOrgs(orgPks);
            if (orgvo == null) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4AllEmployee-000001", null, new String[]{this.NAME}));
            }
            Set<String> managers = WFUserGroupUtil.findManagersOfOrg(orgPks);
            if (ArrayUtil.isNull(managers)) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Superintend-000001", null, new String[]{MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)orgvo[0], (String)"name", null), billtype}));
            }
            hsUser.addAll(managers);
            HashSet<String> hashSet = WFUserGroupUtil.filterDisabledUsersWithException(hsUser);
            return hashSet;
        }
        catch (BusinessException e) {
            throw new BusinessExceptionAdapter(e);
        }
        finally {
            Logger.debug((Object)WFUserGroupUtil.getPerformanceLogString(this.NAME, beginMills));
        }
    }
}

