/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowusergroup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.bs.pub.pf.ParticipantFilterContext;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.pubitf.bd.accessor.GeneralAccessorFactory;
import nc.pubitf.bd.accessor.IGeneralAccessor;
import nc.vo.bd.accessor.IBDData;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.DeptVO;
import nc.vo.org.OrgVO;
import nc.vo.org.util.OrgTypeManager;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.workflowusergroup.WFUserGroupUtil;
import nc.vo.pub.workflowusergroup.WfUserGroupResolvingException;
import nc.vo.uap.pf.IWfUserGroupResolver;
import nccloud.commons.lang.StringUtils;

public class WfUserGroup4Principal
implements IWfUserGroupResolver {
    private String NAME = NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Principal-000000");

    private String[] getParameterValue(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        return WFUserGroupUtil.getParameterValueWithException(this.NAME, context.getBillEntity(), billtype, parameter, pk_org);
    }

    @Override
    public HashSet<String> queryUsers(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        long beginMills = System.currentTimeMillis();
        try {
            DeptVO[] depts;
            OrgVO[] orgs;
            HashSet<String> hsUser = new HashSet<String>();
            String[] orgPks = this.getParameterValue(billtype, context, parameter, pk_org, prevParticipant);
            ArrayList<String> principals = new ArrayList<String>();
            ArrayList<String> busiUnitPks = new ArrayList<String>();
            ArrayList<String> deptPks = new ArrayList<String>();
            for (String pk : orgPks) {
                if (OrgTypeManager.getInstance().isTypeOfByPk(pk, "BUSINESSUNIT00000000")) {
                    busiUnitPks.add(pk);
                    continue;
                }
                if (!OrgTypeManager.getInstance().isTypeOfByPk(pk, "DEPTORGTYPE000000000")) continue;
                deptPks.add(pk);
            }
            if (busiUnitPks.size() == 0 && deptPks.size() == 0) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4AllEmployee-000001", null, new String[]{this.NAME}));
            }
            if (busiUnitPks.size() > 0 && (orgs = WFUserGroupUtil.getOrgUnitQryService().getOrgs(busiUnitPks.toArray(new String[0]))) != null) {
                for (OrgVO org : orgs) {
                    if (!StringUtils.isNotEmpty((CharSequence)org.getPrincipal())) continue;
                    principals.add(org.getPrincipal());
                }
            }
            if (deptPks.size() > 0 && (depts = WFUserGroupUtil.getDeptQryService().queryDeptVOsByPks(deptPks.toArray(new String[0]))) != null) {
                for (DeptVO dept : depts) {
                    if (!StringUtils.isNotEmpty((CharSequence)dept.getPrincipal())) continue;
                    principals.add(dept.getPrincipal());
                }
            }
            if (principals.size() == 0) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4HigherUp-0000"));
            }
            Logger.debug((Object)("\u83b7\u53d6\u8d1f\u8d23\u4ebapk=" + principals.toArray(new String[0]) + "\u5bf9\u5e94\u7684\u7528\u6237"));
            Set<String> userOfPsn = WFUserGroupUtil.findUserOfPsndoc(principals.toArray(new String[0]));
            if (ArrayUtil.isNull(userOfPsn)) {
                IBDData[] principalDatas;
                ArrayList<String> principalsdatas = new ArrayList<String>();
                IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"40d39c26-a2b6-4f16-a018-45664cac1a1f");
                for (IBDData ibddate : principalDatas = acessor.getDocbyPks(principals.toArray(new String[0]))) {
                    principalsdatas.add(ibddate.getName().toString());
                }
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Employer-000007", null, principalsdatas.toArray(new String[0])));
            }
            hsUser.addAll(userOfPsn);
            HashSet<String> hashSet = WFUserGroupUtil.filterDisabledUsersWithException(hsUser);
            return hashSet;
        }
        catch (BusinessException e) {
            throw new BusinessExceptionAdapter(e);
        }
        finally {
            Logger.debug((Object)WFUserGroupUtil.getPerformanceLogString(this.NAME, beginMills));
        }
    }
}

