/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowusergroup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.bs.pub.pf.ParticipantFilterContext;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.util.OrgTypeManager;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.workflowusergroup.WFUserGroupUtil;
import nc.vo.pub.workflowusergroup.WfUserGroupResolvingException;
import nc.vo.uap.pf.IWfUserGroupResolver;

public class WfUserGroup4AllEmployee
implements IWfUserGroupResolver {
    private String NAME = NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4AllEmployee-000000");

    private String[] getParameterValue(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        return WFUserGroupUtil.getParameterValueWithException(this.NAME, context.getBillEntity(), billtype, parameter, pk_org);
    }

    @Override
    public HashSet<String> queryUsers(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        long beginMills = System.currentTimeMillis();
        try {
            HashSet<String> hsUser = new HashSet<String>();
            String[] orgPks = this.getParameterValue(billtype, context, parameter, pk_org, prevParticipant);
            ArrayList<String> busiUnitPks = new ArrayList<String>();
            ArrayList<String> deptPks = new ArrayList<String>();
            for (String pk : orgPks) {
                if (OrgTypeManager.getInstance().isTypeOfByPk(pk, "BUSINESSUNIT00000000")) {
                    busiUnitPks.add(pk);
                    continue;
                }
                if (!OrgTypeManager.getInstance().isTypeOfByPk(pk, "DEPTORGTYPE000000000")) continue;
                deptPks.add(pk);
            }
            if (busiUnitPks.size() == 0 && deptPks.size() == 0) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4AllEmployee-000001", null, new String[]{this.NAME}));
            }
            for (String pk : busiUnitPks) {
                hsUser.addAll(this.findAllEmployeeOfOrgUnitRecursive(pk));
            }
            for (String pk : deptPks) {
                hsUser.addAll(this.findAllEmployeeOfDeptRecursive(pk));
            }
            HashSet<String> hashSet = WFUserGroupUtil.filterDisabledUsersWithException(hsUser);
            return hashSet;
        }
        catch (BusinessException e) {
            throw new BusinessExceptionAdapter(e);
        }
        finally {
            Logger.debug((Object)WFUserGroupUtil.getPerformanceLogString(this.NAME, beginMills));
        }
    }

    private Set<String> findAllEmployeeOfOrgUnitRecursive(String pk_org) throws BusinessException {
        Object[] orgs;
        HashSet<String> resultSet = new HashSet<String>();
        Object[] deptvos = WFUserGroupUtil.getDeptQryService().queryAllDeptVOsByOrgID(pk_org);
        if (ArrayUtil.isNotNull((Object[])deptvos)) {
            String[] pk_depts = (String[])ArrayUtil.getFieldValues(String.class, (SuperVO[])deptvos, (String)"pk_dept");
            Set<String> userOfDepts = WFUserGroupUtil.findAllEmployeeOfDepts(pk_depts);
            resultSet.addAll(userOfDepts);
        }
        if (ArrayUtil.isNotNull((Object[])(orgs = WFUserGroupUtil.getOrgUnitQryService().getChildrenOrgs(pk_org)))) {
            for (Object org : orgs) {
                Set<String> userOfSubOrg = this.findAllEmployeeOfOrgUnitRecursive(org.getPk_org());
                resultSet.addAll(userOfSubOrg);
            }
        }
        return resultSet;
    }

    private Set<String> findAllEmployeeOfDeptRecursive(String pk_dept) throws BusinessException {
        HashSet<String> resultSet = new HashSet<String>();
        Set<String> userOfDept = WFUserGroupUtil.findAllEmployeeOfDept(pk_dept);
        resultSet.addAll(userOfDept);
        Object[] deptvos = WFUserGroupUtil.getDeptQryService().queryChildDeptVOsByDeptID(pk_dept, false);
        if (ArrayUtil.isNotNull((Object[])deptvos)) {
            for (Object deptvo : deptvos) {
                Set<String> userOfSubDept = this.findAllEmployeeOfDeptRecursive(deptvo.getPk_dept());
                resultSet.addAll(userOfSubDept);
            }
        }
        return resultSet;
    }
}

