/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowqry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pf.pub.PfHistoryMsgUtil;
import nc.itf.uap.pf.IPFWorkflowQry;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.lang.UFDateCfg;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.msg.MessageVO;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.uap.historymsg.HistorymsgVO;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.pub.WFTask;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;
import nccloud.commons.lang.StringUtils;
import nccloud.pubitf.platform.workbench.IIndividualReg;
import nccloud.riart.crossservice.pf.IPfCrossServiceHandle;
import nccloud.vo.pf.flowinstance.NCCFlowInstanceVO;

public class FlowHistoryUtil {
    public static HistorymsgVO[] convertHistorymsgVOs(String billtype, WorkflownoteVO[] noteVOs) throws BusinessException {
        HistorymsgVO[] historyVOs = null;
        if (noteVOs != null && noteVOs.length > 0) {
            String performType;
            Activity act;
            historyVOs = new HistorymsgVO[noteVOs.length];
            String[] durations = FlowHistoryUtil.getHisDurationsByWorkFlowNotes(noteVOs);
            Map<String, WorkflownoteVO> map = null;
            BasicWorkflowProcess p = PfHistoryMsgUtil.getBWFProcess(noteVOs);
            ArrayList<WorkflownoteVO> cuslist = new ArrayList<WorkflownoteVO>();
            for (WorkflownoteVO wvo : noteVOs) {
                act = PfHistoryMsgUtil.getActivity(wvo, p);
                if (!(act instanceof GenericActivityEx) || !(performType = ((GenericActivityEx)act).getOrganizeTransferType()).startsWith("CUSTOM_")) continue;
                cuslist.add(wvo);
            }
            if (cuslist != null && cuslist.size() > 0) {
                IPfCrossServiceHandle hand = (IPfCrossServiceHandle)NCLocator.getInstance().lookup(IPfCrossServiceHandle.class);
                map = hand.getCustomParticipantPK(billtype, cuslist);
            }
            for (int i = 0; i < noteVOs.length; ++i) {
                WorkflownoteVO wvo;
                boolean datecfg = UFDateCfg.isSensitiveTimeZone();
                if (!datecfg) {
                    String timeZone = InvocationInfoProxy.getInstance().getTimeZone();
                    TimeZone timeZones = TimeZone.getTimeZone(timeZone);
                    UFDateTime senddate = noteVOs[i].getSenddate();
                    UFDateTime dealdate = noteVOs[i].getDealdate();
                    if (senddate != null) {
                        noteVOs[i].setSenddate(new UFDateTime(senddate.toStdString(timeZones)));
                    }
                    if (dealdate != null) {
                        noteVOs[i].setDealdate(new UFDateTime(dealdate.toStdString(timeZones)));
                    }
                }
                historyVOs[i] = new HistorymsgVO();
                historyVOs[i].setPk_historymsg(noteVOs[i].getPk_checkflow());
                historyVOs[i].setSendman(noteVOs[i].getSenderman());
                String result = ((IIndividualReg)NCLocator.getInstance().lookup(IIndividualReg.class)).openIM(noteVOs[i].getCheckman());
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    historyVOs[i].setIsYhtUser("Y");
                } else {
                    historyVOs[i].setIsYhtUser("N");
                }
                historyVOs[i].setActivity_id(noteVOs[i].getActivityID());
                historyVOs[i].setDealmanpk(noteVOs[i].getCheckman());
                historyVOs[i].setDealman(noteVOs[i].getCheckman());
                if (map != null && !map.isEmpty() && (wvo = map.get(noteVOs[i].getPk_checkflow())) != null) {
                    historyVOs[i].setSendman(wvo.getSenderman());
                    historyVOs[i].setDealmanpk(wvo.getCheckman());
                    historyVOs[i].setDealman(wvo.getCheckman());
                }
                historyVOs[i].setSenddate(noteVOs[i].getSenddate());
                historyVOs[i].setDealdate(noteVOs[i].getDealdate());
                historyVOs[i].setChecknote(noteVOs[i].getChecknote());
                historyVOs[i].setApprovestatus_value(noteVOs[i].getApprovestatus());
                historyVOs[i].setExplain(MessageVO.getMessageNoteAfterI18N(noteVOs[i].getMessagenote()));
                historyVOs[i].setBillno(noteVOs[i].getBillno());
                historyVOs[i].setPk_wf_task(noteVOs[i].getPk_wf_task());
                historyVOs[i].setBilltype(noteVOs[i].getPk_billtype());
                BilltypeVO billtypeVO = PfDataCache.getBillType(noteVOs[i].getPk_billtype());
                historyVOs[i].setPk_task(noteVOs[i].getPk_wf_task());
                historyVOs[i].setBilltypename(billtypeVO.getBilltypename());
                historyVOs[i].setBilltypename2(billtypeVO.getBilltypename2());
                historyVOs[i].setBilltypename3(billtypeVO.getBilltypename3());
                historyVOs[i].setBilltypename4(billtypeVO.getBilltypename4());
                historyVOs[i].setBilltypename5(billtypeVO.getBilltypename5());
                historyVOs[i].setBilltypename6(billtypeVO.getBilltypename6());
                historyVOs[i].setTs(noteVOs[i].getTs());
                if (noteVOs[i].getApproveresult() != null) {
                    String approveResult = WFTask.resolveApproveResult(noteVOs[i].getApproveresult());
                    historyVOs[i].setApproveresult(approveResult);
                }
                if (noteVOs[i].getApprovestatus() != null) {
                    String status = WfTaskOrInstanceStatus.fromIntValue(noteVOs[i].getApprovestatus()).toString();
                    historyVOs[i].setApprovestatus(status == null ? "" : status.toString());
                }
                act = null;
                try {
                    if (p != null) {
                        act = PfHistoryMsgUtil.getActivity(noteVOs[i], p);
                    }
                    if (act == null) {
                        p = PfHistoryMsgUtil.getBWFProcess(new WorkflownoteVO[]{noteVOs[i]});
                        act = PfHistoryMsgUtil.getActivity(noteVOs[i], p);
                    }
                    if (act instanceof GenericActivityEx) {
                        performType = ((GenericActivityEx)act).getOrganizeTransferType();
                        String performTypeName = PfHistoryMsgUtil.getPerformerTypeName(billtype, performType);
                        historyVOs[i].setActortype(performTypeName);
                        historyVOs[i].setActor(PfHistoryMsgUtil.getPerformerName2(p, act, billtype));
                        historyVOs[i].setApprovelink("".equals(act.getMultiLangName().toString()) ? act.getMultiLangName().getText() : act.getMultiLangName().toString());
                        historyVOs[i].setActivity_content(act);
                    }
                    if (StringUtils.isBlank((CharSequence)historyVOs[i].getActor()) || StringUtils.isBlank((CharSequence)historyVOs[i].getApprovelink())) {
                        String performTypeName = PfHistoryMsgUtil.getPerformerTypeName(billtype, noteVOs[i].getActortype());
                        historyVOs[i].setActortype(performTypeName);
                        String performpk_ptype = noteVOs[i].getActor();
                        if (performpk_ptype.endsWith("CUSTOMRULE")) {
                            historyVOs[i].setActor(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WFCustomzdygs-0001"));
                        } else {
                            String[] performpk_ptypes = performpk_ptype.split(",");
                            String performpk = performpk_ptypes[0];
                            String ptype = performpk_ptypes[1];
                            String actorStr = PfHistoryMsgUtil.getPerformerName3(performpk, ptype, billtype);
                            historyVOs[i].setActor(actorStr);
                        }
                        String approvelinkname = noteVOs[i].getApprovelinkname();
                        historyVOs[i].setApprovelink(approvelinkname);
                    }
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
                historyVOs[i].setDuration(durations[i]);
            }
        }
        return historyVOs;
    }

    public static HistorymsgVO[] convertHistorymsgVOsForApproveDetail(String billtype, WorkflownoteVO[] noteVOs) throws BusinessException {
        HistorymsgVO[] historyVOs = null;
        if (noteVOs != null && noteVOs.length > 0) {
            historyVOs = new HistorymsgVO[noteVOs.length];
            String[] durations = FlowHistoryUtil.getHisDurationsByWorkFlowNotes(noteVOs);
            Map<String, WorkflownoteVO> map = null;
            BasicWorkflowProcess p = PfHistoryMsgUtil.getBWFProcess(noteVOs);
            ArrayList<WorkflownoteVO> cuslist = new ArrayList<WorkflownoteVO>();
            for (WorkflownoteVO wvo : noteVOs) {
                String performType;
                Activity act = PfHistoryMsgUtil.getActivity(wvo, p);
                if (!(act instanceof GenericActivityEx) || !(performType = ((GenericActivityEx)act).getOrganizeTransferType()).startsWith("CUSTOM_")) continue;
                cuslist.add(wvo);
            }
            if (cuslist != null && cuslist.size() > 0) {
                IPfCrossServiceHandle hand = (IPfCrossServiceHandle)NCLocator.getInstance().lookup(IPfCrossServiceHandle.class);
                map = hand.getCustomParticipantPK(billtype, cuslist);
            }
            for (int i = 0; i < noteVOs.length; ++i) {
                WorkflownoteVO wvo;
                historyVOs[i] = new HistorymsgVO();
                historyVOs[i].setPk_historymsg(noteVOs[i].getPk_checkflow());
                historyVOs[i].setSendman(noteVOs[i].getSenderman());
                String result = ((IIndividualReg)NCLocator.getInstance().lookup(IIndividualReg.class)).openIM(noteVOs[i].getCheckman());
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    historyVOs[i].setIsYhtUser("Y");
                } else {
                    historyVOs[i].setIsYhtUser("N");
                }
                historyVOs[i].setActivity_id(noteVOs[i].getActivityID());
                historyVOs[i].setDealmanpk(noteVOs[i].getCheckman());
                historyVOs[i].setDealman(noteVOs[i].getCheckman());
                if (map != null && !map.isEmpty() && (wvo = map.get(noteVOs[i].getPk_checkflow())) != null) {
                    historyVOs[i].setSendman(wvo.getSenderman());
                    historyVOs[i].setDealmanpk(wvo.getCheckman());
                    historyVOs[i].setDealman(wvo.getCheckman());
                }
                historyVOs[i].setSenddate(noteVOs[i].getSenddate());
                historyVOs[i].setDealdate(noteVOs[i].getDealdate());
                historyVOs[i].setChecknote(noteVOs[i].getChecknote());
                historyVOs[i].setApprovestatus_value(noteVOs[i].getApprovestatus());
                historyVOs[i].setExplain(MessageVO.getMessageNoteAfterI18N(noteVOs[i].getMessagenote()));
                historyVOs[i].setBillno(noteVOs[i].getBillno());
                historyVOs[i].setPk_wf_task(noteVOs[i].getPk_wf_task());
                historyVOs[i].setBilltype(noteVOs[i].getPk_billtype());
                BilltypeVO billtypeVO = PfDataCache.getBillType(noteVOs[i].getPk_billtype());
                historyVOs[i].setPk_task(noteVOs[i].getPk_wf_task());
                historyVOs[i].setBilltypename(billtypeVO.getBilltypename());
                historyVOs[i].setBilltypename2(billtypeVO.getBilltypename2());
                historyVOs[i].setBilltypename3(billtypeVO.getBilltypename3());
                historyVOs[i].setBilltypename4(billtypeVO.getBilltypename4());
                historyVOs[i].setBilltypename5(billtypeVO.getBilltypename5());
                historyVOs[i].setBilltypename6(billtypeVO.getBilltypename6());
                historyVOs[i].setTs(noteVOs[i].getTs());
                if (noteVOs[i].getApproveresult() != null) {
                    String approveResult = WFTask.resolveApproveResult(noteVOs[i].getApproveresult());
                    historyVOs[i].setApproveresult(approveResult);
                }
                if (noteVOs[i].getApprovestatus() != null) {
                    String status = WfTaskOrInstanceStatus.fromIntValue(noteVOs[i].getApprovestatus()).toString();
                    historyVOs[i].setApprovestatus(status == null ? "" : status.toString());
                }
                Activity act = null;
                try {
                    if (p != null) {
                        act = PfHistoryMsgUtil.getActivity(noteVOs[i], p);
                    }
                    if (act == null) {
                        p = PfHistoryMsgUtil.getBWFProcess(new WorkflownoteVO[]{noteVOs[i]});
                        act = PfHistoryMsgUtil.getActivity(noteVOs[i], p);
                    }
                    if (act instanceof GenericActivityEx) {
                        String performType = ((GenericActivityEx)act).getOrganizeTransferType();
                        String performTypeName = PfHistoryMsgUtil.getPerformerTypeName(billtype, performType);
                        historyVOs[i].setActortype(performTypeName);
                        historyVOs[i].setActor(PfHistoryMsgUtil.getPerformerName2(p, act, billtype));
                        historyVOs[i].setApprovelink("".equals(act.getMultiLangName().toString()) ? act.getMultiLangName().getText() : act.getMultiLangName().toString());
                        historyVOs[i].setActivity_content(act);
                    }
                    if (StringUtils.isBlank((CharSequence)historyVOs[i].getActor()) || StringUtils.isBlank((CharSequence)historyVOs[i].getApprovelink())) {
                        String performTypeName = PfHistoryMsgUtil.getPerformerTypeName(billtype, noteVOs[i].getActortype());
                        historyVOs[i].setActortype(performTypeName);
                        String performpk_ptype = noteVOs[i].getActor();
                        if (performpk_ptype.endsWith("CUSTOMRULE")) {
                            historyVOs[i].setActor(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WFCustomzdygs-0001"));
                        } else {
                            String[] performpk_ptypes = performpk_ptype.split(",");
                            String performpk = performpk_ptypes[0];
                            String ptype = performpk_ptypes[1];
                            String actorStr = PfHistoryMsgUtil.getPerformerName3(performpk, ptype, billtype);
                            historyVOs[i].setActor(actorStr);
                        }
                        String approvelinkname = noteVOs[i].getApprovelinkname();
                        historyVOs[i].setApprovelink(approvelinkname);
                    }
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
                historyVOs[i].setDuration(durations[i]);
            }
        }
        return historyVOs;
    }

    public static HistorymsgVO[] convertHistorymsgVOs4NCC(String billtype, WorkflownoteVO[] noteVOs) throws BusinessException {
        HistorymsgVO[] historyVOs = null;
        if (noteVOs != null && noteVOs.length > 0) {
            historyVOs = new HistorymsgVO[noteVOs.length];
            String[] durations = FlowHistoryUtil.getHisDurationsByWorkFlowNotes(noteVOs);
            BasicWorkflowProcess p = PfHistoryMsgUtil.getBWFProcess(noteVOs);
            for (int i = 0; i < noteVOs.length; ++i) {
                historyVOs[i] = new HistorymsgVO();
                historyVOs[i].setPk_historymsg(noteVOs[i].getPk_checkflow());
                historyVOs[i].setSendman(noteVOs[i].getSenderman());
                historyVOs[i].setSenddate(noteVOs[i].getSenddate());
                historyVOs[i].setDealman(noteVOs[i].getCheckman());
                historyVOs[i].setDealdate(noteVOs[i].getDealdate());
                historyVOs[i].setChecknote(noteVOs[i].getChecknote());
                historyVOs[i].setApprovestatus_value(noteVOs[i].getApprovestatus());
                historyVOs[i].setExplain(MessageVO.getMessageNoteAfterI18N(noteVOs[i].getMessagenote()));
                historyVOs[i].setBillno(noteVOs[i].getBillno());
                historyVOs[i].setBilltype(noteVOs[i].getPk_billtype());
                BilltypeVO billtypeVO = PfDataCache.getBillType(noteVOs[i].getPk_billtype());
                historyVOs[i].setPk_task(noteVOs[i].getPk_wf_task());
                historyVOs[i].setBilltypename(billtypeVO.getBilltypename());
                historyVOs[i].setBilltypename2(billtypeVO.getBilltypename2());
                historyVOs[i].setBilltypename3(billtypeVO.getBilltypename3());
                historyVOs[i].setBilltypename4(billtypeVO.getBilltypename4());
                historyVOs[i].setBilltypename5(billtypeVO.getBilltypename5());
                historyVOs[i].setBilltypename6(billtypeVO.getBilltypename6());
                if (noteVOs[i].getApproveresult() != null) {
                    String approveResult = WFTask.resolveApproveResult(noteVOs[i].getApproveresult());
                    historyVOs[i].setApproveresult(approveResult);
                }
                if (noteVOs[i].getApprovestatus() != null) {
                    String status = WfTaskOrInstanceStatus.fromIntValue(noteVOs[i].getApprovestatus()).toString();
                    historyVOs[i].setApprovestatus(status == null ? "" : status.toString());
                }
                Activity act = null;
                try {
                    if (p != null) {
                        act = PfHistoryMsgUtil.getActivity(noteVOs[i], p);
                    }
                    if (act instanceof GenericActivityEx) {
                        String performType = ((GenericActivityEx)act).getOrganizeTransferType();
                        String performTypeName = PfHistoryMsgUtil.getPerformerTypeName(billtype, performType);
                        historyVOs[i].setActortype(performTypeName);
                        historyVOs[i].setApprovelink("".equals(act.getMultiLangName().toString()) ? act.getMultiLangName().getText() : act.getMultiLangName().toString());
                    }
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
                historyVOs[i].setDuration(durations[i]);
            }
        }
        return historyVOs;
    }

    public static Map<String, String> getLinksName(WorkflownoteVO[] noteVOs) {
        HashMap<String, String> linksName = new HashMap<String, String>(noteVOs.length);
        BasicWorkflowProcess p = PfHistoryMsgUtil.getBWFProcess(noteVOs);
        Activity act = null;
        for (WorkflownoteVO noteVO : noteVOs) {
            try {
                if (p != null) {
                    act = PfHistoryMsgUtil.getActivity(noteVO, p);
                }
                if (act == null) {
                    p = PfHistoryMsgUtil.getBWFProcess(new WorkflownoteVO[]{noteVO});
                    act = PfHistoryMsgUtil.getActivity(noteVO, p);
                }
                if (act == null) {
                    linksName.put(noteVO.getPk_checkflow(), noteVO.getApprovelinkname());
                }
                if (!(act instanceof GenericActivityEx)) continue;
                linksName.put(noteVO.getPk_checkflow(), "".equals(act.getMultiLangName().toString()) ? act.getMultiLangName().getText() : act.getMultiLangName().toString());
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return linksName;
    }

    public static Map<String, String> getLinkActId(WorkflownoteVO[] noteVOs) {
        HashMap<String, String> linksActID = new HashMap<String, String>(noteVOs.length);
        BasicWorkflowProcess p = PfHistoryMsgUtil.getBWFProcess(noteVOs);
        Activity act = null;
        for (WorkflownoteVO noteVO : noteVOs) {
            try {
                if (p != null) {
                    act = PfHistoryMsgUtil.getActivity(noteVO, p);
                }
                if (act == null) {
                    p = PfHistoryMsgUtil.getBWFProcess(new WorkflownoteVO[]{noteVO});
                    act = PfHistoryMsgUtil.getActivity(noteVO, p);
                }
                if (!(act instanceof GenericActivityEx)) continue;
                linksActID.put(noteVO.getPk_checkflow(), act.getId());
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return linksActID;
    }

    public static String[] getHisDurationsByWorkFlowNotes(WorkflownoteVO[] noteVOs) throws BusinessException {
        String[] pk_orgs = new String[noteVOs.length];
        UFDateTime[] beginTimes = new UFDateTime[noteVOs.length];
        String timeZone = InvocationInfoProxy.getInstance().getTimeZone();
        UFDateTime[] endTimes = new UFDateTime[noteVOs.length];
        if (StringUtils.isBlank((CharSequence)timeZone)) {
            for (int i = 0; i < noteVOs.length; ++i) {
                pk_orgs[i] = noteVOs[i].getPk_org();
                beginTimes[i] = noteVOs[i].getSenddate() != null ? noteVOs[i].getSenddate() : null;
                endTimes[i] = noteVOs[i].getDealdate() != null ? noteVOs[i].getDealdate() : null;
            }
        } else {
            TimeZone timeZones = TimeZone.getTimeZone(timeZone);
            for (int i = 0; i < noteVOs.length; ++i) {
                pk_orgs[i] = noteVOs[i].getPk_org();
                beginTimes[i] = noteVOs[i].getSenddate() != null ? new UFDateTime(noteVOs[i].getSenddate().toStdString(timeZones)) : null;
                endTimes[i] = noteVOs[i].getDealdate() != null ? new UFDateTime(noteVOs[i].getDealdate().toStdString(timeZones)) : null;
            }
        }
        return ((IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class)).getElapsedTimeInWorkCalendarBatch(pk_orgs, beginTimes, endTimes);
    }

    public static HistorymsgVO[] convertHistorymsgVOs(String billtype, WorkflownoteVO[] noteVOs, NCCFlowInstanceVO instanceVO) throws BusinessException {
        HistorymsgVO[] historyVOs = null;
        if (noteVOs != null && noteVOs.length > 0) {
            historyVOs = new HistorymsgVO[noteVOs.length];
            String[] durations = FlowHistoryUtil.getHisDurationsByWorkFlowNotes(noteVOs);
            Map<String, WorkflownoteVO> map = null;
            BasicWorkflowProcess p = null;
            if (instanceVO != null) {
                try {
                    p = PfDataCache.getWorkflowProcess(instanceVO.getProcessdefid());
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                p = PfHistoryMsgUtil.getBWFProcess(noteVOs);
            }
            ArrayList<WorkflownoteVO> cuslist = new ArrayList<WorkflownoteVO>();
            for (WorkflownoteVO wvo : noteVOs) {
                String performType;
                Activity act = null;
                act = p != null && wvo.getActivityID() != null ? p.findActivityByID(wvo.getActivityID()) : PfHistoryMsgUtil.getActivity(wvo, p);
                if (!(act instanceof GenericActivityEx) || !(performType = ((GenericActivityEx)act).getOrganizeTransferType()).startsWith("CUSTOM_")) continue;
                cuslist.add(wvo);
            }
            if (cuslist != null && cuslist.size() > 0) {
                IPfCrossServiceHandle hand = (IPfCrossServiceHandle)NCLocator.getInstance().lookup(IPfCrossServiceHandle.class);
                map = hand.getCustomParticipantPK(billtype, cuslist);
            }
            for (int i = 0; i < noteVOs.length; ++i) {
                WorkflownoteVO wvo;
                historyVOs[i] = new HistorymsgVO();
                historyVOs[i].setPk_historymsg(noteVOs[i].getPk_checkflow());
                historyVOs[i].setSendman(noteVOs[i].getSenderman());
                String result = ((IIndividualReg)NCLocator.getInstance().lookup(IIndividualReg.class)).openIM(noteVOs[i].getCheckman());
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    historyVOs[i].setIsYhtUser("Y");
                } else {
                    historyVOs[i].setIsYhtUser("N");
                }
                historyVOs[i].setActivity_id(noteVOs[i].getActivityID());
                historyVOs[i].setDealmanpk(noteVOs[i].getCheckman());
                historyVOs[i].setDealman(noteVOs[i].getCheckman());
                if (map != null && !map.isEmpty() && (wvo = map.get(noteVOs[i].getPk_checkflow())) != null) {
                    historyVOs[i].setSendman(wvo.getSenderman());
                    historyVOs[i].setDealmanpk(wvo.getCheckman());
                    historyVOs[i].setDealman(wvo.getCheckman());
                }
                historyVOs[i].setSenddate(noteVOs[i].getSenddate());
                historyVOs[i].setDealdate(noteVOs[i].getDealdate());
                historyVOs[i].setChecknote(noteVOs[i].getChecknote());
                historyVOs[i].setApprovestatus_value(noteVOs[i].getApprovestatus());
                historyVOs[i].setExplain(MessageVO.getMessageNoteAfterI18N(noteVOs[i].getMessagenote()));
                historyVOs[i].setBillno(noteVOs[i].getBillno());
                historyVOs[i].setPk_wf_task(noteVOs[i].getPk_wf_task());
                historyVOs[i].setBilltype(noteVOs[i].getPk_billtype());
                BilltypeVO billtypeVO = PfDataCache.getBillTypeInfo(noteVOs[i].getPk_group(), noteVOs[i].getPk_billtype());
                historyVOs[i].setPk_task(noteVOs[i].getPk_wf_task());
                historyVOs[i].setBilltypename(billtypeVO.getBilltypename());
                historyVOs[i].setBilltypename2(billtypeVO.getBilltypename2());
                historyVOs[i].setBilltypename3(billtypeVO.getBilltypename3());
                historyVOs[i].setBilltypename4(billtypeVO.getBilltypename4());
                historyVOs[i].setBilltypename5(billtypeVO.getBilltypename5());
                historyVOs[i].setBilltypename6(billtypeVO.getBilltypename6());
                historyVOs[i].setTs(noteVOs[i].getTs());
                if (noteVOs[i].getApproveresult() != null) {
                    String approveResult = WFTask.resolveApproveResult(noteVOs[i].getApproveresult());
                    historyVOs[i].setApproveresult(approveResult);
                }
                if (noteVOs[i].getApprovestatus() != null) {
                    String status = WfTaskOrInstanceStatus.fromIntValue(noteVOs[i].getApprovestatus()).toString();
                    historyVOs[i].setApprovestatus(status == null ? "" : status.toString());
                }
                Activity act = null;
                try {
                    if (StringUtils.isNotBlank((CharSequence)noteVOs[i].getActor())) {
                        String performTypeName = PfHistoryMsgUtil.getPerformerTypeName(billtype, noteVOs[i].getActortype());
                        historyVOs[i].setActortype(performTypeName);
                        String performpk_ptype = noteVOs[i].getActor();
                        if (performpk_ptype.endsWith("CUSTOMRULE")) {
                            historyVOs[i].setActor(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WFCustomzdygs-0001"));
                        } else {
                            String[] performpk_ptypes = performpk_ptype.split(",");
                            String performpk = performpk_ptypes[0];
                            String ptype = performpk_ptypes[1];
                            historyVOs[i].setActor(PfHistoryMsgUtil.getPerformerName3(performpk, ptype, billtype));
                        }
                        String approvelinkname = noteVOs[i].getApprovelinkname();
                        historyVOs[i].setApprovelink(approvelinkname);
                    } else {
                        if (p != null) {
                            act = p.findActivityByID(noteVOs[i].getActivityID());
                        }
                        if (act == null) {
                            p = PfHistoryMsgUtil.getBWFProcess(new WorkflownoteVO[]{noteVOs[i]});
                            act = PfHistoryMsgUtil.getActivity(noteVOs[i], p);
                        }
                        if (act instanceof GenericActivityEx) {
                            String performType = ((GenericActivityEx)act).getOrganizeTransferType();
                            String performTypeName = PfHistoryMsgUtil.getPerformerTypeName(billtype, performType);
                            historyVOs[i].setActortype(performTypeName);
                            historyVOs[i].setActor(PfHistoryMsgUtil.getPerformerName2(p, act, billtype));
                            historyVOs[i].setApprovelink("".equals(act.getMultiLangName().toString()) ? act.getMultiLangName().getText() : act.getMultiLangName().toString());
                            historyVOs[i].setActivity_content(act);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
                historyVOs[i].setDuration(durations[i]);
            }
        }
        return historyVOs;
    }
}

