/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflownote;

import java.io.Serializable;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.wfengine.core.workflow.MailModal;
import nc.vo.wfengine.core.workflow.MobileModal;

public class WorkitemMsgConfigVO
implements Serializable {
    private static final long serialVersionUID = -2755937146601694766L;
    public static final int TYPE_WORKITEM = 0;
    public static final int TYPE_MAILNOTICE = 110;
    public static final int TYPE_MAILAPPROVE = 120;
    public static final int TYPE_MAIL_NONE = 130;
    public static final int TYPE_MAIL_BLANK = 140;
    public static final int TYPE_SMSNOTICE = 210;
    public static final int TYPE_SMSAPPROVE = 220;
    public static final int TYPE_SMS_NONE = 230;
    public static final int TYPE_SMS_BLANK = 240;
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_MSGTEMPCODE = "msgTempCode";
    public static final String FIELD_PUSHABLE = "pushable";
    private int type;
    private String msgTempCode;
    private Boolean pushable = null;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getMsgTempCode() {
        return this.msgTempCode;
    }

    public void setMsgTempCode(String msgTempCode) {
        this.msgTempCode = msgTempCode;
    }

    public Boolean isPushable() {
        return this.pushable;
    }

    public void setPushable(Boolean pushable) {
        this.pushable = pushable;
    }

    public static boolean isMailType(Integer type) {
        boolean isMailType = type == 120 || type == 110;
        return isMailType;
    }

    public static boolean isSMSType(Integer type) {
        boolean isSMSType = type == 220 || type == 210;
        return isSMSType;
    }

    public static WorkitemMsgConfigVO getWorkitemConfig(WorkitemMsgConfigVO[] configs) {
        if (configs == null) {
            return null;
        }
        for (WorkitemMsgConfigVO c : configs) {
            if (!WorkitemMsgConfigVO.isWorkitemConfig(c)) continue;
            return c;
        }
        return null;
    }

    public static WorkitemMsgConfigVO getMailConfig(WorkitemMsgConfigVO[] configs) {
        if (configs == null) {
            return null;
        }
        for (WorkitemMsgConfigVO c : configs) {
            if (!WorkitemMsgConfigVO.isMailConfig(c)) continue;
            return c;
        }
        return null;
    }

    public static WorkitemMsgConfigVO getMobileConfig(WorkitemMsgConfigVO[] configs) {
        if (configs == null) {
            return null;
        }
        for (WorkitemMsgConfigVO c : configs) {
            if (!WorkitemMsgConfigVO.isMobileConfig(c)) continue;
            return c;
        }
        return null;
    }

    public static boolean isWorkitemConfig(WorkitemMsgConfigVO c) {
        if (c == null) {
            return false;
        }
        return c.getType() == 0;
    }

    public static boolean isMailConfig(WorkitemMsgConfigVO c) {
        if (c == null) {
            return false;
        }
        return c.getType() == 120 || c.getType() == 110 || c.getType() == 130 || c.getType() == 140;
    }

    public static boolean isMobileConfig(WorkitemMsgConfigVO c) {
        if (c == null) {
            return false;
        }
        return c.getType() == 220 || c.getType() == 210 || c.getType() == 230 || c.getType() == 240;
    }

    public static MailModal getMailModal(WorkitemMsgConfigVO c) {
        if (c == null) {
            return MailModal.BLANK;
        }
        switch (c.getType()) {
            case 120: {
                return MailModal.MAIL_APPROVE;
            }
            case 110: {
                return MailModal.MAIL_INFO;
            }
            case 130: {
                return MailModal.NO_MAIL;
            }
            case 140: {
                return MailModal.BLANK;
            }
        }
        throw new IllegalArgumentException(c + " is not mail config");
    }

    public static MobileModal getMobileModal(WorkitemMsgConfigVO c) {
        if (c == null) {
            return MobileModal.BLANK;
        }
        switch (c.getType()) {
            case 220: {
                return MobileModal.MOBILE_APPROVE;
            }
            case 210: {
                return MobileModal.MOBILE_INFO;
            }
            case 230: {
                return MobileModal.NO_MOBILE;
            }
            case 240: {
                return MobileModal.BLANK;
            }
        }
        throw new IllegalArgumentException(c + " is not mobile config");
    }

    public static String getTypeCaption(int type) {
        switch (type) {
            case 0: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630015");
            }
            case 120: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630016");
            }
            case 110: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630017");
            }
            case 130: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630018");
            }
            case 220: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630019");
            }
            case 210: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630020");
            }
            case 230: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630018");
            }
        }
        return "";
    }
}

