/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflownote;

import nc.bs.pf.pub.cache.CondStringKey;
import nc.vo.pub.pf.MailApproveTemplateConfigVO;
import nc.vo.pub.workflownote.WorkitemMsgConfigVO;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.util.CoreUtilities;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.core.workflow.MailModal;
import nc.vo.wfengine.core.workflow.MailPrintTemplet;
import nc.vo.wfengine.core.workflow.MobileModal;

public class WorkitemMsgConfigContext {
    private BasicWorkflowProcess process;
    private GenericActivityEx activity;
    private WorkitemMsgConfigVO mailConfig = null;
    private WorkitemMsgConfigVO mobileConfig = null;
    private boolean isV63Mode = false;
    private String workitemTempCode = null;
    private Boolean workitemPushable = false;
    private MailModal mailModal = null;
    private MobileModal mobileModal = null;
    private String mailTempCode = null;
    private String mobileTempCode = null;

    public WorkitemMsgConfigContext(BasicWorkflowProcess process, GenericActivityEx activity) {
        this.process = process;
        this.activity = activity;
        this.init();
    }

    private void init() {
        WorkitemMsgConfigVO[] actConfigs = CoreUtilities.workitemMsgConfigFromXML(this.activity.getWorkitemMsgConfig());
        WorkitemMsgConfigVO[] processConfigs = CoreUtilities.workitemMsgConfigFromXML(this.process.getWorkitemMsgConfig());
        if (actConfigs != null || processConfigs != null) {
            this.isV63Mode = true;
            if (actConfigs != null) {
                for (WorkitemMsgConfigVO c : actConfigs) {
                    if (WorkitemMsgConfigVO.isWorkitemConfig(c)) {
                        this.workitemTempCode = c.getMsgTempCode();
                        this.workitemPushable = c.isPushable();
                        continue;
                    }
                    if (WorkitemMsgConfigVO.isMailConfig(c)) {
                        this.mailConfig = c;
                        continue;
                    }
                    if (!WorkitemMsgConfigVO.isMobileConfig(c)) continue;
                    this.mobileConfig = c;
                }
            }
            if (processConfigs != null) {
                for (WorkitemMsgConfigVO c : processConfigs) {
                    if (WorkitemMsgConfigVO.isWorkitemConfig(c)) {
                        if (this.workitemTempCode == null) {
                            this.workitemTempCode = c.getMsgTempCode();
                        }
                        if (this.workitemPushable != null && this.workitemPushable.booleanValue()) continue;
                        this.workitemPushable = c.isPushable();
                        continue;
                    }
                    if (WorkitemMsgConfigVO.isMailConfig(c)) {
                        if (this.mailConfig != null) continue;
                        this.mailConfig = c;
                        continue;
                    }
                    if (!WorkitemMsgConfigVO.isMobileConfig(c) || this.mobileConfig != null) continue;
                    this.mobileConfig = c;
                }
            }
            this.mailModal = WorkitemMsgConfigVO.getMailModal(this.mailConfig);
            this.mobileModal = WorkitemMsgConfigVO.getMobileModal(this.mobileConfig);
            this.mailTempCode = this.mailConfig == null ? null : this.mailConfig.getMsgTempCode();
            this.mobileTempCode = this.mobileConfig == null ? null : this.mobileConfig.getMsgTempCode();
        } else {
            this.isV63Mode = false;
            this.workitemTempCode = this.activity.getWorkitemTitle();
            this.workitemPushable = this.activity.getWorkitemPushable();
            this.mailModal = this.activity.getMailModal();
            this.mobileModal = this.activity.getMobileModal();
            if (this.mailModal == null || this.mailModal.equals(MailModal.BLANK)) {
                this.mailModal = this.process.getMailModal();
            }
            if (this.mobileModal == null || this.mobileModal.equals(MobileModal.BLANK)) {
                this.mobileModal = this.process.getMobileModal();
            }
        }
    }

    public String getWorkitemTempCode() {
        return this.workitemTempCode;
    }

    public boolean isWorkitemPushable() {
        return this.workitemPushable;
    }

    public MailModal getMailModal() {
        return this.mailModal;
    }

    public boolean isV63Mode() {
        return this.isV63Mode;
    }

    public MobileModal getMobileModal() {
        return this.mobileModal;
    }

    public String getMailTempCode() {
        return this.mailTempCode;
    }

    public String getMobileTempCode() {
        return this.mobileTempCode;
    }

    public String getV61MailApproveTemplateId() {
        MailPrintTemplet templet = this.process.getMailPrintTemplet();
        if (templet != null) {
            String templetid = templet.getTempletid();
            return templetid;
        }
        return null;
    }

    public MailApproveTemplateConfigVO getV61MailApproveTemplateConf() {
        MailPrintTemplet templet = this.process.getMailPrintTemplet();
        if (templet != null) {
            String templetid = templet.getTempletid();
            MailApproveTemplateConfigVO conf = MailApproveTemplateConfigVO.deserialize(templetid);
            return conf;
        }
        return null;
    }

    public static class CacheKey
    extends CondStringKey {
        static final String CATEGORY = CacheKey.class.getName();

        public CacheKey(String pk_wf_task) {
            super(CATEGORY, pk_wf_task);
        }
    }
}

