/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.pfworkflow;

import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.pf.Pfi18nTools;
import nc.vo.sm.funcreg.ModuleVO;

public class LocalBillTypeVO {
    public static final int NODE_BILL_TYPE = 1;
    public static final int NODE_SYSTEM_TYPE = 2;
    private String pk;
    private int iVOType;
    private String name;
    private String nodeCode;
    private String pk_group = null;
    private boolean queryed = false;
    private Object objVO = null;

    public LocalBillTypeVO(ModuleVO moduleVO) {
        this.setObjectVO(moduleVO);
        this.setVOType(2);
        if (moduleVO == null) {
            this.setName(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "LocalBillTypeVO-000000"));
        } else {
            this.setPrimaryKey(moduleVO.getSystypecode());
            this.setName(Pfi18nTools.i18nSystemtypeName(moduleVO.getResid(), moduleVO.getSystypename()));
        }
    }

    public LocalBillTypeVO(BilltypeVO billtypeVO) {
        this.setObjectVO(billtypeVO);
        this.setVOType(1);
        this.setPrimaryKey(billtypeVO.getPk_billtypecode());
        String billTypeNameRes = Pfi18nTools.i18nBilltypeNameByVO(this.getPrimaryKey(), billtypeVO);
        this.setName(billTypeNameRes);
        this.setNodeCode(billtypeVO.getNodecode());
    }

    public LocalBillTypeVO(BilltypeVO billtypeVO, String nccloud) {
        this.setObjectVO(billtypeVO);
        this.setVOType(1);
        this.setPrimaryKey(billtypeVO.getPk_billtypecode());
        String billTypeNameRes = Pfi18nTools.nccloudi18nBilltypeNameByVO(this.getPrimaryKey(), billtypeVO);
        this.setName(billTypeNameRes);
        this.setNodeCode(billtypeVO.getNodecode());
    }

    public boolean isQueryed() {
        return this.queryed;
    }

    public void setQueryed(boolean queryed) {
        this.queryed = queryed;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeCode() {
        return this.nodeCode;
    }

    public String getPrimaryKey() {
        return this.pk;
    }

    public int getVOType() {
        return this.iVOType;
    }

    private void setName(String newName) {
        this.name = newName;
    }

    public void setNodeCode(String newM_stringNodeCode) {
        this.nodeCode = newM_stringNodeCode;
    }

    private void setPrimaryKey(String newPrimaryKey) {
        this.pk = newPrimaryKey;
    }

    private void setVOType(int newType) {
        this.iVOType = newType;
    }

    public Object getObjectVO() {
        return this.objVO;
    }

    public void setObjectVO(Object obj) {
        this.objVO = obj;
    }

    public String toString() {
        if (this.getVOType() == 1) {
            return this.getPrimaryKey() + " " + this.getName();
        }
        if (this.getVOType() == 2) {
            return this.getName();
        }
        return "ERROR!";
    }

    public void setPk_group(String pk_group) {
        this.pk_group = pk_group;
    }

    public String getPk_group() {
        return this.pk_group;
    }
}

