/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.pf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.itf.uap.pf.IPFTemplate;
import nc.itf.uap.print.IPrintTemplateQry;
import nc.vo.cache.ext.ICacheVersionMonitor;
import nc.vo.cache.ext.TableVersionMonitor;
import nc.vo.cache.ext.VersionSensitiveMap;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.pftemplate.SystemplateVO;
import nc.vo.pub.print.PrintTemplateVO;

public class MailApproveTemplateCache {
    private static MailApproveTemplateCache instance = null;
    private Map<String, Map<String, PrintTemplateVO>> billTempMap = null;

    public static synchronized MailApproveTemplateCache getInstance() {
        if (instance == null) {
            instance = new MailApproveTemplateCache();
        }
        return instance;
    }

    protected Map<String, Map<String, PrintTemplateVO>> getBillTempMap() {
        if (this.billTempMap == null) {
            this.billTempMap = new VersionSensitiveMap(new HashMap(), (ICacheVersionMonitor)new TableVersionMonitor(new String[]{"pub_print_template", "pub_systemplate"}, 60000L));
        }
        return this.billTempMap;
    }

    public void clear() {
        this.getBillTempMap().clear();
    }

    public Map<String, PrintTemplateVO> getTemplates(String billtype) {
        Map<String, PrintTemplateVO> map = this.getBillTempMap().get(billtype);
        if (map == null) {
            map = this.queryTemplates(billtype);
            this.getBillTempMap().put(billtype, map);
        }
        return map;
    }

    private Map<String, PrintTemplateVO> queryTemplates(String billtype) {
        HashMap<String, PrintTemplateVO> map = new HashMap<String, PrintTemplateVO>();
        BilltypeVO bt = PfDataCache.getBillType(billtype);
        String nodecode = bt.getNodecode();
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        try {
            List sysvoList = ((IPFTemplate)NCLocator.getInstance().lookup(IPFTemplate.class)).getSystemplatesBy(nodecode, pk_group);
            ArrayList<String> pkList = new ArrayList<String>();
            for (SystemplateVO svo : sysvoList) {
                if (svo.getTempstyle() != 3) continue;
                pkList.add(svo.getTemplateid());
            }
            IPrintTemplateQry qry = (IPrintTemplateQry)NCLocator.getInstance().lookup(IPrintTemplateQry.class);
            Object[] pvos = qry.getTemplateBySysTemplateIDs(pkList.toArray(new String[0]), pk_group);
            if (!ArrayUtil.isNull((Object[])pvos)) {
                for (Object pvo : pvos) {
                    map.put(pvo.getCtemplateid(), (PrintTemplateVO)pvo);
                }
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }
}

