/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.busilog;

import nc.bs.busilog.vo.BusinessLogContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.pub.BusitypeVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.busilog.PFBusiLogUtil;
import nc.vo.pub.busilog.operation.PFOperaEnum;
import nc.vo.pub.pf.Pfi18nTools;

public class BusiTypeBusiLogUtil {
    public static void writeBaseLog(BusitypeVO busiTypeVO, PFOperaEnum operation) throws BusinessException {
        BusinessLogContext context = BusiTypeBusiLogUtil.buildLogContext(busiTypeVO, operation);
        String logMsg = BusiTypeBusiLogUtil.buildBaseOperaMsg(busiTypeVO, operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    private static BusinessLogContext buildLogContext(BusitypeVO busiTypeVO, PFOperaEnum operation) {
        BusinessLogContext context = PFBusiLogUtil.createPFBusinessLogContext();
        context.setPk_busiobj(busiTypeVO.getPrimaryKey());
        context.setBusiobjcode(busiTypeVO.getBusicode());
        context.setBusiobjname(Pfi18nTools.i18nBusiTypeName(busiTypeVO));
        context.setTypepk_busiobj("7717f1a3-b777-454e-abb5-ef8705a0f0c2");
        context.setBusiobjvo((Object)busiTypeVO);
        context.setPk_operation(BusiTypeBusiLogUtil.getPkOperationByEnum(operation));
        return context;
    }

    private static String buildBaseOperaMsg(BusitypeVO busiTypeVO, PFOperaEnum operation) {
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(operation.toString()).append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000007"));
        sbMsg.append("[").append(Pfi18nTools.i18nBusiTypeName(busiTypeVO)).append("],");
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000008")).append("[").append(busiTypeVO.getVersion()).append("]");
        return sbMsg.toString();
    }

    private static String getPkOperationByEnum(PFOperaEnum operation) {
        if (PFOperaEnum.Add.equals(operation)) {
            return "62ff4555-7e3a-4b95-89f9-331928852cc2";
        }
        if (PFOperaEnum.Edit.equals(operation)) {
            return "98a87ccb-ee98-4c9b-898a-7e05ca4db116";
        }
        if (PFOperaEnum.Delete.equals(operation)) {
            return "8146e790-21f1-4333-8632-c8c8e285ba6a";
        }
        if (PFOperaEnum.Enable.equals(operation)) {
            return "52af4d73-aad8-4429-a2d1-08c7aad36603";
        }
        if (PFOperaEnum.Disable.equals(operation)) {
            return "619dd42a-7cab-4c14-a7f3-28204fb0f04e";
        }
        return null;
    }
}

