/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.busilog;

import nc.bs.busilog.vo.BusinessLogContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.busilog.PFBusiLogUtil;
import nc.vo.pub.busilog.operation.BillTypeOperaEnum;
import nc.vo.pub.busilog.operation.PFOperaEnum;
import nc.vo.pub.pf.Pfi18nTools;

public class BillTypeBusiLogUtil {
    public static void writePublishLog(BilltypeVO btVO, String nodeCode) throws BusinessException {
        BillTypeOperaEnum operation = BillTypeOperaEnum.Publish;
        BusinessLogContext context = BillTypeBusiLogUtil.buildLogContext(btVO, operation);
        String logMsg = BillTypeBusiLogUtil.buildPublishMsg(btVO, nodeCode, operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    public static void writeBaseLog(BilltypeVO btVO, PFOperaEnum operation) throws BusinessException {
        BusinessLogContext context = BillTypeBusiLogUtil.buildLogContext(btVO, operation);
        String logMsg = BillTypeBusiLogUtil.buildBaseOperaMsg(btVO, operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    private static BusinessLogContext buildLogContext(BilltypeVO btVO, PFOperaEnum operation) {
        BusinessLogContext context = PFBusiLogUtil.createPFBusinessLogContext();
        context.setPk_busiobj(btVO.getPk_billtypeid());
        context.setBusiobjcode(btVO.getPk_billtypecode());
        context.setBusiobjname(Pfi18nTools.i18nBilltypeNameByVO(btVO.getPk_billtypecode(), btVO));
        context.setTypepk_busiobj("b0fa41cd-a649-4309-b685-d341a5d1b0ed");
        context.setBusiobjvo((Object)btVO);
        context.setPk_operation(BillTypeBusiLogUtil.getPkOperationByEnum(operation));
        return context;
    }

    private static String buildPublishMsg(BilltypeVO btVO, String nodeCode, BillTypeOperaEnum operation) {
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BillTypeBusiLogUtil-000000")).append("[").append(Pfi18nTools.i18nBilltypeNameByVO(btVO.getPk_billtypecode(), btVO)).append("]");
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BillTypeBusiLogUtil-000001")).append(",").append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BillTypeBusiLogUtil-000002")).append("[").append(nodeCode).append("]");
        return sbMsg.toString();
    }

    private static String buildBaseOperaMsg(BilltypeVO btVO, PFOperaEnum operation) {
        StringBuffer sbMsg = new StringBuffer();
        if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BillTypeBusiLogUtil-000003")).append(":[").append(btVO.getBilltypenameOfCurrLang()).append("]");
            sbMsg.append(operation.toString()).append(" ");
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BillTypeBusiLogUtil-000000"));
        } else {
            sbMsg.append(operation.toString()).append(" ");
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BillTypeBusiLogUtil-000003"));
        }
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BillTypeBusiLogUtil-000006")).append("[").append(btVO.getPk_billtypecode()).append("],").append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BillTypeBusiLogUtil-000005")).append("[").append(Pfi18nTools.i18nBilltypeNameByVO(btVO.getPk_billtypecode(), btVO)).append("]");
        return sbMsg.toString();
    }

    private static String getPkOperationByEnum(PFOperaEnum operation) {
        if (PFOperaEnum.Add.equals(operation)) {
            return "c8d4bd6b-e38f-4c16-bd07-c9ce54b5ce5c";
        }
        if (PFOperaEnum.Edit.equals(operation)) {
            return "7188106a-5c7e-4b16-a71c-253b6ac8250c";
        }
        if (PFOperaEnum.Delete.equals(operation)) {
            return "b5ef6eeb-0089-4e6d-ab7f-f5258057630b";
        }
        if (BillTypeOperaEnum.Publish.equals(operation)) {
            return "c457733b-c36f-4961-84dc-d1f5cf211574";
        }
        return null;
    }
}

