/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.pub.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.logging.Logger;
import nc.bs.mw.sqltrans.TempTable;
import nc.bs.sec.esapi.NCESAPI;
import nc.jdbc.framework.ConnectionFactory;
import nc.jdbc.framework.DataSourceCenter;
import nc.jdbc.framework.JdbcSession;
import nc.jdbc.framework.PersistenceManager;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.crossdb.CrossDBConnection;
import nc.jdbc.framework.exception.DbException;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nccloud.commons.lang.StringUtils;

public class SqlUtilTempTable {
    public static final int MAXLENGTH = 200;
    public static final int INMAXLIMITCOUNT = 800;
    public static final int TMPMAXCOUNT = 20000;
    public static String tempTableName = "riawf_tmp_table";
    public static String tempcolname = "pk";
    public static String tempcoltype = "varchar(60)";

    public static String buildInSql(String fieldName, String[] values, int listMax) throws BusinessException {
        return SqlUtilTempTable.buildInSql(fieldName, Arrays.asList(values), true);
    }

    public static String buildInSql(String fieldName, String[] values) throws BusinessException {
        return SqlUtilTempTable.buildInSql(fieldName, Arrays.asList(values), true);
    }

    public static String buildInSql(String fieldName, Collection<String> values) throws BusinessException {
        return SqlUtilTempTable.buildInSql(fieldName, values, true);
    }

    public static <T extends SuperVO> String buildInSql(String fieldName, Collection<T> values, String attrName) throws BusinessException {
        ArrayList<String> col = new ArrayList<String>();
        for (SuperVO vo : values) {
            col.add((String)vo.getAttributeValue(attrName));
        }
        return SqlUtilTempTable.buildInSql(fieldName, col, true);
    }

    public static String buildInSql(String fieldName, Collection<String> values, boolean autoUseTempTable) throws BusinessException {
        if (fieldName == null) {
            throw new BusinessException("\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4f20\u7a7a\u503c");
        }
        if (values == null || values.isEmpty()) {
            return fieldName + " in ('') ";
        }
        ArrayList<String> pks = null;
        if (values instanceof List) {
            pks = (ArrayList<String>)values;
        } else {
            pks = new ArrayList<String>();
            pks.addAll(values);
        }
        String rsStr = null;
        int length = pks.size();
        if (length > 200 && autoUseTempTable) {
            return SqlUtilTempTable.autoUseTmpTable(fieldName, pks, length);
        }
        if (length > 800) {
            StringBuffer sb = new StringBuffer();
            sb.append(" (");
            for (int i = 0; i < length; i += 800) {
                sb.append(SqlUtilTempTable.getInStr(fieldName, pks, i, i + 800 - 1));
                sb.append(" or");
            }
            rsStr = sb.substring(0, sb.length() - 3) + ") ";
        } else {
            rsStr = SqlUtilTempTable.getInStr(fieldName, pks, 0, length - 1);
        }
        return rsStr;
    }

    private static String autoUseTmpTable(String fieldName, List<String> pks, int length) {
        String rsStr;
        block14: {
            boolean canCreateTable = false;
            try {
                canCreateTable = RuntimeEnv.getInstance().isRunningInServer();
            }
            catch (Exception e) {
                Logger.error((Object)"UAPSQLUtil\u67e5\u770b\u670d\u52a1\u5668\u8fd0\u884c\u4e0e\u5426\u51fa\u9519!", (Throwable)e);
            }
            catch (Error e) {
                Logger.error((Object)"UAPSQLUtil\u67e5\u770b\u670d\u52a1\u5668\u8fd0\u884c\u4e0e\u5426\u51fa\u9519!", (Throwable)e);
            }
            if (canCreateTable) {
                try {
                    String tablename = SqlUtilTempTable.getTempTablename(fieldName);
                    String colname = tempcolname;
                    String coltype = tempcoltype;
                    tablename = SqlUtilTempTable.createTempTable(tablename, colname, coltype);
                    if (tablename == null) {
                        tablename = SqlUtilTempTable.getTempTablename(fieldName);
                        tablename = SqlUtilTempTable.createTempTable(tablename, colname, coltype);
                    }
                    if (tablename == null) {
                        throw new BusinessException("\u521b\u5efa\u4e34\u65f6\u8868\u5931\u8d25");
                    }
                    SqlUtilTempTable.insertIntoTable(tablename, colname, pks);
                    rsStr = fieldName + " in (select " + colname + " from " + tablename + ") ";
                }
                catch (Exception e) {
                    Logger.error((Object)"\u521b\u5efa\u4e34\u65f6\u8868\u5931\u8d25\u3002\u5c1d\u8bd5\u4f7f\u7528OR\u65b9\u5f0f\u3002", (Throwable)e);
                    if (length > 800) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(" (");
                        for (int i = 0; i < length; i += 800) {
                            sb.append(SqlUtilTempTable.getInStr(fieldName, pks, i, i + 800 - 1));
                            sb.append(" or");
                        }
                        rsStr = sb.substring(0, sb.length() - 3) + ") ";
                        break block14;
                    }
                    rsStr = SqlUtilTempTable.getInStr(fieldName, pks, 0, length - 1);
                }
            } else if (length > 800) {
                StringBuffer sb = new StringBuffer();
                sb.append(" (");
                for (int i = 0; i < length; i += 800) {
                    sb.append(SqlUtilTempTable.getInStr(fieldName, pks, i, i + 800 - 1));
                    sb.append(" or");
                }
                rsStr = sb.substring(0, sb.length() - 3) + ") ";
            } else {
                rsStr = SqlUtilTempTable.getInStr(fieldName, pks, 0, length - 1);
            }
        }
        return rsStr;
    }

    public static String getTempTable(String tempTableName, String[] pks) {
        if (pks == null || pks.length == 0) {
            return null;
        }
        boolean canCreateTable = false;
        try {
            canCreateTable = RuntimeEnv.getInstance().isRunningInServer();
        }
        catch (Exception e) {
            Logger.error((Object)"UapSQLUtil\u67e5\u770b\u670d\u52a1\u5668\u8fd0\u884c\u4e0e\u5426\u51fa\u9519!", (Throwable)e);
        }
        catch (Error e) {
            Logger.error((Object)"UapSQLUtil\u67e5\u770b\u670d\u52a1\u5668\u8fd0\u884c\u4e0e\u5426\u51fa\u9519!", (Throwable)e);
        }
        if (canCreateTable) {
            String tablename = null;
            tablename = StringUtils.isEmpty((CharSequence)tempTableName) ? SqlUtilTempTable.getTempTablename(null) : tempTableName;
            String colname = tempcolname;
            String coltype = tempcoltype;
            try {
                tablename = SqlUtilTempTable.createTempTable(tablename, colname, coltype);
                if (tablename == null) {
                    tablename = SqlUtilTempTable.createTempTable(tablename, colname, coltype);
                }
                if (tablename == null) {
                    throw new BusinessException("\u521b\u5efa\u4e34\u65f6\u8868\u5931\u8d25");
                }
                SqlUtilTempTable.insertIntoTable(tablename, colname, Arrays.asList(pks));
                return tablename;
            }
            catch (Exception e) {
                Logger.error((Object)e);
            }
        }
        return null;
    }

    private static String getInStr(String fieldName, List<String> pks, int start, int end) {
        start = Math.min(start, end);
        end = Math.max(start, end);
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(fieldName);
        sb.append(" in (");
        String key = null;
        for (int i = start; i < pks.size() && i <= end; ++i) {
            if (pks.get(i) == null) continue;
            key = pks.get(i).trim();
            sb.append("'");
            sb.append(NCESAPI.sqlEncode((String)key));
            sb.append("',");
        }
        String inStr = sb.substring(0, sb.length() - 1) + ") ";
        return inStr;
    }

    private static String getTempTablename(String fieldName) {
        return tempTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createTempTable(String tablename, String colname, String coltype) throws SQLException {
        Connection con = null;
        try {
            con = ConnectionFactory.getConnection();
            TempTable tt = new TempTable();
            tablename = tt.createTempTable(con, tablename, " " + colname + " " + coltype + " ", null);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return tablename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertIntoTable(String tableName, String colName, Collection<String> datas) throws SQLException, DbException {
        Connection con = null;
        JdbcSession session = null;
        try {
            PersistenceManager manager = PersistenceManager.getInstance((String)DataSourceCenter.getInstance().getSourceName());
            manager.setAddTimeStamp(false);
            session = manager.getJdbcSession();
            con = session.getConnection();
            if (con instanceof CrossDBConnection) {
                ((CrossDBConnection)con).setAddTimeStamp(false);
            }
            String sql_insert = "insert into " + tableName + " (" + colName + ")  values( ? ) ";
            session.setBatchSize(20000);
            for (String string : datas) {
                if (string == null) continue;
                SQLParameter sqlParam = new SQLParameter();
                sqlParam.addParam(string);
                session.addBatch(sql_insert, sqlParam);
            }
            session.executeBatch();
            if (session.getDbType() == 7) {
                session.executeUpdate(" analyze " + tableName);
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (session != null) {
                    session.closeAll();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void dropTempTable() throws SQLException {
        Connection con = null;
        try {
            con = ConnectionFactory.getConnection();
            TempTable tt = new TempTable();
            tt.dropTempTable(con, tempTableName);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void dropTempTable(String tempTable) throws SQLException {
        Connection con = null;
        try {
            con = ConnectionFactory.getConnection();
            TempTable tt = new TempTable();
            if (StringUtils.isEmpty((CharSequence)tempTable)) {
                tt.dropTempTable(con, tempTableName);
            } else {
                tt.dropTempTable(con, tempTable);
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

