/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.vo.pf.mobileapp.MobileAppUtil;
import nc.vo.pf.mobileapp.MobileTaskFilterHandler;
import nc.vo.pf.mobileapp.TaskMetaData;
import nc.vo.pf.mobileapp.log.PerformanceLoggerUtil;
import nc.vo.pf.mobileapp.query.AbstractReceivedQuery;
import nc.vo.pf.term.ApproveTermConfig;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.pf.AssignableInfo;
import nc.vo.pub.pf.PFClientBizRetVO;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;

public class ReceivedUnhandledQuery
extends AbstractReceivedQuery {
    @Override
    public String getPksSql() {
        String checkman = this.getCuserid();
        String pk_group = this.getPk_group();
        String workflowTypeIn = "(" + WorkflowTypeEnum.Approveflow.getIntValue() + ", " + WorkflowTypeEnum.SubApproveflow.getIntValue() + ", " + WorkflowTypeEnum.Workflow.getIntValue() + ", " + WorkflowTypeEnum.SubWorkflow.getIntValue() + ", " + WorkflowTypeEnum.SubWorkApproveflow.getIntValue() + ")";
        String procStatus = String.valueOf(WfTaskOrInstanceStatus.Started.getIntValue());
        String sql = null;
        try {
            sql = this.getBaseSql().replace("#checkman#", checkman).replace("#workflowtype#", workflowTypeIn).replace("#approvestatus#", procStatus).replace("#pk_group#", pk_group).replace("#senddate#", this.getDateAsEnd());
            sql = MobileTaskFilterHandler.getFinalSqlWithWfWork(sql);
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> queryTaskActions(String pk) throws BusinessException {
        String mainTag = "ReceivedUnhandledQuery.queryTaskActions";
        PerformanceLoggerUtil.begin(mainTag);
        try {
            PerformanceLoggerUtil.begin("query task metadata");
            TaskMetaData tmd = MobileAppUtil.queryTaskMetaData("ishandled", "unhandled", pk);
            PerformanceLoggerUtil.end("query task metadata");
            PerformanceLoggerUtil.begin("query bill entity");
            AggregatedValueObject billvo = MobileAppUtil.queryBillEntity(tmd.getBillType(), tmd.getBillId());
            PerformanceLoggerUtil.end("query bill entity");
            PerformanceLoggerUtil.begin("checkworkflow");
            String pk_checknote = tmd.getPk_checkflow();
            WorkflownoteVO tNote = this.queryWorkFlowNoteVO(pk_checknote);
            WorkflownoteVO note = null;
            String actionName = this.getActionNameByFlowType(tNote.getWorkflow_type());
            note = "APPROVE".equals(actionName) ? MobileAppUtil.checkWorkflow(tmd) : this.getWorkflowNote(tmd.getBillType(), tmd.getBillId(), tmd.getCuserid());
            PerformanceLoggerUtil.end("checkworkflow");
            PFClientBizRetVO bizret = null;
            try {
                PerformanceLoggerUtil.begin("execute client biz process");
                bizret = MobileAppUtil.executeClientBiz(billvo, note);
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                PerformanceLoggerUtil.end("execute client biz process");
            }
            ArrayList<Map<String, Object>> list = MobileAppUtil.createArrayList();
            if (MobileAppUtil.canAgree(bizret, note)) {
                HashMap<String, Object> passingMap = MobileAppUtil.createHashMap();
                passingMap.put("code", "doAgree");
                passingMap.put("name", ApproveTermConfig.getInstance().getText("pass"));
                if (MobileAppUtil.canAssignWhenPassing(note)) {
                    passingMap.put("actflag", "0");
                } else {
                    passingMap.put("actflag", "1");
                }
                list.add(passingMap);
            }
            if (MobileAppUtil.canDisAgree(bizret, note)) {
                HashMap<String, Object> noPassMap = MobileAppUtil.createHashMap();
                noPassMap.put("code", "doDisAgree");
                noPassMap.put("name", ApproveTermConfig.getInstance().getText("nopass"));
                if (MobileAppUtil.canAssignWhenNoPass(note)) {
                    noPassMap.put("actflag", "2");
                } else {
                    noPassMap.put("actflag", "3");
                }
                list.add(noPassMap);
            }
            if (MobileAppUtil.canReject(bizret, note)) {
                HashMap<String, Object> rejectMap = MobileAppUtil.createHashMap();
                rejectMap.put("code", "doReject");
                rejectMap.put("name", ApproveTermConfig.getInstance().getText("reject"));
                rejectMap.put("actflag", "4");
                list.add(rejectMap);
            }
            if (MobileAppUtil.canReassign(note)) {
                HashMap<String, Object> reassignMap = MobileAppUtil.createHashMap();
                reassignMap.put("code", "doReassign");
                reassignMap.put("name", ApproveTermConfig.getInstance().getText("transfer"));
                reassignMap.put("actflag", "5");
                list.add(reassignMap);
            }
            if (MobileAppUtil.canAddApprover(note)) {
                HashMap<String, Object> addApproverMap = MobileAppUtil.createHashMap();
                addApproverMap.put("code", "doAddApprove");
                addApproverMap.put("name", ApproveTermConfig.getInstance().getText("addapprover"));
                addApproverMap.put("actflag", "6");
                list.add(addApproverMap);
            }
            HashMap<String, Object> resultMap = MobileAppUtil.createHashMap();
            if (bizret != null && bizret.getHintMessage() != null) {
                resultMap.put("hint", bizret.getHintMessage());
            } else {
                resultMap.put("hint", "");
            }
            if (bizret != null && bizret.isStopFlow()) {
                resultMap.put("actionstructlist", MobileAppUtil.createArrayList());
            } else {
                resultMap.put("actionstructlist", list);
            }
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            PerformanceLoggerUtil.end(mainTag);
        }
    }

    private WorkflownoteVO getWorkflowNote(String billType, String originBillId, String checkman) throws BusinessException {
        AggregatedValueObject billvo = MobileAppUtil.queryBillEntity(billType, originBillId);
        IWorkflowMachine srv = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class);
        WorkflownoteVO note = srv.checkWorkFlow("SIGNAL" + checkman, billType, billvo, null);
        return note;
    }

    @Override
    public Map<String, Object> queryTaskActionDefaultValue(String pk, String actionCode) throws BusinessException {
        Vector assignInfos;
        WorkflownoteVO tworknote = this.queryWorkFlowNoteVO(pk);
        WorkflownoteVO worknote = null;
        worknote = "APPROVE".equals(this.getActionNameByFlowType(tworknote.getWorkflow_type())) ? MobileAppUtil.checkWorkflow(pk) : this.getWorkflowNote(tworknote.getPk_billtype(), tworknote.getBillid(), tworknote.getCheckman());
        HashMap<String, Object> map = MobileAppUtil.createHashMap();
        boolean canAssign = false;
        if ("doAgree".equals(actionCode)) {
            Vector assignInfos2;
            if (!worknote.getActiontype().endsWith("_A") && (assignInfos2 = worknote.getTaskInfo().getAssignableInfos()) != null && assignInfos2.size() > 0) {
                for (AssignableInfo ai : assignInfos2) {
                    if (!AssignableInfo.CRITERION_PASS.equals(ai.getCheckResultCriterion()) && !AssignableInfo.CRITERION_NOTGIVEN.equals(ai.getCheckResultCriterion())) continue;
                    canAssign = true;
                    break;
                }
            }
        } else if ("doDisAgree".equals(actionCode) && (assignInfos = worknote.getTaskInfo().getAssignableInfos()) != null && assignInfos.size() > 0) {
            for (AssignableInfo ai : assignInfos) {
                if (!AssignableInfo.CRITERION_NOPASS.equals(ai.getCheckResultCriterion()) && !AssignableInfo.CRITERION_NOTGIVEN.equals(ai.getCheckResultCriterion())) continue;
                canAssign = true;
                break;
            }
        }
        map.put("isassign", UFBoolean.valueOf((boolean)canAssign).toString());
        map.put("isassignsigle", "Y");
        map.put("assigntype", "1");
        map.put("isupload", "Y");
        if (MobileAppUtil.canAddApprover(worknote)) {
            map.put("isbassign", "Y");
        } else {
            map.put("isbassign", "N");
        }
        map.put("isaassign", "N");
        map.put("issend", "N");
        map.put("ishasmemo", "0");
        map.put("memo", "N");
        map.put("ishasnote", "3");
        return map;
    }

    private WorkflownoteVO queryWorkFlowNoteVO(String pk_workflownote) throws DAOException, BusinessException {
        WorkflownoteVO note = (WorkflownoteVO)new BaseDAO().retrieveByPK(WorkflownoteVO.class, pk_workflownote);
        if (note == null) {
            throw new BusinessException("\u8be5\u5f85\u529e\u5de5\u4f5c\u9879\u5df2\u7ecf\u5931\u6548\uff01");
        }
        return note;
    }

    private String getActionNameByFlowType(int workflowtype) {
        if (workflowtype == WorkflowTypeEnum.Workflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkApproveflow.getIntValue()) {
            return "SIGNAL";
        }
        return "APPROVE";
    }
}

