/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp.log;

import nc.bs.logging.Logger;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.vo.pf.mobileapp.log.DefaultLoggerFormat;
import nc.vo.pf.mobileapp.log.ILoggerFormat;
import nc.vo.pf.mobileapp.log.PerformanceBeginTsKey;

public class PerformanceLoggerUtil {
    private static final ILoggerFormat format = new DefaultLoggerFormat();

    public static void begin(String tag) {
        StringBuffer log = new StringBuffer();
        try {
            Long beginTs = System.currentTimeMillis();
            PerformanceBeginTsKey key = new PerformanceBeginTsKey(tag);
            PFRequestDataCacheProxy.put((IRequestDataCacheKey)key, (Object)beginTs);
            log.append(format.getRecognizablePrefix());
            log.append(tag);
            log.append(", began at: ");
            log.append(String.valueOf(beginTs));
        }
        catch (Exception e) {
            Logger.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(String tag) {
        StringBuffer log = new StringBuffer();
        try {
            PerformanceBeginTsKey key = new PerformanceBeginTsKey(tag);
            Long beginTs = (Long)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key);
            Long endTs = System.currentTimeMillis();
            log.append(format.getRecognizablePrefix());
            log.append(tag);
            log.append(", ended at: ");
            log.append(endTs);
            log.append(", elapsed: ");
        }
        catch (Exception e) {
            Logger.error((Object)e);
        }
        finally {
            Logger.reset();
        }
    }
}

