/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nc.vo.pf.mobileapp.ITaskType;
import nc.vo.pf.mobileapp.ReceivedHandled;
import nc.vo.pf.mobileapp.ReceivedUnhandled;
import nc.vo.pf.mobileapp.SubmittedHandled;
import nc.vo.pf.mobileapp.SubmittedHandling;
import nc.vo.pf.mobileapp.SubmittedUnhandled;

public class TaskTypeFactory {
    private static volatile TaskTypeFactory instance = null;
    private volatile Map<String, Map<String, ITaskType>> typeMap = null;
    private List<ITaskType> typeList = null;

    private TaskTypeFactory() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskTypeFactory getInstance() {
        if (instance != null) return instance;
        Class<TaskTypeFactory> clazz = TaskTypeFactory.class;
        synchronized (TaskTypeFactory.class) {
            if (instance != null) return instance;
            instance = new TaskTypeFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        this.typeList = new ArrayList<ITaskType>();
        this.typeList.add(new SubmittedUnhandled());
        this.typeList.add(new SubmittedHandling());
        this.typeList.add(new SubmittedHandled());
        this.typeList.add(new ReceivedUnhandled());
        this.typeList.add(new ReceivedHandled());
    }

    public ITaskType get(String category, String code) {
        Map<String, ITaskType> map = this.getTypeMap().get(category);
        if (map == null) {
            return null;
        }
        return map.get(code);
    }

    public ITaskType[] get(String category) {
        Map<String, ITaskType> map = this.getTypeMap().get(category);
        if (map == null) {
            return null;
        }
        return map.values().toArray(new ITaskType[0]);
    }

    public String[] getCategories() {
        return this.getTypeMap().keySet().toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Map<String, ITaskType>> getTypeMap() {
        if (this.typeMap != null) return this.typeMap;
        Class<TaskTypeFactory> clazz = TaskTypeFactory.class;
        synchronized (TaskTypeFactory.class) {
            if (this.typeMap != null) return this.typeMap;
            this.typeMap = new HashMap<String, Map<String, ITaskType>>();
            for (ITaskType c : this.typeList) {
                if (!this.typeMap.containsKey(c.getCategory())) {
                    LinkedHashMap map = new LinkedHashMap();
                    this.typeMap.put(c.getCategory(), map);
                }
                this.typeMap.get(c.getCategory()).put(c.getCode(), c);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.typeMap;
        }
    }
}

