/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.logging.Logger;
import nc.itf.uap.IUAPQueryBS;
import nc.jdbc.framework.processor.ColumnListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pf.mobileapp.MobileTaskFilterConfig;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pf.sql.InSqlUtil;
import nc.vo.pub.BusinessException;

public class MobileTaskFilterHandler {
    static final String CONFIG_FILE = RuntimeEnv.getInstance().getNCHome() + "/modules/riart/config/mobiletask/task_filter_config.xml";
    private static MobileTaskFilterConfig mobileTaskFilterConfig;
    private static final String HAS_ORDER_BY = "order";

    public static synchronized MobileTaskFilterConfig getMobileTaskFilterConfig() {
        if (mobileTaskFilterConfig != null) {
            return mobileTaskFilterConfig;
        }
        XStream xs = MobileTaskFilterHandler.getAliasXstream();
        FileReader fr = null;
        try {
            fr = new FileReader(CONFIG_FILE);
            mobileTaskFilterConfig = (MobileTaskFilterConfig)xs.fromXML((Reader)fr);
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return mobileTaskFilterConfig;
    }

    private static XStream getAliasXstream() {
        XStream xs = new XStream();
        xs.addPermission(AnyTypePermission.ANY);
        xs.alias("mobiletaskfilter", MobileTaskFilterConfig.class);
        return xs;
    }

    public static String getInSqlWithWfWork() throws BusinessException {
        MobileTaskFilterConfig config = MobileTaskFilterHandler.getMobileTaskFilterConfig();
        if (config != null) {
            String tempsql;
            String tempsql2;
            List billtypeList;
            IUAPQueryBS qry;
            String sql;
            String returnSql = null;
            String moduleSql = null;
            String billtypeSql = null;
            String transtypeSql = null;
            List moduleHasBill = null;
            if (!ArrayUtil.isNull((Object[])config.getModules())) {
                sql = "select pk_billtypecode from bd_billtype where systemcode in (" + MobileTaskFilterHandler.createConditionSql(config.getModules(), moduleHasBill) + ")";
                qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
                billtypeList = (List)qry.executeQuery(sql, (ResultSetProcessor)new ColumnListProcessor());
                if (billtypeList != null && billtypeList.size() > 0) {
                    moduleHasBill = billtypeList;
                    tempsql2 = InSqlUtil.buildInSql("pk_billtype", "and", "not in", billtypeList.toArray(new String[billtypeList.size()]));
                    moduleSql = " and  " + tempsql2;
                }
            }
            if (!StringUtil.isEmptyWithTrim(moduleSql)) {
                returnSql = moduleSql;
            }
            if (!ArrayUtil.isNull((Object[])config.getBilltypes())) {
                sql = "select pk_billtypecode from bd_billtype where parentbilltype in (" + MobileTaskFilterHandler.createConditionSql(config.getBilltypes(), moduleHasBill) + ") or pk_billtypecode in (" + MobileTaskFilterHandler.createConditionSql(config.getBilltypes(), moduleHasBill) + ")";
                qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
                billtypeList = (List)qry.executeQuery(sql, (ResultSetProcessor)new ColumnListProcessor());
                tempsql2 = InSqlUtil.buildInSql("pk_billtype", "and", "not in", billtypeList.toArray(new String[billtypeList.size()]));
                if (!StringUtil.isEmptyWithTrim((String)tempsql2)) {
                    billtypeSql = " and " + tempsql2;
                }
            }
            if (!StringUtil.isEmptyWithTrim(billtypeSql) && !StringUtil.isEmptyWithTrim(returnSql)) {
                returnSql = returnSql + billtypeSql;
            } else if (!StringUtil.isEmptyWithTrim(billtypeSql) && StringUtil.isEmptyWithTrim(returnSql)) {
                returnSql = billtypeSql;
            }
            if (!ArrayUtil.isNull((Object[])config.getTranstypes()) && !StringUtil.isEmptyWithTrim((String)(tempsql = InSqlUtil.buildInSql("pk_billtype", "and", "not in", config.getTranstypes())))) {
                transtypeSql = " and " + tempsql;
            }
            if (!StringUtil.isEmptyWithTrim(transtypeSql) && !StringUtil.isEmptyWithTrim((String)returnSql)) {
                returnSql = returnSql + transtypeSql;
            } else if (!StringUtil.isEmptyWithTrim(transtypeSql) && StringUtil.isEmptyWithTrim((String)returnSql)) {
                returnSql = transtypeSql;
            }
            return returnSql;
        }
        return null;
    }

    public static String createConditionSql(String[] codes, List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String code : codes) {
            if (list == null) {
                sb.append("'" + code + "',");
                continue;
            }
            if (list.contains(code)) continue;
            sb.append("'" + code + "',");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String getFinalSqlWithWfWork(String sql) throws BusinessException {
        try {
            String insql = MobileTaskFilterHandler.getInSqlWithWfWork();
            if (insql != null) {
                sql = sql.contains(HAS_ORDER_BY) ? sql.substring(0, sql.indexOf(HAS_ORDER_BY)) + insql + " order by senddate desc" : sql + insql;
            }
            return sql;
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getFinalSqlWithWfIns(String sql) throws BusinessException {
        try {
            String insql = MobileTaskFilterHandler.getInSqlWithWfIns();
            if (insql != null) {
                sql = sql.contains(HAS_ORDER_BY) ? sql.substring(0, sql.indexOf(HAS_ORDER_BY)) + insql + " order by startts desc" : sql + insql;
            }
            return sql;
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getInSqlWithWfIns() throws BusinessException {
        MobileTaskFilterConfig config = MobileTaskFilterHandler.getMobileTaskFilterConfig();
        if (config != null) {
            String tempsql;
            String moduleSql = null;
            String billtypeSql = null;
            String transtypeSql = null;
            List moduleHasBill = null;
            if (!ArrayUtil.isNull((Object[])config.getModules())) {
                String sql = "select pk_billtypecode from bd_billtype where systemcode in (" + MobileTaskFilterHandler.createConditionSql(config.getModules(), moduleHasBill) + ")";
                IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
                List billtypeList = (List)qry.executeQuery(sql, (ResultSetProcessor)new ColumnListProcessor());
                if (billtypeList != null && billtypeList.size() > 0) {
                    moduleHasBill = billtypeList;
                    String tempsql2 = MobileTaskFilterHandler.createConditionSql(billtypeList.toArray(new String[billtypeList.size()]), null);
                    moduleSql = " and billtype not in ( " + tempsql2;
                }
            }
            if (!ArrayUtil.isNull((Object[])config.getBilltypes())) {
                tempsql = MobileTaskFilterHandler.createConditionSql(config.getBilltypes(), moduleHasBill);
                billtypeSql = !StringUtil.isEmptyWithTrim(moduleSql) ? moduleSql + "," + tempsql : " and billtype not in (" + tempsql;
            }
            if (!ArrayUtil.isNull((Object[])config.getTranstypes())) {
                tempsql = MobileTaskFilterHandler.createConditionSql(config.getTranstypes(), moduleHasBill);
                transtypeSql = !StringUtil.isEmptyWithTrim(billtypeSql) ? billtypeSql + "," + tempsql + ")" : " and billtype not in (" + tempsql + ")";
            }
            return transtypeSql;
        }
        return null;
    }
}

