/*
 * Decompiled with CFR 0.152.
 */
package nc.ui.pf.multilang;

import java.util.ArrayList;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.pf.pub.PfDataCache;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.MultiLangUtil;
import nc.vo.pf.pub.BusitypeVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.graph.element.AbstractGraphObject;
import nc.vo.pub.pfflow.BillactionVO;
import nc.vo.uap.pf.PFBusinessException;

public class PfMultiLangUtil {
    public static String getMultiGraphObejcetName(AbstractGraphObject obj) {
        if (obj == null) {
            return "";
        }
        int Suffix = MultiLangUtil.getCurrentLangSeq();
        String muliName = "";
        switch (Suffix) {
            case 1: {
                muliName = obj.getName();
                break;
            }
            case 2: {
                muliName = obj.getName2();
                break;
            }
            case 3: {
                muliName = obj.getName3();
                break;
            }
        }
        if (StringUtil.isEmptyWithTrim((String)muliName)) {
            muliName = obj.getName();
        }
        return muliName == null ? "" : muliName;
    }

    public static String getMultiBillActionName(BillactionVO billactionvo) {
        if (billactionvo == null) {
            return "";
        }
        return PfMultiLangUtil.getSuperVONameOfCurrentLang(billactionvo, "actionnote");
    }

    public static String getMultiBillActionName(String actionCode, ArrayList alActions) {
        BillactionVO billactionvo = null;
        for (BillactionVO baVO : alActions) {
            if (!actionCode.equals(baVO.getActiontype())) continue;
            billactionvo = baVO;
            break;
        }
        return PfMultiLangUtil.getMultiBillActionName(billactionvo);
    }

    public static String getMultiBusitypeName(BusitypeVO vo) {
        if (vo == null) {
            return "";
        }
        return PfMultiLangUtil.getSuperVONameOfCurrentLang(vo, "businame");
    }

    public static String getMultiBilltypeName(BilltypeVO vo) {
        if (vo == null) {
            return "";
        }
        return PfMultiLangUtil.getSuperVONameOfCurrentLang(vo, "billtypename");
    }

    public static String getMultiBilltypeName(String billtype) {
        BilltypeVO vo = PfDataCache.getBillType(billtype);
        return PfMultiLangUtil.getMultiBilltypeName(vo);
    }

    public static String getSuperVONameOfCurrentLang(SuperVO vo, String nameField, String defaultName) {
        String suffix = MultiLangUtil.getCurrentLangSeqSuffix();
        String name = (String)vo.getAttributeValue(nameField + suffix);
        if (StringUtil.isEmptyWithTrim((String)name)) {
            return defaultName;
        }
        return name;
    }

    public static String getSuperVONameOfCurrentLang(SuperVO vo, String nameField) {
        String defaultName = (String)vo.getAttributeValue(nameField);
        return PfMultiLangUtil.getSuperVONameOfCurrentLang(vo, nameField, defaultName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInLang(String langcode, Runnable command) throws BusinessException {
        String originLang = InvocationInfoProxy.getInstance().getLangCode();
        try {
            InvocationInfoProxy.getInstance().setLangCode(langcode);
            try {
                command.run();
            }
            catch (Throwable e) {
                throw new PFBusinessException(e.getMessage(), e);
            }
        }
        finally {
            InvocationInfoProxy.getInstance().setLangCode(originLang);
        }
    }

    public static void doInDefaultLangBs(Runnable command) throws BusinessException {
        PfMultiLangUtil.doInLang(PfMultiLangUtil.getDefaultLangcode(), command);
    }

    public static String getDefaultLangcode() {
        return MultiLangContext.getInstance().getEnableLangVOs()[0].getLangcode();
    }
}

