/*
 * Decompiled with CFR 0.152.
 */
package nc.uap.pf.metadata;

import java.util.Map;
import nc.bs.logging.Logger;
import nc.md.data.access.NCObject;
import nc.md.model.IAttribute;
import nc.md.model.IBusinessEntity;
import nc.vo.jcom.lang.StringUtil;

public abstract class AbstractBizInterfaceImpl {
    protected NCObject ncobject = null;
    private Map<String, String> dataMap = null;

    public AbstractBizInterfaceImpl(NCObject ncobject) {
        this.ncobject = ncobject;
    }

    protected void initByBizItf(String itfClzName) {
        if (this.ncobject != null) {
            this.dataMap = ((IBusinessEntity)this.ncobject.getRelatedBean()).getBizInterfaceMapInfo(itfClzName);
        }
    }

    protected Object getAttributeValue(String itfAttrName) {
        if (this.dataMap == null) {
            return null;
        }
        String strAttr = this.dataMap.get(itfAttrName);
        if (StringUtil.isEmptyWithTrim((String)strAttr)) {
            Logger.error((Object)"AbstractBizInterface: getAttributeValue: \u5c5e\u6027\u540d\u4e3a\u7a7a");
            return null;
        }
        return this.ncobject.getAttributeValue(strAttr);
    }

    public Map<String, String> getDataMap() {
        return this.dataMap;
    }

    protected void setAttributeValue(String itfAttrName, Object valueObj) {
        if (this.dataMap == null) {
            return;
        }
        String strAttr = this.dataMap.get(itfAttrName);
        if (StringUtil.isEmptyWithTrim((String)strAttr)) {
            return;
        }
        this.ncobject.setAttributeValue(strAttr, valueObj);
    }

    public String getColumnName(String itfAttrName) {
        if (this.dataMap == null) {
            return null;
        }
        String strAttr = this.dataMap.get(itfAttrName);
        if (StringUtil.isEmptyWithTrim((String)strAttr)) {
            return null;
        }
        IAttribute attr = this.ncobject.getRelatedBean().getAttributeByPath(strAttr);
        return attr.getColumn().getName();
    }
}

