/*
 * Decompiled with CFR 0.152.
 */
package nc.mailapprove.bs;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import uap.sec.esapi.UAPESAPI;

public class MailSender {
    private String smtpHost = null;
    private String username = null;
    private String password = null;
    private boolean isAuthen = true;

    public MailSender(String smtpHost, String user, String pwd) {
        this(smtpHost, user, pwd, true);
    }

    public MailSender(String smtpHost, String user, String pwd, boolean isAuthen) {
        this.smtpHost = smtpHost;
        this.username = user;
        this.password = pwd;
        this.isAuthen = isAuthen;
    }

    private Session createSession() {
        Properties props = new Properties();
        if (this.isAuthen) {
            props.put("mail.smtp.auth", "true");
        }
        return Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailSender.this.username, MailSender.this.password);
            }
        });
    }

    private Transport getTransport(Session session) throws Exception {
        Transport transport = session.getTransport("smtp");
        transport.connect(this.smtpHost, this.username, this.password);
        return transport;
    }

    private Address[] convertToAddress(String[] strs) throws AddressException {
        int count = strs == null ? 0 : strs.length;
        Address[] address = new Address[count];
        for (int i = 0; i < count; ++i) {
            address[i] = new InternetAddress(strs[i]);
        }
        return address;
    }

    public void sendHTMLText(String from, String[] to, String[] cc, String subject, String bodyContent, String attachFileName, String attachHtmlContent) throws Exception {
        Session session = this.createSession();
        MimeMessage msg = new MimeMessage(session);
        if (from != null && from.trim().length() > 0) {
            msg.setFrom((Address)new InternetAddress(from));
        }
        msg.setRecipients(Message.RecipientType.TO, this.convertToAddress(to));
        if (cc != null && cc.length > 0) {
            msg.setRecipients(Message.RecipientType.CC, this.convertToAddress(cc));
        }
        msg.setSubject(UAPESAPI.htmlEncode((String)MimeUtility.encodeText((String)subject)));
        String charset = Charset.defaultCharset().name();
        msg.setSentDate(new Date());
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(bodyContent, "text/html; charset=" + charset)));
        part.setHeader("Content-Transfer-Encoding", "base64");
        multipart.addBodyPart((BodyPart)part);
        part = new MimeBodyPart();
        String name = MimeUtility.encodeText((String)attachFileName);
        part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(attachHtmlContent, "text/html; charset=" + charset)));
        part.setHeader("Content-Transfer-Encoding", "base64");
        part.setFileName(name);
        multipart.addBodyPart((BodyPart)part);
        msg.setContent((Multipart)multipart);
        msg.saveChanges();
        Transport transport = this.getTransport(session);
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }

    public void sendNormalText(String from, String[] to, String[] cc, String subject, String text, boolean isHtml) throws Exception {
        Session session = this.createSession();
        MimeMessage msg = new MimeMessage(session);
        if (from != null && from.trim().length() > 0) {
            msg.setFrom((Address)new InternetAddress(from));
        }
        msg.setRecipients(Message.RecipientType.TO, this.convertToAddress(to));
        if (cc != null && cc.length > 0) {
            msg.setRecipients(Message.RecipientType.CC, this.convertToAddress(cc));
        }
        msg.setSubject(subject);
        String charset = Charset.defaultCharset().name();
        msg.setSentDate(new Date());
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart();
        if (isHtml) {
            part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(text, "text/html; charset=" + charset)));
        } else {
            part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(text, "text/plain; charset=" + charset)));
        }
        part.setHeader("Content-Transfer-Encoding", "base64");
        multipart.addBodyPart((BodyPart)part);
        msg.setContent((Multipart)multipart);
        msg.saveChanges();
        Transport transport = this.getTransport(session);
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }
}

