/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pf.mailapprove;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import nc.bs.dao.BaseDAO;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.WorkflowProcessCache;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ColumnListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.ui.pf.multilang.PfMultiLangUtil;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.pf.mobileapp.MobileAppUtil;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pf.sql.ParameterizedBatchCaller;
import nc.vo.pf.term.ApproveTermConfig;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.MultiLangText;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.pf.AssignableInfo;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.sm.UserVO;
import nc.vo.uap.pf.OrganizeUnit;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;

public class MailApproveUtil {
    static String VISIBLE = "visible";
    static String TEXT = "text";

    public static Map<String, Map<String, String>> extractAssignableInfo(String billtype, String billid, Vector<AssignableInfo> assignInfos) {
        if (ArrayUtil.isNull(assignInfos)) {
            return null;
        }
        Context ctx = new Context(billtype, billid, assignInfos);
        LinkedHashMap<String, Map<String, String>> map = new LinkedHashMap<String, Map<String, String>>();
        for (AssignableInfo ai : assignInfos) {
            LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
            Vector<OrganizeUnit> vct = ai.getOuUsers();
            if (ArrayUtil.isNull(vct)) continue;
            for (OrganizeUnit ou : vct) {
                String name = ctx.getUserName(ou.getPk(), ou.getName());
                String id = ou.getPk() + "#" + ai.getActivityDefId();
                value.put(name, id);
            }
            String activityName = ctx.getActivityName(ai.getActivityDefId(), ai.getDesc());
            map.put(activityName, value);
        }
        return map;
    }

    public static Map<String, Map<String, String>> extractApproveBtnInfo(WorkflownoteVO noteVO) {
        boolean canDisagree = MobileAppUtil.canDisAgree(null, noteVO);
        String passText = ApproveTermConfig.getInstance().getText("pass");
        String nowPassText = ApproveTermConfig.getInstance().getText("nopass");
        HashMap<String, Map<String, String>> approveBtnInfo = new HashMap<String, Map<String, String>>();
        HashMap<String, String> passInfo = new HashMap<String, String>();
        passInfo.put(VISIBLE, "true");
        passInfo.put(TEXT, passText);
        approveBtnInfo.put("pass", passInfo);
        HashMap<String, String> noPassInfo = new HashMap<String, String>();
        noPassInfo.put(VISIBLE, UFBoolean.valueOf((boolean)canDisagree).toString());
        noPassInfo.put(TEXT, nowPassText);
        approveBtnInfo.put("nopass", noPassInfo);
        return approveBtnInfo;
    }

    protected static class Context {
        private String billtype;
        private String billid;
        private Vector<AssignableInfo> assignInfo;
        private Map<String, String> idNameMap = null;
        private List<BasicWorkflowProcess> processList = null;

        private Map<String, String> getIdNameMap() {
            if (this.idNameMap == null) {
                this.idNameMap = new HashMap<String, String>();
                if (this.assignInfo != null) {
                    HashSet<String> idSet = new HashSet<String>();
                    for (AssignableInfo ai : this.assignInfo) {
                        for (OrganizeUnit ou : ai.getOuUsers()) {
                            idSet.add(ou.getPk());
                        }
                    }
                    try {
                        new ParameterizedBatchCaller(idSet).execute(new ParameterizedBatchCaller.Callback(){

                            @Override
                            public void doInParameter(String inSql, SQLParameter param) throws BusinessException {
                                String cond = "cuserid in " + inSql;
                                Collection col = new BaseDAO().retrieveByClause(UserVO.class, cond, new String[]{"cuserid", "user_name", "user_name" + MultiLangUtil.getCurrentLangSeqSuffix()}, param);
                                if (col != null) {
                                    for (UserVO uvo : col) {
                                        idNameMap.put(uvo.getCuserid(), PfMultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)uvo, "user_name"));
                                    }
                                }
                            }
                        });
                    }
                    catch (BusinessException e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            return this.idNameMap;
        }

        private List<BasicWorkflowProcess> getProcessList() {
            if (this.processList == null) {
                this.processList = new ArrayList<BasicWorkflowProcess>();
                String sql = "select processdefid from pub_wf_instance where billtype=? and billversionpk=?";
                SQLParameter param = new SQLParameter();
                param.addParam(this.billtype);
                param.addParam(this.billid);
                try {
                    Collection col = (Collection)new BaseDAO().executeQuery(sql, param, (ResultSetProcessor)new ColumnListProcessor());
                    if (col != null) {
                        for (String pk_wf_def : col) {
                            BasicWorkflowProcess process = WorkflowProcessCache.getInstance().getWorkflowProcess(pk_wf_def);
                            if (process == null) continue;
                            this.processList.add(process);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return this.processList;
        }

        public Context(String billtype, String billid, Vector<AssignableInfo> assignInfo) {
            this.billtype = billtype;
            this.billid = billid;
            this.assignInfo = assignInfo;
        }

        public String getUserName(String cuserid, String defaultName) {
            String mlname = this.getIdNameMap().get(cuserid);
            if (!StringUtil.isEmptyWithTrim((String)mlname)) {
                return mlname;
            }
            return defaultName;
        }

        public String getActivityName(String activityid, String defaultName) {
            for (BasicWorkflowProcess process : this.getProcessList()) {
                MultiLangText mlt;
                String mlname;
                Activity act = process.findActivityByID(activityid);
                if (act == null || StringUtil.isEmptyWithTrim((String)(mlname = (mlt = act.getMultiLangName()).getText(mlt.getCurrLangIndex())))) continue;
                return mlname;
            }
            return defaultName;
        }
    }
}

