/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pf.busistate;

import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pub.pf.CheckStatusCallbackContext;
import nc.bs.pub.pf.ICheckStatusCallback;
import nc.bs.pub.pf.PfUtilTools;
import nc.bs.pub.pf.busistate.AbstractBusiStateCallback;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFWorkflowQry;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.itf.uap.pf.metadata.IFlowBizItf;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ArrayProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.md.model.IBusinessEntity;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.compiler.PfParameterVO;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.pf.WfTaskInfo;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;
import nccloud.commons.lang.StringUtils;
import nccloud.pubitf.riart.pf.IWfstatusRecordService;

public class PFBusiStateOfMeta
extends AbstractBusiStateCallback {
    @Override
    protected String[] getTableInfo(String billType) throws BusinessException {
        IBusinessEntity bean = PfMetadataTools.queryMetaOfBilltype(billType);
        return new String[]{bean.getTable().getName(), bean.getTable().getPrimaryKeyName()};
    }

    @Override
    protected void changeStatusWhenApprove(PfParameterVO paraVo, int approveStatus) throws Exception {
        this.changeVoStatus(paraVo, approveStatus);
    }

    protected void changeVoStatus(PfParameterVO paraVo, int iApproveStatus) throws BusinessException {
        int start;
        WorkflownoteVO worknoteVO;
        this.setPreValueVos(paraVo);
        Object checkObj = PfUtilTools.getBizRuleImpl(paraVo.m_billType);
        Logger.debug((Object)("bd_billtype.checkclassname\u7684\u5b9e\u4f8b=" + checkObj));
        boolean isUnApprove = false;
        if (StringUtils.isNotBlank((CharSequence)paraVo.m_actionName) && StringUtils.isNotBlank((CharSequence)paraVo.m_billType) && (PfUtilBaseTools.isUnapproveAction(paraVo.m_actionName, paraVo.m_billType) || PfUtilBaseTools.isRollbackAction(paraVo.m_actionName, paraVo.m_billType))) {
            isUnApprove = true;
        }
        if ((worknoteVO = paraVo.m_workFlow) == null) {
            worknoteVO = new WorkflownoteVO();
        }
        int end = paraVo.m_preValueVos.length;
        for (start = 0; start < end; ++start) {
            IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(paraVo.m_preValueVos[start], IFlowBizItf.class);
            if (isUnApprove) {
                fbi.setApproveNote(null);
            } else {
                fbi.setApproveNote(worknoteVO.getChecknote());
            }
            fbi.setApproveStatus(iApproveStatus);
            switch (iApproveStatus) {
                case -1: {
                    fbi.setApprover(null);
                    fbi.setApproveDate(null);
                    break;
                }
                case 3: {
                    fbi.setApprover(null);
                    fbi.setApproveDate(null);
                    break;
                }
                default: {
                    if (this.isNotExistsFlow(paraVo)) {
                        fbi.setApprover(paraVo.m_operator);
                        fbi.setApproveDate(new UFDateTime(InvocationInfoProxy.getInstance().getBizDateTime()));
                    } else if (this.isReject(paraVo)) {
                        fbi.setApprover(paraVo.m_operator);
                        fbi.setApproveDate(new UFDateTime(InvocationInfoProxy.getInstance().getBizDateTime()));
                    }
                    if (!StringUtils.isBlank((CharSequence)fbi.getApprover())) break;
                    String currentUserId = InvocationInfoProxy.getInstance().getUserId();
                    fbi.setApprover(currentUserId);
                    fbi.setApproveDate(new UFDateTime(InvocationInfoProxy.getInstance().getBizDateTime()));
                }
            }
            if (checkObj instanceof ICheckStatusCallback) {
                CheckStatusCallbackContext cscc = new CheckStatusCallbackContext();
                cscc.setBillVo(paraVo.m_preValueVos[start]);
                switch (iApproveStatus) {
                    case -1: {
                        cscc.setApproveId(null);
                        cscc.setApproveDate(null);
                        break;
                    }
                    case 3: {
                        cscc.setApproveId(null);
                        cscc.setApproveDate(null);
                        break;
                    }
                    default: {
                        if (StringUtils.isBlank((CharSequence)fbi.getApprover())) {
                            String currentUserId = InvocationInfoProxy.getInstance().getUserId();
                            cscc.setApproveId(currentUserId);
                            cscc.setApproveDate(new UFDateTime(InvocationInfoProxy.getInstance().getBizDateTime()).toString());
                            break;
                        }
                        cscc.setApproveId(fbi.getApprover());
                        cscc.setApproveDate(null == fbi.getApproveDate() ? null : fbi.getApproveDate().toString());
                    }
                }
                if (isUnApprove) {
                    cscc.setCheckNote(null);
                } else {
                    cscc.setCheckNote(worknoteVO.getChecknote());
                }
                cscc.setCheckStatus(iApproveStatus);
                WfTaskInfo ti = worknoteVO.getTaskInfo();
                boolean isReject = ti == null ? false : (ti.getTask() == null ? false : ti.getTask().isBackToFirstActivity());
                cscc.setReject(isReject);
                boolean isTerminate = worknoteVO.getActiontype() != null && worknoteVO.getActiontype().equals("TERMINATE");
                cscc.setTerminate(isTerminate);
                ((ICheckStatusCallback)checkObj).callCheckStatus(cscc);
                String callbackclass = ((ICheckStatusCallback)checkObj).getClass().getName();
                this.recordApproveStatus(cscc, fbi.getBillId(), fbi.getBillNo(), fbi.getBilltype(), paraVo.m_actionName, callbackclass);
                continue;
            }
            this.recordApproveStatus(null, fbi.getBillId(), fbi.getBillNo(), fbi.getBilltype(), paraVo.m_actionName, "noclass");
        }
        end = paraVo.m_preValueVos.length;
        for (start = 0; start < end; ++start) {
            this.refreshHeadTs(paraVo.m_preValueVos[start]);
        }
    }

    private void recordApproveStatus(CheckStatusCallbackContext context, String billid, String billno, String billtype, String actionName, String callbackclass) throws BusinessException {
        IWfstatusRecordService record = (IWfstatusRecordService)NCLocator.getInstance().lookup(IWfstatusRecordService.class);
        record.recordApproveStatus_RequiresNew(context, billid, billno, billtype, actionName, callbackclass);
    }

    @Override
    protected void changeStatusWhenUnapprove(PfParameterVO paraVo, String preCheckman, int iBackCheckState) throws Exception {
        String[] result;
        if (!StringUtil.isEmptyWithTrim((String)preCheckman) && (result = ((IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class)).findLastPostTacheInfo(paraVo)) != null) {
            paraVo.m_workFlow.setChecknote(result[1]);
        }
        if (iBackCheckState != 2 && iBackCheckState != 3 && iBackCheckState != -1) {
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "PFBusiStateOfMeta-000000"));
        }
        this.changeVoStatus(paraVo, iBackCheckState);
    }

    private boolean isNotExistsFlow(PfParameterVO paraVo) {
        return paraVo.m_workFlow == null;
    }

    private boolean isReject(PfParameterVO paraVo) {
        return paraVo.m_workFlow != null && null != paraVo.m_workFlow.getApproveresult() && !"R".equals(paraVo.m_workFlow.getApproveresult());
    }

    protected int changeVoStatusWhenUnapprove(PfParameterVO paraVo, String preCheckman, int iApproveStatus, UFDateTime lastPostTacheBizDate) {
        WorkflownoteVO worknoteVO = paraVo.m_workFlow;
        if (worknoteVO == null) {
            worknoteVO = new WorkflownoteVO();
        }
        int firstBillapproveStatus = -1;
        int end = paraVo.m_preValueVos.length;
        for (int start = 0; start < end; ++start) {
            IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(paraVo.m_preValueVos[start], IFlowBizItf.class);
            fbi.setApproveNote("");
            fbi.setApproveStatus(iApproveStatus);
            if (start != 0) continue;
            firstBillapproveStatus = iApproveStatus;
        }
        return firstBillapproveStatus;
    }

    private UFDateTime getLastPostTacheUFDate(PfParameterVO paraVo) throws BusinessException {
        String processInstancePK = paraVo.m_workFlow.getTaskInfo().getTask().getWfProcessInstancePK();
        String bizTimeStr = null;
        IWorkflowMachine workFlowMachine = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class);
        do {
            String sql = "select modifyTime from pub_wf_task where pk_wf_instance = ? and taskstatus= ? order by modifyTime desc";
            SQLParameter param = new SQLParameter();
            param.addParam(processInstancePK);
            param.addParam(WfTaskOrInstanceStatus.Finished.getIntValue());
            Object[] bizTimes = (Object[])((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).executeQuery(sql, param, (ResultSetProcessor)new ArrayProcessor());
            if (!ArrayUtil.isNull((Object[])bizTimes) && bizTimes[0] != null) {
                bizTimeStr = bizTimes[0].toString();
            }
            if (!StringUtil.isEmptyWithTrim(bizTimeStr)) continue;
            processInstancePK = WorkflowTypeEnum.isSubFlow(paraVo.m_workFlow.getWorkflow_type()) ? workFlowMachine.findParentProcessInstancePK(processInstancePK) : null;
        } while (!StringUtil.isEmptyWithTrim((String)processInstancePK) && StringUtil.isEmptyWithTrim(bizTimeStr));
        return StringUtil.isEmptyWithTrim(bizTimeStr) ? null : new UFDateTime(bizTimeStr);
    }

    private void setPreValueVos(PfParameterVO paraVo) {
        if (paraVo.m_preValueVos == null) {
            AggregatedValueObject[] inVos = null;
            if (paraVo.m_preValueVo != null) {
                try {
                    inVos = PfUtilBaseTools.pfInitVos(paraVo.m_preValueVo.getClass().getName(), 1);
                }
                catch (BusinessException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
                inVos[0] = paraVo.m_preValueVo;
            }
            paraVo.m_preValueVos = inVos;
        }
    }
}

