/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import nc.bs.framework.cluster.impl.ClusterMessageFacade;
import nc.bs.framework.cluster.itf.BytesClusterMessage;
import nc.bs.framework.cluster.itf.ClusterMessage;
import nc.bs.framework.cluster.itf.ClusterMessageHeader;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.framework.exception.ClusterServiceException;
import nc.bs.logging.Logger;

public class PFClusterTools {
    public static final String CLUSTER_MSG_HEADER_FILENAME = "fileName";
    public static final String CLUSTER_MSG_HEADER_FILETYPE = "fileType";
    public static final String CLUSTER_MSG_HEADER_MODULE = "module";
    public static final String CLUSTER_MSG_HEADER_PATH = "relativePath";
    public static final String CLUSTER_MSG_HEADER_TS = "ts";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clusterFile(String relativePath, String fileName, String module) {
        Logger.debug((Object)">>\u6d41\u7a0b\u5e73\u53f0\u96c6\u7fa4\u6d88\u606f\u53d1\u9001\u5f00\u59cb");
        String strFile = RuntimeEnv.getInstance().getNCHome() + relativePath + fileName;
        File file = new File(strFile);
        if (!file.exists()) {
            Logger.warn((Object)(">>\u6587\u4ef6=" + strFile + "\u5e76\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u96c6\u7fa4\u5316\u6587\u4ef6\u3002"));
            return;
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[bis.available()];
            bis.read(bytes);
            BytesClusterMessage message = new BytesClusterMessage();
            ClusterMessageHeader header = new ClusterMessageHeader(CLUSTER_MSG_HEADER_FILETYPE, "PF");
            message.addHeader(header);
            ClusterMessageHeader header2 = new ClusterMessageHeader(CLUSTER_MSG_HEADER_FILENAME, fileName);
            message.addHeader(header2);
            ClusterMessageHeader header3 = new ClusterMessageHeader(CLUSTER_MSG_HEADER_TS, String.valueOf(file.lastModified()));
            message.addHeader(header3);
            ClusterMessageHeader header4 = new ClusterMessageHeader(CLUSTER_MSG_HEADER_PATH, relativePath);
            message.addHeader(header4);
            if (module != null) {
                ClusterMessageHeader header5 = new ClusterMessageHeader(CLUSTER_MSG_HEADER_MODULE, module);
                message.addHeader(header5);
            }
            message.setBytes(bytes);
            ClusterMessageFacade.sendMessage((ClusterMessage)message);
            Logger.debug((Object)(">>\u6d41\u7a0b\u5e73\u53f0\u96c6\u7fa4\u6d88\u606f\u53d1\u9001\u7ed3\u675f=" + strFile));
        }
        catch (FileNotFoundException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClusterServiceException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != bis) {
                try {
                    bis.close();
                }
                catch (IOException e2) {
                    Logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
                bis = null;
            }
        }
    }
}

