/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.mobile;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.bs.framework.common.InvocationInfo;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pub.pf.PfMailAndSMSUtil;
import nc.bs.pub.pf.PfMessageUtil;
import nc.bs.pub.pf.mailapprove.MailApproveUtil;
import nc.bs.pub.pf.tx.TxCompletionChecker;
import nc.bs.uap.scheduler.ITask;
import nc.bs.uap.scheduler.ITaskBody;
import nc.bs.uap.scheduler.ITaskJudger;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.ml.DataMultiLangAccessor;
import nc.itf.uap.pf.IPFConfig;
import nc.itf.uap.pf.IPFMessage;
import nc.itf.uap.pf.IPFMessageMetaService;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.itf.uap.rbac.IUserManageQuery;
import nc.pubitf.rbac.IUserPubService;
import nc.vo.bd.psn.PsndocVO;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.msg.MessageMetaVO;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.msg.EmailMsg;
import nc.vo.pub.pf.MailApproveTemplateConfigVO;
import nc.vo.pub.pf.Pfi18nTools;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.sm.UserVO;
import nc.vo.uap.pf.PFBusinessException;
import nc.vo.uap.scheduler.TaskStatus;
import nc.vo.uap.scheduler.TimeConfigVO;
import nc.vo.wfengine.core.util.DateUtilities;
import nc.vo.wfengine.core.workflow.MailModal;
import nc.vo.wfengine.pub.WfTaskType;
import nccloud.impl.platform.common.util.StringUtils;

public class PfEmailSendTask
implements ITask {
    private EmailMsg emailMsg;
    private TimeConfigVO m_tc;

    public PfEmailSendTask(EmailMsg em) {
        this.emailMsg = em;
    }

    public String getName() {
        return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "PfEmailSendTask-000000");
    }

    public String getType() {
        return "PfEmailSendTask";
    }

    public ITaskJudger getTaskJudger() {
        return null;
    }

    public ITaskBody getTaskBody() {
        return new PfEmailSendTaskBody();
    }

    public TimeConfigVO getTimeConfig() {
        if (this.m_tc == null) {
            this.m_tc = new TimeConfigVO();
            this.m_tc.setJustInTime(true, System.currentTimeMillis() + 2000L);
        }
        return this.m_tc;
    }

    private void mailNoApprove(String[] userIds) throws BusinessException {
        IUserManageQuery umq = (IUserManageQuery)NCLocator.getInstance().lookup(IUserManageQuery.class);
        IUAPQueryBS uapQry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        HashMap<String, HashSet<String>> topicEmailsMap = new HashMap<String, HashSet<String>>();
        Map<String, MessageMetaVO> userMetaMap = this.emailMsg.getUserMetaMap();
        ArrayList<MessageMetaVO> metaList = new ArrayList<MessageMetaVO>();
        for (int i = 0; i < userIds.length; ++i) {
            HashSet<String> emailSet;
            String temp;
            String email;
            String userid = userIds[i];
            Logger.debug((Object)(">>userIds[" + i + "]=" + userid));
            UserVO uservo = umq.getUser(userid);
            MessageMetaVO meta = userMetaMap.get(userid);
            PsndocVO psndoc = null;
            if (uservo.getPk_base_doc() != null) {
                psndoc = (PsndocVO)uapQry.retrieveByPK(PsndocVO.class, uservo.getPk_base_doc());
            }
            String string = email = psndoc == null ? null : psndoc.getEmail();
            if (StringUtil.isEmptyWithTrim((String)email)) {
                Logger.error((Object)("**\u627e\u4e0d\u5230\u7528\u6237=" + userIds[i] + ",\u5bf9\u5e94\u7684\u90ae\u4ef6\u5730\u5740"));
                continue;
            }
            String topic = this.emailMsg.getTopic();
            if (this.emailMsg.getTopicCallback() != null && !StringUtil.isEmptyWithTrim((String)(temp = this.emailMsg.getTopicCallback().getLocalizedMsg(userIds[i])))) {
                topic = temp;
            }
            if ((emailSet = (HashSet<String>)topicEmailsMap.get(topic)) == null) {
                emailSet = new HashSet<String>();
                topicEmailsMap.put(topic, emailSet);
            }
            emailSet.add(email);
            meta.setMessage_type("email-notice");
            meta.setTitle(topic);
            metaList.add(meta);
        }
        if (topicEmailsMap.size() > 0) {
            String templateid = this.getRealTemplateid(this.emailMsg.getPrintTempletId());
            String billHtml = ((IPFMessage)NCLocator.getInstance().lookup(IPFMessage.class)).generateBillHtml(this.emailMsg.getBillId(), this.emailMsg.getBillType(), templateid, this.emailMsg.getSenderman());
            for (String topic : topicEmailsMap.keySet()) {
                Set emails = (Set)topicEmailsMap.get(topic);
                PfMailAndSMSUtil.sendEmailsWithoutApprove(billHtml, emails.toArray(new String[0]), topic, this.emailMsg.getBillId());
            }
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metaList);
        }
    }

    private String getRealTemplateid(String soCalledTemplateid) throws BusinessException {
        String langcode;
        if (StringUtils.isBlank((String)soCalledTemplateid)) {
            return null;
        }
        MailApproveTemplateConfigVO config = MailApproveTemplateConfigVO.deserialize(soCalledTemplateid);
        String realId = config.getTemplateid(langcode = InvocationInfoProxy.getInstance().getLangCode());
        if (realId == null) {
            realId = config.getTemplateid(DataMultiLangAccessor.getInstance().getDefaultLang().getLangcode());
        }
        return realId;
    }

    private void mailWithApprove(String[] userIds) throws BusinessException {
        Logger.debug((Object)">>mailWithApprove() called");
        Logger.debug((Object)(">>EmailMsg.billNo=" + this.emailMsg.getBillNo()));
        if (WfTaskType.Makebill.getIntValue() == this.emailMsg.getTasktype()) {
            Logger.debug((Object)"\u53d1\u9001\u7ed9\u5236\u5355\u4eba\u7684\u9a73\u56de\u90ae\u4ef6\uff0c\u65e0\u9700\u4ea4\u4e92\u529f\u80fd");
            this.mailNoApprove(userIds);
        } else {
            Logger.debug((Object)"\u53d1\u9001\u7ed9\u5ba1\u6279\u4eba\u7684\u5ba1\u6279\u90ae\u4ef6\uff0c\u5177\u6709\u4ea4\u4e92\u529f\u80fd");
            IUserPubService userService = (IUserPubService)NCLocator.getInstance().lookup(IUserPubService.class);
            IWorkflowMachine machine = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class);
            IPFConfig pfConf = (IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class);
            IUAPQueryBS uapQry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
            Logger.debug((Object)"\u68c0\u67e5\u5355\u636e\u7c7b\u578b\u6ce8\u518c\u7684\u5ba1\u6279\u6d41\u68c0\u67e5\u7c7b\u662f\u5426\u5b9e\u73b0\u4e86\u6253\u5370\u6570\u636e\u6e90\u83b7\u53d6\u63a5\u53e3");
            String templateid = this.getRealTemplateid(this.emailMsg.getPrintTempletId());
            String billHtml = ((IPFMessage)NCLocator.getInstance().lookup(IPFMessage.class)).generateBillHtml(this.emailMsg.getBillId(), this.emailMsg.getBillType(), templateid, this.emailMsg.getSenderman());
            if (billHtml == null) {
                billHtml = "";
            }
            Map<String, MessageMetaVO> userMetaMap = this.emailMsg.getUserMetaMap();
            ArrayList<MessageMetaVO> metaList = new ArrayList<MessageMetaVO>();
            for (int i = 0; i < (userIds == null ? 0 : userIds.length); ++i) {
                String userid = userIds[i];
                Logger.debug((Object)(">>userIds[" + i + "]=" + userid));
                MessageMetaVO meta = userMetaMap.get(userid);
                try {
                    String email;
                    PsndocVO psndoc = (PsndocVO)uapQry.retrieveByPK(PsndocVO.class, userService.queryPsndocByUserid(userIds[i]));
                    String string = email = psndoc == null ? null : psndoc.getEmail();
                    if (StringUtil.isEmptyWithTrim((String)email)) {
                        Logger.error((Object)("**\u627e\u4e0d\u5230\u7528\u6237=" + userIds[i] + ",\u5bf9\u5e94\u7684\u90ae\u4ef6\u5730\u5740"));
                        continue;
                    }
                    AggregatedValueObject billVo = pfConf.queryBillDataVO(this.emailMsg.getBillType(), this.emailMsg.getBillId());
                    if (billVo == null) {
                        throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "PfEmailSendTask-000001"));
                    }
                    Date date = new Date();
                    String currentDate = DateUtilities.getInstance().formatJustDay(date);
                    Logger.debug((Object)">>\u83b7\u5f97\u6307\u6d3e\u4fe1\u606f");
                    HashMap<String, String> hmPfExParams = new HashMap<String, String>();
                    hmPfExParams.put("nolockandconsist", "nolockandconsist");
                    WorkflownoteVO worknoteVO = machine.checkWorkFlow("APPROVE" + userIds[i], this.emailMsg.getBillType(), billVo, hmPfExParams);
                    String topic = PfMessageUtil.getI18NMessageNoteForUser(worknoteVO.getMessagenote(), userIds[i]);
                    Logger.debug((Object)(">>\u53d1\u9001\u5ba1\u6279\u90ae\u4ef6=" + email));
                    PfMailAndSMSUtil.sendEmailWithApprove(billHtml, email, this.emailMsg.getBillId(), this.emailMsg.getBillType(), topic, userIds[i], worknoteVO == null ? null : worknoteVO.getTaskInfo().getAssignableInfos(), MailApproveUtil.extractApproveBtnInfo(worknoteVO), worknoteVO == null ? null : worknoteVO.getPk_checkflow());
                    meta.setTitle(topic);
                    meta.setMessage_type("email-approve");
                    metaList.add(meta);
                    continue;
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metaList);
        }
    }

    private void mailCopySend(String html, String[] userIds, String mailContent) throws BusinessException {
        IUserManageQuery umq = (IUserManageQuery)NCLocator.getInstance().lookup(IUserManageQuery.class);
        IUAPQueryBS uapQry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        HashMap<String, ArrayList<String>> topicEmailsMap = new HashMap<String, ArrayList<String>>();
        Map<String, MessageMetaVO> userMetaMap = this.emailMsg.getUserMetaMap();
        ArrayList<MessageMetaVO> metaList = new ArrayList<MessageMetaVO>();
        for (int i = 0; i < userIds.length; ++i) {
            ArrayList<String> emailList;
            String temp;
            String email;
            String userid = userIds[i];
            Logger.debug((Object)(">>userIds[" + i + "]=" + userid));
            UserVO uservo = umq.getUser(userid);
            MessageMetaVO meta = userMetaMap.get(userid);
            PsndocVO psndoc = null;
            if (uservo.getPk_base_doc() != null) {
                psndoc = (PsndocVO)uapQry.retrieveByPK(PsndocVO.class, uservo.getPk_base_doc());
            }
            String string = email = psndoc == null ? null : psndoc.getEmail();
            if (StringUtil.isEmptyWithTrim((String)email)) {
                Logger.error((Object)("**\u627e\u4e0d\u5230\u7528\u6237=" + userIds[i] + ",\u5bf9\u5e94\u7684\u90ae\u4ef6\u5730\u5740"));
                continue;
            }
            String topic = this.emailMsg.getTopic();
            if (this.emailMsg.getTopicCallback() != null && !StringUtil.isEmptyWithTrim((String)(temp = this.emailMsg.getTopicCallback().getLocalizedMsg(userIds[i])))) {
                topic = temp;
            }
            if ((emailList = (ArrayList<String>)topicEmailsMap.get(topic)) == null) {
                emailList = new ArrayList<String>();
                topicEmailsMap.put(topic, emailList);
            }
            emailList.add(email);
            meta.setMessage_type("email-notice");
            meta.setTitle(topic);
            metaList.add(meta);
        }
        if (topicEmailsMap.size() > 0) {
            for (String topic : topicEmailsMap.keySet()) {
                List emails = (List)topicEmailsMap.get(topic);
                PfMailAndSMSUtil.sendCopySendEmailsWithoutApprove(html, emails.toArray(new String[0]), topic, mailContent, this.emailMsg.getBillId());
            }
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metaList);
        }
    }

    class PfEmailSendTaskBody
    implements ITaskBody {
        PfEmailSendTaskBody() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws BusinessException {
            Logger.debug((Object)">>\u90ae\u4ef6\u53d1\u9001\u4efb\u52a1\u4f53:PfEmailSendTaskBody.execute() called");
            Logger.debug((Object)("\u4f7f\u7528\u8bed\u79cd\u4fe1\u606f=" + PfEmailSendTask.this.emailMsg.getLangCode()));
            Logger.debug((Object)("\u4f7f\u7528\u6570\u636e\u6e90\u4fe1\u606f=" + PfEmailSendTask.this.emailMsg.getDatasource()));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Logger.debug((Object)e.getMessage());
            }
            InvocationInfo info = PfEmailSendTask.this.emailMsg.getInvocationInfo();
            if (info != null) {
                InvocationInfoProxy.getInstance().setBizDateTime(info.getBizDateTime());
                InvocationInfoProxy.getInstance().setGroupId(info.getGroupId());
                InvocationInfoProxy.getInstance().setGroupNumber(info.getGroupNumber());
                InvocationInfoProxy.getInstance().setLangCode(info.getLangCode());
                InvocationInfoProxy.getInstance().setUserDataSource(info.getUserDataSource());
                InvocationInfoProxy.getInstance().setUserId(info.getUserId());
            } else {
                InvocationInfoProxy.getInstance().setLangCode(PfEmailSendTask.this.emailMsg.getLangCode());
                InvocationInfoProxy.getInstance().setUserDataSource(PfEmailSendTask.this.emailMsg.getDatasource());
            }
            String txMark = PfEmailSendTask.this.emailMsg.getTxMark();
            if (!StringUtil.isEmptyWithTrim((String)txMark) && !TxCompletionChecker.getInstance().isTxCompleted(txMark)) {
                return;
            }
            String[] userIds = PfEmailSendTask.this.emailMsg.getUserIds();
            Map<String, List<String>> langUserlistMap = Pfi18nTools.classifyUsersByLangcode(userIds);
            String originLang = InvocationInfoProxy.getInstance().getLangCode();
            try {
                for (String lang : langUserlistMap.keySet()) {
                    List<String> userList = langUserlistMap.get(lang);
                    InvocationInfoProxy.getInstance().setLangCode(lang);
                    boolean isCopySend = PfEmailSendTask.this.emailMsg.isCopySend();
                    if (isCopySend) {
                        Logger.debug((Object)"\u90ae\u4ef6\u6284\u9001\uff1a\u65e0\u4ea4\u4e92\u529f\u80fd\u7684\u90ae\u4ef6\uff0c\u6279\u91cf\u53d1\u9001");
                        PfEmailSendTask.this.mailCopySend(PfEmailSendTask.this.emailMsg.getCopySendHtml(), userList.toArray(new String[0]), PfEmailSendTask.this.emailMsg.getCopySendContent());
                        continue;
                    }
                    MailModal mailModal = PfEmailSendTask.this.emailMsg.getMailModal();
                    if (1 == mailModal.getValue()) {
                        Logger.debug((Object)"\u90ae\u4ef6\u901a\u77e5\uff1a\u65e0\u4ea4\u4e92\u529f\u80fd\u7684\u90ae\u4ef6\uff0c\u6279\u91cf\u53d1\u9001");
                        PfEmailSendTask.this.mailNoApprove(userList.toArray(new String[0]));
                        continue;
                    }
                    if (2 != mailModal.getValue()) continue;
                    Logger.debug((Object)"\u90ae\u4ef6\u5ba1\u6279\uff1a\u6709\u4ea4\u4e92\u529f\u80fd\u7684\u90ae\u4ef6\uff0c\u5fc5\u987b\u5355\u72ec\u53d1\u7ed9\u6bcf\u4e2a\u7528\u6237");
                    PfEmailSendTask.this.mailWithApprove(userList.toArray(new String[0]));
                }
            }
            finally {
                InvocationInfoProxy.getInstance().setLangCode(originLang);
            }
            Logger.debug((Object)">>\u90ae\u4ef6\u53d1\u9001\u4efb\u52a1\u4f53:PfEmailSendTaskBody.execute() end");
        }

        public void cancelExecute() throws BusinessException {
        }

        public TaskStatus getStatus() {
            return null;
        }
    }
}

