/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.mobile;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.framework.server.util.NewObjectService;
import nc.bs.logging.Logger;
import nc.bs.pub.mobile.MobilePluginBase;
import nc.bs.pub.mobile.ShortMessageService;
import nc.bs.pub.mobile.WirelessManager;
import nc.bs.pub.pf.PfMailAndSMSUtil;
import nc.bs.uap.sf.excp.MailException;
import nc.itf.uap.IUAPQueryBS;
import nc.vo.bd.psn.PsndocVO;
import nc.vo.framework.rsa.Encode;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.OrgVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.mobile.MobileConfig;
import nc.vo.pub.mobile.MobileData;
import nc.vo.pub.mobile.MobileException;
import nc.vo.pub.mobile.MobileImplInfo;
import nc.vo.pub.mobile.MobilePluginVO;
import nc.vo.sm.UserVO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import uap.apppf.util.SQLTransferMeaningUtil;

public class MobileHandler {
    private static MobileHandler instance = new MobileHandler();
    static final String CONFIG_FILE = RuntimeEnv.getInstance().getNCHome() + "/ierp/bin/mobileplugin.xml";
    public static final String CMD_DELIMITER = "####";
    public static final String OPTIONS_DELIMITER = "@@@@";
    private static MobileConfig m_mobileConfig;

    private MobileHandler() {
    }

    public static MobileHandler getInstance() {
        return instance;
    }

    @Deprecated
    public static synchronized MobileConfig getMobileConfig() {
        if (m_mobileConfig != null) {
            return m_mobileConfig;
        }
        XStream xs = MobileHandler.getAliasXstream();
        FileReader fr = null;
        try {
            fr = new FileReader(CONFIG_FILE);
            m_mobileConfig = (MobileConfig)xs.fromXML((Reader)fr);
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return m_mobileConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMobileConfig(MobileConfig mc) {
        XStream xs = MobileHandler.getAliasXstream();
        FileWriter fw = null;
        try {
            fw = new FileWriter(CONFIG_FILE);
            xs.toXML((Object)mc, (Writer)fw);
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static XStream getAliasXstream() {
        XStream xs = new XStream();
        xs.addPermission(AnyTypePermission.ANY);
        xs.alias("mobileconfig", MobileConfig.class);
        xs.alias("mobileplugin", MobilePluginVO.class);
        xs.alias("mobileplugins", MobilePluginVO[].class);
        xs.alias("mobileimplinfos", MobileImplInfo[].class);
        xs.alias("mobileimpl", MobileImplInfo.class);
        return xs;
    }

    public void mobileMsgReceived(String phone, String msg, String sid) {
        Logger.debug((Object)">>>MobileHandler.mobileMsgReceived(...) called");
        Logger.debug((Object)"*********************************************");
        Logger.debug((Object)("* phone=" + phone));
        Logger.debug((Object)("* msg=" + msg));
        Logger.debug((Object)("* pk_sid=" + sid));
        Logger.debug((Object)"*********************************************");
        if (phone == null || msg == null) {
            return;
        }
        HashMap hmOptionValue = new HashMap();
        String strCmd = "";
        try {
            strCmd = this.checkOptions(msg, hmOptionValue);
            this.regDataSourceForServlet(hmOptionValue);
            MobilePluginBase mobileplugin = null;
            mobileplugin = this.initCurrentPlugin(strCmd, hmOptionValue);
            this.checkUserAndCorpByPhone(phone, mobileplugin, hmOptionValue);
            String retStr = mobileplugin.dealMobileMsg();
            if (mobileplugin.shouldDeleteSid()) {
                try {
                    BaseDAO dao = new BaseDAO();
                    dao.deleteByClause(MobileData.class, "mobile='" + phone + "' and pk_sid='" + sid + "'");
                }
                catch (DAOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (retStr != null) {
                this.sendMessage(phone, retStr);
            }
        }
        catch (MobileException e) {
            Logger.error((Object)e.getMessage(), (Throwable)((Object)e));
            this.sendMessage(phone, e.getMessage());
            throw new RuntimeException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void emailMsgReceived(String emailAddr, String subject) {
        Logger.info((Object)"========================");
        Logger.info((Object)"\u8fdb\u5165MobileHandler.emailMsgReceived");
        Logger.info((Object)("emailAddr\uff1a" + emailAddr));
        Logger.info((Object)("subject\uff1a" + subject));
        Logger.info((Object)"========================");
        HashMap hmOptionValue = new HashMap();
        String strCmd = "";
        try {
            strCmd = this.checkOptions(subject, hmOptionValue);
            this.regDataSourceForServlet(hmOptionValue);
            MobilePluginBase mobileplugin = null;
            mobileplugin = this.initCurrentPlugin(strCmd, hmOptionValue);
            this.checkUserAndCorpByEmail(emailAddr, mobileplugin, hmOptionValue);
            String retStr = mobileplugin.dealMobileMsg();
            if (retStr != null) {
                PfMailAndSMSUtil.sendEmail(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000000"), retStr, new String[]{emailAddr}, null, null);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            try {
                PfMailAndSMSUtil.sendEmail(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000000"), e.getMessage(), new String[]{emailAddr}, null, null);
            }
            catch (MailException mailException) {
                // empty catch block
            }
        }
    }

    private void sendMessage(String phone, String message) {
        ShortMessageService sms = WirelessManager.getSMS();
        if (sms == null) {
            Logger.error((Object)">>\u627e\u4e0d\u5230\u6d3b\u52a8\u7684\u77ed\u4fe1\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c\u65e0\u6cd5\u53d1\u9001\u548c\u63a5\u6536\u77ed\u4fe1");
            return;
        }
        if (!sms.initialize()) {
            Logger.error((Object)">>\u77ed\u4fe1\u670d\u52a1\u521d\u59cb\u5316\u5931\u8d25");
            return;
        }
        sms.sendMessage(phone, message);
    }

    private String checkOptions(String strMsg, HashMap hmOptionValues) throws MobileException {
        Logger.info((Object)("\u8fdb\u5165MobileHandler.checkOptions strMsg: " + strMsg));
        int cmdIndex = strMsg.indexOf(CMD_DELIMITER);
        if (cmdIndex < 1) {
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000001", null, new String[]{strMsg}));
        }
        String strCmd = strMsg.substring(0, cmdIndex);
        String strOptions = strMsg.substring(cmdIndex + CMD_DELIMITER.length());
        StringTokenizer st = new StringTokenizer(strOptions, OPTIONS_DELIMITER);
        String[] tokens = new String[st.countTokens()];
        int j = 0;
        while (st.hasMoreTokens()) {
            tokens[j] = st.nextToken();
            ++j;
        }
        Options _options = new Options().addOption("u", true, "usercode").addOption("p", true, "password").addOption("a", true, "account").addOption("c", true, "unitcode").addOption("d", true, "logindate");
        PosixParser _parser = new PosixParser();
        Logger.info((Object)("\u8fdb\u5165MobileHandler.checkOptions _options: " + _options));
        Logger.info((Object)("\u8fdb\u5165MobileHandler.checkOptions tokens: " + tokens));
        try {
            CommandLine cl = _parser.parse(_options, tokens);
            hmOptionValues.put("p", cl.getOptionValue("p"));
            hmOptionValues.put("u", cl.getOptionValue("u"));
            hmOptionValues.put("a", cl.getOptionValue("a"));
            hmOptionValues.put("d", cl.getOptionValue("d"));
            hmOptionValues.put("c", cl.getOptionValue("c"));
            hmOptionValues.put("ARGS", cl.getArgs());
        }
        catch (ParseException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000002"));
        }
        return strCmd;
    }

    private void checkUserAndCorpByEmail(String emailAddr, MobilePluginBase mpb, HashMap hmOptionValue) throws MobileException {
        try {
            Collection coCorps;
            String unitCode = (String)hmOptionValue.get("c");
            String pkCorp = null;
            if (unitCode != null && (coCorps = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveByClause(OrgVO.class, "unitcode='" + SQLTransferMeaningUtil.tmsql((String)unitCode) + "'")).size() > 0) {
                OrgVO voCorp = (OrgVO)coCorps.iterator().next();
                pkCorp = voCorp.getPrimaryKey();
                mpb.setPkCorp(pkCorp);
            }
            Collection psnVOs = new BaseDAO().retrieveByClause(PsndocVO.class, "email ='" + emailAddr + "'");
            this.checkPsndoc(mpb, hmOptionValue, psnVOs.toArray(new PsndocVO[0]));
        }
        catch (MobileException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000003"), e);
        }
    }

    private void checkPsndoc(MobilePluginBase mpb, HashMap hmOptionValue, PsndocVO[] psnVOs) throws MobileException, BusinessException {
        if (psnVOs == null || psnVOs.length == 0) {
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000004"));
        }
        ArrayList<PsndocVO> alFoundPsns = new ArrayList<PsndocVO>();
        ArrayList<UserVO> alFoundUsers = new ArrayList<UserVO>();
        String userCode = (String)hmOptionValue.get("u");
        if (psnVOs.length > 1) {
            for (int i = 0; i < psnVOs.length; ++i) {
                PsndocVO docVO = psnVOs[i];
                Collection colUser = new BaseDAO().retrieveByClause(UserVO.class, "pk_base_doc ='" + docVO.getPrimaryKey() + "'");
                if (colUser == null) continue;
                for (UserVO userVO : colUser) {
                    if (!userVO.getUser_code().equals(userCode) && userCode != null) continue;
                    alFoundUsers.add(userVO);
                    if (alFoundPsns.contains(docVO)) continue;
                    alFoundPsns.add(docVO);
                }
            }
        } else {
            PsndocVO docVO = psnVOs[0];
            alFoundPsns.add(docVO);
            Collection colUser = new BaseDAO().retrieveByClause(UserVO.class, "pk_base_doc ='" + docVO.getPrimaryKey() + "'");
            if (colUser != null) {
                for (UserVO userVO : colUser) {
                    if (!userVO.getUser_code().equals(userCode) && userCode != null) continue;
                    alFoundUsers.add(userVO);
                }
            }
        }
        if (alFoundUsers.size() == 0) {
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000005"));
        }
        if (alFoundUsers.size() > 1) {
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000006"));
        }
        UserVO uVO = (UserVO)alFoundUsers.get(0);
        if (mpb.isNeedValidatePwd()) {
            Encode rsa = new Encode();
            String pwd = (String)hmOptionValue.get("p");
            if (StringUtil.isEmptyWithTrim((String)pwd)) {
                throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000007"));
            }
            String rsaPwd = rsa.encode(pwd);
            if (!rsaPwd.equals(uVO.getUser_password())) {
                throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000008"));
            }
        }
        mpb.setPkPsndoc(((PsndocVO)alFoundPsns.get(0)).getPrimaryKey());
        mpb.setPkUser(uVO.getPrimaryKey());
    }

    private void checkUserAndCorpByPhone(String phone, MobilePluginBase mpb, HashMap hmOptionValue) throws MobileException {
        try {
            Collection coCorps;
            String unitCode = (String)hmOptionValue.get("c");
            String pkCorp = null;
            if (unitCode != null && (coCorps = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveByClause(OrgVO.class, "unitcode='" + SQLTransferMeaningUtil.tmsql((String)unitCode) + "'")).size() > 0) {
                OrgVO voCorp = (OrgVO)coCorps.iterator().next();
                pkCorp = voCorp.getPrimaryKey();
                mpb.setPkCorp(pkCorp);
            }
            Collection psnVOs = new BaseDAO().retrieveByClause(PsndocVO.class, "mobile ='" + phone + "'");
            this.checkPsndoc(mpb, hmOptionValue, psnVOs.toArray(new PsndocVO[0]));
        }
        catch (MobileException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000003"), e);
        }
    }

    private void regDataSourceForServlet(HashMap hmOptionValue) throws MobileException {
        String dsName = null;
        String accountCode = (String)hmOptionValue.get("a");
        if (accountCode != null) {
            // empty if block
        }
        MobileConfig mc = MobileHandler.getMobileConfig();
        dsName = mc.getDatasource();
        InvocationInfoProxy.getInstance().setUserDataSource(dsName);
    }

    private MobilePluginBase initCurrentPlugin(String command, HashMap hmOptionValue) throws MobileException {
        MobileConfig mc = MobileHandler.getMobileConfig();
        MobilePluginVO selectedPluginVO = null;
        MobilePluginVO[] mps = mc.getMobilePlugins();
        for (int i = 0; i < mps.length; ++i) {
            List<String> lComms = Arrays.asList(mps[i].getCommands());
            if (!lComms.contains(command)) continue;
            selectedPluginVO = mps[i];
            break;
        }
        if (selectedPluginVO == null) {
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000010", null, new String[]{command}));
        }
        MobilePluginBase mpb = null;
        try {
            mpb = (MobilePluginBase)NewObjectService.newInstance((String)selectedPluginVO.getModule(), (String)selectedPluginVO.getClassname());
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (mpb == null) {
            throw new MobileException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "MobileHandler-000011"));
        }
        mpb.setCommand(command);
        mpb.setLoginDate((String)hmOptionValue.get("d"));
        mpb.setParams((String[])hmOptionValue.get("ARGS"));
        return mpb;
    }
}

