/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.workflow.def;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.itf.uap.pf.workflow.IWFActivityFuncodeService;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.pub.WFTask;
import nccloud.commons.lang.StringUtils;
import nccloud.putitf.riart.billtype.IBillRelatedAppService;
import nccloud.putitf.riart.billtype.ITranstypePublishAppService;

public class WFFuncodeUtil {
    public static String getActivityFuncode(WorkflownoteVO noteVO) {
        String pk_wf_task = noteVO.getPk_wf_task();
        if (pk_wf_task == null) {
            Logger.debug((Object)"pk_wf_task is null where get activity funcode");
            return "";
        }
        IWorkflowMachine service = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class);
        WFTask task = null;
        try {
            task = service.getWFTask(pk_wf_task);
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String funcode = WFFuncodeUtil.getActivityFuncode(task, noteVO.getPk_billtype());
        if (funcode == null) {
            return "";
        }
        return funcode;
    }

    public static String[] getActivityFuncode(WorkflownoteVO[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        String[] result = new String[array.length];
        ArrayList<String> wfTaskpks = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            String pk_wf_task = array[i].getPk_wf_task();
            if (pk_wf_task == null || "".equalsIgnoreCase(pk_wf_task)) continue;
            wfTaskpks.add(pk_wf_task);
        }
        if (wfTaskpks.size() > 0) {
            IWorkflowMachine service = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class);
            try {
                List<WFTask> wfTasks = service.getWFTasks(wfTaskpks);
                for (int i = 0; i < array.length; ++i) {
                    String pk_wf_task = array[i].getPk_wf_task();
                    String Pk_billtype = array[i].getPk_billtype();
                    WFTask task = null;
                    String funcode = null;
                    for (int j = 0; j < wfTasks.size(); ++j) {
                        if (!pk_wf_task.equalsIgnoreCase(wfTasks.get(j).getTaskPK())) continue;
                        task = wfTasks.get(j);
                        break;
                    }
                    if (task != null) {
                        funcode = WFFuncodeUtil.getActivityFuncode(task, Pk_billtype);
                    }
                    if (funcode == null) {
                        funcode = "";
                    }
                    result[i] = funcode;
                }
            }
            catch (BusinessException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static String getActivityFuncode(WFTask task, String billType) {
        String funcode = null;
        String targetActId = task.getActivityID();
        String pk_wf_def = task.getWfProcessDefPK();
        BasicWorkflowProcess process = null;
        try {
            process = PfDataCache.getWorkflowProcess(pk_wf_def);
        }
        catch (XPDLParserException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            BilltypeVO btvo = null;
            if (StringUtils.isNotEmpty((CharSequence)billType)) {
                btvo = PfDataCache.getBillTypeInfo(InvocationInfoProxy.getInstance().getGroupId(), PfUtilBaseTools.getRealBilltype(billType));
            }
            if (btvo != null && btvo.getIsLightBill() != null && btvo.getIsLightBill().toString().equals("Y")) {
                Activity act = process.findActivityByID(targetActId);
                if (act instanceof GenericActivityEx) {
                    funcode = ((GenericActivityEx)act).getNccAppcode();
                }
                if ("DEFAULT_MAKEBILL_FUNCODE".equals(funcode)) {
                    funcode = WFFuncodeUtil.handleDefaultAppcode(billType);
                }
            } else {
                Activity act = process.findActivityByID(targetActId);
                if (act instanceof GenericActivityEx) {
                    funcode = ((GenericActivityEx)act).getFuncode();
                }
                if ("DEFAULT_MAKEBILL_FUNCODE".equals(funcode)) {
                    funcode = WFFuncodeUtil.handleDefaultFuncode(billType);
                }
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return funcode;
    }

    public static String handleDefaultFuncode(String billOrTranType) throws BusinessException {
        IWFActivityFuncodeService service = (IWFActivityFuncodeService)NCLocator.getInstance().lookup(IWFActivityFuncodeService.class);
        String funcode = null;
        if (PfUtilBaseTools.isTranstype(billOrTranType)) {
            funcode = service.queryMakeBillFuncode(billOrTranType);
            if (StringUtil.isEmpty((String)funcode)) {
                BilltypeVO transTypeVO = PfDataCache.getBillType(billOrTranType);
                String parentBillType = transTypeVO.getParentbilltype();
                funcode = service.queryMakeBillFuncode(parentBillType);
            }
        } else {
            funcode = service.queryMakeBillFuncode(billOrTranType);
        }
        return funcode;
    }

    public static String handleDefaultAppcode(String billOrTranType) throws BusinessException {
        IBillRelatedAppService service = (IBillRelatedAppService)NCLocator.getInstance().lookup(IBillRelatedAppService.class);
        String appcode = null;
        if (PfUtilBaseTools.isTranstype(billOrTranType)) {
            ITranstypePublishAppService publish = (ITranstypePublishAppService)NCLocator.getInstance().lookup(ITranstypePublishAppService.class);
            appcode = publish.queryPublishApproveAppCode(billOrTranType);
            if (StringUtil.isEmpty((String)appcode)) {
                BilltypeVO transTypeVO = PfDataCache.getBillType(billOrTranType);
                String parentBillType = transTypeVO.getParentbilltype();
                Map<String, String> map = service.queryApproveAppInfo(null, billOrTranType);
                appcode = map.get("appcode");
            }
        } else {
            Map<String, String> map = service.queryApproveAppInfo(null, billOrTranType);
            appcode = map.get("appcode");
        }
        return appcode;
    }
}

