/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.pub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.impl.pubapp.pattern.database.IDExQueryBuilder;
import nc.itf.uap.IUAPQueryBS;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ArrayListProcessor;
import nc.jdbc.framework.processor.ArrayProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.ui.bd.ref.AbstractRefModel;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.pub.util.SQLUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.participant.ParticipantItem;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.uap.pf.OrganizeUnitTypes;
import nc.vo.uap.pf.refmodel.OrganizeUnitRefModelUtil;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.participant.Participant;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;

public class PfHistoryMsgUtil {
    public static BasicWorkflowProcess getBWFProcess(WorkflownoteVO noteVO) {
        SQLParameter param = new SQLParameter();
        param.addParam(noteVO.getPk_checkflow());
        String sql = "select i.processdefid from pub_workflownote n join pub_wf_task k on n.pk_wf_task=k.pk_wf_task join pub_wf_instance i on k.pk_wf_instance=i.pk_wf_instance where pk_checkflow=?";
        IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        Object[] result = null;
        BasicWorkflowProcess p = null;
        try {
            result = (Object[])qry.executeQuery(sql, param, (ResultSetProcessor)new ArrayProcessor());
            if (result != null) {
                String processdef = (String)result[0];
                p = PfDataCache.getWorkflowProcess(processdef);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return p;
    }

    public static BasicWorkflowProcess getBWFProcess(WorkflownoteVO[] noteVO) {
        ArrayList<String> pk = new ArrayList<String>();
        for (WorkflownoteVO vo : noteVO) {
            pk.add(vo.getPk_checkflow());
        }
        String sql = "select i.processdefid from pub_workflownote n join pub_wf_task k on n.pk_wf_task=k.pk_wf_task join pub_wf_instance i on k.pk_wf_instance=i.pk_wf_instance where " + SQLUtil.buildSqlForIn("n.pk_checkflow", pk.toArray(new String[pk.size()]));
        IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        Object[] result = null;
        BasicWorkflowProcess p = null;
        try {
            result = (Object[])qry.executeQuery(sql, (ResultSetProcessor)new ArrayProcessor());
            if (result != null) {
                String processdef = (String)result[0];
                p = PfDataCache.getWorkflowProcess(processdef);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return p;
    }

    public static List<Map> getBWFProcessForReport(List<String> pk) throws BusinessException {
        HashMap<String, BasicWorkflowProcess> mapProcess;
        HashMap<String, String> wfps;
        ArrayList<Map> listmap;
        block6: {
            listmap = new ArrayList<Map>();
            wfps = new HashMap<String, String>();
            mapProcess = new HashMap<String, BasicWorkflowProcess>();
            BasicWorkflowProcess p = null;
            IDExQueryBuilder builder = new IDExQueryBuilder("TEMP_MSGCHECKFLOW_");
            String sqlnpk_checkflow = builder.buildSQL("n.pk_checkflow", pk.toArray(new String[0]));
            String sql = "select i.processdefid,n.pk_checkflow from pub_workflownote n join pub_wf_task k on n.pk_wf_task=k.pk_wf_task join pub_wf_instance i on k.pk_wf_instance=i.pk_wf_instance where " + sqlnpk_checkflow;
            SQLParameter param = new SQLParameter();
            try {
                List result1 = (List)new BaseDAO().executeQuery(sql, param, (ResultSetProcessor)new ArrayListProcessor());
                if (result1 == null || result1.size() <= 0) break block6;
                for (Object[] object : result1) {
                    String processdef = (String)object[0];
                    if (!mapProcess.containsKey((String)object[1])) {
                        wfps.put((String)object[1], (String)object[0]);
                    }
                    if (mapProcess.containsKey(processdef)) continue;
                    try {
                        p = PfDataCache.getWorkflowProcess(processdef);
                    }
                    catch (BusinessException | XPDLParserException e) {
                        throw new BusinessException(e.getMessage());
                    }
                    mapProcess.put(processdef, p);
                }
            }
            catch (DAOException e) {
                throw new BusinessException(e.getMessage());
            }
        }
        listmap.add(wfps);
        listmap.add(mapProcess);
        return listmap;
    }

    public static Activity getActivity(WorkflownoteVO noteVO, BasicWorkflowProcess bwp) {
        SQLParameter param = new SQLParameter();
        param.addParam(noteVO.getPk_checkflow());
        String sql = "select k.activitydefid from pub_workflownote n join pub_wf_task k on n.pk_wf_task=k.pk_wf_task join pub_wf_instance i on k.pk_wf_instance=i.pk_wf_instance where pk_checkflow=?";
        IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        Object[] result = null;
        Activity act = null;
        try {
            result = (Object[])qry.executeQuery(sql, param, (ResultSetProcessor)new ArrayProcessor());
            if (result != null) {
                String activitydef = (String)result[0];
                if (bwp != null) {
                    act = bwp.findActivityByID(activitydef);
                }
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return act;
    }

    public static String getPerformerName(BasicWorkflowProcess p, Activity act) {
        String performerName = null;
        Participant par = p.findParticipantByID(act.getPerformer());
        String performPK = (String)par.getExtendedAttributes().get("OrganizeUnitPK");
        String pType = (String)par.getExtendedAttributes().get("OrganizeUnitType");
        if ("CUSTOMRULE".equals(pType)) {
            performerName = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WFCustomzdygs-0001");
        } else {
            AbstractRefModel refModel = OrganizeUnitRefModelUtil.getRefModel(pType);
            if (refModel == null) {
                performerName = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WFSSCgxfwyh-0001");
            } else {
                Vector vector = refModel.matchPkData(performPK);
                if (vector != null && vector.size() > 0) {
                    Vector rowData = (Vector)vector.get(0);
                    String nameField = refModel.getRefNameField();
                    int nameIndex = refModel.getFieldIndex(nameField);
                    performerName = (String)rowData.get(nameIndex);
                }
            }
        }
        return performerName;
    }

    public static String getPerformerName2(BasicWorkflowProcess p, Activity act, String billtype) {
        String performerName = null;
        Participant par = p.findParticipantByID(act.getPerformer());
        if (par == null) {
            return null;
        }
        String performPK = (String)par.getExtendedAttributes().get("OrganizeUnitPK");
        String pType = (String)par.getExtendedAttributes().get("OrganizeUnitType");
        if ("CUSTOMRULE".equals(pType)) {
            performerName = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WFCustomzdygs-0001");
            return performerName;
        }
        if (pType.startsWith("CUSTOM_")) {
            Map<String, ParticipantItem> participantMap = new OrganizeUnitRefModelUtil().getParticipantMap(billtype);
            ParticipantItem participantItem = participantMap.get(pType);
            performerName = participantItem.getDisplayName();
            return performerName;
        }
        AbstractRefModel refModel = OrganizeUnitRefModelUtil.getRefModel(pType);
        Vector vector = refModel.matchPkData(performPK);
        if (vector != null && vector.size() > 0) {
            Vector rowData = (Vector)vector.get(0);
            String nameField = refModel.getRefNameField();
            int nameIndex = refModel.getFieldIndex(nameField);
            performerName = (String)rowData.get(nameIndex);
        }
        return performerName;
    }

    public static String getPerformerName3(String performPK, String pType, String billtype) {
        String performerName = "";
        if ("CUSTOMRULE".equals(pType)) {
            performerName = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WFCustomzdygs-0001");
        }
        if (pType.startsWith("CUSTOM_")) {
            Map<String, ParticipantItem> participantMap = new OrganizeUnitRefModelUtil().getParticipantMap(billtype);
            ParticipantItem participantItem = participantMap.get(pType);
            performerName = participantItem.getDisplayName();
        } else {
            AbstractRefModel refModel = OrganizeUnitRefModelUtil.getRefModel(pType);
            Vector vector = refModel.matchPkData(performPK);
            if (vector != null && vector.size() > 0) {
                Vector rowData = (Vector)vector.get(0);
                String nameField = refModel.getRefNameField();
                int nameIndex = refModel.getFieldIndex(nameField);
                performerName = (String)rowData.get(nameIndex);
            }
        }
        return performerName;
    }

    public static String getPerformerTypeName(String billType, String performType) {
        if (!performType.startsWith("CUSTOM_")) {
            OrganizeUnitTypes untiType = OrganizeUnitTypes.fetchTypeByTag((String)performType);
            return untiType.showName();
        }
        Map<String, ParticipantItem> participantMap = new OrganizeUnitRefModelUtil().getParticipantMap(billType);
        ParticipantItem participantItem = participantMap.get(performType);
        return participantItem.getDisplayName();
    }
}

