/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.definition;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.ui.wfengine.designer.DesignerMapCache;
import nc.ui.wfengine.designer.cache.DesignerCacheKey;
import nc.vo.pub.lang.MultiLangText;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.wfengine.core.WFElement;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.participant.Participant;
import nc.vo.wfengine.core.serializer.UfXPDLSerializer;
import nc.vo.wfengine.core.util.CoreUtilities;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.ActivityTypeEnum;
import nc.vo.wfengine.definition.WorkflowDefStatusEnum;
import nc.vo.wfengine.definition.WorkflowDefinitionVO;
import nc.vo.wfengine.definition.WorkflowTypeEnum;

public class DefinitionUtil {
    public static WorkflowDefinitionVO processToSuperVo(WorkflowProcess process, String fatherPK, String billType) {
        String pkCorp = InvocationInfoProxy.getInstance().getGroupId();
        DesignerCacheKey key = new DesignerCacheKey(process.getPrimaryKey());
        String pkOrg = (String)DesignerMapCache.Instance().get(key.getPk_orgKey());
        WorkflowDefinitionVO def_vo = new WorkflowDefinitionVO();
        Participant billMakerPart = DefinitionUtil.getBillMakerParticipant(process);
        Object billMakerPK = CoreUtilities.getValueOfExtendedAttr(billMakerPart, "OrganizeUnitPK");
        Object billMakerType = CoreUtilities.getValueOfExtendedAttr(billMakerPart, "OrganizeUnitType");
        def_vo.setBillmaker(billMakerPK == null ? null : billMakerPK.toString());
        def_vo.setBillmaker_name(billMakerPart == null ? null : billMakerPart.getName());
        def_vo.setBillmaker_type(billMakerType == null ? null : billMakerType.toString());
        def_vo.setBilltype(billType);
        def_vo.setPk_billtypeid(PfDataCache.getBillType(billType).getPk_billtypeid());
        List acts = process.getActivities();
        def_vo.setPk_group(pkCorp);
        String pk_org = def_vo.getPk_org();
        pk_org = pk_org == null ? pkOrg : pk_org;
        def_vo.setPk_org(pk_org);
        int workflowType = process.getWorkflowType();
        def_vo.setWorkflow_type(workflowType);
        def_vo.setValidity(WorkflowDefStatusEnum.Init.getIntValue());
        def_vo.setFatherpk(fatherPK);
        def_vo.setProcessdefid(process.getId());
        DefinitionUtil.setName(def_vo, process);
        def_vo.setNode_type(WorkflowTypeEnum.fromIntValue(workflowType).getStrValue());
        Date date = process.getProcessHeader().getCreated();
        def_vo.setCreatedate(new UFDateTime(date));
        def_vo.setPrimaryKey(process.getPrimaryKey());
        def_vo.setVersion(((BasicWorkflowProcess)process).getVersion());
        def_vo.setEmendEnum(((BasicWorkflowProcess)process).getEmendFlow());
        def_vo.setIsSubmitTORejecter(((BasicWorkflowProcess)process).fetchSubmitTORejecter());
        String[] pk_orgs = null;
        ArrayList orgList = ((BasicWorkflowProcess)process).getOrgUnitTree();
        if (orgList != null && orgList.size() != 0) {
            pk_orgs = orgList.toArray(new String[orgList.size()]);
        }
        def_vo.setPk_orgs(pk_orgs);
        String content = "";
        try {
            content = UfXPDLSerializer.getInstance().serialize(process);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        def_vo.setPriority(((BasicWorkflowProcess)process).getPriority());
        def_vo.setSupervisorList(((BasicWorkflowProcess)process).getSupervisor());
        def_vo.setContent(content);
        def_vo.setSubflowIds(process.getSublfowIds());
        def_vo.setFakeid(process.getFakeId());
        return def_vo;
    }

    public static Participant getBillMakerParticipant(WorkflowProcess wp) {
        List acts = wp.getActivities();
        List parts = wp.getParticipants();
        for (int i = 0; i < acts.size(); ++i) {
            Object act = acts.get(i);
            if (!(act instanceof GenericActivityEx) || !((GenericActivityEx)act).getAppId().equals(ActivityTypeEnum.Makebill.getTag())) continue;
            String performerGuid = ((GenericActivityEx)act).getPerformer();
            return DefinitionUtil.getParticipant(performerGuid, parts);
        }
        return null;
    }

    public static Participant getParticipant(String performerGuid, List parts) {
        for (int i = 0; i < parts.size(); ++i) {
            Object obj = parts.get(i);
            if (!((Participant)obj).getId().equals(performerGuid)) continue;
            return (Participant)obj;
        }
        return null;
    }

    public static void setName(WorkflowDefinitionVO defVO, WFElement element) {
        MultiLangText multiLangName = element.getMultiLangName();
        int currLangIndex = multiLangName.getCurrLangIndex();
        if (currLangIndex != 0 && multiLangName.getText() == null) {
            multiLangName.setText(multiLangName.getText(currLangIndex));
        }
        defVO.setNode_name(multiLangName.getText());
        defVO.setNode_name2(multiLangName.getText2());
        defVO.setNode_name3(multiLangName.getText3());
        defVO.setNode_name4(multiLangName.getText4());
        defVO.setNode_name5(multiLangName.getText5());
        defVO.setNode_name6(multiLangName.getText6());
    }
}

