/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.change;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.change.BillSplitHelper;
import nc.bs.pf.pub.PfDataCache;
import nc.itf.uap.pf.IPFConfig;
import nc.itf.uap.pf.IPFSplitBill;
import nc.itf.uap.pf.metadata.IFlowBizItf;
import nc.md.data.access.DASFacade;
import nc.md.data.access.NCObject;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.ChangeVOAdjustContext;
import nc.vo.pf.change.ExchangeRuleVO;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pf.change.SplitItemVO;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.compiler.PfParameterVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.trade.pub.IExAggVO;

public class BillSplitter
implements IPFSplitBill {
    public static final String SEPARATOR_CH = "#";
    public static final String TIMESPACE_LINK_TOKEN = "=";
    public static final String TIMESPACE_TOKEN = "_timespace_";
    private static final String FIELD_TOKEN = "_fd_";
    private static final String FUNCTION_TOKEN = "_func_";
    private static final String NULL_STR = "#123456789*123456789";
    private ArrayList<ExchangeRuleVO> exchangeRuleVO;

    @Override
    public void clearSplitChange(AggregatedValueObject[] originalVOs, ChangeVOAdjustContext context) {
        ArrayList<SplitItemVO> alSplitVO = context.getSplitVOList();
        if (!ArrayUtil.isNull((Object[])originalVOs)) {
            for (AggregatedValueObject originalVO : originalVOs) {
                originalVO.getParentVO().setAttributeValue("splitkeyvalue", null);
                try {
                    Object[] childrenVO = this.getChildrenOfSrcVO(originalVO, alSplitVO, context);
                    if (ArrayUtil.isNull((Object[])childrenVO)) continue;
                    for (Object childVO : childrenVO) {
                        childVO.setAttributeValue("splitkeyvalue", null);
                    }
                }
                catch (BusinessException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
    }

    public String findTableCode(String[] tableCodes, ArrayList<SplitItemVO> alSplitVO) {
        for (SplitItemVO splitVO : alSplitVO) {
            String item;
            String[] items;
            if (splitVO.getItemtype() != 1 || (items = (item = splitVO.getItem()).split("\\.")) == null || items.length < 2) continue;
            for (String tableCode : tableCodes) {
                if (!tableCode.equals(items[0])) continue;
                return tableCode;
            }
        }
        return tableCodes[0];
    }

    public String[] getAllOtherTableCodes(String[] allTableCodes, String currTableCode) {
        ArrayList<String> list = new ArrayList<String>();
        for (String code : allTableCodes) {
            if (code.equals(currTableCode)) continue;
            list.add(code);
        }
        return list.toArray(new String[0]);
    }

    public void setOtherTableData(IExAggVO srcAggVO, IExAggVO destAggVO, String[] tableCodes) {
        for (String tableCode : tableCodes) {
            destAggVO.setTableVO(tableCode, srcAggVO.getTableVO(tableCode));
        }
    }

    @Override
    public AggregatedValueObject[] splitAfterProc(AggregatedValueObject[] srcVos, AggregatedValueObject[] destVos, ChangeVOAdjustContext context) {
        String destBillOrTranType = context.getDestBilltype();
        BilltypeVO destBillTypeVO = this.queryBillTypeById(destBillOrTranType);
        this.fillTranTypeForDestVOs(destVos, destBillTypeVO);
        ArrayList<SplitItemVO> alSplitVO = context.getSplitVOList();
        if (alSplitVO == null || alSplitVO.size() == 0) {
            return destVos;
        }
        AggregatedValueObject[] retVos = new BillSplitHelper().splitLastBill(destVos, context.getSplitVOList());
        return retVos;
    }

    @Override
    public AggregatedValueObject[] splitBeforProc(AggregatedValueObject[] srcVos, ChangeVOAdjustContext context) {
        ArrayList<SplitItemVO> alSplitVO = context.getSplitVOList();
        if (alSplitVO == null || alSplitVO.size() == 0) {
            return srcVos;
        }
        this.sortSplitVOlist(alSplitVO);
        try {
            this.appendUniqueKeyForSrcVOs(srcVos, context);
            if (srcVos == null || srcVos.length == 0) {
                return srcVos;
            }
            AggregatedValueObject[] retVos = this.splitBillToSingleBody(srcVos, srcVos[0].getClass(), alSplitVO, context);
            return retVos;
        }
        catch (BusinessException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendBodyItem(ArrayList<SplitItemVO> alSplitVO, StringBuffer[] bodyUniqueKeys) {
        for (int i = 0; i < bodyUniqueKeys.length; ++i) {
            for (SplitItemVO splitVO : alSplitVO) {
                if (splitVO.getItemtype() == 1) {
                    bodyUniqueKeys[i].append(FIELD_TOKEN);
                } else {
                    bodyUniqueKeys[i].append(FUNCTION_TOKEN);
                }
                bodyUniqueKeys[i].append(splitVO.getItem());
            }
        }
    }

    private void appendBusiType(StringBuffer headUniqueKey, AggregatedValueObject srcVo) {
        IFlowBizItf itf = PfMetadataTools.getBizItfImpl(srcVo, IFlowBizItf.class);
        String busiType = itf.getBusitype();
        this.appendStr(headUniqueKey, busiType);
    }

    private void appendHeadItem(ArrayList<SplitItemVO> alSplitVO, StringBuffer headUniqueKey) {
        for (SplitItemVO splitVO : alSplitVO) {
            if (splitVO.getItemtype() == 1) {
                headUniqueKey.append(FIELD_TOKEN);
            } else {
                headUniqueKey.append(FUNCTION_TOKEN);
            }
            headUniqueKey.append(splitVO.getItem());
        }
    }

    private void appendStr(StringBuffer src, Object value) {
        if (value == null) {
            src.append(NULL_STR);
        } else if (value instanceof UFDate || value instanceof UFDateTime) {
            UFDate date = null;
            date = value instanceof UFDate ? ((UFDate)value).asBegin() : ((UFDateTime)value).getBeginDate();
            src.append(date);
        } else {
            src.append(value);
        }
    }

    private void appendTimeSpaceInfo(StringBuffer headUniqueKey, ChangeVOAdjustContext context) {
        ArrayList<SplitItemVO> alSplitVO = context.getSplitVOList();
        ArrayList<ExchangeRuleVO> exRuleVO = this.findExchangeRule(context);
        headUniqueKey.append(TIMESPACE_TOKEN);
        for (SplitItemVO splitVO : alSplitVO) {
            String destAttr;
            int timespace = splitVO.getTimeSpace();
            if (timespace <= 0 || (destAttr = this.findDestAttr(splitVO.getItem(), exRuleVO)) == null) continue;
            headUniqueKey.append(destAttr + TIMESPACE_LINK_TOKEN + timespace);
            headUniqueKey.append(SEPARATOR_CH);
        }
    }

    private void appendTranType(StringBuffer headUniqueKey, String billtype) {
        headUniqueKey.append(SEPARATOR_CH);
        BilltypeVO billtypeVO = this.queryBillTypeById(billtype);
        if (UFBoolean.TRUE.equals((Object)billtypeVO.istransaction)) {
            this.appendStr(headUniqueKey, billtype);
        } else {
            this.appendStr(headUniqueKey, null);
        }
    }

    private void appendUniqueKeyForSrcVO(AggregatedValueObject srcVo, ChangeVOAdjustContext context, List<Object[]> resourceValues_List, int ncobectIndex) throws BusinessException {
        ArrayList<SplitItemVO> alSplitVO = context.getSplitVOList();
        String destBilltype = context.getDestBilltype();
        String srcBilltype = context.getSrcBilltype();
        CircularlyAccessibleValueObject[] childrenVO = this.getChildrenOfSrcVO(srcVo, alSplitVO, context);
        StringBuffer[] bodyUniqueKeys = null;
        if (childrenVO != null) {
            bodyUniqueKeys = new StringBuffer[childrenVO.length];
            for (int i = 0; i < bodyUniqueKeys.length; ++i) {
                bodyUniqueKeys[i] = new StringBuffer();
            }
        }
        StringBuffer headUniqueKey = new StringBuffer();
        int fieldIndex = 0;
        for (SplitItemVO splitVO : alSplitVO) {
            if (splitVO.getTimeSpace() > 0) continue;
            if (splitVO.getItemtype() == 1) {
                Object[] qryResult = resourceValues_List.get(fieldIndex) == null ? null : resourceValues_List.get(fieldIndex);
                ++fieldIndex;
                Object value = null;
                value = qryResult != null && qryResult instanceof Object[] ? qryResult[ncobectIndex] : qryResult;
                if (value != null && value.getClass().isArray()) {
                    if (bodyUniqueKeys == null) continue;
                    Object values = value;
                    if (((Object[])values).length != bodyUniqueKeys.length) {
                        throw new RuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0082"));
                    }
                    for (int i = 0; i < bodyUniqueKeys.length; ++i) {
                        bodyUniqueKeys[i].append(SEPARATOR_CH);
                        this.appendStr(bodyUniqueKeys[i], values[i]);
                    }
                    continue;
                }
                headUniqueKey.append(SEPARATOR_CH);
                this.appendStr(headUniqueKey, value);
                continue;
            }
            Hashtable hashBilltypeToParavo = new Hashtable();
            PfParameterVO paraVo = PfUtilBaseTools.getVariableValue(srcBilltype, null, srcVo, null, null, null, null, null, hashBilltypeToParavo);
            IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(srcVo, IFlowBizItf.class);
            String billVersionPK = fbi.getBillVersionPK();
            String functionPK = splitVO.getItem();
            Object result = ((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).executeFunction(billVersionPK, functionPK, paraVo);
            if (result instanceof ArrayList) {
                if (bodyUniqueKeys == null) continue;
                ArrayList values = (ArrayList)result;
                for (int i = 0; i < values.size(); ++i) {
                    bodyUniqueKeys[i].append(SEPARATOR_CH);
                    this.appendStr(bodyUniqueKeys[i], values.get(i));
                }
                continue;
            }
            headUniqueKey.append(SEPARATOR_CH);
            this.appendStr(headUniqueKey, result);
        }
        this.appendHeadItem(alSplitVO, headUniqueKey);
        if (bodyUniqueKeys != null) {
            this.appendBodyItem(alSplitVO, bodyUniqueKeys);
        }
        this.appendTranType(headUniqueKey, destBilltype);
        BilltypeVO destBilltypeVO = PfDataCache.getBillType(destBilltype);
        UFBoolean isBizFlowBill = destBilltypeVO.isBizflowBill;
        if (isBizFlowBill == null || isBizFlowBill.booleanValue()) {
            this.appendBusiType(headUniqueKey, srcVo);
        }
        this.fillBodyUniqueKeysForSrcVO(childrenVO, bodyUniqueKeys);
        this.appendTimeSpaceInfo(headUniqueKey, context);
        this.fillHeadUniqueKeyForSrcVO(srcVo.getParentVO(), headUniqueKey);
    }

    private void appendUniqueKeyForSrcVOs(AggregatedValueObject[] srcVos, ChangeVOAdjustContext context) throws BusinessException {
        ArrayList<SplitItemVO> alSplitVO = context.getSplitVOList();
        NCObject[] ncobjs = new NCObject[srcVos.length];
        int end = srcVos.length;
        for (int start = 0; start < end; ++start) {
            ncobjs[start] = NCObject.newInstance((Object)srcVos[start]);
        }
        ArrayList<String> itemFieds = new ArrayList<String>();
        for (SplitItemVO splitVO : alSplitVO) {
            if (splitVO.getTimeSpace() > 0 || splitVO.getItemtype() != 1) continue;
            itemFieds.add(splitVO.getItem());
        }
        List resourceValues_List = DASFacade.getAttributeValue2((String[])itemFieds.toArray(new String[0]), (NCObject[])ncobjs);
        int ncobject_end = srcVos.length;
        for (int ncobject_start = 0; ncobject_start < ncobject_end; ++ncobject_start) {
            this.appendUniqueKeyForSrcVO(srcVos[ncobject_start], context, resourceValues_List, ncobject_start);
        }
    }

    private void fillBodyUniqueKeysForSrcVO(CircularlyAccessibleValueObject[] childrenVO, StringBuffer[] uniqueKeys) {
        if (childrenVO == null) {
            return;
        }
        for (int i = 0; i < childrenVO.length; ++i) {
            childrenVO[i].setAttributeValue("splitkeyvalue", (Object)uniqueKeys[i].toString());
        }
    }

    private void fillHeadUniqueKeyForSrcVO(CircularlyAccessibleValueObject parentVO, StringBuffer headUniqueKey) {
        parentVO.setAttributeValue("splitkeyvalue", (Object)headUniqueKey.toString());
    }

    private void fillTranTypeForDestVO(AggregatedValueObject destVo, BilltypeVO destBillTypeVO) {
        String transtypePk;
        String destTranTypeCode;
        IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(destVo, IFlowBizItf.class);
        if (fbi == null) {
            return;
        }
        if (!StringUtil.isEmptyWithTrim((String)fbi.getTranstypePk())) {
            return;
        }
        if (UFBoolean.TRUE.equals((Object)destBillTypeVO.istransaction)) {
            destTranTypeCode = destBillTypeVO.getPk_billtypecode();
            transtypePk = destBillTypeVO.getPk_billtypeid();
        } else {
            destTranTypeCode = null;
            transtypePk = null;
        }
        fbi.setTranstype(destTranTypeCode);
        fbi.setTranstypePk(transtypePk);
    }

    private void fillTranTypeForDestVOs(AggregatedValueObject[] destVos, BilltypeVO destBillTypeVO) {
        for (AggregatedValueObject destVo : destVos) {
            this.fillTranTypeForDestVO(destVo, destBillTypeVO);
        }
    }

    private String findDestAttr(String srcAttr, ArrayList<ExchangeRuleVO> exRuleVO) {
        for (ExchangeRuleVO rule : exRuleVO) {
            if (!srcAttr.equals(rule.getRuleData())) continue;
            return rule.getDest_attr();
        }
        return null;
    }

    private ArrayList<ExchangeRuleVO> findExchangeRule(ChangeVOAdjustContext context) {
        if (this.exchangeRuleVO == null) {
            String srcBilltypeOrTrantype = context.getSrcBilltype();
            String destBilltypeOrTrantype = context.getDestBilltype();
            String pk_group = InvocationInfoProxy.getInstance().getGroupId();
            this.exchangeRuleVO = (ArrayList)((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).getMappingRelation(srcBilltypeOrTrantype, destBilltypeOrTrantype, null, pk_group);
        }
        return this.exchangeRuleVO;
    }

    private CircularlyAccessibleValueObject[] getChildrenOfSrcVO(AggregatedValueObject srcVo, ArrayList<SplitItemVO> alSplitVO, ChangeVOAdjustContext context) throws BusinessException {
        String srcBilltype = context.getSrcBilltype();
        if (srcVo instanceof IExAggVO) {
            IExAggVO srcExAggVO = (IExAggVO)srcVo;
            String[] tableCodes = PfMetadataTools.queryChildAttributes(srcBilltype);
            if (tableCodes == null || tableCodes.length <= 1) {
                return srcVo.getChildrenVO();
            }
            String tableCode = this.findTableCode(tableCodes, alSplitVO);
            if (tableCode != null) {
                return srcExAggVO.getTableVO(tableCode);
            }
        }
        return srcVo.getChildrenVO();
    }

    private BilltypeVO queryBillTypeById(String id) {
        return PfDataCache.getBillTypeInfo(id);
    }

    private void setOtherTableData(AggregatedValueObject srcAggVO, IExAggVO destAggVO, String[] tableCodes) {
        for (String tableCode : tableCodes) {
            destAggVO.setTableVO(tableCode, ((IExAggVO)srcAggVO).getTableVO(tableCode));
        }
    }

    private void sortSplitVOlist(ArrayList<SplitItemVO> alSplitVO) {
        Collections.sort(alSplitVO, new Comparator<SplitItemVO>(){

            @Override
            public int compare(SplitItemVO o1, SplitItemVO o2) {
                if (!o1.getItemtype().equals(o2.getItemtype())) {
                    return o1.getItemtype().compareTo(o2.getItemtype());
                }
                String itemname1 = o1.getItem();
                String itemname2 = o2.getItem();
                return itemname1.compareTo(itemname2);
            }
        });
    }

    private <G extends AggregatedValueObject> AggregatedValueObject[] splitBillToSingleBody(AggregatedValueObject[] srcVos, Class<G> aggClazz, ArrayList<SplitItemVO> alSplitVO, ChangeVOAdjustContext context) throws BusinessException {
        String srcBilltype = context.getSrcBilltype();
        ArrayList<AggregatedValueObject> voList = new ArrayList<AggregatedValueObject>();
        for (AggregatedValueObject srcVo : srcVos) {
            CircularlyAccessibleValueObject[] childrenVO = this.getChildrenOfSrcVO(srcVo, alSplitVO, context);
            if (childrenVO == null) {
                try {
                    Object[] tableCodes;
                    AggregatedValueObject aggVO = (AggregatedValueObject)aggClazz.newInstance();
                    if (srcVo instanceof IExAggVO && !ArrayUtil.isNull((Object[])(tableCodes = ((IExAggVO)aggVO).getTableCodes()))) {
                        String tableCode = this.findTableCode((String[])tableCodes, alSplitVO);
                        if (tableCodes.length > 1) {
                            Method m1 = null;
                            try {
                                m1 = srcVo.getClass().getMethod("getTableCodes", new Class[0]);
                            }
                            catch (NoSuchMethodException e) {
                                Logger.debug((Object)e.getMessage());
                            }
                            if (null != m1) {
                                this.setOtherTableData((IExAggVO)srcVo, (IExAggVO)aggVO, this.getAllOtherTableCodes((String[])tableCodes, tableCode));
                            }
                        }
                    }
                    aggVO.setParentVO((CircularlyAccessibleValueObject)srcVo.getParentVO().clone());
                    voList.add(aggVO);
                    continue;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            boolean isNeedAppendOtherTabData = true;
            for (CircularlyAccessibleValueObject childVO : childrenVO) {
                if (childVO == null) continue;
                try {
                    AggregatedValueObject aggVO = (AggregatedValueObject)aggClazz.newInstance();
                    aggVO.setParentVO((CircularlyAccessibleValueObject)srcVo.getParentVO().clone());
                    CircularlyAccessibleValueObject[] bodiesVO = (CircularlyAccessibleValueObject[])Array.newInstance(childVO.getClass(), 1);
                    bodiesVO[0] = childVO;
                    if (isNeedAppendOtherTabData && srcVo instanceof IExAggVO && !ArrayUtil.isNull((Object[])((IExAggVO)aggVO).getTableCodes())) {
                        String[] tableCodes = PfMetadataTools.queryChildAttributes(srcBilltype);
                        if (tableCodes == null || tableCodes.length < 1) {
                            tableCodes = ((IExAggVO)aggVO).getTableCodes();
                        }
                        String tableCode = this.findTableCode(tableCodes, alSplitVO);
                        this.setOtherTableData(srcVo, (IExAggVO)aggVO, this.getAllOtherTableCodes(tableCodes, tableCode));
                        ((IExAggVO)aggVO).setTableVO(tableCode, bodiesVO);
                        isNeedAppendOtherTabData = true;
                    } else {
                        aggVO.setChildrenVO(bodiesVO);
                    }
                    voList.add(aggVO);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return voList.toArray((AggregatedValueObject[])Array.newInstance(aggClazz, voList.size()));
    }
}

