/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.riawf.workflow.pagination;

import java.util.ArrayList;
import java.util.List;
import nc.vo.pub.BusinessException;
import nccloud.dto.baseapp.querytree.dataformat.PageInfo;
import nccloud.dto.baseapp.querytree.dataformat.QueryTreeFormatVO;
import nccloud.framework.web.pagination.IPaginationQueryService;
import nccloud.framework.web.pagination.PaginationModelUtils;

public class PaginationModelUtilsForWorkflow
extends PaginationModelUtils {
    private PageInfo pageinfo = null;

    public PaginationModelUtilsForWorkflow(IPaginationQueryService paginationQueryService, QueryTreeFormatVO queryInfo) {
        super(paginationQueryService, queryInfo);
    }

    public PageInfo getPageInfo() throws BusinessException {
        if (this.pageinfo != null) {
            return this.pageinfo;
        }
        if (this.getQueryInfo() == null) {
            return this.pageinfo;
        }
        this.pageinfo = this.getQueryInfo().getPageInfo();
        List allpks = this.getPaginationQueryService().getAllPks(this.getQueryInfo());
        if (allpks == null || allpks.size() < 1) {
            return this.pageinfo;
        }
        this.pageinfo.setTotal(allpks.size());
        this.pageinfo.setAllpks(allpks.toArray(new String[0]));
        int pageSize = Integer.parseInt(this.pageinfo.getPageSize());
        int moreRecord = allpks.size() % pageSize;
        int totalPage = 1;
        totalPage = moreRecord > 0 ? allpks.size() / pageSize + 1 : allpks.size() / pageSize;
        this.pageinfo.setTotalPage(totalPage);
        List pagePks = new ArrayList();
        if (allpks.size() <= pageSize) {
            pagePks = allpks;
        } else {
            int k = Integer.parseInt(this.pageinfo.getPageIndex());
            for (int count = 0; count < pageSize && count + k * pageSize < allpks.size(); ++count) {
                pagePks.add(allpks.get(count + k * pageSize));
            }
        }
        this.pageinfo.setPagepks(pagePks.toArray(new String[pagePks.size()]));
        Object[] pageData = this.getPaginationQueryService().queryObjectByPks(this.getQueryInfo());
        this.pageinfo.setPageData(pageData);
        return this.pageinfo;
    }
}

