/*
 * Decompiled with CFR 0.152.
 */
package nccloud.riawf.flowchar;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import nc.bs.logging.Logger;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nccloud.riawf.flowchar.NccFlowGraphManager;
import nccloud.riawf.flowchar.NccProcessGraph;
import nccloud.riawf.flowchar.graph.NccActivityCell;
import nccloud.riawf.flowchar.graph.NccBlockCell;
import nccloud.riawf.flowchar.graph.NccEndCell;
import nccloud.riawf.flowchar.graph.NccParticipantCell;
import nccloud.riawf.flowchar.graph.NccStartCell;
import nccloud.riawf.flowchar.graph.NccTransitionCell;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.plaf.basic.BasicGraphUI;

public class NccUfWGraphUI
extends BasicGraphUI {
    protected boolean canMouseReleaseSelectCell = true;
    protected Point2D insertionPoint = null;

    public NccProcessGraph getGraph() {
        return (NccProcessGraph)this.graph;
    }

    public void setInsertionPoint(Point2D p) {
        this.insertionPoint = p;
    }

    protected boolean startEditing(Object cell, MouseEvent event) {
        return false;
    }

    protected void paintBackground(Graphics g) {
        Rectangle pageBounds = this.graph.getBounds();
        if (this.graph.isGridVisible()) {
            this.paintGrid(this.graph.getGridSize(), g, pageBounds);
        }
    }

    protected MouseListener createMouseListener() {
        return new PEMouseHandler();
    }

    public CellHandle createHandle(GraphContext context) {
        if (context != null && !context.isEmpty() && this.graph.isEnabled()) {
            return new PERootHandle(context);
        }
        return null;
    }

    protected TransferHandler createTransferHandler() {
        return new PETransferHandler();
    }

    public void insertCells(Object[] cells, Map viewAttributeMap, ConnectionSet cs, boolean clone, int dx, int dy) {
        NccFlowGraphManager fgm = this.getGraph().getNccFlowGraphManager();
        WorkflowProcess wp = this.getGraph().getWorkflowProcess();
        HashSet<Object> cellsToCloneOrPaste = new HashSet<Object>();
        boolean dispMessage = true;
        for (int i = 0; i < cells.length; ++i) {
            if (!(cells[i] instanceof NccParticipantCell || cells[i] instanceof NccTransitionCell || cells[i] instanceof NccStartCell || cells[i] instanceof NccEndCell || cells[i] instanceof NccBlockCell)) {
                NccActivityCell actCell = (NccActivityCell)cells[i];
                Activity act = (Activity)actCell.getUserObject();
                if (act.getWorkflowProcess() != wp) {
                    return;
                }
                cellsToCloneOrPaste.add(cells[i]);
                if (!(cells[i] instanceof NccActivityCell) || ((NccActivityCell)cells[i]).getChildren() != null && ((NccActivityCell)cells[i]).getPort() != null) continue;
                DefaultPort port = new DefaultPort((Object)"Center");
                ((NccActivityCell)cells[i]).add((MutableTreeNode)port);
                continue;
            }
            if (!(cells[i] instanceof NccTransitionCell)) continue;
            dispMessage = false;
        }
        if (cellsToCloneOrPaste.size() != cells.length) {
            cells = cellsToCloneOrPaste.toArray();
        }
        if (cellsToCloneOrPaste.size() > 0) {
            Map cellMap = this.graph.cloneCells(cells);
            viewAttributeMap = GraphConstants.replaceKeys((Map)cellMap, (Map)viewAttributeMap);
            if (clone) {
                for (Map.Entry entry : viewAttributeMap.entrySet()) {
                    Object userObject = ((DefaultMutableTreeNode)entry.getKey()).getUserObject();
                    Map map = (Map)entry.getValue();
                    GraphConstants.setValue((Map)map, (Object)userObject);
                }
            }
            cs = cs.clone(cellMap);
            Object[] insertCells = new Object[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                insertCells[i] = cellMap.get(cells[i]);
            }
            if (dx != 0 || dy != 0) {
                AttributeMap.translate(viewAttributeMap.values(), (double)dx, (double)dy);
            }
            fgm.insertCellsAndArrangeParticipants(insertCells, viewAttributeMap);
        }
    }

    public class PETransferHandler
    extends TransferHandler {
        protected Object in;
        protected Object out;
        protected boolean isCut = false;
        protected int inCount = 0;

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            return true;
        }

        @Override
        protected final Transferable createTransferable(JComponent c) {
            JGraph graph;
            Object[] cells;
            if (c instanceof JGraph && (cells = (graph = (JGraph)c).order(graph.getSelectionCells())) != null && cells.length > 0) {
                boolean dispMessage = true;
                HashSet<Object> cellsToCopy = new HashSet<Object>();
                for (int i = 0; i < cells.length; ++i) {
                    if (!(cells[i] instanceof NccParticipantCell || cells[i] instanceof NccTransitionCell || cells[i] instanceof NccStartCell || cells[i] instanceof NccEndCell || cells[i] instanceof NccBlockCell)) {
                        cellsToCopy.add(cells[i]);
                    }
                    if (!(cells[i] instanceof NccTransitionCell)) continue;
                    dispMessage = false;
                }
                if (cellsToCopy.size() != cells.length && (cells = cellsToCopy.toArray()).length == 0) {
                    return null;
                }
                this.out = cells;
                Object[] flat = graph.getDescendants(cells);
                ConnectionSet cs = ConnectionSet.create((GraphModel)NccUfWGraphUI.this.graphModel, (Object[])flat, (boolean)false);
                Map viewAttributes = GraphConstants.createAttributes((Object[])flat, (CellMapper)NccUfWGraphUI.this.graphLayoutCache);
                Rectangle2D bounds = graph.getCellBounds((Object[])this.out);
                return this.create(graph, cells, cs, viewAttributes, bounds);
            }
            return null;
        }

        protected GraphTransferable create(JGraph graph, Object[] cells, ConnectionSet cs, Map viewAttributes, Rectangle2D bounds) {
            return new GraphTransferable(cells, viewAttributes, bounds, cs, null);
        }

        @Override
        protected void exportDone(JComponent comp, Transferable data, int action) {
            if (comp instanceof JGraph && data instanceof GraphTransferable) {
                Object[] cells = ((GraphTransferable)data).getCells();
                JGraph graph = (JGraph)comp;
                Point p = NccUfWGraphUI.this.insertionLocation;
                if (p == null && action == 2) {
                    this.removeCells(graph, cells);
                } else if (p != null && NccUfWGraphUI.this.handle != null) {
                    int mod = action == 1 ? 2 : 0;
                    NccUfWGraphUI.this.handle.mouseReleased(new MouseEvent(comp, 0, 0L, mod, p.x, p.y, 1, false));
                }
                NccUfWGraphUI.this.insertionLocation = null;
            }
        }

        @Override
        public void exportToClipboard(JComponent compo, Clipboard clip, int action) {
            this.isCut = action == 2;
            super.exportToClipboard(compo, clip, action);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean importData(JComponent comp, Transferable t) {
            try {
                if (comp instanceof JGraph) {
                    JGraph graph = (JGraph)comp;
                    if (t.isDataFlavorSupported(GraphTransferable.dataFlavor)) {
                        Object obj = t.getTransferData(GraphTransferable.dataFlavor);
                        GraphTransferable gt = (GraphTransferable)obj;
                        if (this.out != gt.getCells() || NccUfWGraphUI.this.insertionLocation == null) {
                            boolean bl = this.handleInsert(graph, gt);
                            return bl;
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception exception) {
                Logger.debug((Object)exception);
            }
            finally {
                this.isCut = false;
            }
            return false;
        }

        protected boolean handleInsert(JGraph graph, GraphTransferable t) {
            boolean c;
            Object[] cells = t.getCells();
            boolean bl = c = this.out != cells || !this.isCut;
            if (this.in != cells) {
                this.inCount = c ? 1 : 0;
            }
            this.in = cells;
            double dx = (double)this.inCount * graph.getGridSize();
            double dy = (double)this.inCount * graph.getGridSize();
            Map attributeMap = null;
            if (NccUfWGraphUI.this.insertionLocation != null || NccUfWGraphUI.this.insertionPoint != null) {
                Point p = t.getBounds().getBounds().getLocation();
                Point2D insPoint = NccUfWGraphUI.this.insertionLocation;
                if (insPoint == null) {
                    insPoint = NccUfWGraphUI.this.insertionPoint;
                }
                dx = insPoint.getX() - (double)p.x;
                dy = insPoint.getY() - (double)p.y;
                if (NccUfWGraphUI.this.insertionPoint != null) {
                    attributeMap = t.getAttributeMap();
                    AttributeMap.translate(attributeMap.values(), (double)dx, (double)dy);
                    Rectangle2D tmp = t.getBounds();
                    t.getBounds().setFrame(tmp.getX() + dx, tmp.getY() + dy, tmp.getWidth(), tmp.getHeight());
                    dx = 0.0;
                    dy = 0.0;
                    this.inCount = 0;
                }
            }
            ++this.inCount;
            if (cells == this.out || graph.isDropEnabled()) {
                if (attributeMap == null) {
                    attributeMap = t.getAttributeMap();
                }
                NccUfWGraphUI.this.insertCells(cells, attributeMap, t.getConnectionSet(), c, (int)dx, (int)dy);
                return true;
            }
            return false;
        }

        protected void removeCells(JGraph graph, Object[] cells) {
            NccUfWGraphUI.this.getGraph().getNccFlowGraphManager().removeCellsAndArrangeParticipants(cells);
        }
    }

    public class PERootHandle
    extends BasicGraphUI.RootHandle {
        public PERootHandle(GraphContext ctx) {
            super((BasicGraphUI)NccUfWGraphUI.this, ctx);
        }

        public void mouseDragged(MouseEvent event) {
            boolean constrained = NccUfWGraphUI.this.isConstrainedMoveEvent(event);
            Rectangle2D dirty = null;
            if (this.firstDrag && NccUfWGraphUI.this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            if (event != null && !event.isConsumed()) {
                if (this.activeHandle != null) {
                    this.activeHandle.mouseDragged(event);
                } else if (this.start != null) {
                    Point2D snapCurrent;
                    Graphics g = this.offgraphics != null ? this.offgraphics : NccUfWGraphUI.this.graph.getGraphics();
                    Point ep = event.getPoint();
                    Point2D.Double point = new Point2D.Double(ep.getX() - this._mouseToViewDelta_x, ep.getY() - this._mouseToViewDelta_y);
                    Point2D current = snapCurrent = NccUfWGraphUI.this.graph.snap((Point2D)point);
                    int thresh = NccUfWGraphUI.this.graph.getMinimumMove();
                    double dx = current.getX() - this.start.getX();
                    double dy = current.getY() - this.start.getY();
                    if (this.isMoving || Math.abs(dx) > (double)thresh || Math.abs(dy) > (double)thresh) {
                        boolean overlayed = false;
                        this.isMoving = true;
                        if (this.disconnect == null && NccUfWGraphUI.this.graph.isDisconnectOnMove()) {
                            this.disconnect = this.context.disconnect(NccUfWGraphUI.this.graphLayoutCache.getAllDescendants(this.views));
                        }
                        double totDx = current.getX() - this.start.getX();
                        double totDy = current.getY() - this.start.getY();
                        dx = current.getX() - this.last.getX();
                        dy = current.getY() - this.last.getY();
                        if (constrained && this.cachedBounds == null) {
                            if (Math.abs(totDx) < Math.abs(totDy)) {
                                dx = 0.0;
                                dy = totDy;
                            } else {
                                dx = totDx;
                                dy = 0.0;
                            }
                        } else if (!NccUfWGraphUI.this.graph.isMoveBelowZero() && this.last != null && this.initialLocation != null && this.start != null) {
                            if (this.initialLocation.getX() + totDx < 0.0) {
                                dx = this.start.getX() - this.last.getX() - this.initialLocation.getX();
                            }
                            if (this.initialLocation.getY() + totDy < 0.0) {
                                dy = this.start.getY() - this.last.getY() - this.initialLocation.getY();
                            }
                        }
                        double scale = NccUfWGraphUI.this.graph.getScale();
                        dx = (int)(dx / scale);
                        dy = (int)(dy / scale);
                        g.setColor(NccUfWGraphUI.this.graph.getForeground());
                        g.setXORMode(NccUfWGraphUI.this.graph.getBackground().darker());
                        if (NccUfWGraphUI.this.graph.isDragEnabled() && !this.isDragging) {
                            this.startDragging(event);
                        }
                        if (dx != 0.0 || dy != 0.0) {
                            Rectangle2D t;
                            if (!(this.snapLast.equals(this.snapStart) || this.offgraphics == null && this.blockPaint)) {
                                this.overlay(g);
                                overlayed = true;
                            }
                            this.isContextVisible = (!event.isControlDown() || !NccUfWGraphUI.this.graph.isCloneable()) && this.contextViews != null && this.contextViews.length < BasicGraphUI.MAXCELLS;
                            this.blockPaint = false;
                            if (this.offgraphics != null) {
                                dirty = NccUfWGraphUI.this.graph.toScreen(AbstractCellView.getBounds((CellView[])this.views));
                                t = NccUfWGraphUI.this.graph.toScreen(AbstractCellView.getBounds((CellView[])this.contextViews));
                                if (t != null) {
                                    dirty.add(t);
                                }
                            }
                            if (constrained && this.cachedBounds == null) {
                                CellView[] all = NccUfWGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                                for (int i = 0; i < all.length; ++i) {
                                    CellView orig = NccUfWGraphUI.this.graphLayoutCache.getMapping(all[i].getCell(), false);
                                    AttributeMap attr = orig.getAllAttributes();
                                    all[i].changeAttributes(NccUfWGraphUI.this.graphLayoutCache, (Map)((AttributeMap)attr.clone()));
                                }
                            }
                            if (this.cachedBounds != null) {
                                this.cachedBounds.setFrame(this.cachedBounds.getX() + dx * scale, this.cachedBounds.getY() + dy * scale, this.cachedBounds.getWidth(), this.cachedBounds.getHeight());
                            } else {
                                GraphLayoutCache.translateViews((CellView[])this.views, (double)dx, (double)dy);
                                if (this.views != null) {
                                    NccUfWGraphUI.this.graphLayoutCache.update(this.views);
                                }
                                if (this.contextViews != null) {
                                    NccUfWGraphUI.this.graphLayoutCache.update(this.contextViews);
                                }
                            }
                            if (!snapCurrent.equals(this.snapStart)) {
                                this.overlay(g);
                                overlayed = true;
                            }
                            if (constrained) {
                                this.last = (Point2D)this.start.clone();
                            }
                            this.last.setLocation(this.last.getX() + dx * scale, this.last.getY() + dy * scale);
                            this.snapLast = snapCurrent;
                            if (overlayed && this.offgraphics != null) {
                                dirty.add(NccUfWGraphUI.this.graph.toScreen(AbstractCellView.getBounds((CellView[])this.views)));
                                t = NccUfWGraphUI.this.graph.toScreen(AbstractCellView.getBounds((CellView[])this.contextViews));
                                if (t != null) {
                                    dirty.add(t);
                                }
                                dirty.setFrame(dirty.getX() - 3.0, dirty.getY() - 3.0, dirty.getWidth() + 5.0, dirty.getHeight() + 5.0);
                                double sx1 = Math.max(0.0, dirty.getX());
                                double sy1 = Math.max(0.0, dirty.getY());
                                double sx2 = sx1 + dirty.getWidth();
                                double sy2 = sy1 + dirty.getHeight();
                                if (this.isDragging && !BasicGraphUI.DNDPREVIEW) {
                                    return;
                                }
                                NccUfWGraphUI.this.graph.drawImage((int)sx1, (int)sy1, (int)sx2, (int)sy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2);
                            }
                        }
                    }
                }
            } else if (event == null) {
                NccUfWGraphUI.this.graph.repaint();
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (event != null && !event.isConsumed()) {
                if (this.activeHandle != null) {
                    this.activeHandle.mouseReleased(event);
                    this.activeHandle = null;
                } else if (this.isMoving && !event.getPoint().equals(this.start)) {
                    if (this.cachedBounds != null) {
                        double dx = (double)event.getX() - this.start.getX();
                        double dy = (double)event.getY() - this.start.getY();
                        Point2D tmp = NccUfWGraphUI.this.graph.fromScreen((Point2D)new Point2D.Double(dx, dy));
                        GraphLayoutCache.translateViews((CellView[])this.views, (double)tmp.getX(), (double)tmp.getY());
                    }
                    Object[] all = NccUfWGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                    if (event.isControlDown() && NccUfWGraphUI.this.graph.isCloneable()) {
                        Object[] cells = NccUfWGraphUI.this.graph.getDescendants(this.context.getCells());
                        ConnectionSet cs = ConnectionSet.create((GraphModel)NccUfWGraphUI.this.graphModel, (Object[])cells, (boolean)false);
                        cs.addConnections((CellView[])all);
                        Map propertyMap = GraphConstants.createAttributes((Object[])all, null);
                        NccUfWGraphUI.this.insertCells(this.context.getCells(), propertyMap, cs, true, 0, 0);
                    } else if (NccUfWGraphUI.this.graph.isMoveable()) {
                        Map propertyMap = GraphConstants.createAttributes((Object[])all, null);
                        NccUfWGraphUI.this.getGraph().getNccFlowGraphManager().moveCellsAndArrangeParticipants(propertyMap);
                    }
                    event.consume();
                }
            }
            this.start = null;
        }
    }

    public class PEMouseHandler
    extends BasicGraphUI.MouseHandler {
        public PEMouseHandler() {
            super((BasicGraphUI)NccUfWGraphUI.this);
        }

        public void mousePressed(MouseEvent e) {
            this.handler = null;
            if (!e.isConsumed() && NccUfWGraphUI.this.graph.isEnabled()) {
                NccUfWGraphUI.this.graph.requestFocus();
                int s = NccUfWGraphUI.this.graph.getTolerance();
                Rectangle2D r = NccUfWGraphUI.this.graph.fromScreen((Rectangle2D)new Rectangle(e.getX() - 1, e.getY() - 1, 2, 2));
                Point2D point = NccUfWGraphUI.this.graph.fromScreen((Point2D)new Point(e.getPoint()));
                NccUfWGraphUI.this.focus = NccUfWGraphUI.this.focus != null && NccUfWGraphUI.this.focus.intersects(NccUfWGraphUI.this.graph, r) ? NccUfWGraphUI.this.focus : null;
                this.cell = NccUfWGraphUI.this.graph.getNextViewAt(NccUfWGraphUI.this.focus, point.getX(), point.getY());
                if (NccUfWGraphUI.this.focus == null) {
                    NccUfWGraphUI.this.focus = this.cell;
                }
                NccUfWGraphUI.this.cancelEditing(NccUfWGraphUI.this.graph);
                Logger.debug((Object)(" after focus == null focus:" + NccUfWGraphUI.this.focus));
                if (this.cell != null && !NccUfWGraphUI.this.graph.isCellSelected(this.cell.getCell())) {
                    NccUfWGraphUI.this.selectCellForEvent(this.cell.getCell(), e);
                    NccUfWGraphUI.this.canMouseReleaseSelectCell = false;
                }
                if (e.getClickCount() == NccUfWGraphUI.this.graph.getEditClickCount() && NccUfWGraphUI.this.focus != null && !SwingUtilities.isRightMouseButton(e)) {
                    NccUfWGraphUI.this.graph.startEditingAtCell(NccUfWGraphUI.this.focus.getCell());
                    e.consume();
                    this.cell = null;
                } else if (!NccUfWGraphUI.this.isToggleSelectionEvent(e) && !NccUfWGraphUI.this.isForceMarqueeEvent(e) && NccUfWGraphUI.this.focus != null) {
                    if (NccUfWGraphUI.this.handle != null) {
                        NccUfWGraphUI.this.handle.mousePressed(e);
                        this.handler = NccUfWGraphUI.this.handle;
                    }
                } else if ((!NccUfWGraphUI.this.isToggleSelectionEvent(e) || NccUfWGraphUI.this.focus == null || System.getProperty("os.name").startsWith("Mac OS")) && NccUfWGraphUI.this.marquee != null) {
                    NccUfWGraphUI.this.marquee.mousePressed(e);
                    if (NccUfWGraphUI.this.focus == null) {
                        Object[] cells = new ArrayList().toArray();
                        NccUfWGraphUI.this.selectCellsForEvent(cells, e);
                    }
                    this.handler = NccUfWGraphUI.this.marquee;
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            try {
                BasicGraphUI.autoscroll((JGraph)NccUfWGraphUI.this.graph, (Point)e.getPoint());
                if (this.handler != null && this.handler == NccUfWGraphUI.this.marquee) {
                    NccUfWGraphUI.this.marquee.mouseDragged(e);
                } else if (this.handler == null && !NccUfWGraphUI.this.isEditing(NccUfWGraphUI.this.graph) && NccUfWGraphUI.this.focus != null) {
                    if (!NccUfWGraphUI.this.graph.isCellSelected(NccUfWGraphUI.this.focus.getCell())) {
                        NccUfWGraphUI.this.selectCellForEvent(NccUfWGraphUI.this.focus.getCell(), e);
                        this.cell = null;
                    }
                    if (NccUfWGraphUI.this.handle != null) {
                        NccUfWGraphUI.this.handle.mousePressed(e);
                    }
                    this.handler = NccUfWGraphUI.this.handle;
                }
                if (NccUfWGraphUI.this.handle != null && this.handler == NccUfWGraphUI.this.handle) {
                    NccUfWGraphUI.this.handle.mouseDragged(e);
                }
            }
            finally {
                this.cell = null;
            }
        }

        public void mouseReleased(MouseEvent e) {
            try {
                if (e != null && !e.isConsumed()) {
                    if (this.handler == NccUfWGraphUI.this.marquee) {
                        NccUfWGraphUI.this.marquee.mouseReleased(e);
                    } else if (this.handler == NccUfWGraphUI.this.handle && NccUfWGraphUI.this.handle != null) {
                        NccUfWGraphUI.this.handle.mouseReleased(e);
                    }
                    if (!e.isConsumed() && NccUfWGraphUI.this.focus != null && !SwingUtilities.isRightMouseButton(e) && NccUfWGraphUI.this.canMouseReleaseSelectCell) {
                        NccUfWGraphUI.this.selectCellForEvent(NccUfWGraphUI.this.focus.getCell(), e);
                        NccUfWGraphUI.this.focus = this.cell;
                    }
                    NccUfWGraphUI.this.canMouseReleaseSelectCell = true;
                }
            }
            finally {
                NccUfWGraphUI.this.insertionLocation = null;
                this.handler = null;
                this.cell = null;
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (NccUfWGraphUI.this.graph != null && NccUfWGraphUI.this.graph.isEnabled()) {
                if (NccUfWGraphUI.this.marquee != null) {
                    NccUfWGraphUI.this.marquee.mouseMoved(e);
                }
                if (NccUfWGraphUI.this.handle != null) {
                    NccUfWGraphUI.this.handle.mouseMoved(e);
                }
                if (!e.isConsumed()) {
                    NccUfWGraphUI.this.graph.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

