/*
 * Decompiled with CFR 0.152.
 */
package nccloud.bs.pub.pf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.impl.pubapp.pattern.rule.IRule;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFConfig;
import nc.itf.uap.pf.IPfExchangeService;
import nc.itf.uap.pf.IWorkflowDefine;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.itf.uap.pf.IplatFormEntry;
import nc.itf.uap.pf.metadata.IFlowBizItf;
import nc.security.NCAuthenticator;
import nc.security.NCAuthenticatorFactory;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.ui.pf.workitem.beside.BesideApproveContext;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.pf.AssignableInfo;
import nc.vo.pub.pf.PfAddInfo;
import nc.vo.pub.pf.TransitionSelectableInfo;
import nc.vo.pub.pf.plugin.MsgReceiverVO;
import nc.vo.pub.pfflow01.BillbusinessVO;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.uap.pf.FlowDefNotFoundException;
import nc.vo.uap.pf.OrganizeUnit;
import nc.vo.uap.pf.PFBatchExceptionInfo;
import nc.vo.uap.pf.PFRuntimeException;
import nc.vo.uap.pf.PfProcessBatchRetObject;
import nc.vo.wfengine.core.condition.Condition;
import nc.vo.wfengine.core.transition.BasicTransition;
import nc.vo.wfengine.core.transition.SplitJoinType;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.WFTask;
import nc.vo.wfengine.pub.WfTaskType;
import nccloud.base.exception.ExceptionUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.pubitf.riart.pf.INccPFCrossServiceQuery;

public class CloudPfUtil {
    private static boolean m_checkFlag = true;
    private static String m_currentBillType = null;
    private static int m_iCheckResult = 0;
    private static String m_sourceBillType = null;
    private static AggregatedValueObject m_tmpRetVo = null;
    private static AggregatedValueObject[] m_tmpRetVos = null;
    private static boolean makeFlag = false;
    private static IPfExchangeService exchangeService;
    private static int m_classifyMode;

    private CloudPfUtil() {
    }

    private static WorkflownoteVO checkOnSave(String actionName, String billType, AggregatedValueObject billVo, Stack dlgResult, HashMap hmPfExParams) throws BusinessException {
        WorkflownoteVO worknoteVO = new WorkflownoteVO();
        try {
            worknoteVO = ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).checkWorkFlow(actionName, billType, billVo, hmPfExParams);
        }
        catch (FlowDefNotFoundException e) {
            ExceptionUtils.wrapException((Throwable)((Object)e));
        }
        if (worknoteVO == null && !PfUtilBaseTools.isSaveAction(actionName, billType)) {
            worknoteVO = new WorkflownoteVO();
            worknoteVO.setApproveresult("Y");
            worknoteVO.setChecknote(NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "00020001-0475"));
        }
        return worknoteVO;
    }

    private static WorkflownoteVO checkOnStart(String actionName, String billType, AggregatedValueObject billVo, Stack dlgResult, HashMap hmPfExParams) throws BusinessException {
        WorkflownoteVO wfVo = ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).checkWorkFlow(actionName, billType, billVo, hmPfExParams);
        return wfVo;
    }

    private static WorkflownoteVO checkWorkitemWhenApprove(String actionName, String billType, AggregatedValueObject billVo, HashMap hmPfExParams, int voAryLen) throws BusinessException {
        WorkflownoteVO noteVO = null;
        if (!CloudPfUtil.hasApproveflowDef(billType, billVo)) {
            return null;
        }
        noteVO = ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).checkWorkFlow(actionName, billType, billVo, hmPfExParams);
        Logger.debug((Object)"*checkWorkitemWhenApprove 3.");
        Object notSilent = null;
        if (hmPfExParams != null) {
            notSilent = hmPfExParams.get("notsilent");
        }
        if (noteVO == null) {
            if (notSilent == null) {
                m_checkFlag = true;
                Logger.debug((Object)"*checkWorkitemWhenApprove 1 billType.");
                return noteVO;
            }
            noteVO = new WorkflownoteVO();
        }
        if (hmPfExParams == null) {
            hmPfExParams = new HashMap<String, WorkflownoteVO>();
        }
        if (!(hmPfExParams.containsKey("worknote") && hmPfExParams.get("worknote") != null || hmPfExParams.get("batch") == null)) {
            hmPfExParams.put("worknote", noteVO);
        }
        return noteVO;
    }

    public static boolean hasApproveflowDef(String billType, AggregatedValueObject billVo) throws BusinessException {
        IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(billVo, IFlowBizItf.class);
        if (fbi == null) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "00020001-0476"));
        }
        IWorkflowDefine wfDefine = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
        Logger.debug((Object)("\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49: billType=" + billType + ";pkOrg=" + fbi.getPkorg() + ";userId=" + fbi.getBillMaker() + ";\u5f00\u59cb"));
        String billpk_group = (String)billVo.getParentVO().getAttributeValue("pk_group");
        return wfDefine.hasValidProcessDef(billpk_group != null ? billpk_group : InvocationInfoProxy.getInstance().getGroupId(), billType, fbi.getPkorg(), fbi.getBillMaker(), fbi.getEmendEnum(), WorkflowTypeEnum.Approveflow.getIntValue());
    }

    public static boolean hasWorkflowDef(String billType, AggregatedValueObject billVo) throws BusinessException {
        IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(billVo, IFlowBizItf.class);
        if (fbi == null) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "00020001-0476"));
        }
        IWorkflowDefine wfDefine = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
        Logger.debug((Object)("\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49: billType=" + billType + ";pkOrg=" + fbi.getPkorg() + ";userId=" + fbi.getBillMaker() + ";\u5f00\u59cb"));
        String billpk_group = (String)billVo.getParentVO().getAttributeValue("pk_group");
        return wfDefine.hasValidProcessDef(billpk_group != null ? billpk_group : InvocationInfoProxy.getInstance().getGroupId(), billType, fbi.getPkorg(), fbi.getBillMaker(), fbi.getEmendEnum(), WorkflowTypeEnum.Workflow.getIntValue());
    }

    public static int getCurrentCheckResult() {
        return m_iCheckResult;
    }

    public static AggregatedValueObject getRetOldVo() {
        return m_tmpRetVo;
    }

    public static AggregatedValueObject[] getRetOldVos() {
        return m_tmpRetVos;
    }

    public static AggregatedValueObject getRetVo() {
        try {
            AggregatedValueObject[] aggregatedValueObjectArray;
            m_tmpRetVo = CloudPfUtil.getExchangeService().runChangeData(m_sourceBillType, m_currentBillType, m_tmpRetVo, null);
            if (m_tmpRetVo == null) {
                aggregatedValueObjectArray = null;
            } else {
                AggregatedValueObject[] aggregatedValueObjectArray2 = new AggregatedValueObject[1];
                aggregatedValueObjectArray = aggregatedValueObjectArray2;
                aggregatedValueObjectArray2[0] = m_tmpRetVo;
            }
            CloudPfUtil.jumpBusitype(aggregatedValueObjectArray);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            ExceptionUtils.wrapException((Throwable)ex);
        }
        return m_tmpRetVo;
    }

    public static AggregatedValueObject[] getRetVos() throws BusinessException {
        return CloudPfUtil.getRetVos(true);
    }

    public static AggregatedValueObject[] getRetVos(boolean exchangeByBusiType) throws BusinessException {
        if (!exchangeByBusiType && m_tmpRetVos != null) {
            for (int i = 0; i < m_tmpRetVos.length; ++i) {
                AggregatedValueObject aggVO = m_tmpRetVos[i];
                IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(aggVO, IFlowBizItf.class);
                if (fbi == null) continue;
                fbi.setBusitype(null);
            }
        }
        m_tmpRetVos = CloudPfUtil.changeVos(m_tmpRetVos, m_classifyMode);
        CloudPfUtil.jumpBusitype(m_tmpRetVos);
        return m_tmpRetVos;
    }

    private static IPfExchangeService getExchangeService() {
        if (exchangeService == null) {
            exchangeService = (IPfExchangeService)NCLocator.getInstance().lookup(IPfExchangeService.class);
        }
        return exchangeService;
    }

    private static AggregatedValueObject[] changeVos(AggregatedValueObject[] vos, int classifyMode) {
        AggregatedValueObject[] tmpRetVos = null;
        try {
            tmpRetVos = CloudPfUtil.getExchangeService().runChangeDataAryNeedClassify(m_sourceBillType, m_currentBillType, vos, null, classifyMode);
        }
        catch (BusinessException ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            ExceptionUtils.wrapException((Throwable)ex);
        }
        return tmpRetVos;
    }

    private static void jumpBusitype(AggregatedValueObject[] vos) throws BusinessException {
        if (vos == null || vos.length == 0) {
            return;
        }
        IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(vos[0], IFlowBizItf.class);
        if (fbi == null || StringUtil.isEmptyWithTrim((String)fbi.getBusitype())) {
            return;
        }
        BillbusinessVO condVO = new BillbusinessVO();
        condVO.setPk_businesstype(fbi.getBusitype());
        condVO.setJumpflag(UFBoolean.TRUE);
        String billtype = PfUtilBaseTools.getRealBilltype(m_currentBillType);
        condVO.setPk_billtype(billtype);
        condVO.setTranstype(fbi.getTranstype());
        try {
            Collection co = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieve((SuperVO)condVO, true);
            if (co.size() > 0) {
                HashMap busitypeMaps = new HashMap();
                for (AggregatedValueObject vo : vos) {
                    String destBusitypePk = null;
                    fbi = PfMetadataTools.getBizItfImpl(vo, IFlowBizItf.class);
                    String transtype = fbi.getTranstype();
                    String pk_org = fbi.getPkorg();
                    String operator = InvocationInfoProxy.getInstance().getUserId();
                    if (StringUtil.isEmptyWithTrim((String)billtype)) continue;
                    String key = billtype + (StringUtil.isEmptyWithTrim((String)transtype) ? "" : transtype) + (StringUtil.isEmptyWithTrim((String)pk_org) ? "" : pk_org) + operator;
                    destBusitypePk = busitypeMaps.containsKey(key) ? (String)busitypeMaps.get(key) : ((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).retBusitypeCanStart(billtype, transtype, pk_org, operator);
                    if (StringUtil.isEmptyWithTrim((String)destBusitypePk)) continue;
                    fbi.setBusitype(destBusitypePk);
                }
            }
        }
        catch (DAOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionUtils.wrapException((Throwable)e);
        }
    }

    public static Object runAction(String actionCode, String billOrTranstype, AggregatedValueObject billvo, Object userObj, BesideApproveContext besideContext, AggregatedValueObject checkVo, HashMap eParam) throws BusinessException {
        JSONArray jsonAray;
        String jsonString;
        Object content;
        JSONObject jsono;
        Logger.debug((Object)"*\u5355\u636e\u52a8\u4f5c\u5904\u7406 \u5f00\u59cb");
        long start = System.currentTimeMillis();
        WorkflownoteVO worknoteVO = null;
        if (PfUtilBaseTools.isSaveAction(actionCode, billOrTranstype) || PfUtilBaseTools.isApproveAction(actionCode, billOrTranstype)) {
            worknoteVO = CloudPfUtil.actionAboutApproveflow(actionCode, billOrTranstype, billvo, eParam, 0);
            if (PfUtilBaseTools.isSaveAction(actionCode, billOrTranstype)) {
                if (eParam.get("isSkipAssign") != null && ((Boolean)eParam.get("isSkipAssign")).booleanValue()) {
                    Logger.debug((Object)"nothing");
                } else {
                    Vector assignInfos;
                    if (eParam != null && eParam.get("content") != null) {
                        assignInfos = worknoteVO.getTaskInfo().getAssignableInfos();
                        jsono = null;
                        content = eParam.get("content");
                        if (content instanceof String) {
                            jsono = JSON.parseObject((String)((String)content));
                        } else {
                            jsonString = JSON.toJSONString((Object)JSON.toJSON(content));
                            jsono = JSON.parseObject((String)jsonString);
                        }
                        List jsonArayList = (List)jsono.get((Object)"content");
                        jsonAray = new JSONArray(jsonArayList);
                        block7: for (Object obj : jsonAray) {
                            JSONObject json = new JSONObject((Map)obj);
                            if (assignInfos == null || assignInfos.size() <= 0) continue;
                            for (int i = 0; i < assignInfos.size(); ++i) {
                                AssignableInfo assignInfo = (AssignableInfo)assignInfos.get(i);
                                String activitydefid = json.getString("activitydefid");
                                if (!activitydefid.equals(assignInfo.getActivityDefId())) continue;
                                Vector<String> userPKs = assignInfo.getAssignedOperatorPKs();
                                userPKs.clear();
                                JSONArray listStr = new JSONArray((List)json.get((Object)"uservos"));
                                for (Object jsonobj : listStr) {
                                    JSONObject json11 = new JSONObject((Map)jsonobj);
                                    userPKs.addElement(json11.getString("userpk"));
                                }
                                continue block7;
                            }
                        }
                    }
                    if (worknoteVO != null && (assignInfos = worknoteVO.getTaskInfo().getAssignableInfos()) != null && assignInfos.size() > 0 && (eParam == null || eParam.get("content") == null)) {
                        JSONArray array = CloudPfUtil.getAssignUserPKs(worknoteVO);
                        HashMap<String, String> jsonMap = new HashMap<String, String>();
                        jsonMap.put("workflow", "approveflow");
                        jsonMap.put("content", (String)array);
                        jsonMap.put("flow_type", "approveflow");
                        jsonMap.put("muplityWithOutAssgin", "true");
                        return new Object[]{jsonMap};
                    }
                }
            }
        } else if (PfUtilBaseTools.isStartAction(actionCode, billOrTranstype) || PfUtilBaseTools.isSignalAction(actionCode, billOrTranstype)) {
            worknoteVO = CloudPfUtil.actionAboutWorkflow(actionCode, billOrTranstype, billvo, besideContext, 0);
        }
        if (PfUtilBaseTools.isStartAction(actionCode, billOrTranstype)) {
            if (eParam.get("isSkipAssign") != null && ((Boolean)eParam.get("isSkipAssign")).booleanValue()) {
                Logger.debug((Object)"nothing");
            } else if (eParam == null || eParam.get("content") == null) {
                HashMap<String, Object> assginJson;
                boolean muplityWithOutAssgin = true;
                Vector assignInfos = worknoteVO.getTaskInfo().getAssignableInfos();
                Vector tSelectInfos = worknoteVO.getTaskInfo().getTransitionSelectableInfos();
                JSONArray jsonArray = new JSONArray();
                muplityWithOutAssgin = tSelectInfos != null && tSelectInfos.size() > 0;
                if (assignInfos.size() > 0 && tSelectInfos.size() > 0) {
                    for (int i = 0; i < tSelectInfos.size(); ++i) {
                        assginJson = new HashMap<String, Object>();
                        boolean isfind = false;
                        TransitionSelectableInfo trans = (TransitionSelectableInfo)tSelectInfos.get(i);
                        if (assignInfos != null && assignInfos.size() > 0) {
                            for (int j = 0; j < assignInfos.size(); ++j) {
                                AssignableInfo assgin = (AssignableInfo)assignInfos.get(j);
                                if (!assgin.getAfferentTransitions().containsKey(trans.getTransitionDefId())) continue;
                                assginJson.put("selectpath", trans.getTransitionDefId());
                                assginJson.put("isAssgin", true);
                                assginJson.put("assginUsers", assgin.getOuUsers());
                                isfind = true;
                                break;
                            }
                        }
                        if (!isfind) {
                            assginJson.put("selectpath", trans.getTransitionDefId());
                            assginJson.put("isAssgin", false);
                        }
                        if (i == 0) {
                            assginJson.put("isChoice", true);
                            trans.setChoiced(true);
                        } else {
                            assginJson.put("isChoice", false);
                            trans.setChoiced(false);
                        }
                        assginJson.put("desc", trans.getDesc());
                        JSONObject itemJSONObj = JSON.parseObject((String)JSON.toJSONString(assginJson));
                        jsonArray.add((Object)itemJSONObj);
                    }
                    JSONObject json = new JSONObject();
                    json.put("muplityWithOutAssgin", (Object)muplityWithOutAssgin);
                    json.put("content", (Object)jsonArray);
                    json.put("flow_type", (Object)"workflow");
                    json.put("workflow", (Object)"workflow");
                    return json;
                }
                if (assignInfos != null && assignInfos.size() > 0 && tSelectInfos.size() == 0) {
                    jsonAray = new JSONArray();
                    assginJson = new HashMap();
                    for (int j = 0; j < assignInfos.size(); ++j) {
                        AssignableInfo assgin = (AssignableInfo)assignInfos.get(j);
                        JSONObject json = new JSONObject();
                        if (j == 0) {
                            json.put("isChoice", (Object)true);
                        } else {
                            json.put("isChoice", (Object)false);
                        }
                        json.put("selectpath", (Object)assgin.getActivityDefId());
                        json.put("isAssgin", (Object)true);
                        json.put("desc", (Object)assgin.getDesc());
                        json.put("assginUsers", assgin.getOuUsers());
                        jsonAray.add((Object)json);
                    }
                    JSONObject returnjson = new JSONObject();
                    returnjson.put("content", (Object)jsonAray);
                    returnjson.put("flow_type", (Object)"workflow");
                    returnjson.put("muplityWithOutAssgin", (Object)muplityWithOutAssgin);
                    returnjson.put("workflow", (Object)"workflow");
                    return new Object[]{returnjson};
                }
            } else {
                boolean isSkipAssign = false;
                if (eParam.get("isSkipAssign") != null && ((Boolean)eParam.get("isSkipAssign")).booleanValue()) {
                    isSkipAssign = true;
                }
                if (!isSkipAssign) {
                    jsono = null;
                    content = eParam.get("content");
                    if (content instanceof String) {
                        jsono = JSON.parseObject((String)((String)content));
                    } else {
                        jsonString = JSON.toJSONString((Object)JSON.toJSON(content));
                        jsono = JSON.parseObject((String)jsonString);
                    }
                    if (jsono.get((Object)"content") != null && jsono.get((Object)"muplityWithOutAssgin") != null) {
                        Vector assignInfos;
                        if (jsono.getBooleanValue("muplityWithOutAssgin")) {
                            assignInfos = worknoteVO.getTaskInfo().getAssignableInfos();
                            List jsonArayList = (List)jsono.get((Object)"content");
                            JSONArray jsonAray2 = new JSONArray(jsonArayList);
                            block13: for (Object obj : jsonAray2) {
                                JSONObject json = new JSONObject((Map)obj);
                                if (assignInfos == null || assignInfos.size() <= 0) continue;
                                for (int i = 0; i < assignInfos.size(); ++i) {
                                    AssignableInfo assignInfo = (AssignableInfo)assignInfos.get(i);
                                    String activitydefid = json.getString("selectpath");
                                    if (!assignInfo.getAfferentTransitions().containsKey(activitydefid)) continue;
                                    Vector<String> userPKs = assignInfo.getAssignedOperatorPKs();
                                    userPKs.clear();
                                    JSONArray listStr = new JSONArray((List)json.get((Object)"assginUsers"));
                                    for (Object jsonobj : listStr) {
                                        JSONObject json11 = new JSONObject((Map)jsonobj);
                                        userPKs.addElement(json11.getString("pk"));
                                    }
                                    continue block13;
                                }
                            }
                            Vector tSelectInfos = worknoteVO.getTaskInfo().getTransitionSelectableInfos();
                            for (JSONObject jsonObject : jsonAray2) {
                                if (!jsonObject.getBoolean("isChoice").booleanValue()) continue;
                                for (int i = 0; i < tSelectInfos.size(); ++i) {
                                    TransitionSelectableInfo trans = (TransitionSelectableInfo)tSelectInfos.get(i);
                                    if (jsonObject.getString("selectpath").equals(trans.getTransitionDefId())) {
                                        trans.setChoiced(true);
                                        continue;
                                    }
                                    trans.setChoiced(false);
                                }
                            }
                        } else {
                            JSONObject jsonObject;
                            assignInfos = worknoteVO.getTaskInfo().getAssignableInfos();
                            Vector tSelectInfos = worknoteVO.getTaskInfo().getTransitionSelectableInfos();
                            JSONObject jsondata11 = jsono;
                            List jsonArayList = (List)jsondata11.get((Object)"content");
                            JSONArray jsonAray3 = new JSONArray(jsonArayList);
                            Iterator iterator = jsonAray3.iterator();
                            while (iterator.hasNext()) {
                                jsonObject = (JSONObject)iterator.next();
                                if (!jsonObject.getBoolean("isChoice").booleanValue()) continue;
                                for (int j = 0; j < assignInfos.size(); ++j) {
                                    List userJsonList;
                                    AssignableInfo _assignInfos = (AssignableInfo)assignInfos.get(j);
                                    if (!_assignInfos.getActivityDefId().endsWith(jsonObject.getString("selectpath")) || (userJsonList = (List)jsonObject.get((Object)"assginUsers")) == null || userJsonList.size() <= 0) continue;
                                    JSONArray userListJson = new JSONArray(userJsonList);
                                    _assignInfos.getAssignedOperatorPKs().clear();
                                    for (Object obj : userListJson) {
                                        JSONObject jsonu = (JSONObject)obj;
                                        _assignInfos.getAssignedOperatorPKs().add(jsonu.getString("pk"));
                                    }
                                }
                            }
                            iterator = jsonAray3.iterator();
                            while (iterator.hasNext()) {
                                jsonObject = (JSONObject)iterator.next();
                                if (!jsonObject.getBoolean("isChoice").booleanValue()) continue;
                                for (int i = 0; i < tSelectInfos.size(); ++i) {
                                    TransitionSelectableInfo trans = (TransitionSelectableInfo)tSelectInfos.get(i);
                                    if (jsonObject.getString("selectpath").equals(trans.getTransitionDefId())) {
                                        trans.setChoiced(true);
                                        continue;
                                    }
                                    trans.setChoiced(false);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (worknoteVO == null) {
            if (eParam == null) {
                eParam = new HashMap<String, String>();
            }
            eParam.put("notechecked", "notechecked");
        }
        Object retObj = null;
        Logger.debug((Object)"*\u540e\u53f0\u52a8\u4f5c\u5904\u7406 \u5f00\u59cb");
        long start2 = System.currentTimeMillis();
        IplatFormEntry iIplatFormEntry = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class.getName());
        retObj = iIplatFormEntry.processAction(actionCode, billOrTranstype, worknoteVO, billvo, userObj, eParam);
        Logger.debug((Object)("*\u540e\u53f0\u52a8\u4f5c\u5904\u7406 \u7ed3\u675f=" + (System.currentTimeMillis() - start2) + "ms"));
        Logger.debug((Object)("*\u5355\u636e\u52a8\u4f5c\u5904\u7406 \u7ed3\u675f=" + (System.currentTimeMillis() - start) + "ms"));
        INccPFCrossServiceQuery nccPFCrossServiceQueryImpl = (INccPFCrossServiceQuery)NCLocator.getInstance().lookup(INccPFCrossServiceQuery.class);
        if (!nccPFCrossServiceQueryImpl.isStartMoudle("nccloud.pubimpl.ssctp.sscapv.approve.SSCIntelligentApvServiceImpl", null)) {
            return retObj;
        }
        if (StringUtils.isBlank((CharSequence)CloudPfUtil.isCrossService("nccloud.pubimpl.ssctp.sscapv.approve.SSCIntelligentApvServiceImpl"))) {
            try {
                String checkAfterSSCObj = null;
                Collection coAll = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class.getName())).retrieveByClause(Billtype2VO.class, "PK_BILLTYPE = 'SSCAPV'");
                if (coAll != null && coAll.size() > 0) {
                    for (Billtype2VO co : coAll) {
                        if (!"SSCAPV".equals(co.getPk_billtype())) continue;
                        checkAfterSSCObj = co.getClassname();
                    }
                }
                if (checkAfterSSCObj != null) {
                    Class<?> clazz = Class.forName("nccloud.pubitf.ssctp.sscapv.approve.ISSCIntelligentApvService");
                    Object objclass = NCLocator.getInstance().lookup("nccloud.pubitf.ssctp.sscapv.approve.ISSCIntelligentApvService");
                    clazz.getMethod("afterActionWithErr", Object.class, AggregatedValueObject.class, WorkflownoteVO.class).invoke(objclass, retObj, billvo, worknoteVO);
                }
            }
            catch (ClassNotFoundException e) {
                Logger.error((Object)e.getMessage());
            }
            catch (SecurityException e) {
                Logger.error((Object)e.getMessage());
            }
            catch (NoSuchMethodException e) {
                Logger.error((Object)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                Logger.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                Logger.error((Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                Throwable t = ExceptionUtils.unmarsh((Throwable)e);
                Logger.error((Object)t.getMessage(), (Throwable)t);
                throw new BusinessException(t.getMessage());
            }
        }
        return retObj;
    }

    private static synchronized String isCrossService(String className) throws BusinessException {
        try {
            INccPFCrossServiceQuery nccPFCrossServiceQueryImpl = (INccPFCrossServiceQuery)NCLocator.getInstance().lookup(INccPFCrossServiceQuery.class);
            return nccPFCrossServiceQueryImpl.isCrossServiceByClassName(className);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    protected static void onApprove(BesideApproveContext besideContext, WorkflownoteVO worknoteVO) {
        boolean isNeedDispatch = CloudPfUtil.isExistAssignableInfoWhenPass(worknoteVO);
        if (!CloudPfUtil.beforeButtonOperate(worknoteVO)) {
            return;
        }
        worknoteVO.setTrack(false);
        worknoteVO.setChecknote(besideContext.getCheckNote());
        worknoteVO.setApproveresult(besideContext.getApproveResult());
    }

    private static boolean beforeButtonOperate(WorkflownoteVO worknoteVO) {
        String checkNote = NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "00020001-0477");
        String result = null;
        if (!CloudPfUtil.isNeedCASign(worknoteVO)) {
            result = null;
        }
        try {
            NCAuthenticator authenticator = NCAuthenticatorFactory.getBusiAuthenticator((String)InvocationInfoProxy.getInstance().getUserId());
            String signResult = authenticator.sign(worknoteVO.getApproveresult() + checkNote);
            worknoteVO.setCiphertext(signResult);
        }
        catch (Exception e) {
            result = e.getMessage();
            Logger.error((Object)e.getMessage());
        }
        return StringUtil.isEmptyWithTrim((String)result);
    }

    private static boolean isNeedCASign(WorkflownoteVO worknoteVO) {
        Object value = worknoteVO.getRelaProperties().get("ElectSignature");
        return value != null && "true".equalsIgnoreCase(value.toString());
    }

    public static boolean isExistAssignableInfoWhenPass(WorkflownoteVO worknoteVO) {
        if (worknoteVO.getActiontype().endsWith("_A")) {
            return false;
        }
        Vector assignInfos = worknoteVO.getTaskInfo().getAssignableInfos();
        if (assignInfos != null && assignInfos.size() > 0) {
            String strCriterion = null;
            for (AssignableInfo ai : assignInfos) {
                strCriterion = ai.getCheckResultCriterion();
                if (!AssignableInfo.CRITERION_NOTGIVEN.equals(strCriterion) && !AssignableInfo.CRITERION_PASS.equals(strCriterion)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExistTransitionSelectableInfos(WorkflownoteVO worknoteVO, WorkflowProcess wp) throws BusinessException {
        IWorkflowDefine workflowDefineImpl = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
        return workflowDefineImpl.isExistTransitionSelectableInfos(worknoteVO, wp);
    }

    private static Object getParamFromMap(HashMap eParam, String paramKey) {
        return eParam == null ? null : eParam.get(paramKey);
    }

    private static WorkflownoteVO actionAboutApproveflow(String actionName, String billType, AggregatedValueObject billvo, HashMap eParam, int voAryLen) throws BusinessException {
        WorkflownoteVO worknoteVO = null;
        if (PfUtilBaseTools.isSaveAction(actionName, billType)) {
            Logger.debug((Object)("*\u63d0\u4ea4\u52a8\u4f5c=" + actionName + "\uff0c\u68c0\u67e5\u5ba1\u6279\u6d41"));
            Stack dlgResult = new Stack();
            worknoteVO = CloudPfUtil.checkOnSave(actionName, billType, billvo, dlgResult, eParam);
        } else if (PfUtilBaseTools.isApproveAction(actionName, billType)) {
            Logger.debug((Object)("*\u5ba1\u6279\u52a8\u4f5c=" + actionName + "\uff0c\u68c0\u67e5\u5ba1\u6279\u6d41"));
            worknoteVO = CloudPfUtil.checkWorkitemWhenApprove(actionName, billType, billvo, eParam, voAryLen);
            if (worknoteVO != null) {
                if ("Y".equals(worknoteVO.getApproveresult())) {
                    m_iCheckResult = 0;
                } else if ("R".equals(worknoteVO.getApproveresult())) {
                    WFTask currTask = worknoteVO.getTaskInfo().getTask();
                    if (currTask != null && currTask.getTaskType() == WfTaskType.Backward.getIntValue()) {
                        m_iCheckResult = currTask.isBackToFirstActivity() ? 3 : 2;
                    }
                } else {
                    m_iCheckResult = 1;
                }
            } else if (!m_checkFlag) {
                Logger.debug((Object)"*\u7528\u6237\u5ba1\u6279\u65f6\u70b9\u51fb\u4e86\u53d6\u6d88\uff0c\u5219\u505c\u6b62\u5ba1\u6279");
            }
        }
        return worknoteVO;
    }

    private static WorkflownoteVO actionAboutWorkflow(String actionName, String billType, AggregatedValueObject billvo, BesideApproveContext besideContext, int voAryLen) throws BusinessException {
        WorkflownoteVO worknoteVO = null;
        if (PfUtilBaseTools.isStartAction(actionName, billType)) {
            Logger.debug((Object)("*\u542f\u52a8\u52a8\u4f5c=" + actionName + "\uff0c\u68c0\u67e5\u5de5\u4f5c\u6d41"));
            worknoteVO = CloudPfUtil.checkOnStart(actionName, billType, billvo, null, null);
        } else if (PfUtilBaseTools.isSignalAction(actionName, billType)) {
            Logger.debug((Object)("*\u6267\u884c\u52a8\u4f5c=" + actionName + "\uff0c\u68c0\u67e5\u5de5\u4f5c\u6d41"));
            worknoteVO = CloudPfUtil.checkWorkitemWhenSignal(actionName, billType, billvo, besideContext, voAryLen);
            if (worknoteVO != null) {
                worknoteVO.setApproveresult("Y");
                worknoteVO.setChecknote(NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "00020001-0475"));
            } else if (!m_checkFlag) {
                Logger.debug((Object)"*\u7528\u6237\u9a71\u52a8\u5de5\u4f5c\u6d41\u65f6\u70b9\u51fb\u4e86\u53d6\u6d88\uff0c\u5219\u505c\u6b62\u6267\u884c\u5de5\u4f5c\u6d41");
            }
        }
        return worknoteVO;
    }

    private static WorkflownoteVO checkWorkitemWhenSignal(String actionCode, String billType, AggregatedValueObject billVo, BesideApproveContext besideContext, int voAryLen) throws BusinessException {
        WorkflownoteVO noteVO = ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).checkWorkFlow(actionCode, billType, billVo, null);
        if (noteVO == null) {
            return null;
        }
        if (noteVO.getWorkflow_type().intValue() == WorkflowTypeEnum.SubWorkApproveflow.getIntValue()) {
            // empty if block
        }
        return noteVO;
    }

    private static boolean canAddApprover(WorkflownoteVO noteVO) {
        Object value = noteVO.getRelaProperties().get("CanAddApprover");
        if (value != null && "true".equalsIgnoreCase(value.toString())) {
            return !noteVO.actiontype.equalsIgnoreCase("Z_A");
        }
        return false;
    }

    private static void debugParams(String actionCode, String billType, Object billEntity, Object userObj) {
        Logger.debug((Object)"*********************************************");
        Logger.debug((Object)("* actionCode=" + actionCode));
        Logger.debug((Object)("* billType=" + billType));
        Logger.debug((Object)("* billEntity=" + billEntity));
        Logger.debug((Object)("* userObj=" + userObj));
        Logger.debug((Object)"*********************************************");
    }

    public static Object[] runBatch(String actionCode, String billOrTranstype, AggregatedValueObject[] voAry, Object[] userObjAry, BesideApproveContext besideContext, HashMap eParam) throws Exception {
        Logger.debug((Object)"*\u5355\u636e\u52a8\u4f5c\u6279\u5904\u7406 \u5f00\u59cb");
        long start = System.currentTimeMillis();
        ArrayList<AggregatedValueObject> runbathAggvos = new ArrayList<AggregatedValueObject>();
        ArrayList<AggregatedValueObject> assginAggvos = new ArrayList<AggregatedValueObject>();
        PFBatchExceptionInfo batchAgginInfo = new PFBatchExceptionInfo();
        if (voAry != null && voAry.length == 1) {
            Object obj = CloudPfUtil.runAction(actionCode, billOrTranstype, voAry[0], userObjAry, besideContext, null, eParam);
            Object[] ret = null;
            ret = PfUtilBaseTools.composeResultAry(obj, 1, 0, ret);
            return ret;
        }
        WorkflownoteVO workflownote = null;
        Object paramNoflow = CloudPfUtil.getParamFromMap(eParam, "nosendmessage");
        Object paramSilent = CloudPfUtil.getParamFromMap(eParam, "silently");
        if (paramNoflow == null && paramSilent == null) {
            Vector assignInfos;
            int i;
            if (voAry != null && voAry.length > 1) {
                eParam = CloudPfUtil.putParam(eParam, "batch", "batch");
            }
            if (PfUtilBaseTools.isSaveAction(actionCode, billOrTranstype) || PfUtilBaseTools.isApproveAction(actionCode, billOrTranstype)) {
                for (i = 0; i < voAry.length; ++i) {
                    workflownote = CloudPfUtil.actionAboutApproveflow(actionCode, billOrTranstype, voAry[i], eParam, voAry.length);
                    assignInfos = workflownote.getTaskInfo().getAssignableInfos();
                    if (assignInfos == null || assignInfos.size() > 0) {
                        batchAgginInfo.getHm_index_billVO().put(i, voAry[i]);
                        batchAgginInfo.getErrorMessageMap().put(i, NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "00020001-0478"));
                        assginAggvos.add(voAry[i]);
                        continue;
                    }
                    runbathAggvos.add(voAry[i]);
                }
                if (runbathAggvos == null || runbathAggvos.size() == 0) {
                    PfProcessBatchRetObject retObj = new PfProcessBatchRetObject(null, batchAgginInfo);
                    return new Object[]{retObj};
                }
                workflownote = CloudPfUtil.actionAboutApproveflow(actionCode, billOrTranstype, (AggregatedValueObject)runbathAggvos.get(0), eParam, voAry.length);
                voAry = runbathAggvos.toArray(new AggregatedValueObject[0]);
            } else if (PfUtilBaseTools.isStartAction(actionCode, billOrTranstype) || PfUtilBaseTools.isSignalAction(actionCode, billOrTranstype)) {
                for (i = 0; i < voAry.length; ++i) {
                    workflownote = CloudPfUtil.actionAboutWorkflow(actionCode, billOrTranstype, voAry[i], null, voAry.length);
                    assignInfos = workflownote.getTaskInfo().getAssignableInfos();
                    if (assignInfos == null || assignInfos.size() > 0) {
                        batchAgginInfo.getHm_index_billVO().put(i, voAry[i]);
                        batchAgginInfo.getErrorMessageMap().put(i, NCLangRes4VoTransl.getNCLangRes().getStrByID("0020nccloud_pub_0", "00020001-0478"));
                        assginAggvos.add(voAry[i]);
                        continue;
                    }
                    runbathAggvos.add(voAry[i]);
                }
                if (runbathAggvos == null || runbathAggvos.size() == 0) {
                    PfProcessBatchRetObject retObj = new PfProcessBatchRetObject(null, batchAgginInfo);
                    return new Object[]{retObj};
                }
                workflownote = CloudPfUtil.actionAboutWorkflow(actionCode, billOrTranstype, (AggregatedValueObject)runbathAggvos.get(0), null, voAry.length);
                voAry = runbathAggvos.toArray(new AggregatedValueObject[0]);
            }
        }
        Logger.debug((Object)"*\u540e\u53f0\u52a8\u4f5c\u6279\u5904\u7406 \u5f00\u59cb");
        Object retObj = ((IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class)).processBatch(actionCode, billOrTranstype, workflownote, voAry, userObjAry, eParam);
        if (retObj instanceof PfProcessBatchRetObject) {
            PfProcessBatchRetObject retobj = (PfProcessBatchRetObject)retObj;
            if (assginAggvos != null && assginAggvos.size() > 0 || batchAgginInfo.getHm_index_billVO() != null) {
                for (Map.Entry<Integer, Object> entry : batchAgginInfo.getHm_index_billVO().entrySet()) {
                    retobj.getExceptionInfo().getHm_index_billVO().put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<Integer, Object> entry : batchAgginInfo.getErrorMessageMap().entrySet()) {
                    retobj.getExceptionInfo().getErrorMessageMap().put(entry.getKey(), (String)entry.getValue());
                }
            }
            return new Object[]{retObj};
        }
        if (!(retObj instanceof PfProcessBatchRetObject) && (assginAggvos != null && assginAggvos.size() > 0 || batchAgginInfo.getHm_index_billVO() != null)) {
            PFBatchExceptionInfo pgextion = new PFBatchExceptionInfo();
            for (Map.Entry<Integer, Object> entry : batchAgginInfo.getHm_index_billVO().entrySet()) {
                pgextion.getHm_index_billVO().put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Integer, Object> entry : batchAgginInfo.getErrorMessageMap().entrySet()) {
                pgextion.getErrorMessageMap().put(entry.getKey(), (String)entry.getValue());
            }
            PfProcessBatchRetObject reobj = new PfProcessBatchRetObject(new Object[]{retObj}, pgextion);
            return new Object[]{reobj};
        }
        Logger.debug((Object)("*\u5355\u636e\u52a8\u4f5c\u6279\u5904\u7406 \u7ed3\u675f=" + (System.currentTimeMillis() - start) + "ms"));
        return (Object[])retObj;
    }

    public static Object[] runScriptPFlow_CommitNoFlowBatch(String actionCode, String billOrTranstype, AggregatedValueObject[] voAry, Object[] userObjAry, BesideApproveContext besideContext, HashMap eParam) throws Exception {
        if (eParam == null) {
            eParam = new HashMap<String, Boolean>();
        }
        eParam.put("batch", true);
        eParam.put("NCCLOUD_ENTRY", true);
        eParam.put("CommitNoFlowBatch", true);
        WorkflownoteVO worknoteVO = new WorkflownoteVO();
        Logger.debug((Object)"*\u540e\u53f0\u52a8\u4f5c\u6279\u5904\u7406 \u5f00\u59cb");
        Object retObj = ((IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class)).processCommitNoFlowBatch4NCC(actionCode, billOrTranstype, worknoteVO, voAry, userObjAry, eParam);
        return new Object[]{retObj};
    }

    public static Object[] runScriptPFlow_CommitNoFlowBatchNew(String actionCode, String billOrTranstype, AggregatedValueObject[] voAry, Object[] userObjAry, BesideApproveContext besideContext, HashMap eParam) throws Exception {
        if (eParam == null) {
            eParam = new HashMap<String, Boolean>();
        }
        eParam.put("batch", true);
        eParam.put("NCCLOUD_ENTRY", true);
        eParam.put("CommitNoFlowBatch", true);
        WorkflownoteVO worknoteVO = new WorkflownoteVO();
        Logger.debug((Object)"*\u540e\u53f0\u52a8\u4f5c\u6279\u5904\u7406 \u5f00\u59cb");
        Object retObj = ((IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class)).processCommitNoFlowBatch4NCCNew(actionCode, billOrTranstype, worknoteVO, voAry, userObjAry, eParam);
        return new Object[]{retObj};
    }

    public static PfProcessBatchRetObject runBatchNew(String actionCode, String billOrTranstype, AggregatedValueObject[] voAry, Object[] userObjAry, BesideApproveContext besideContext, HashMap eParam) throws Exception {
        Logger.debug((Object)"*\u5355\u636e\u52a8\u4f5c\u6279\u5904\u7406 \u5f00\u59cb");
        CloudPfUtil.debugParams(actionCode, billOrTranstype, voAry, userObjAry);
        long start = System.currentTimeMillis();
        if (voAry != null && voAry.length == 1) {
            Object obj = CloudPfUtil.runAction(actionCode, billOrTranstype, voAry[0], userObjAry, besideContext, null, eParam);
            Object[] retObj = null;
            retObj = PfUtilBaseTools.composeResultAry(obj, 1, 0, retObj);
            return new PfProcessBatchRetObject(retObj, null);
        }
        WorkflownoteVO workflownote = null;
        Object paramNoflow = CloudPfUtil.getParamFromMap(eParam, "nosendmessage");
        Object paramSilent = CloudPfUtil.getParamFromMap(eParam, "silently");
        if (paramNoflow == null && paramSilent == null) {
            if (voAry != null && voAry.length > 1) {
                eParam = CloudPfUtil.putParam(eParam, "batch", "batch");
            }
            if (PfUtilBaseTools.isSaveAction(actionCode, billOrTranstype) || PfUtilBaseTools.isApproveAction(actionCode, billOrTranstype)) {
                workflownote = CloudPfUtil.actionAboutApproveflow(actionCode, billOrTranstype, voAry[0], eParam, voAry.length);
            } else if (PfUtilBaseTools.isStartAction(actionCode, billOrTranstype) || PfUtilBaseTools.isSignalAction(actionCode, billOrTranstype)) {
                workflownote = CloudPfUtil.actionAboutWorkflow(actionCode, billOrTranstype, voAry[0], besideContext, voAry.length);
            }
            CloudPfUtil.putParam(eParam, "worknote", workflownote);
        }
        Logger.debug((Object)"*\u540e\u53f0\u52a8\u4f5c\u6279\u5904\u7406 \u5f00\u59cb");
        Object retObj = ((IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class)).processBatch(actionCode, billOrTranstype, workflownote, voAry, userObjAry, eParam);
        Logger.debug((Object)("*\u5355\u636e\u52a8\u4f5c\u6279\u5904\u7406 \u7ed3\u675f=" + (System.currentTimeMillis() - start) + "ms"));
        return (PfProcessBatchRetObject)retObj;
    }

    private static HashMap putParam(HashMap eParam, String paramKey, Object value) {
        if (eParam == null) {
            eParam = new HashMap<String, Object>();
        }
        eParam.put(paramKey, value);
        return eParam;
    }

    public static PfAddInfo[] retAddInfo(String billtype, String transtype, String pk_group, String userId, boolean includeBillType) throws BusinessException {
        return ((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).retAddInfo(billtype, transtype, pk_group, userId, includeBillType);
    }

    public static String retBusitypeCanStart(String billtype, String transtype, String pk_org, String userId) throws BusinessException {
        return ((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).retBusitypeCanStart(billtype, transtype, pk_org, userId);
    }

    public static void setM_sourceBillType(String m_sourceBillType) {
        CloudPfUtil.m_sourceBillType = m_sourceBillType;
    }

    public static void setM_currentBillType(String m_currentBillType) {
        CloudPfUtil.m_currentBillType = m_currentBillType;
    }

    public static Object[] runScriptPFlow_UnSaveNoFlowBatch(String actionCode, String billOrTranstype, AggregatedValueObject[] voAry, Object[] userObjAry, Object object, HashMap eParam) throws BusinessException {
        if (eParam == null) {
            eParam = new HashMap<String, Boolean>();
        }
        eParam.put("batch", true);
        eParam.put("NCCLOUD_ENTRY", true);
        eParam.put("IS_UNSAVENOFlOW", true);
        WorkflownoteVO worknoteVO = new WorkflownoteVO();
        Logger.debug((Object)"*\u540e\u53f0\u52a8\u4f5c\u6279\u5904\u7406 \u5f00\u59cb");
        Object retObj = ((IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class)).processUnSaveNoFlowBatch4NCC(actionCode, billOrTranstype, worknoteVO, voAry, userObjAry, eParam);
        return new Object[]{retObj};
    }

    private static JSONArray getAssignUserPKs(WorkflownoteVO wfVo) {
        String strCriterion = "Y";
        Vector userPks = new Vector();
        JSONArray jsonArray = new JSONArray();
        Vector _assignableInfos = wfVo.getTaskInfo().getAssignableInfos();
        for (AssignableInfo ainfo : _assignableInfos) {
            String s = ainfo.getCheckResultCriterion();
            if (!AssignableInfo.CRITERION_NOTGIVEN.equals(strCriterion) && !AssignableInfo.CRITERION_NOTGIVEN.equals(s) && !s.equals(strCriterion)) continue;
            JSONObject json = new JSONObject();
            json.put("desc", (Object)ainfo.getDesc());
            json.put("activitydefid", (Object)ainfo.getActivityDefId());
            ArrayList userPkss = new ArrayList();
            Vector<OrganizeUnit> vecLeftUsers = new Vector<OrganizeUnit>();
            for (OrganizeUnit element : ainfo.getOuUsers()) {
                vecLeftUsers.add(element);
            }
            if (vecLeftUsers.size() > 0) {
                Collections.sort(vecLeftUsers, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return String.valueOf(o1).compareToIgnoreCase(String.valueOf(o2));
                    }
                });
            }
            JSONArray jsonArrayUser = new JSONArray();
            if (vecLeftUsers != null && vecLeftUsers.size() > 0) {
                Iterator _itero = vecLeftUsers.iterator();
                while (_itero.hasNext()) {
                    JSONObject jsonobj = new JSONObject();
                    OrganizeUnit obj = (OrganizeUnit)_itero.next();
                    jsonobj.put("user_group", (Object)obj.getPkOrg());
                    jsonobj.put("username", (Object)obj.toString());
                    jsonobj.put("userpk", (Object)obj.getPk());
                    jsonArrayUser.add((Object)jsonobj);
                }
            }
            json.put("uservos", (Object)jsonArrayUser);
            jsonArray.add((Object)json);
        }
        return jsonArray;
    }

    public static String getTooltip(Object object) {
        return CloudPfUtil.makeTooltip(object, new String[]{"Name", "Description", "FromActivity", "ToActivity", "Priority", "Condition"});
    }

    private static String makeTooltip(Object userObject, String[] elements) {
        if (elements == null) {
            return "";
        }
        String s = "<html>";
        for (int i = 0; i < elements.length; ++i) {
            s = s + CloudPfUtil.makeAnotherHtmlLine(userObject, elements[i]);
        }
        s = s.substring(0, s.length() - "<br>".length());
        s = s + "</html>";
        return s;
    }

    private static String makeAnotherHtmlLine(Object userObject, String el) {
        String textToAppend = "";
        textToAppend = textToAppend + "<p>";
        if (el.equals("Condition")) {
            textToAppend = textToAppend + NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000027") + ": ";
            textToAppend = textToAppend + "</p>";
            BasicTransition bt = (BasicTransition)userObject;
            Condition cond = bt.getCondition();
            if (cond != null) {
                List lExpress = cond.getXpressions();
                if (lExpress.size() > 0) {
                    IRule rule = (IRule)lExpress.get(0);
                    textToAppend = textToAppend + rule.toString();
                }
                textToAppend = textToAppend + "<br>";
            }
        } else {
            textToAppend = textToAppend + NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", el) + ": ";
            textToAppend = textToAppend + "</p>";
            Object o = CloudPfUtil.getValueByReflect(userObject, el);
            String val = "";
            if (o != null) {
                if (o instanceof String) {
                    val = o.toString();
                } else if (o instanceof MsgReceiverVO[]) {
                    MsgReceiverVO[] msgs;
                    for (MsgReceiverVO msg : msgs = (MsgReceiverVO[])o) {
                        val = val + msg.getName() + ",";
                    }
                    if (val.length() > 0) {
                        val = val.substring(0, val.length() - 1);
                    }
                } else {
                    val = o instanceof SplitJoinType ? ((SplitJoinType)o).toString() : (o instanceof Boolean ? UFBoolean.valueOf((boolean)((Boolean)o)).toString() : o.toString());
                }
            }
            textToAppend = textToAppend + val;
            textToAppend = textToAppend + "<br>";
        }
        return textToAppend;
    }

    private static Object getValueByReflect(Object obj, String name) {
        Method m = CloudPfUtil.getReadMethod(obj.getClass(), name);
        Object ret = null;
        try {
            if (m != null) {
                ret = m.invoke(obj, null);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret == null ? "" : ret;
    }

    private static Method getReadMethod(Class clazz, String propertyName) {
        Method readMethod = null;
        String base = CloudPfUtil.capitalize(propertyName);
        try {
            readMethod = clazz.getMethod("is" + base, null);
        }
        catch (Exception getterExc) {
            try {
                readMethod = clazz.getMethod("get" + base, null);
            }
            catch (Exception e) {
                Logger.error((Object)e);
            }
        }
        return readMethod;
    }

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    static {
        m_classifyMode = -1;
    }
}

