/*
 * Decompiled with CFR 0.152.
 */
package ncccloud.vo.ml;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.framework.common.UserExit;
import nc.bs.logging.Logger;
import nc.itf.uap.IUAPQueryBS;
import nc.vo.ml.Language;
import nc.vo.ml.LanguageVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.ml.UserLangCodeFindHelper;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.trade.voutils.VOUtil;

public class NccMultiLangContext
implements Serializable {
    private static final long serialVersionUID = -4574803569499150275L;
    private static Map<String, NccMultiLangContext> dsName_Instance_Map = new ConcurrentHashMap<String, NccMultiLangContext>();
    private LanguageVO[] enableLangVOs = null;

    private NccMultiLangContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NccMultiLangContext getInstance() {
        boolean isInServer = RuntimeEnv.getInstance().isRunningInServer();
        String dsName = null;
        dsName = isInServer ? InvocationInfoProxy.getInstance().getUserDataSource() : UserExit.getInstance().getUserDataSource();
        NccMultiLangContext instance = dsName_Instance_Map.get(dsName);
        if (instance != null) return instance;
        Class<NccMultiLangContext> clazz = NccMultiLangContext.class;
        synchronized (NccMultiLangContext.class) {
            if (dsName_Instance_Map.get(dsName) != null) return dsName_Instance_Map.get(dsName);
            instance = new NccMultiLangContext();
            dsName_Instance_Map.put(dsName, instance);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public LanguageVO getCurrentLangVO() {
        LanguageVO currLangVO = null;
        String langCode = null;
        Language lang = NCLangRes4VoTransl.getNCLangRes().getCurrLanguage();
        langCode = lang == null ? null : lang.getCode();
        LanguageVO languageVO = currLangVO = langCode == null ? null : this.getlegalLangVO(langCode);
        if (currLangVO == null) {
            langCode = this.getUserDefaultLang();
            LanguageVO languageVO2 = currLangVO = langCode == null ? null : this.getlegalLangVObyPK(langCode);
        }
        if (currLangVO == null && this.getEnableLangVOs() != null && this.getEnableLangVOs().length > 0) {
            currLangVO = this.getEnableLangVOs()[0];
        }
        return currLangVO;
    }

    private String getUserDefaultLang() {
        String useid = InvocationInfoProxy.getInstance().getUserId();
        return UserLangCodeFindHelper.getUserLangDefCode((String)useid);
    }

    private LanguageVO getlegalLangVO(String langcode) {
        if (langcode == null) {
            return null;
        }
        LanguageVO currLangVO = null;
        int iLen = this.getEnableLangVOs() == null ? 0 : this.getEnableLangVOs().length;
        for (int i = 0; i < iLen; ++i) {
            if (!this.getEnableLangVOs()[i].getLangcode().equals(langcode)) continue;
            currLangVO = this.getEnableLangVOs()[i];
            break;
        }
        return currLangVO;
    }

    private LanguageVO getlegalLangVObyPK(String langpk) {
        if (langpk == null) {
            return null;
        }
        LanguageVO currLangVO = null;
        int iLen = this.getEnableLangVOs() == null ? 0 : this.getEnableLangVOs().length;
        for (int i = 0; i < iLen; ++i) {
            if (!this.getEnableLangVOs()[i].getPk_multilang().equals(langpk)) continue;
            currLangVO = this.getEnableLangVOs()[i];
            break;
        }
        return currLangVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LanguageVO[] getEnableLangVOs() {
        if (this.enableLangVOs != null && this.enableLangVOs.length != 0) return this.enableLangVOs;
        Class<NccMultiLangContext> clazz = NccMultiLangContext.class;
        synchronized (NccMultiLangContext.class) {
            IUAPQueryBS service = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class.getName());
            List langList = null;
            try {
                langList = (List)service.retrieveAll(LanguageVO.class);
                this.enableLangVOs = langList == null ? null : langList.toArray(new LanguageVO[langList.size()]);
                VOUtil.sort((CircularlyAccessibleValueObject[])this.enableLangVOs, (String[])new String[]{"langseq"}, (int[])new int[]{1});
            }
            catch (BusinessException e) {
                Logger.error((Object)((Object)e));
            }
            return this.enableLangVOs;
        }
    }

    public Integer getCurrentLangSeq() {
        if (!this.hasDataSource()) {
            return 1;
        }
        LanguageVO currLangVO = this.getCurrentLangVO();
        if (currLangVO != null && currLangVO.getLangseq() != null) {
            return currLangVO.getLangseq();
        }
        return -1;
    }

    private boolean hasDataSource() {
        String dsname = InvocationInfoProxy.getInstance().getUserDataSource();
        return dsname != null && !dsname.isEmpty();
    }

    public LanguageVO getMainLangVO() {
        LanguageVO[] arrlangvos = this.getEnableLangVOs();
        if (arrlangvos != null && arrlangvos.length > 0) {
            return arrlangvos[0];
        }
        return null;
    }
}

