/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.definition;

import java.util.ArrayList;
import java.util.StringTokenizer;
import nc.vo.pub.ValidationException;
import nc.vo.pub.ValueObject;

public class NCFunctionXpression
extends ValueObject {
    private static final long serialVersionUID = 1569662512710249529L;
    private String functionId;
    private String functionName;
    private String returnType;
    private String ysf;
    private String value;
    private String valueNote = null;

    public String getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getYsf() {
        return this.ysf;
    }

    public void setYsf(String ysf) {
        this.ysf = ysf;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getValueNote() {
        return this.valueNote;
    }

    public void setValueNote(String valueNote) {
        this.valueNote = valueNote;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getEntityName() {
        return null;
    }

    public void validate() throws ValidationException {
    }

    public String toString() {
        String ret = this.getFunctionId() + ";" + this.getYsf() + ";" + this.getValue();
        return ret;
    }

    public static NCFunctionXpression fromString(String strExp) {
        if (strExp == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(strExp, ";");
        ArrayList<String> alTokens = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String element = (String)st.nextElement();
            alTokens.add(element);
        }
        if (alTokens.size() != 3) {
            return null;
        }
        NCFunctionXpression exp = new NCFunctionXpression();
        exp.setFunctionId((String)alTokens.get(0));
        exp.setYsf((String)alTokens.get(1));
        exp.setValue((String)alTokens.get(2));
        return exp;
    }

    public Object clone() {
        NCFunctionXpression obj = new NCFunctionXpression();
        obj.setFunctionId(this.getFunctionId());
        obj.setFunctionName(this.getFunctionName());
        obj.setReturnType(this.getReturnType());
        obj.setValue(this.getValue());
        obj.setValueNote(this.getValueNote());
        obj.setYsf(this.getYsf());
        return obj;
    }
}

